/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.CloseAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorTabPresentationUtil;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWindowHolder;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorAssociateFinder;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.HistoryEntry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorWindow {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.EditorWindow");
    public static final DataKey<EditorWindow> DATA_KEY = DataKey.create((String)"editorWindow");
    protected JPanel myPanel;
    private EditorTabbedContainer myTabbedPane;
    private final EditorsSplitters myOwner;
    private static final Icon MODIFIED_ICON = !UISettings.getInstance().getHideTabsIfNeed() ? new Icon(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            GraphicsConfig config2 = GraphicsUtil.setupAAPainting((Graphics)g);
            Font oldFont = g.getFont();
            try {
                g.setFont(UIUtil.getLabelFont());
                g.setColor(JBColor.foreground());
                g.drawString("*", 0, 10);
            }
            finally {
                config2.restore();
                g.setFont(oldFont);
            }
        }

        @Override
        public int getIconWidth() {
            return 9;
        }

        @Override
        public int getIconHeight() {
            return 9;
        }
    } : AllIcons.General.Modified;
    private static final Icon GAP_ICON = EmptyIcon.create((Icon)MODIFIED_ICON);
    private boolean myIsDisposed;
    public static final Key<Integer> INITIAL_INDEX_KEY = Key.create((String)"initial editor index");
    private final Stack<Pair<String, Integer>> myRemovedTabs = new Stack<Pair<String, Integer>>(){

        public void push(Pair<String, Integer> pair) {
            if (this.size() >= UISettings.getInstance().getEditorTabLimit()) {
                this.remove(0);
            }
            super.push(pair);
        }
    };
    private final AtomicBoolean myTabsHidingInProgress = new AtomicBoolean(false);
    private final Stack<Pair<String, Integer>> myHiddenTabs = new Stack();

    protected EditorWindow(EditorsSplitters owner) {
        this.myOwner = owner;
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.setOpaque(false);
        this.myTabbedPane = null;
        int tabPlacement = UISettings.getInstance().getEditorTabPlacement();
        if (tabPlacement != 0 && !UISettings.getInstance().getPresentationMode()) {
            this.createTabs();
        }
        if (UISettings.getInstance().getScrollTabLayoutInEditor()) {
            this.setTabLayoutPolicy(1);
        } else {
            this.setTabLayoutPolicy(0);
        }
        this.myOwner.addWindow(this);
        if (this.myOwner.getCurrentWindow() == null) {
            this.myOwner.setCurrentWindow(this, false);
        }
    }

    private void createTabs() {
        LOG.assertTrue(this.myTabbedPane == null);
        this.myTabbedPane = new EditorTabbedContainer(this, this.getManager().getProject());
        this.myPanel.add((Component)this.myTabbedPane.getComponent(), "Center");
    }

    public boolean isShowing() {
        return this.myPanel.isShowing();
    }

    public void closeAllExcept(VirtualFile selectedFile) {
        VirtualFile[] files2;
        for (VirtualFile file2 : files2 = this.getFiles()) {
            if (Comparing.equal((Object)file2, (Object)selectedFile) || this.isFilePinned(file2)) continue;
            this.closeFile(file2);
        }
    }

    void dispose() {
        try {
            this.disposeTabs();
            this.myOwner.removeWindow(this);
        }
        finally {
            this.myIsDisposed = true;
        }
    }

    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    private void disposeTabs() {
        if (this.myTabbedPane != null) {
            Disposer.dispose((Disposable)this.myTabbedPane);
            this.myTabbedPane = null;
        }
        this.myPanel.removeAll();
        this.myPanel.revalidate();
    }

    public void closeFile(VirtualFile file2) {
        this.closeFile(file2, true);
    }

    public void closeFile(VirtualFile file2, boolean disposeIfNeeded) {
        this.closeFile(file2, disposeIfNeeded, true);
    }

    boolean hasClosedTabs() {
        return !this.myRemovedTabs.empty();
    }

    void restoreClosedTab() {
        assert (this.hasClosedTabs()) : "Nothing to restore";
        Pair info = (Pair)this.myRemovedTabs.pop();
        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl((String)info.getFirst());
        Integer second = (Integer)info.getSecond();
        if (file2 != null) {
            this.getManager().openFileImpl4(this, file2, null, true, true, null, second == null ? -1 : second, false);
        }
    }

    private void restoreHiddenTabs() {
        while (!this.myHiddenTabs.isEmpty()) {
            Pair info = (Pair)this.myHiddenTabs.pop();
            this.myRemovedTabs.remove((Object)info);
            VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl((String)info.getFirst());
            Integer second = (Integer)info.getSecond();
            if (file2 == null) continue;
            this.getManager().openFileImpl4(this, file2, null, true, true, null, second == null ? -1 : second, false);
        }
    }

    public void closeFile(@NotNull VirtualFile file2, boolean disposeIfNeeded, boolean transferFocus) {
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(0);
        }
        FileEditorManagerImpl editorManager = this.getManager();
        editorManager.runChange(splitters -> {
            List<EditorWithProviderComposite> editors = splitters.findEditorComposites(file2);
            if (editors.isEmpty()) {
                return;
            }
            try {
                EditorWithProviderComposite editor = this.findFileComposite(file2);
                FileEditorManagerListener.Before beforePublisher = (FileEditorManagerListener.Before)editorManager.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER);
                beforePublisher.beforeFileClosed((FileEditorManager)editorManager, file2);
                if (this.myTabbedPane != null && editor != null) {
                    int componentIndex = this.findComponentIndex(editor.getComponent());
                    if (componentIndex >= 0) {
                        int indexToSelect = this.calcIndexToSelect(file2, componentIndex);
                        Pair pair = Pair.create((Object)file2.getUrl(), (Object)componentIndex);
                        this.myRemovedTabs.push((Object)pair);
                        if (this.myTabsHidingInProgress.get()) {
                            this.myHiddenTabs.push((Object)pair);
                        }
                        this.myTabbedPane.removeTabAt(componentIndex, indexToSelect, transferFocus);
                        editorManager.disposeComposite(editor);
                    }
                } else {
                    Splitter splitter;
                    JComponent otherComponent;
                    if (this.inSplitter() && (otherComponent = (splitter = (Splitter)this.myPanel.getParent()).getOtherComponent((Component)this.myPanel)) != null) {
                        IdeFocusManager.findInstance().requestFocus((Component)otherComponent, true);
                    }
                    this.myPanel.removeAll();
                    if (editor != null) {
                        editorManager.disposeComposite(editor);
                    }
                }
                if (disposeIfNeeded && this.getTabCount() == 0) {
                    ThreeComponentsSplitter splitter;
                    EditorsSplitters owner;
                    this.removeFromSplitter();
                    if (UISettings.getInstance().getEditorTabPlacement() == 0 && (owner = this.getOwner()) != null && (splitter = (ThreeComponentsSplitter)UIUtil.getParentOfType(ThreeComponentsSplitter.class, (Component)((Object)owner))) != null) {
                        splitter.revalidate();
                        splitter.repaint();
                    }
                } else {
                    this.myPanel.revalidate();
                    if (this.myTabbedPane == null) {
                        this.myPanel.repaint();
                    }
                }
            }
            finally {
                editorManager.removeSelectionRecord(file2, this);
                ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
                editorManager.notifyPublisher(() -> {
                    Project project = editorManager.getProject();
                    if (!project.isDisposed()) {
                        FileEditorManagerListener afterPublisher = (FileEditorManagerListener)project.getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER);
                        afterPublisher.fileClosed((FileEditorManager)editorManager, file2);
                    }
                });
                splitters.afterFileClosed(file2);
            }
        }, this.myOwner);
    }

    void removeFromSplitter() {
        if (!this.inSplitter()) {
            return;
        }
        if (this.myOwner.getCurrentWindow() == this) {
            EditorWindow[] siblings = this.findSiblings();
            this.myOwner.setCurrentWindow(siblings[0], true);
        }
        Splitter splitter = (Splitter)this.myPanel.getParent();
        JComponent otherComponent = splitter.getOtherComponent((Component)this.myPanel);
        Container parent = splitter.getParent().getParent();
        if (parent instanceof Splitter) {
            Splitter parentSplitter = (Splitter)parent;
            if (parentSplitter.getFirstComponent() == splitter.getParent()) {
                parentSplitter.setFirstComponent(otherComponent);
            } else {
                parentSplitter.setSecondComponent(otherComponent);
            }
        } else if (parent instanceof EditorsSplitters) {
            Component currentFocusComponent = IdeFocusManager.getGlobalInstance().getFocusedDescendantFor((Component)parent);
            parent.removeAll();
            parent.add((Component)otherComponent, "Center");
            parent.revalidate();
            if (currentFocusComponent != null) {
                currentFocusComponent.requestFocusInWindow();
            }
        } else {
            throw new IllegalStateException("Unknown container: " + parent);
        }
        this.dispose();
    }

    int calcIndexToSelect(VirtualFile fileBeingClosed, int fileIndex) {
        int currentlySelectedIndex = this.myTabbedPane.getSelectedIndex();
        if (currentlySelectedIndex != fileIndex) {
            return currentlySelectedIndex;
        }
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.getState().getActiveMruEditorOnClose()) {
            List<VirtualFile> histFiles = EditorHistoryManager.getInstance(this.getManager().getProject()).getFileList();
            for (int idx = histFiles.size() - 1; idx >= 0; --idx) {
                int histFileIndex;
                EditorWithProviderComposite editor;
                VirtualFile histFile = histFiles.get(idx);
                if (histFile.equals(fileBeingClosed) || (editor = this.findFileComposite(histFile)) == null || (histFileIndex = this.findComponentIndex(editor.getComponent())) < 0) continue;
                return histFileIndex;
            }
        } else if (uiSettings.getActiveRightEditorOnClose() && fileIndex + 1 < this.myTabbedPane.getTabCount()) {
            return fileIndex + 1;
        }
        if (fileIndex > 0) {
            return fileIndex - 1;
        }
        return -1;
    }

    public FileEditorManagerImpl getManager() {
        return this.myOwner.getManager();
    }

    public int getTabCount() {
        if (this.myTabbedPane != null) {
            return this.myTabbedPane.getTabCount();
        }
        return this.myPanel.getComponentCount();
    }

    void setForegroundAt(int index, Color color) {
        if (this.myTabbedPane != null) {
            this.myTabbedPane.setForegroundAt(index, color);
        }
    }

    void setWaveColor(int index, @Nullable Color color) {
        if (this.myTabbedPane != null) {
            this.myTabbedPane.setWaveColor(index, color);
        }
    }

    private void setIconAt(int index, Icon icon) {
        if (this.myTabbedPane != null) {
            this.myTabbedPane.setIconAt(index, icon);
        }
    }

    private void setTitleAt(int index, String text) {
        if (this.myTabbedPane != null) {
            this.myTabbedPane.setTitleAt(index, text);
        }
    }

    private void setBackgroundColorAt(int index, Color color) {
        if (this.myTabbedPane != null) {
            this.myTabbedPane.setBackgroundColorAt(index, color);
        }
    }

    private void setToolTipTextAt(int index, String text) {
        if (this.myTabbedPane != null) {
            this.myTabbedPane.setToolTipTextAt(index, text);
        }
    }

    void setTabLayoutPolicy(int policy) {
        if (this.myTabbedPane != null) {
            this.myTabbedPane.setTabLayoutPolicy(policy);
        }
    }

    void setTabsPlacement(int tabPlacement) {
        if (tabPlacement != 0 && !UISettings.getInstance().getPresentationMode()) {
            if (this.myTabbedPane == null) {
                EditorWithProviderComposite editor = this.getSelectedEditor();
                this.myPanel.removeAll();
                this.createTabs();
                this.restoreHiddenTabs();
                this.setEditor(editor, true);
            } else {
                this.myTabbedPane.setTabPlacement(tabPlacement);
            }
        } else if (this.myTabbedPane != null) {
            boolean focusEditor = this == this.myOwner.getCurrentWindow() && ToolWindowManager.getInstance((Project)this.getManager().getProject()).isEditorComponentActive();
            VirtualFile currentFile = this.getSelectedFile();
            if (currentFile != null) {
                currentFile.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, (Object)Boolean.TRUE);
            }
            VirtualFile[] files2 = this.getFiles();
            this.myHiddenTabs.clear();
            this.myTabsHidingInProgress.set(true);
            for (VirtualFile file2 : files2) {
                this.closeFile(file2, false);
            }
            this.getManager().runChange(splitters -> this.myTabsHidingInProgress.set(false), this.myOwner);
            this.disposeTabs();
            if (currentFile != null) {
                currentFile.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, null);
                this.getManager().openFileImpl2(this, currentFile, focusEditor);
            } else {
                this.myPanel.repaint();
            }
        }
    }

    public void setAsCurrentWindow(boolean requestFocus) {
        this.myOwner.setCurrentWindow(this, requestFocus);
    }

    void updateFileBackgroundColor(@NotNull VirtualFile file2) {
        int index;
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(1);
        }
        if ((index = this.findEditorIndex(this.findFileComposite(file2))) != -1) {
            Color color = EditorTabPresentationUtil.getEditorTabBackgroundColor(this.getManager().getProject(), file2, this);
            this.setBackgroundColorAt(index, color);
        }
    }

    public EditorsSplitters getOwner() {
        return this.myOwner;
    }

    boolean isEmptyVisible() {
        return this.myTabbedPane != null ? this.myTabbedPane.isEmptyVisible() : this.getFiles().length == 0;
    }

    public Dimension getSize() {
        return this.myPanel.getSize();
    }

    @Nullable
    public EditorTabbedContainer getTabbedPane() {
        return this.myTabbedPane;
    }

    public void requestFocus(boolean forced) {
        if (this.myTabbedPane != null) {
            this.myTabbedPane.requestFocus(forced);
        } else {
            JComponent preferred;
            EditorWithProviderComposite editor = this.getSelectedEditor();
            JComponent jComponent = preferred = editor == null ? null : editor.getPreferredFocusedComponent();
            if (preferred == null) {
                preferred = this.myPanel;
            }
            IdeFocusManager.findInstanceByComponent((Component)preferred).requestFocus((Component)preferred, forced);
        }
    }

    public boolean isValid() {
        return this.myPanel.isShowing();
    }

    private void checkConsistency() {
        LOG.assertTrue(this.myOwner.containsWindow(this), (Object)"EditorWindow not in collection");
    }

    public EditorWithProviderComposite getSelectedEditor() {
        return this.getSelectedEditor(false);
    }

    public EditorWithProviderComposite getSelectedEditor(boolean ignorePopup) {
        TComp comp;
        if (this.myTabbedPane != null) {
            comp = (TComp)ObjectUtils.tryCast((Object)this.myTabbedPane.getSelectedComponent(ignorePopup), TComp.class);
        } else if (this.myPanel.getComponentCount() != 0) {
            Component component = this.myPanel.getComponent(0);
            comp = component instanceof TComp ? (TComp)component : null;
        } else {
            return null;
        }
        if (comp != null) {
            return comp.myEditor;
        }
        return null;
    }

    public EditorWithProviderComposite[] getEditors() {
        int tabCount = this.getTabCount();
        EditorWithProviderComposite[] res2 = new EditorWithProviderComposite[tabCount];
        for (int i = 0; i != tabCount; ++i) {
            res2[i] = this.getEditorAt(i);
        }
        return res2;
    }

    public VirtualFile[] getFiles() {
        int tabCount = this.getTabCount();
        VirtualFile[] res2 = new VirtualFile[tabCount];
        for (int i = 0; i != tabCount; ++i) {
            res2[i] = this.getEditorAt(i).getFile();
        }
        return res2;
    }

    public void setSelectedEditor(EditorComposite editor, boolean focusEditor) {
        JComponent preferred;
        if (editor == null) {
            return;
        }
        if (this.myTabbedPane != null) {
            int index = this.findFileIndex(editor.getFile());
            if (index != -1) {
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (this.myTabbedPane != null) {
                        this.myTabbedPane.setSelectedIndex(index, focusEditor);
                    }
                });
            }
        } else if (focusEditor && (preferred = editor.getPreferredFocusedComponent()) != null) {
            IdeFocusManager.findInstanceByComponent((Component)preferred).requestFocus((Component)preferred, true);
        }
    }

    public void setEditor(@Nullable EditorWithProviderComposite editor, boolean focusEditor) {
        this.setEditor(editor, true, focusEditor);
    }

    public void setEditor(@Nullable EditorWithProviderComposite editor, boolean selectEditor, boolean focusEditor) {
        if (editor != null) {
            this.onBeforeSetEditor(editor.getFile());
            if (this.myTabbedPane == null) {
                this.myPanel.removeAll();
                this.myPanel.add((Component)new TCompForTablessMode(this, editor), "Center");
                this.myOwner.validate();
                if (selectEditor) {
                    this.setSelectedEditor(editor, focusEditor);
                }
                return;
            }
            int index = this.findEditorIndex(editor);
            if (index != -1) {
                if (selectEditor) {
                    this.setSelectedEditor(editor, focusEditor);
                }
            } else {
                int selectedIndex;
                Integer initialIndex = (Integer)editor.getFile().getUserData(INITIAL_INDEX_KEY);
                int indexToInsert = initialIndex != null ? initialIndex : (Registry.is((String)"ide.editor.tabs.open.at.the.end") ? this.myTabbedPane.getTabCount() : ((selectedIndex = this.myTabbedPane.getSelectedIndex()) >= 0 ? selectedIndex + 1 : 0));
                VirtualFile file2 = editor.getFile();
                Icon template = AllIcons.FileTypes.Text;
                this.myTabbedPane.insertTab(file2, (Icon)EmptyIcon.create((int)template.getIconWidth(), (int)template.getIconHeight()), new TComp(this, editor), null, indexToInsert);
                this.trimToSize(UISettings.getInstance().getEditorTabLimit(), file2, false);
                if (selectEditor) {
                    this.setSelectedEditor(editor, focusEditor);
                }
                this.myOwner.updateFileIcon(file2);
                this.myOwner.updateFileColor(file2);
            }
            this.myOwner.setCurrentWindow(this, false);
        }
        this.myOwner.validate();
    }

    protected void onBeforeSetEditor(VirtualFile file2) {
    }

    private boolean splitAvailable() {
        return this.getTabCount() >= 1;
    }

    @Nullable
    public EditorWindow split(int orientation, boolean forceSplit, @Nullable VirtualFile virtualFile, boolean focusNew) {
        this.checkConsistency();
        FileEditorManagerImpl fileEditorManager = this.myOwner.getManager();
        if (this.splitAvailable()) {
            if (!forceSplit && this.inSplitter()) {
                EditorWindow[] siblings = this.findSiblings();
                EditorWindow target2 = siblings[0];
                if (virtualFile != null) {
                    FileEditor[] editors = (FileEditor[])fileEditorManager.openFileImpl3((EditorWindow)target2, (VirtualFile)virtualFile, (boolean)focusNew, null, (boolean)true).first;
                    this.syncCaretIfPossible(editors);
                }
                return target2;
            }
            JPanel panel2 = this.myPanel;
            panel2.setBorder(null);
            int tabCount = this.getTabCount();
            if (tabCount != 0) {
                EditorWithProviderComposite firstEC = this.getEditorAt(0);
                this.myPanel = new JPanel(new BorderLayout());
                this.myPanel.setOpaque(false);
                OnePixelSplitter splitter = new OnePixelSplitter(orientation == 0, 0.5f, 0.1f, 0.9f);
                EditorWindow res2 = new EditorWindow(this.myOwner);
                if (this.myTabbedPane != null) {
                    EditorWithProviderComposite selectedEditor = this.getSelectedEditor();
                    panel2.remove(this.myTabbedPane.getComponent());
                    panel2.add((Component)splitter, "Center");
                    splitter.setFirstComponent((JComponent)this.myPanel);
                    this.myPanel.add((Component)this.myTabbedPane.getComponent(), "Center");
                    splitter.setSecondComponent((JComponent)res2.myPanel);
                    VirtualFile file2 = selectedEditor.getFile();
                    if (virtualFile == null) {
                        for (FileEditorAssociateFinder finder : FileEditorAssociateFinder.EP_NAME.getExtensionList()) {
                            VirtualFile associatedFile = finder.getAssociatedFileToOpen(fileEditorManager.getProject(), file2);
                            if (associatedFile == null) continue;
                            virtualFile = associatedFile;
                            break;
                        }
                    }
                    VirtualFile nextFile = virtualFile == null ? file2 : virtualFile;
                    HistoryEntry currentState = selectedEditor.currentStateAsHistoryEntry();
                    FileEditor[] editors = (FileEditor[])fileEditorManager.openFileImpl4((EditorWindow)res2, (VirtualFile)nextFile, (HistoryEntry)currentState, (boolean)true, (boolean)focusNew, null, (int)-1, (boolean)true).first;
                    this.syncCaretIfPossible(editors);
                    res2.setFilePinned(nextFile, this.isFilePinned(file2));
                    if (!focusNew) {
                        res2.setSelectedEditor(selectedEditor, true);
                        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)selectedEditor.getComponent(), true));
                    }
                    panel2.revalidate();
                } else {
                    Component oldComp = panel2.getComponent(0);
                    this.myPanel.add(oldComp);
                    panel2.removeAll();
                    panel2.add((Component)splitter, "Center");
                    splitter.setFirstComponent((JComponent)this.myPanel);
                    splitter.setSecondComponent((JComponent)res2.myPanel);
                    panel2.revalidate();
                    VirtualFile firstFile = firstEC.getFile();
                    VirtualFile nextFile = virtualFile == null ? firstFile : virtualFile;
                    HistoryEntry currentState = firstEC.currentStateAsHistoryEntry();
                    fileEditorManager.openFileImpl4(res2, nextFile, currentState, true, focusNew, null, -1, true);
                    if (!focusNew) {
                        IdeFocusManager.getGlobalInstance().requestFocus(oldComp, true);
                    }
                }
                return res2;
            }
        }
        return null;
    }

    private void syncCaretIfPossible(@Nullable FileEditor[] toSync) {
        if (toSync == null) {
            return;
        }
        EditorWithProviderComposite from = this.getSelectedEditor();
        if (from == null) {
            return;
        }
        FileEditor caretSource = from.getSelectedEditor();
        if (!(caretSource instanceof TextEditor)) {
            return;
        }
        Editor editorFrom = ((TextEditor)caretSource).getEditor();
        int offset = editorFrom.getCaretModel().getOffset();
        if (offset <= 0) {
            return;
        }
        int scrollOffset = editorFrom.getScrollingModel().getVerticalScrollOffset();
        for (FileEditor fileEditor : toSync) {
            if (!(fileEditor instanceof TextEditor)) continue;
            Editor editor = ((TextEditor)fileEditor).getEditor();
            if (editorFrom.getDocument() != editor.getDocument()) continue;
            editor.getCaretModel().moveToOffset(offset);
            ScrollingModel scrollingModel = editor.getScrollingModel();
            scrollingModel.scrollVertically(scrollOffset);
            SwingUtilities.invokeLater(() -> {
                if (!editor.isDisposed()) {
                    scrollingModel.scrollToCaret(ScrollType.MAKE_VISIBLE);
                }
            });
        }
    }

    public EditorWindow[] findSiblings() {
        this.checkConsistency();
        ArrayList<EditorWindow> res2 = new ArrayList<EditorWindow>();
        if (this.myPanel.getParent() instanceof Splitter) {
            Splitter splitter = (Splitter)this.myPanel.getParent();
            for (EditorWindow win : this.myOwner.getWindows()) {
                if (win == this || !SwingUtilities.isDescendingFrom(win.myPanel, (Component)splitter)) continue;
                res2.add(win);
            }
        }
        return res2.toArray(new EditorWindow[0]);
    }

    void changeOrientation() {
        this.checkConsistency();
        Container parent = this.myPanel.getParent();
        if (parent instanceof Splitter) {
            Splitter splitter;
            splitter.setOrientation(!(splitter = (Splitter)parent).getOrientation());
        }
    }

    void updateFileIcon(VirtualFile file2) {
        int index = this.findEditorIndex(this.findFileComposite(file2));
        LOG.assertTrue(index != -1);
        this.setIconAt(index, this.getFileIcon(file2));
    }

    void updateFileName(VirtualFile file2) {
        int index = this.findEditorIndex(this.findFileComposite(file2));
        if (index != -1) {
            this.setTitleAt(index, EditorTabPresentationUtil.getEditorTabTitle(this.getManager().getProject(), file2, this));
            this.setToolTipTextAt(index, UISettings.getInstance().getShowTabsTooltips() ? this.getManager().getFileTooltipText(file2) : null);
        }
    }

    private Icon getFileIcon(@NotNull VirtualFile file2) {
        Icon modifiedIcon;
        Icon pinIcon;
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(2);
        }
        if (!file2.isValid()) {
            Icon fakeIcon = FileTypes.UNKNOWN.getIcon();
            assert (fakeIcon != null) : "Can't find the icon for unknown file type";
            return fakeIcon;
        }
        Icon baseIcon = IconUtil.getIcon((VirtualFile)file2, (int)2, (Project)this.getManager().getProject());
        int count = 1;
        EditorWithProviderComposite composite = this.findFileComposite(file2);
        if (composite != null && composite.isPinned()) {
            ++count;
            pinIcon = AllIcons.Nodes.TabPin;
        } else {
            pinIcon = null;
        }
        UISettings settings = UISettings.getInstance();
        if (settings.getMarkModifiedTabsWithAsterisk() || !settings.getHideTabsIfNeed()) {
            modifiedIcon = settings.getMarkModifiedTabsWithAsterisk() && composite != null && ((EditorComposite)composite).isModified() ? MODIFIED_ICON : GAP_ICON;
            ++count;
        } else {
            modifiedIcon = null;
        }
        if (count == 1) {
            return baseIcon;
        }
        int i = 0;
        LayeredIcon result2 = new LayeredIcon(count);
        int xShift = !settings.getHideTabsIfNeed() ? 4 : 0;
        result2.setIcon(baseIcon, i++, xShift, 0);
        if (pinIcon != null) {
            result2.setIcon(pinIcon, i++, xShift, 0);
        }
        if (modifiedIcon != null) {
            result2.setIcon(modifiedIcon, i++);
        }
        return JBUI.scale((JBUI.JBIcon)result2);
    }

    public void unsplit(boolean setCurrent) {
        this.checkConsistency();
        Container splitter = this.myPanel.getParent();
        if (!(splitter instanceof Splitter)) {
            return;
        }
        EditorWithProviderComposite editorToSelect = this.getSelectedEditor();
        EditorWindow[] siblings = this.findSiblings();
        JPanel parent = (JPanel)splitter.getParent();
        for (EditorWindow eachSibling : siblings) {
            EditorWithProviderComposite selected = eachSibling.getSelectedEditor();
            if (editorToSelect != null) continue;
            editorToSelect = selected;
        }
        for (EditorWindow sibling : siblings) {
            EditorWithProviderComposite[] siblingEditors;
            for (EditorWithProviderComposite siblingEditor : siblingEditors = sibling.getEditors()) {
                if (editorToSelect == null) {
                    editorToSelect = siblingEditor;
                }
                this.processSiblingEditor(siblingEditor);
            }
            LOG.assertTrue(sibling != this);
            sibling.dispose();
        }
        parent.remove(splitter);
        if (this.myTabbedPane != null) {
            parent.add((Component)this.myTabbedPane.getComponent(), "Center");
        } else if (this.myPanel.getComponentCount() > 0) {
            parent.add(this.myPanel.getComponent(0), "Center");
        }
        parent.revalidate();
        this.myPanel = parent;
        if (editorToSelect != null) {
            this.setSelectedEditor(editorToSelect, true);
        }
        if (setCurrent) {
            this.myOwner.setCurrentWindow(this, false);
        }
    }

    private void processSiblingEditor(EditorWithProviderComposite siblingEditor) {
        if (this.myTabbedPane != null && this.getTabCount() < UISettings.getInstance().getState().getEditorTabLimit() && this.findFileComposite(siblingEditor.getFile()) == null || this.myTabbedPane == null && this.getTabCount() == 0) {
            this.setEditor(siblingEditor, true);
        } else {
            this.getManager().disposeComposite(siblingEditor);
        }
    }

    void unsplitAll() {
        this.checkConsistency();
        while (this.inSplitter()) {
            this.unsplit(true);
        }
    }

    public boolean inSplitter() {
        this.checkConsistency();
        return this.myPanel.getParent() instanceof Splitter;
    }

    public VirtualFile getSelectedFile() {
        this.checkConsistency();
        EditorWithProviderComposite editor = this.getSelectedEditor();
        return editor == null ? null : editor.getFile();
    }

    @Nullable
    public EditorWithProviderComposite findFileComposite(VirtualFile file2) {
        for (int i = 0; i != this.getTabCount(); ++i) {
            EditorWithProviderComposite editor = this.getEditorAt(i);
            if (!editor.getFile().equals(file2)) continue;
            return editor;
        }
        return null;
    }

    private int findComponentIndex(Component component) {
        for (int i = 0; i != this.getTabCount(); ++i) {
            EditorWithProviderComposite editor = this.getEditorAt(i);
            if (!editor.getComponent().equals(component)) continue;
            return i;
        }
        return -1;
    }

    int findEditorIndex(EditorComposite editorToFind) {
        for (int i = 0; i != this.getTabCount(); ++i) {
            EditorWithProviderComposite editor = this.getEditorAt(i);
            if (!editor.equals(editorToFind)) continue;
            return i;
        }
        return -1;
    }

    int findFileIndex(VirtualFile fileToFind) {
        for (int i = 0; i != this.getTabCount(); ++i) {
            VirtualFile file2 = this.getFileAt(i);
            if (!file2.equals(fileToFind)) continue;
            return i;
        }
        return -1;
    }

    private EditorWithProviderComposite getEditorAt(int i) {
        TComp comp;
        if (this.myTabbedPane != null) {
            comp = (TComp)this.myTabbedPane.getComponentAt(i);
        } else {
            LOG.assertTrue(i <= 1);
            comp = (TComp)this.myPanel.getComponent(i);
        }
        return comp.myEditor;
    }

    public boolean isFileOpen(VirtualFile file2) {
        return this.findFileComposite(file2) != null;
    }

    public boolean isFilePinned(VirtualFile file2) {
        EditorWithProviderComposite editorComposite = this.findFileComposite(file2);
        if (editorComposite == null) {
            throw new IllegalArgumentException("file is not open: " + file2.getPath());
        }
        return editorComposite.isPinned();
    }

    public void setFilePinned(VirtualFile file2, boolean pinned) {
        EditorWithProviderComposite editorComposite = this.findFileComposite(file2);
        if (editorComposite == null) {
            throw new IllegalArgumentException("file is not open: " + file2.getPath());
        }
        boolean wasPinned = editorComposite.isPinned();
        editorComposite.setPinned(pinned);
        if (wasPinned != pinned && ApplicationManager.getApplication().isDispatchThread()) {
            this.updateFileIcon(file2);
        }
    }

    void trimToSize(int limit, @Nullable VirtualFile fileToIgnore, boolean transferFocus) {
        if (this.myTabbedPane == null) {
            return;
        }
        FileEditorManagerEx.getInstanceEx(this.getManager().getProject()).getReady(this).doWhenDone(() -> {
            if (this.myTabbedPane == null) {
                return;
            }
            EditorWithProviderComposite selectedComposite = this.getSelectedEditor();
            try {
                this.doTrimSize(limit, fileToIgnore, UISettings.getInstance().getState().getCloseNonModifiedFilesFirst(), transferFocus);
            }
            finally {
                this.setSelectedEditor(selectedComposite, false);
            }
        });
    }

    private void doTrimSize(int limit, @Nullable VirtualFile fileToIgnore, boolean closeNonModifiedFilesFirst, boolean transferFocus) {
        LinkedHashSet<VirtualFile> closingOrder = this.getTabClosingOrder(closeNonModifiedFilesFirst);
        VirtualFile selectedFile = this.getSelectedFile();
        if (this.shouldCloseSelected(fileToIgnore)) {
            this.defaultCloseFile(selectedFile, transferFocus);
            closingOrder.remove(selectedFile);
        }
        for (VirtualFile file2 : closingOrder) {
            if (this.myTabbedPane.getTabCount() <= limit || this.myTabbedPane.getTabCount() == 0 || this.areAllTabsPinned(fileToIgnore)) {
                return;
            }
            if (!this.fileCanBeClosed(file2, fileToIgnore)) continue;
            this.defaultCloseFile(file2, transferFocus);
        }
    }

    private LinkedHashSet<VirtualFile> getTabClosingOrder(boolean closeNonModifiedFilesFirst) {
        VirtualFile[] allFiles = this.getFiles();
        List<VirtualFile> histFiles = EditorHistoryManager.getInstance(this.getManager().getProject()).getFileList();
        LinkedHashSet closingOrder = ContainerUtil.newLinkedHashSet();
        for (VirtualFile file2 : allFiles) {
            if (histFiles.contains(file2)) continue;
            closingOrder.add(file2);
        }
        if (closeNonModifiedFilesFirst) {
            for (VirtualFile file3 : histFiles) {
                EditorWithProviderComposite composite = this.findFileComposite(file3);
                if (composite == null || this.myOwner.getManager().isChanged(composite)) continue;
                closingOrder.add(file3);
            }
            for (int i = 0; i < this.myTabbedPane.getTabCount(); ++i) {
                VirtualFile file4 = this.getFileAt(i);
                if (this.myOwner.getManager().isChanged(this.getEditorAt(i))) continue;
                closingOrder.add(file4);
            }
        }
        closingOrder.addAll(histFiles);
        for (int i = 0; i < this.myTabbedPane.getTabCount(); ++i) {
            closingOrder.add(this.getFileAt(i));
        }
        VirtualFile selectedFile = this.getSelectedFile();
        closingOrder.remove(selectedFile);
        closingOrder.add(selectedFile);
        return closingOrder;
    }

    private boolean shouldCloseSelected(VirtualFile fileToIgnore) {
        Component owner;
        if (!UISettings.getInstance().getReuseNotModifiedTabs() || !this.myOwner.getManager().getProject().isInitialized()) {
            return false;
        }
        VirtualFile file2 = this.getSelectedFile();
        if (file2 == null || !this.isFileOpen(file2) || this.isFilePinned(file2)) {
            return false;
        }
        if (file2.equals(fileToIgnore)) {
            return false;
        }
        EditorWithProviderComposite composite = this.findFileComposite(file2);
        if (composite == null) {
            return false;
        }
        if (!(ApplicationManager.getApplication().isUnitTestMode() || (owner = IdeFocusManager.getInstance((Project)this.myOwner.getManager().getProject()).getFocusOwner()) != null && SwingUtilities.isDescendingFrom(owner, composite.getSelectedEditor().getComponent()))) {
            return false;
        }
        return !this.myOwner.getManager().isChanged(composite);
    }

    private boolean areAllTabsPinned(VirtualFile fileToIgnore) {
        for (int i = this.myTabbedPane.getTabCount() - 1; i >= 0; --i) {
            if (!this.fileCanBeClosed(this.getFileAt(i), fileToIgnore)) continue;
            return false;
        }
        return true;
    }

    private void defaultCloseFile(VirtualFile file2, boolean transferFocus) {
        this.closeFile(file2, true, transferFocus);
    }

    private boolean fileCanBeClosed(VirtualFile file2, @Nullable VirtualFile fileToIgnore) {
        return this.isFileOpen(file2) && !file2.equals(fileToIgnore) && !this.isFilePinned(file2);
    }

    VirtualFile getFileAt(int i) {
        return this.getEditorAt(i).getFile();
    }

    public void clear() {
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        FileEditorManagerImpl manager = this.getManager();
        FileEditorManagerListener.Before beforePublisher = (FileEditorManagerListener.Before)manager.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER);
        FileEditorManagerListener afterPublisher = (FileEditorManagerListener)manager.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER);
        for (EditorWithProviderComposite composite : this.getEditors()) {
            VirtualFile file2 = composite.getFile();
            beforePublisher.beforeFileClosed((FileEditorManager)manager, file2);
            manager.disposeComposite(composite);
            afterPublisher.fileClosed((FileEditorManager)manager, file2);
        }
        if (this.myTabbedPane == null) {
            this.myPanel.removeAll();
        }
    }

    public String toString() {
        return "EditorWindow: files=" + Arrays.asList(this.getFiles());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "file";
        objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorWindow";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "closeFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateFileBackgroundColor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class TCompForTablessMode
    extends TComp
    implements CloseAction.CloseTarget {
        TCompForTablessMode(@NotNull EditorWindow window, @NotNull EditorWithProviderComposite editor) {
            if (window == null) {
                TCompForTablessMode.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                TCompForTablessMode.$$$reportNull$$$0(1);
            }
            super(window, editor);
        }

        @Override
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                TCompForTablessMode.$$$reportNull$$$0(2);
            }
            if (DATA_KEY.is(dataId)) {
                return this.myWindow;
            }
            if (CloseAction.CloseTarget.KEY.is(dataId)) {
                return this;
            }
            return super.getData(dataId);
        }

        @Override
        public void close() {
            this.myWindow.closeFile(this.myEditor.getFile());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "window";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorWindow$TCompForTablessMode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class TComp
    extends JPanel
    implements DataProvider,
    EditorWindowHolder {
        @NotNull
        final EditorWithProviderComposite myEditor;
        protected final EditorWindow myWindow;

        TComp(@NotNull EditorWindow window, @NotNull EditorWithProviderComposite editor) {
            if (window == null) {
                TComp.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                TComp.$$$reportNull$$$0(1);
            }
            super(new BorderLayout());
            this.myEditor = editor;
            this.myWindow = window;
            this.add((Component)editor.getComponent(), "Center");
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (!this.hasFocus()) {
                            return;
                        }
                        JComponent focus = ((FileEditor)myEditor.getSelectedEditorWithProvider().getFirst()).getPreferredFocusedComponent();
                        if (focus != null && !focus.hasFocus()) {
                            IdeFocusManager.getGlobalInstance().requestFocus((Component)focus, true);
                        }
                    });
                }
            });
            this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

                @Override
                public Component getComponentAfter(Container aContainer, Component aComponent) {
                    return myEditor.getComponent();
                }

                @Override
                public Component getComponentBefore(Container aContainer, Component aComponent) {
                    return myEditor.getComponent();
                }

                @Override
                public Component getFirstComponent(Container aContainer) {
                    return myEditor.getComponent();
                }

                @Override
                public Component getLastComponent(Container aContainer) {
                    return myEditor.getComponent();
                }

                @Override
                public Component getDefaultComponent(Container aContainer) {
                    return myEditor.getComponent();
                }
            });
        }

        @Override
        @NotNull
        public EditorWindow getEditorWindow() {
            EditorWindow editorWindow = this.myWindow;
            if (editorWindow == null) {
                TComp.$$$reportNull$$$0(2);
            }
            return editorWindow;
        }

        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                TComp.$$$reportNull$$$0(3);
            }
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                VirtualFile virtualFile = this.myEditor.getFile();
                return virtualFile.isValid() ? virtualFile : null;
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return this.myEditor.getFileEditorManager().getProject();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "window";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileEditor/impl/EditorWindow$TComp";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorWindow$TComp";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditorWindow";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

