/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.textarea;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.CaretActionListener;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.textarea.TextComponentCaret;
import com.intellij.openapi.editor.textarea.TextComponentEditor;
import com.intellij.util.EventDispatcher;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextComponentCaretModel
implements CaretModel {
    private final JTextComponent myTextComponent;
    private final TextComponentEditor myEditor;
    private final Caret myCaret;
    private final EventDispatcher<CaretActionListener> myCaretActionListeners;

    public TextComponentCaretModel(@NotNull JTextComponent textComponent, @NotNull TextComponentEditor editor) {
        if (textComponent == null) {
            TextComponentCaretModel.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            TextComponentCaretModel.$$$reportNull$$$0(1);
        }
        this.myCaretActionListeners = EventDispatcher.create(CaretActionListener.class);
        this.myTextComponent = textComponent;
        this.myEditor = editor;
        this.myCaret = new TextComponentCaret((Editor)editor);
    }

    public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean blockSelection, boolean scrollToCaret) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void moveToLogicalPosition(@NotNull LogicalPosition pos) {
        if (pos == null) {
            TextComponentCaretModel.$$$reportNull$$$0(2);
        }
        this.moveToOffset(this.myEditor.logicalPositionToOffset(pos), false);
    }

    public void moveToVisualPosition(@NotNull VisualPosition pos) {
        if (pos == null) {
            TextComponentCaretModel.$$$reportNull$$$0(3);
        }
        this.moveToLogicalPosition(this.myEditor.visualToLogicalPosition(pos));
    }

    public void moveToOffset(int offset) {
        this.moveToOffset(offset, false);
    }

    public void moveToOffset(int offset, boolean locateBeforeSoftWrap) {
        int currentPosition;
        int targetOffset = Math.min(offset, this.myTextComponent.getText().length());
        if (targetOffset != (currentPosition = this.myTextComponent.getCaretPosition())) {
            if (targetOffset == this.myTextComponent.getCaret().getMark()) {
                this.myTextComponent.setCaretPosition(currentPosition);
                this.myTextComponent.moveCaretPosition(targetOffset);
            } else {
                this.myTextComponent.setCaretPosition(targetOffset);
            }
        }
    }

    public boolean isUpToDate() {
        return true;
    }

    @NotNull
    public LogicalPosition getLogicalPosition() {
        int lineStart;
        int line;
        int caretPos = this.myTextComponent.getCaretPosition();
        if (this.myTextComponent instanceof JTextArea) {
            JTextArea textArea = (JTextArea)this.myTextComponent;
            try {
                line = textArea.getLineOfOffset(caretPos);
                lineStart = textArea.getLineStartOffset(line);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        } else {
            line = 0;
            lineStart = 0;
        }
        LogicalPosition logicalPosition = new LogicalPosition(line, caretPos - lineStart);
        if (logicalPosition == null) {
            TextComponentCaretModel.$$$reportNull$$$0(4);
        }
        return logicalPosition;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        LogicalPosition pos = this.getLogicalPosition();
        VisualPosition visualPosition = new VisualPosition(pos.line, pos.column);
        if (visualPosition == null) {
            TextComponentCaretModel.$$$reportNull$$$0(5);
        }
        return visualPosition;
    }

    public int getOffset() {
        return this.myTextComponent.getCaretPosition();
    }

    public void addCaretListener(@NotNull CaretListener listener2) {
        if (listener2 == null) {
            TextComponentCaretModel.$$$reportNull$$$0(6);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeCaretListener(@NotNull CaretListener listener2) {
        if (listener2 == null) {
            TextComponentCaretModel.$$$reportNull$$$0(7);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getVisualLineStart() {
        return 0;
    }

    public int getVisualLineEnd() {
        return 0;
    }

    public TextAttributes getTextAttributes() {
        return null;
    }

    public boolean supportsMultipleCarets() {
        return false;
    }

    @NotNull
    public Caret getCurrentCaret() {
        Caret caret = this.myCaret;
        if (caret == null) {
            TextComponentCaretModel.$$$reportNull$$$0(8);
        }
        return caret;
    }

    @NotNull
    public Caret getPrimaryCaret() {
        Caret caret = this.myCaret;
        if (caret == null) {
            TextComponentCaretModel.$$$reportNull$$$0(9);
        }
        return caret;
    }

    public int getCaretCount() {
        return 1;
    }

    @NotNull
    public List<Caret> getAllCarets() {
        List<Caret> list2 = Collections.singletonList(this.myCaret);
        if (list2 == null) {
            TextComponentCaretModel.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @Nullable
    public Caret getCaretAt(@NotNull VisualPosition pos) {
        if (pos == null) {
            TextComponentCaretModel.$$$reportNull$$$0(11);
        }
        return this.myCaret.getVisualPosition().equals((Object)pos) ? this.myCaret : null;
    }

    @Nullable
    public Caret addCaret(@NotNull VisualPosition pos) {
        if (pos == null) {
            TextComponentCaretModel.$$$reportNull$$$0(12);
        }
        return null;
    }

    @Nullable
    public Caret addCaret(@NotNull VisualPosition pos, boolean makePrimary) {
        if (pos == null) {
            TextComponentCaretModel.$$$reportNull$$$0(13);
        }
        return null;
    }

    public boolean removeCaret(@NotNull Caret caret) {
        if (caret == null) {
            TextComponentCaretModel.$$$reportNull$$$0(14);
        }
        return false;
    }

    public void removeSecondaryCarets() {
    }

    public void setCaretsAndSelections(@NotNull List<CaretState> caretStates) {
        if (caretStates == null) {
            TextComponentCaretModel.$$$reportNull$$$0(15);
        }
        if (caretStates.size() != 1) {
            throw new IllegalArgumentException("Exactly one CaretState object must be passed");
        }
        CaretState state = caretStates.get(0);
        if (state != null) {
            if (state.getCaretPosition() != null) {
                this.moveToLogicalPosition(state.getCaretPosition());
            }
            if (state.getSelectionStart() != null && state.getSelectionEnd() != null) {
                this.myEditor.getSelectionModel().setSelection(this.myEditor.logicalPositionToOffset(state.getSelectionStart()), this.myEditor.logicalPositionToOffset(state.getSelectionEnd()));
            }
        }
    }

    public void setCaretsAndSelections(@NotNull List<CaretState> caretStates, boolean updateSystemSelection) {
        if (caretStates == null) {
            TextComponentCaretModel.$$$reportNull$$$0(16);
        }
        this.setCaretsAndSelections(caretStates);
    }

    @NotNull
    public List<CaretState> getCaretsAndSelections() {
        List<CaretState> list2 = Collections.singletonList(new CaretState(this.getLogicalPosition(), this.myEditor.offsetToLogicalPosition(this.myEditor.getSelectionModel().getSelectionStart()), this.myEditor.offsetToLogicalPosition(this.myEditor.getSelectionModel().getSelectionEnd())));
        if (list2 == null) {
            TextComponentCaretModel.$$$reportNull$$$0(17);
        }
        return list2;
    }

    public void runForEachCaret(@NotNull CaretAction action) {
        if (action == null) {
            TextComponentCaretModel.$$$reportNull$$$0(18);
        }
        ((CaretActionListener)this.myCaretActionListeners.getMulticaster()).beforeAllCaretsAction();
        action.perform(this.myCaret);
        ((CaretActionListener)this.myCaretActionListeners.getMulticaster()).afterAllCaretsAction();
    }

    public void runForEachCaret(@NotNull CaretAction action, boolean reverseOrder) {
        if (action == null) {
            TextComponentCaretModel.$$$reportNull$$$0(19);
        }
        this.runForEachCaret(action);
    }

    public void addCaretActionListener(@NotNull CaretActionListener listener2, @NotNull Disposable disposable) {
        if (listener2 == null) {
            TextComponentCaretModel.$$$reportNull$$$0(20);
        }
        if (disposable == null) {
            TextComponentCaretModel.$$$reportNull$$$0(21);
        }
        this.myCaretActionListeners.addListener((EventListener)listener2, disposable);
    }

    public void runBatchCaretOperation(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            TextComponentCaretModel.$$$reportNull$$$0(22);
        }
        runnable2.run();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComponent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/textarea/TextComponentCaretModel";
                break;
            }
            case 6: 
            case 7: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretStates";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/textarea/TextComponentCaretModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogicalPosition";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisualPosition";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentCaret";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryCaret";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCarets";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaretsAndSelections";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "moveToLogicalPosition";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "moveToVisualPosition";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addCaretListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeCaretListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCaretAt";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addCaret";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeCaret";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setCaretsAndSelections";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "runForEachCaret";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addCaretActionListener";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "runBatchCaretOperation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

