/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.openapi.editor.colors.impl.ValueElementReader;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Color;
import org.intellij.lang.annotations.JdkConstants;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

class TextAttributesReader
extends ValueElementReader {
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String OPTION = "option";
    @NonNls
    private static final String BACKGROUND = "BACKGROUND";
    @NonNls
    private static final String FOREGROUND = "FOREGROUND";
    @NonNls
    private static final String ERROR_STRIPE = "ERROR_STRIPE_COLOR";
    @NonNls
    private static final String EFFECT_COLOR = "EFFECT_COLOR";
    @NonNls
    private static final String EFFECT_TYPE = "EFFECT_TYPE";
    @NonNls
    private static final String FONT_TYPE = "FONT_TYPE";

    TextAttributesReader() {
    }

    @Override
    public <T> T read(Class<T> type, Element element) {
        if (!TextAttributes.class.equals(type)) {
            return super.read(type, element);
        }
        TextAttributes attributes = new TextAttributes();
        if (element != null) {
            attributes.setAttributes(this.readChild(Color.class, element, FOREGROUND), this.readChild(Color.class, element, BACKGROUND), this.readChild(Color.class, element, EFFECT_COLOR), this.readChild(Color.class, element, ERROR_STRIPE), Effect.read(this, element), FontStyle.read(this, element));
        }
        return (T)attributes;
    }

    private <T> T readChild(Class<T> type, Element element, String name) {
        for (Element option2 : element.getChildren(OPTION)) {
            if (!name.equals(option2.getAttributeValue(NAME))) continue;
            return this.read(type, option2);
        }
        return null;
    }

    private static enum FontStyle {
        PLAIN(0),
        BOLD(1),
        ITALIC(2),
        BOLD_ITALIC(3);

        private final int myStyle;

        private FontStyle(int style) {
            this.myStyle = style;
        }

        @JdkConstants.FontStyle
        static int read(TextAttributesReader reader, Element element) {
            FontStyle style = (FontStyle)((Object)reader.readChild(FontStyle.class, element, TextAttributesReader.FONT_TYPE));
            return style != null ? style.myStyle : 0;
        }
    }

    private static enum Effect {
        BORDER(EffectType.BOXED),
        LINE(EffectType.LINE_UNDERSCORE),
        WAVE(EffectType.WAVE_UNDERSCORE),
        STRIKEOUT(EffectType.STRIKEOUT),
        BOLD_LINE(EffectType.BOLD_LINE_UNDERSCORE),
        BOLD_DOTTED_LINE(EffectType.BOLD_DOTTED_LINE);

        private final EffectType myType;

        private Effect(EffectType type) {
            this.myType = type;
        }

        static EffectType read(TextAttributesReader reader, Element element) {
            Effect effect = (Effect)((Object)reader.readChild(Effect.class, element, TextAttributesReader.EFFECT_TYPE));
            return effect != null ? effect.myType : EffectType.BOXED;
        }
    }
}

