/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.highlighting;

import com.intellij.codeInsight.daemon.RainbowVisitor;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.json.highlighting.JsonSyntaxHighlighterFactory;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class JsonRainbowVisitor
extends RainbowVisitor {
    @Override
    public boolean suitableForFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            JsonRainbowVisitor.$$$reportNull$$$0(0);
        }
        return file2 instanceof JsonFile;
    }

    @Override
    public void visit(@NotNull PsiElement element) {
        if (element == null) {
            JsonRainbowVisitor.$$$reportNull$$$0(1);
        }
        if (element instanceof JsonProperty) {
            String name = ((JsonProperty)element).getName();
            PsiFile file2 = element.getContainingFile();
            this.addInfo(this.getInfo((PsiElement)file2, ((JsonProperty)element).getNameElement(), name, JsonSyntaxHighlighterFactory.JSON_PROPERTY_KEY));
            JsonValue value = ((JsonProperty)element).getValue();
            if (value instanceof JsonObject) {
                this.addInfo(this.getInfo((PsiElement)file2, value.getFirstChild(), name, JsonSyntaxHighlighterFactory.JSON_BRACES));
                this.addInfo(this.getInfo((PsiElement)file2, value.getLastChild(), name, JsonSyntaxHighlighterFactory.JSON_BRACES));
            } else if (value instanceof JsonArray) {
                this.addInfo(this.getInfo((PsiElement)file2, value.getFirstChild(), name, JsonSyntaxHighlighterFactory.JSON_BRACKETS));
                this.addInfo(this.getInfo((PsiElement)file2, value.getLastChild(), name, JsonSyntaxHighlighterFactory.JSON_BRACKETS));
                for (JsonValue jsonValue : ((JsonArray)value).getValueList()) {
                    this.addSimpleValueInfo(name, file2, jsonValue);
                }
            } else {
                this.addSimpleValueInfo(name, file2, value);
            }
        }
    }

    private void addSimpleValueInfo(String name, PsiFile file2, JsonValue value) {
        if (value instanceof JsonStringLiteral) {
            this.addInfo(this.getInfo((PsiElement)file2, value, name, JsonSyntaxHighlighterFactory.JSON_STRING));
        } else if (value instanceof JsonNumberLiteral) {
            this.addInfo(this.getInfo((PsiElement)file2, value, name, JsonSyntaxHighlighterFactory.JSON_NUMBER));
        } else if (value instanceof JsonLiteral) {
            this.addInfo(this.getInfo((PsiElement)file2, value, name, JsonSyntaxHighlighterFactory.JSON_KEYWORD));
        }
    }

    @Override
    @NotNull
    public HighlightVisitor clone() {
        JsonRainbowVisitor jsonRainbowVisitor = new JsonRainbowVisitor();
        if (jsonRainbowVisitor == null) {
            JsonRainbowVisitor.$$$reportNull$$$0(2);
        }
        return jsonRainbowVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/highlighting/JsonRainbowVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/highlighting/JsonRainbowVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suitableForFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

