/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.codeinsight;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.icons.AllIcons;
import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonDuplicatePropertyKeysInspection
extends LocalInspectionTool {
    private static final String COMMENT = "$comment";

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JsonBundle.message("inspection.duplicate.keys.name", new Object[0]);
        if (string == null) {
            JsonDuplicatePropertyKeysInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            JsonDuplicatePropertyKeysInspection.$$$reportNull$$$0(1);
        }
        final boolean isSchemaFile = JsonSchemaService.isSchemaFile(holder.getFile());
        JsonElementVisitor jsonElementVisitor = new JsonElementVisitor(){

            @Override
            public void visitObject(@NotNull JsonObject o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                MultiMap keys = new MultiMap();
                for (JsonProperty property : o.getPropertyList()) {
                    keys.putValue((Object)property.getName(), (Object)property.getNameElement());
                }
                for (Map.Entry entry : keys.entrySet()) {
                    Collection sameNamedKeys = (Collection)entry.getValue();
                    String entryKey = (String)entry.getKey();
                    if (sameNamedKeys.size() <= 1 || isSchemaFile && JsonDuplicatePropertyKeysInspection.COMMENT.equalsIgnoreCase(entryKey)) continue;
                    for (PsiElement element : sameNamedKeys) {
                        holder.registerProblem(element, JsonBundle.message("inspection.duplicate.keys.msg.duplicate.keys", entryKey), new LocalQuickFix[]{new NavigateToDuplicatesFix(sameNamedKeys, element, entryKey)});
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/json/codeinsight/JsonDuplicatePropertyKeysInspection$1", "visitObject"));
            }
        };
        if (jsonElementVisitor == null) {
            JsonDuplicatePropertyKeysInspection.$$$reportNull$$$0(2);
        }
        return jsonElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/codeinsight/JsonDuplicatePropertyKeysInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/codeinsight/JsonDuplicatePropertyKeysInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NavigateToDuplicatesFix
    extends LocalQuickFixBase {
        @NotNull
        private final Collection<SmartPsiElementPointer> mySameNamedKeys;
        @NotNull
        private final SmartPsiElementPointer myElement;
        @NotNull
        private final String myEntryKey;

        private NavigateToDuplicatesFix(@NotNull Collection<PsiElement> sameNamedKeys, @NotNull PsiElement element, @NotNull String entryKey) {
            if (sameNamedKeys == null) {
                NavigateToDuplicatesFix.$$$reportNull$$$0(0);
            }
            if (element == null) {
                NavigateToDuplicatesFix.$$$reportNull$$$0(1);
            }
            if (entryKey == null) {
                NavigateToDuplicatesFix.$$$reportNull$$$0(2);
            }
            super("Navigate to duplicates");
            this.mySameNamedKeys = ContainerUtil.map(sameNamedKeys, k -> SmartPointerManager.createPointer((PsiElement)k));
            this.myElement = SmartPointerManager.createPointer((PsiElement)element);
            this.myEntryKey = entryKey;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Editor editor;
            if (project == null) {
                NavigateToDuplicatesFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                NavigateToDuplicatesFix.$$$reportNull$$$0(4);
            }
            if ((editor = PsiEditorUtil.Service.getInstance().findEditorByPsiElement(descriptor.getPsiElement())) == null) {
                return;
            }
            this.applyFix(editor);
        }

        private void applyFix(final @NotNull Editor editor) {
            if (editor == null) {
                NavigateToDuplicatesFix.$$$reportNull$$$0(5);
            }
            PsiElement currentElement = this.myElement.getElement();
            if (this.mySameNamedKeys.size() == 2) {
                PsiElement toNavigate;
                Iterator<SmartPsiElementPointer> iterator = this.mySameNamedKeys.iterator();
                PsiElement next = iterator.next().getElement();
                PsiElement psiElement = toNavigate = next != currentElement ? next : iterator.next().getElement();
                if (toNavigate == null) {
                    return;
                }
                NavigateToDuplicatesFix.navigateTo(editor, toNavigate);
            } else {
                List allElements = this.mySameNamedKeys.stream().map(k -> k.getElement()).filter(k -> k != currentElement).collect(Collectors.toList());
                JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<PsiElement>("Duplicates of '" + this.myEntryKey + "'", allElements){

                    @NotNull
                    public Icon getIconFor(PsiElement aValue) {
                        Icon icon = AllIcons.Nodes.Property;
                        if (icon == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return icon;
                    }

                    @NotNull
                    public String getTextFor(PsiElement value) {
                        String string = "'" + myEntryKey + "' at line #" + editor.getDocument().getLineNumber(value.getTextOffset());
                        if (string == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return string;
                    }

                    public int getDefaultOptionIndex() {
                        return 0;
                    }

                    @Nullable
                    public PopupStep onChosen(PsiElement selectedValue, boolean finalChoice) {
                        NavigateToDuplicatesFix.navigateTo(editor, selectedValue);
                        return PopupStep.FINAL_CHOICE;
                    }

                    public boolean isSpeedSearchEnabled() {
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = "com/intellij/json/codeinsight/JsonDuplicatePropertyKeysInspection$NavigateToDuplicatesFix$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getIconFor";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getTextFor";
                                break;
                            }
                        }
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                    }
                }).showInBestPositionFor(editor);
            }
        }

        private static void navigateTo(@NotNull Editor editor, @NotNull PsiElement toNavigate) {
            if (editor == null) {
                NavigateToDuplicatesFix.$$$reportNull$$$0(6);
            }
            if (toNavigate == null) {
                NavigateToDuplicatesFix.$$$reportNull$$$0(7);
            }
            editor.getCaretModel().moveToOffset(toNavigate.getTextOffset());
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sameNamedKeys";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entryKey";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toNavigate";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/json/codeinsight/JsonDuplicatePropertyKeysInspection$NavigateToDuplicatesFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFix";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "navigateTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

