/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.utils;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginType;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.extensions.PluginId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\b\u001a\u00020\u00012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n\u001a\u0010\u0010\u000b\u001a\u00020\u00012\b\u0010\f\u001a\u0004\u0018\u00010\r\u001a\u0010\u0010\u000e\u001a\u00020\u00012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\u00a8\u0006\u0011"}, d2={"notListedPlugin", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "getNotListedPlugin", "()Lcom/intellij/internal/statistic/utils/PluginInfo;", "platformPlugin", "getPlatformPlugin", "unknownPlugin", "getUnknownPlugin", "getPluginInfo", "clazz", "Ljava/lang/Class;", "getPluginInfoByDescriptor", "plugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "getPluginInfoById", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "intellij.platform.ide.impl"})
public final class PluginInfoDetectorKt {
    @NotNull
    private static final PluginInfo platformPlugin = new PluginInfo(PluginType.PLATFORM, null);
    @NotNull
    private static final PluginInfo unknownPlugin = new PluginInfo(PluginType.UNKNOWN, null);
    @NotNull
    private static final PluginInfo notListedPlugin = new PluginInfo(PluginType.NOT_LISTED, null);

    @NotNull
    public static final PluginInfo getPluginInfo(@NotNull Class<?> clazz) {
        String className;
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        String string = className = clazz.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className");
        if (StringsKt.startsWith$default((String)string, (String)"java.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"javax.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"kotlin.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"groovy.", (boolean)false, (int)2, null)) {
            return platformPlugin;
        }
        PluginId pluginId = PluginManagerCore.getPluginOrPlatformByClassName(className);
        if (pluginId == null) {
            return unknownPlugin;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)pluginId, (String)"PluginManagerCore.getPlu\u2026) ?: return unknownPlugin");
        PluginId pluginId2 = pluginId;
        if (Intrinsics.areEqual((Object)"com.intellij", (Object)pluginId2.getIdString())) {
            return platformPlugin;
        }
        return PluginInfoDetectorKt.getPluginInfoById(pluginId2);
    }

    @NotNull
    public static final PluginInfo getPluginInfoById(@Nullable PluginId pluginId) {
        if (pluginId == null) {
            return unknownPlugin;
        }
        return PluginInfoDetectorKt.getPluginInfoByDescriptor(PluginManager.getPlugin(pluginId));
    }

    @NotNull
    public static final PluginInfo getPluginInfoByDescriptor(@Nullable IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            return unknownPlugin;
        }
        PluginId pluginId = plugin.getPluginId();
        Intrinsics.checkExpressionValueIsNotNull((Object)pluginId, (String)"plugin.pluginId");
        String string = pluginId.getIdString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"plugin.pluginId.idString");
        String id = string;
        if (PluginManagerMain.isDevelopedByJetBrains(plugin)) {
            return plugin.isBundled() ? new PluginInfo(PluginType.JB_BUNDLED, id) : new PluginInfo(PluginType.JB_NOT_BUNDLED, id);
        }
        boolean listed = !plugin.isBundled() && StatisticsUtilKt.isSafeToReport(id);
        return listed ? new PluginInfo(PluginType.LISTED, id) : notListedPlugin;
    }

    @NotNull
    public static final PluginInfo getPlatformPlugin() {
        return platformPlugin;
    }

    @NotNull
    public static final PluginInfo getUnknownPlugin() {
        return unknownPlugin;
    }

    @NotNull
    public static final PluginInfo getNotListedPlugin() {
        return notListedPlugin;
    }
}

