/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.internal.statistic.service.fus.collectors.UsagesCollectorConsumer;
import com.intellij.openapi.extensions.ExtensionPointName;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class FeatureUsagesCollector {
    private static final String GROUP_ID_PATTERN = "([a-zA-Z]*\\.)*[a-zA-Z]*";

    public final boolean isValid() {
        return Pattern.compile(GROUP_ID_PATTERN).matcher(this.getGroupId()).matches();
    }

    protected static <T extends FeatureUsagesCollector> Set<T> getExtensions(@NotNull UsagesCollectorConsumer invoker, ExtensionPointName<T> ep) {
        if (invoker == null) {
            FeatureUsagesCollector.$$$reportNull$$$0(0);
        }
        if (invoker.getClass().getClassLoader() instanceof PluginClassLoader) {
            return Collections.emptySet();
        }
        return Arrays.stream(ep.getExtensions()).filter(u -> u.isValid()).collect(Collectors.toSet());
    }

    @NotNull
    public abstract String getGroupId();

    public int getVersion() {
        return 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invoker", "com/intellij/internal/statistic/service/fus/collectors/FeatureUsagesCollector", "getExtensions"));
    }
}

