/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.GsonBuilder;
import com.intellij.internal.statistic.service.fus.FUSWhitelist;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FUStatisticsWhiteListGroupsService {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.internal.statistic.service.whiteList.FUStatisticsWhiteListGroupsService");

    @Nullable
    public static FUSWhitelist getApprovedGroups(@NotNull String serviceUrl, @NotNull BuildNumber current) {
        if (serviceUrl == null) {
            FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(0);
        }
        if (current == null) {
            FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(1);
        }
        String content = null;
        try {
            content = HttpRequests.request((String)serviceUrl).productNameAsUserAgent().readString(null);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        return content != null ? FUStatisticsWhiteListGroupsService.parseApprovedGroups(content, current) : null;
    }

    @VisibleForTesting
    @NotNull
    public static FUSWhitelist parseApprovedGroups(String content, @NotNull BuildNumber build2) {
        if (build2 == null) {
            FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(2);
        }
        WLGroups groups = null;
        try {
            groups = (WLGroups)new GsonBuilder().create().fromJson(content, WLGroups.class);
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
        if (groups == null) {
            FUSWhitelist fUSWhitelist = FUSWhitelist.empty();
            if (fUSWhitelist == null) {
                FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(3);
            }
            return fUSWhitelist;
        }
        Map<String, List<FUSWhitelist.VersionRange>> result2 = groups.groups.stream().filter(group -> group.accepts(build2)).collect(Collectors.toMap(group -> group.id, group -> FUStatisticsWhiteListGroupsService.toVersionRanges(group.versions)));
        FUSWhitelist fUSWhitelist = FUSWhitelist.create(result2);
        if (fUSWhitelist == null) {
            FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(4);
        }
        return fUSWhitelist;
    }

    @NotNull
    private static List<FUSWhitelist.VersionRange> toVersionRanges(@Nullable ArrayList<WLVersion> versions) {
        List list2 = versions == null || versions.isEmpty() ? ContainerUtil.emptyList() : ContainerUtil.map(versions, version2 -> FUSWhitelist.VersionRange.create(version2.from, version2.to));
        if (list2 == null) {
            FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(5);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceUrl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "build";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/service/fus/FUStatisticsWhiteListGroupsService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/service/fus/FUStatisticsWhiteListGroupsService";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseApprovedGroups";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toVersionRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getApprovedGroups";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseApprovedGroups";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class WLBuild {
        public final String from;
        public final String to;

        private WLBuild(String from, String to) {
            this.from = from;
            this.to = to;
        }

        public boolean contains(BuildNumber build2) {
            return !(!StringUtil.isEmpty((String)this.to) && BuildNumber.fromString((String)this.to).compareTo(build2) <= 0 || !StringUtil.isEmpty((String)this.from) && BuildNumber.fromString((String)this.from).compareTo(build2) > 0);
        }
    }

    private static class WLVersion {
        public final String from;
        public final String to;

        private WLVersion(String from, String to) {
            this.from = from;
            this.to = to;
        }
    }

    private static class WLGroup {
        @Nullable
        public final String id;
        @Nullable
        public final ArrayList<WLBuild> builds = new ArrayList();
        @Nullable
        public final ArrayList<WLVersion> versions = new ArrayList();

        WLGroup(@Nullable String id) {
            this.id = id;
        }

        public boolean accepts(BuildNumber current) {
            if (!this.isValid()) {
                return false;
            }
            boolean hasBuilds = this.builds != null && !this.builds.isEmpty();
            return !hasBuilds || this.builds.stream().anyMatch(build2 -> build2.contains(current));
        }

        private boolean isValid() {
            boolean hasBuilds = this.builds != null && !this.builds.isEmpty();
            boolean hasVersions = this.versions != null && !this.versions.isEmpty();
            return StringUtil.isNotEmpty((String)this.id) && (hasBuilds || hasVersions);
        }
    }

    private static class WLGroups {
        @NotNull
        public final ArrayList<WLGroup> groups = new ArrayList();

        private WLGroups() {
        }
    }
}

