/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.os;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OsVersionUsageCollector {
    private static final Set<String> ourReleases = ContainerUtil.newHashSet((Object[])new String[]{"alpine", "amzn", "antergos", "arch", "centos", "debian", "deepin", "elementary", "fedora", "galliumos", "gentoo", "kali", "linuxmint", "manjaro", "neon", "nixos", "ol", "opensuse", "opensuse-leap", "opensuse-tumbleweed", "freedesktop", "parrot", "raspbian", "rhel", "sabayon", "solus", "ubuntu", "zorin"});

    @NotNull
    public static LinuxRelease getLinuxRelease() {
        String releaseId = null;
        String releaseVersion = null;
        try (Stream<String> lines2 = Files.lines(Paths.get("/etc/os-release", new String[0]));){
            Map<String, String> releases = lines2.map(line -> StringUtil.split((String)line, (String)"=")).filter(parts -> parts.size() == 2).collect(Collectors.toMap(parts -> (String)parts.get(0), parts -> StringUtil.unquoteString((String)((String)parts.get(1)))));
            releaseId = releases.get("ID");
            releaseVersion = releases.get("VERSION_ID");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LinuxRelease linuxRelease = new LinuxRelease(OsVersionUsageCollector.parseName(releaseId), releaseVersion != null ? releaseVersion : SystemInfo.OS_VERSION);
        if (linuxRelease == null) {
            OsVersionUsageCollector.$$$reportNull$$$0(0);
        }
        return linuxRelease;
    }

    @Nullable
    public static Version parse(@Nullable String releaseVersion) {
        return releaseVersion != null ? Version.parseVersion((String)releaseVersion.trim()) : null;
    }

    @NotNull
    private static String parseName(@Nullable String releaseId) {
        if (releaseId == null) {
            if ("unknown" == null) {
                OsVersionUsageCollector.$$$reportNull$$$0(1);
            }
            return "unknown";
        }
        String release2 = StringUtil.trimStart((String)StringUtil.toLowerCase((String)releaseId).trim(), (String)"org.");
        int separator = release2.indexOf(".");
        if (separator > 0) {
            release2 = release2.substring(0, separator);
        }
        if (ourReleases.contains(release2)) {
            String string = release2;
            if (string == null) {
                OsVersionUsageCollector.$$$reportNull$$$0(2);
            }
            return string;
        }
        if ("custom" == null) {
            OsVersionUsageCollector.$$$reportNull$$$0(3);
        }
        return "custom";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/internal/statistic/collectors/fus/os/OsVersionUsageCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinuxRelease";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class LinuxRelease {
        @NotNull
        private final String myRelease;
        @Nullable
        private final String myVersion;

        public LinuxRelease(@NotNull String release2, @Nullable String version2) {
            if (release2 == null) {
                LinuxRelease.$$$reportNull$$$0(0);
            }
            this.myRelease = release2;
            this.myVersion = version2;
        }

        @NotNull
        public String getRelease() {
            String string = this.myRelease;
            if (string == null) {
                LinuxRelease.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public String getVersion() {
            return this.myVersion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "release";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/os/OsVersionUsageCollector$LinuxRelease";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/os/OsVersionUsageCollector$LinuxRelease";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRelease";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

