/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.jdkEx.JdkEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.openapi.wm.impl.customFrameDecorations.CustomFrameTitleButtons;
import com.intellij.openapi.wm.impl.customFrameDecorations.ResizableCustomFrameTitleButtons;
import com.intellij.openapi.wm.impl.customFrameDecorations.titleLabel.CustomDecorationPath;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;

public class DarculaTitlePane
extends JPanel
implements Disposable {
    private PropertyChangeListener myPropertyChangeListener;
    private ComponentListener myComponentListener;
    private JMenuBar myMenuBar;
    private JMenuBar myIdeMenu;
    private Action myCloseAction;
    private Action myIconifyAction;
    private Action myRestoreAction;
    private Action myMaximizeAction;
    private WindowListener myWindowListener;
    private Window myWindow;
    private final JRootPane myRootPane;
    private int myState;
    private CustomFrameTitleButtons buttonPanes;
    private final JLabel titleLabel = new JLabel();
    private final CustomDecorationPath mySelectedEditorFilePath = new CustomDecorationPath(this);
    private final Color myInactiveForeground = UIManager.getColor("inactiveCaptionText");
    private Color myActiveForeground = null;
    private boolean myIsActive;
    private MyTopBorder myTopBorder = new MyTopBorder();
    private static final int menuBarGap = 7;
    private static final int minMenuHeight = 24;
    private static final int resizeGap = JBUI.scale((int)3);

    public DarculaTitlePane(JRootPane root) {
        this.myRootPane = root;
        this.myState = -1;
        this.installSubcomponents();
        this.determineColors();
        this.installDefaults();
        this.setOpaque(true);
        this.setBackground(JBUI.CurrentTheme.CustomFrameDecorations.titlePaneBackground());
        this.setBorder(this.myTopBorder);
    }

    private void uninstall() {
        this.uninstallListeners();
        this.myWindow = null;
        this.removeAll();
    }

    private void installListeners() {
        if (this.myWindow != null) {
            this.myWindowListener = this.createWindowListener();
            this.myWindow.addWindowListener(this.myWindowListener);
            this.myWindow.addWindowStateListener((WindowStateListener)((Object)this.myWindowListener));
            this.myComponentListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    DarculaTitlePane.this.setCustomDecorationHitTestSpots();
                }
            };
            this.addComponentListener(this.myComponentListener);
        }
    }

    private void uninstallListeners() {
        if (this.myWindow != null) {
            this.myWindow.removeWindowListener(this.myWindowListener);
            this.removeComponentListener(this.myComponentListener);
        }
    }

    private WindowListener createWindowListener() {
        return new WindowHandler();
    }

    @Override
    public JRootPane getRootPane() {
        return this.myRootPane;
    }

    private int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.myWindow = SwingUtilities.getWindowAncestor(this);
        if (this.myWindow != null) {
            if (this.myWindow instanceof Frame) {
                this.setState(((Frame)this.myWindow).getExtendedState());
            } else {
                this.setState(0);
            }
            this.installListeners();
        }
        this.setCustomDecorationHitTestSpots();
    }

    private void setCustomDecorationHitTestSpots() {
        int state;
        ArrayList<Rectangle> hitTestSpots = new ArrayList<Rectangle>();
        Rectangle iconRect = new RelativeRectangle((JComponent)this.myMenuBar).getRectangleOn((Component)this);
        Rectangle menuRect = new RelativeRectangle((JComponent)this.myIdeMenu).getRectangleOn((Component)this);
        Rectangle buttonsRect = new RelativeRectangle(this.buttonPanes.getView()).getRectangleOn((Component)this);
        Frame frame = this.getFrame();
        if (frame != null && (state = frame.getExtendedState()) != 4 && state != 6) {
            menuRect.y += Math.round(menuRect.height / 3);
            iconRect.y += resizeGap;
            iconRect.x += resizeGap;
            buttonsRect.y += resizeGap;
            buttonsRect.x += resizeGap;
            buttonsRect.width -= resizeGap;
        }
        hitTestSpots.add(menuRect);
        hitTestSpots.addAll(this.mySelectedEditorFilePath.getListenerBounds());
        hitTestSpots.add(iconRect);
        hitTestSpots.add(buttonsRect);
        JdkEx.setCustomDecorationHitTestSpots(this.myWindow, hitTestSpots);
    }

    public void dispose() {
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.myWindow = null;
    }

    private void installSubcomponents() {
        int decorationStyle = this.getWindowDecorationStyle();
        if (decorationStyle == 1) {
            this.setLayout((LayoutManager)new MigLayout("novisualpadding, fillx, ins 0, gap 0, top", "7[pref!]7[][pref!]"));
            this.createActions();
            this.buttonPanes = ResizableCustomFrameTitleButtons.Companion.create(this.myCloseAction, this.myRestoreAction, this.myIconifyAction, this.myMaximizeAction);
            this.myMenuBar = this.createMenuBar();
            this.add(this.myMenuBar);
            if (this.myRootPane instanceof IdeRootPane) {
                this.myIdeMenu = new IdeMenuBar(ActionManagerEx.getInstanceEx(), DataManager.getInstance()){

                    @Override
                    public Border getBorder() {
                        return JBUI.Borders.empty();
                    }
                };
                JPanel pane = new JPanel((LayoutManager)new MigLayout("fillx, ins 0, novisualpadding", "[pref!][]"));
                pane.setOpaque(false);
                pane.add((Component)this.myIdeMenu, "wmin 0, wmax pref, top, hmin 24");
                pane.add((Component)this.mySelectedEditorFilePath.getView(), "center, growx, wmin 0, gapbefore 7, gapafter 7");
                this.add((Component)pane, "wmin 0, growx");
            } else {
                this.add((Component)this.titleLabel, "growx, snap 2");
            }
            this.add((Component)this.buttonPanes.getView(), "top, wmin pref");
        } else if (decorationStyle == 2 || decorationStyle == 3 || decorationStyle == 4 || decorationStyle == 5 || decorationStyle == 6 || decorationStyle == 7 || decorationStyle == 8) {
            this.setLayout((LayoutManager)new MigLayout("fill, novisualpadding, ins 0, gap 0", "7[pref!]push[pref!]"));
            this.createActions();
            this.add((Component)this.titleLabel, "growx");
            this.buttonPanes = CustomFrameTitleButtons.Companion.create(this.myCloseAction);
            this.add(this.buttonPanes.getView());
        }
    }

    private void determineColors() {
        switch (this.getWindowDecorationStyle()) {
            case 4: {
                this.myActiveForeground = UIManager.getColor("OptionPane.errorDialog.titlePane.foreground");
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.myActiveForeground = UIManager.getColor("OptionPane.questionDialog.titlePane.foreground");
                break;
            }
            case 8: {
                this.myActiveForeground = UIManager.getColor("OptionPane.warningDialog.titlePane.foreground");
                break;
            }
            default: {
                this.myActiveForeground = UIManager.getColor("activeCaptionText");
            }
        }
    }

    private void installDefaults() {
        this.setFont((Font)JBUI.Fonts.label().asBold());
    }

    protected JMenuBar createMenuBar() {
        this.myMenuBar = new JMenuBar(){
            private final JBUI.ScaleContext.Cache<Icon> myIconProvider = new JBUI.ScaleContext.Cache(ctx -> (Icon)ObjectUtils.notNull((Object)AppUIUtil.loadHiDPIApplicationIcon(ctx, 16), (Object)AllIcons.Icon_small));

            private Icon getIcon() {
                if (DarculaTitlePane.this.myWindow == null) {
                    return AllIcons.Icon_small;
                }
                JBUI.ScaleContext ctx = JBUI.ScaleContext.create((Component)DarculaTitlePane.this.myWindow);
                ctx.overrideScale(JBUI.ScaleType.USR_SCALE.of(1.0));
                return (Icon)this.myIconProvider.getOrProvide((JBUI.BaseScaleContext)ctx);
            }

            @Override
            public Dimension getPreferredSize() {
                return this.getMinimumSize();
            }

            @Override
            public Dimension getMinimumSize() {
                Icon icon = this.getIcon();
                return new Dimension(icon.getIconWidth(), icon.getIconHeight());
            }

            @Override
            public void paint(Graphics g) {
                this.getIcon().paintIcon(this, g, 0, 0);
            }
        };
        JMenu menu = new JMenu(){

            @Override
            public Dimension getPreferredSize() {
                return DarculaTitlePane.this.myMenuBar.getPreferredSize();
            }
        };
        this.myMenuBar.add(menu);
        this.myMenuBar.setOpaque(false);
        menu.setFocusable(false);
        menu.setBorderPainted(true);
        if (this.getWindowDecorationStyle() == 1) {
            this.addMenuItems(menu);
        }
        return this.myMenuBar;
    }

    private void close() {
        Window window = this.getWindow();
        if (window != null) {
            Disposer.dispose((Disposable)this);
            window.dispatchEvent(new WindowEvent(window, 201));
        }
    }

    private void iconify() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.myState | 1);
        }
    }

    private void maximize() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.myState | 6);
        }
    }

    private void restore() {
        Frame frame = this.getFrame();
        if (frame == null) {
            return;
        }
        if ((this.myState & 1) != 0) {
            frame.setExtendedState(this.myState & 0xFFFFFFFE);
        } else {
            frame.setExtendedState(this.myState & 0xFFFFFFF9);
        }
    }

    private void createActions() {
        this.myCloseAction = new CloseAction();
        if (this.getWindowDecorationStyle() == 1) {
            this.myIconifyAction = new IconifyAction();
            this.myRestoreAction = new RestoreAction();
            this.myMaximizeAction = new MaximizeAction();
        }
    }

    private void addMenuItems(JMenu menu) {
        menu.add(this.myRestoreAction);
        menu.add(this.myIconifyAction);
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            menu.add(this.myMaximizeAction);
        }
        menu.add(new JSeparator());
        JMenuItem closeMenuItem = menu.add(this.myCloseAction);
        closeMenuItem.setFont(this.getFont().deriveFont(1));
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        super.paintComponent(g);
    }

    private void setState(int state) {
        this.setState(state, false);
    }

    private void setState(int state, boolean updateRegardless) {
        Window wnd = this.getWindow();
        this.titleLabel.setText(this.getTitle());
        if (wnd != null && this.getWindowDecorationStyle() == 1) {
            if (this.myState == state && !updateRegardless) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                if (frame.isResizable()) {
                    if ((state & 6) != 0) {
                        this.myMaximizeAction.setEnabled(false);
                        this.myRestoreAction.setEnabled(true);
                    } else {
                        this.myMaximizeAction.setEnabled(true);
                        this.myRestoreAction.setEnabled(false);
                    }
                } else {
                    this.myMaximizeAction.setEnabled(false);
                    this.myRestoreAction.setEnabled(false);
                }
            } else {
                this.myMaximizeAction.setEnabled(false);
                this.myRestoreAction.setEnabled(false);
                this.myIconifyAction.setEnabled(false);
            }
            this.myCloseAction.setEnabled(true);
            this.myState = state;
        }
        if (this.buttonPanes != null) {
            this.buttonPanes.updateVisibility();
        }
    }

    private void setActive(boolean isSelected) {
        this.buttonPanes.setSelected(isSelected);
        this.titleLabel.setForeground(isSelected ? this.myActiveForeground : this.myInactiveForeground);
        this.myIsActive = isSelected;
        this.repaintTopBorderArea();
    }

    private void repaintTopBorderArea() {
        this.repaint(0, 0, this.getWidth(), 1);
    }

    private Frame getFrame() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    private Window getWindow() {
        return this.myWindow;
    }

    private String getTitle() {
        Window w = this.getWindow();
        if (w instanceof Frame) {
            return ((Frame)w).getTitle();
        }
        if (w instanceof Dialog) {
            return ((Dialog)w).getTitle();
        }
        return null;
    }

    private class MyTopBorder
    implements Border {
        private int state = 0;

        private MyTopBorder() {
        }

        public void setState(int value) {
            this.state = value;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (this.topNeeded()) {
                g.setColor(DarculaTitlePane.this.myIsActive ? MyTopBorderConsts.ACTIVE_COLOR : MyTopBorderConsts.INACTIVE_COLOR);
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)y, (double)width, (double)y);
            }
            g.setColor(MyTopBorderConsts.MENUBAR_BORDER_COLOR);
            int y1 = y + height - JBUI.scale((int)1);
            LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)y1, (double)width, (double)y1);
        }

        private boolean topNeeded() {
            return this.state != 4 && this.state != 6;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            int scale = JBUI.scale((int)1);
            return this.topNeeded() ? new Insets(1, 0, scale, 0) : new Insets(0, 0, scale, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    private static interface MyTopBorderConsts {
        public static final int THICKNESS = 1;
        public static final Color MENUBAR_BORDER_COLOR = JBColor.namedColor((String)"MenuBar.borderColor", (Color)new JBColor((Color)Gray.xCD, (Color)Gray.x51));
        public static final Color ACTIVE_COLOR = (Color)ObjectUtils.notNull((Object)((Color)Toolkit.getDefaultToolkit().getDesktopProperty("win.dwm.colorizationColor")), () -> (Color)Toolkit.getDefaultToolkit().getDesktopProperty("win.frame.activeBorderColor"));
        public static final Color INACTIVE_COLOR = (Color)Toolkit.getDefaultToolkit().getDesktopProperty("win.3d.shadowColor");
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent ev) {
            DarculaTitlePane.this.setActive(true);
        }

        @Override
        public void windowDeactivated(WindowEvent ev) {
            DarculaTitlePane.this.setActive(false);
        }

        @Override
        public void windowStateChanged(WindowEvent e) {
            Frame frame = DarculaTitlePane.this.getFrame();
            if (frame == null) {
                return;
            }
            DarculaTitlePane.this.myTopBorder.setState(frame.getExtendedState());
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        MaximizeAction() {
            super("Maximize", AllIcons.Windows.MaximizeSmall);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DarculaTitlePane.this.maximize();
        }
    }

    private class RestoreAction
    extends AbstractAction {
        RestoreAction() {
            super("Restore", AllIcons.Windows.RestoreSmall);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DarculaTitlePane.this.restore();
        }
    }

    private class IconifyAction
    extends AbstractAction {
        IconifyAction() {
            super("Minimize", AllIcons.Windows.MinimizeSmall);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DarculaTitlePane.this.iconify();
        }
    }

    private class CloseAction
    extends AbstractAction {
        CloseAction() {
            super("Close", AllIcons.Windows.CloseSmall);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DarculaTitlePane.this.close();
        }
    }
}

