/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class PluginBooleanOptionDescriptor
extends BooleanOptionDescription {
    private static final Logger LOG = Logger.getInstance(PluginBooleanOptionDescriptor.class);
    private static final NotificationGroup PLUGINS_LIST_CHANGED_GROUP = new NotificationGroup("Plugins updates", NotificationDisplayType.STICKY_BALLOON, false);
    private static final NotificationGroup PLUGINS_AUTO_SWITCH_GROUP = new NotificationGroup("Plugins AutoSwitch", NotificationDisplayType.BALLOON, false);
    private static final Notifier ourRestartNeededNotifier = new Notifier();
    private final PluginId myId;

    public PluginBooleanOptionDescriptor(PluginId id) {
        super(PluginManager.getPlugin(id).getName(), "preferences.pluginManager");
        this.myId = id;
    }

    public boolean isOptionEnabled() {
        return PluginBooleanOptionDescriptor.optionalDescriptor(this.myId).map(IdeaPluginDescriptor::isEnabled).orElse(false);
    }

    public void setOptionState(boolean enabled) {
        try {
            Collection<PluginId> autoSwitchedIds = enabled ? PluginBooleanOptionDescriptor.getPluginsIdsToEnable(this.myId) : PluginBooleanOptionDescriptor.getPluginsIdsToDisable(this.myId);
            ArrayList<PluginId> switchedPlugins = new ArrayList<PluginId>(autoSwitchedIds);
            switchedPlugins.add(this.myId);
            PluginBooleanOptionDescriptor.switchPlugins(switchedPlugins, enabled);
            if (!autoSwitchedIds.isEmpty()) {
                this.showAutoSwitchNotification(autoSwitchedIds, enabled);
            }
            ourRestartNeededNotifier.showNotification();
        }
        catch (IOException e) {
            LOG.error("Cannot save plugins state");
        }
    }

    private void showAutoSwitchNotification(Collection<PluginId> autoSwitchedIds, final boolean enabled) {
        final ArrayList<PluginId> switchedPlugins = new ArrayList<PluginId>(autoSwitchedIds);
        switchedPlugins.add(this.myId);
        String pluginString = PluginBooleanOptionDescriptor.idToName(this.myId);
        String dependenciesString = autoSwitchedIds.stream().map(id -> PluginBooleanOptionDescriptor.idToName(id)).collect(Collectors.joining(", "));
        String titleKey = enabled ? "plugins.auto.enabled.notification.title" : "plugins.auto.disabled.notification.title";
        String contentKey = enabled ? "plugins.auto.enabled.notification.content" : "plugins.auto.disabled.notification.content";
        final Notification switchNotification = PLUGINS_AUTO_SWITCH_GROUP.createNotification(IdeBundle.message((String)contentKey, (Object[])new Object[]{pluginString, dependenciesString}), NotificationType.INFORMATION).setTitle(IdeBundle.message((String)titleKey, (Object[])new Object[0])).addAction((AnAction)new UndoPluginsSwitchAction(switchedPlugins, enabled));
        Runnable listener2 = new Runnable(){

            @Override
            public void run() {
                Balloon balloon;
                boolean notificationValid;
                List<String> disabledPlugins = PluginManagerCore.getDisabledPlugins();
                List ids = ContainerUtil.map((Collection)switchedPlugins, PluginId::getIdString);
                boolean bl = enabled ? ids.stream().noneMatch(disabledPlugins::contains) : (notificationValid = disabledPlugins.containsAll(ids));
                if (!notificationValid) {
                    switchNotification.expire();
                }
                if ((balloon = switchNotification.getBalloon()) == null || balloon.isDisposed()) {
                    ApplicationManager.getApplication().invokeLater(() -> PluginManagerCore.removeDisablePluginListener(this));
                }
            }
        };
        PluginManagerCore.addDisablePluginListener(listener2);
        Notifications.Bus.notify((Notification)switchNotification);
    }

    @NotNull
    private static String idToName(PluginId id) {
        String string = '\"' + PluginBooleanOptionDescriptor.optionalDescriptor(id).map(IdeaPluginDescriptor::getName).orElse(id.getIdString()) + '\"';
        if (string == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static void switchPlugins(Collection<PluginId> ids, boolean enabled) throws IOException {
        HashSet<String> disabledPlugins = new HashSet<String>(PluginManagerCore.getDisabledPlugins());
        if (enabled) {
            ids.forEach(id -> disabledPlugins.remove(id.getIdString()));
        } else {
            ids.forEach(id -> disabledPlugins.add(id.getIdString()));
        }
        PluginManagerCore.saveDisabledPlugins(disabledPlugins, false);
        ids.forEach(id -> PluginBooleanOptionDescriptor.optionalDescriptor(id).ifPresent(descriptor -> descriptor.setEnabled(enabled)));
    }

    private static Optional<IdeaPluginDescriptor> optionalDescriptor(PluginId id) {
        return Optional.ofNullable(PluginManager.getPlugin(id));
    }

    private static Collection<PluginId> getPluginsIdsToEnable(PluginId id) {
        Optional<IdeaPluginDescriptor> maybeDescriptor = PluginBooleanOptionDescriptor.optionalDescriptor(id);
        if (!maybeDescriptor.isPresent()) {
            return Collections.emptyList();
        }
        HashSet<PluginId> res2 = new HashSet<PluginId>();
        IdeaPluginDescriptor descriptor = maybeDescriptor.get();
        PluginManagerCore.checkDependants(descriptor, (Function<? super PluginId, ? extends IdeaPluginDescriptor>)((Function)PluginManager::getPlugin), (Condition<? super PluginId>)((Condition)pluginId -> {
            boolean enabled = PluginBooleanOptionDescriptor.optionalDescriptor(pluginId).map(IdeaPluginDescriptor::isEnabled).orElse(true);
            if (!enabled) {
                res2.add((PluginId)pluginId);
            }
            return true;
        }));
        return res2;
    }

    private static Collection<PluginId> getPluginsIdsToDisable(PluginId id) {
        HashSet<PluginId> res2 = new HashSet<PluginId>();
        Arrays.stream(PluginManagerCore.getPlugins()).filter(IdeaPluginDescriptor::isEnabled).forEach(descriptor -> PluginManagerCore.checkDependants(descriptor, (Function<? super PluginId, ? extends IdeaPluginDescriptor>)((Function)PluginManager::getPlugin), (Condition<? super PluginId>)((Condition)pluginId -> {
            if (pluginId.equals(id)) {
                res2.add(descriptor.getPluginId());
                return false;
            }
            return true;
        })));
        return res2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/PluginBooleanOptionDescriptor", "idToName"));
    }

    private static class Notifier {
        private final AtomicReference<Notification> prevNotification = new AtomicReference();

        private Notifier() {
        }

        public void showNotification() {
            Notification prev2 = this.prevNotification.get();
            if (prev2 != null && prev2.getBalloon() != null && !prev2.getBalloon().isDisposed()) {
                return;
            }
            Notification next = PLUGINS_LIST_CHANGED_GROUP.createNotification(IdeBundle.message((String)"plugins.changed.notification.content", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}), NotificationType.INFORMATION).setTitle(IdeBundle.message((String)"plugins.changed.notification.title", (Object[])new Object[0]));
            if (this.prevNotification.compareAndSet(prev2, next)) {
                Notifications.Bus.notify((Notification)next);
            }
        }
    }

    private static class UndoPluginsSwitchAction
    extends NotificationAction {
        private final Collection<PluginId> myIds;
        private final boolean myEnabled;

        UndoPluginsSwitchAction(Collection<PluginId> ids, boolean enabled) {
            super(IdeBundle.message((String)"plugins.auto.switch.action.name", (Object[])new Object[0]));
            this.myIds = ids;
            this.myEnabled = enabled;
        }

        public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
            if (e == null) {
                UndoPluginsSwitchAction.$$$reportNull$$$0(0);
            }
            if (notification == null) {
                UndoPluginsSwitchAction.$$$reportNull$$$0(1);
            }
            try {
                PluginBooleanOptionDescriptor.switchPlugins(this.myIds, !this.myEnabled);
                notification.expire();
                ourRestartNeededNotifier.showNotification();
            }
            catch (IOException exception) {
                LOG.error("Cannot save plugins state");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "e";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/ui/PluginBooleanOptionDescriptor$UndoPluginsSwitchAction";
            objectArray[2] = "actionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

