/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerColumnInfo;
import com.intellij.ide.plugins.PluginManagerConfigurableNew;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RatesPanel;
import com.intellij.ide.plugins.newui.CellPluginComponent;
import com.intellij.ide.plugins.newui.ColorButton;
import com.intellij.ide.plugins.newui.HorizontalLayout;
import com.intellij.ide.plugins.newui.InstallButton;
import com.intellij.ide.plugins.newui.LinkComponent;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.MyOptionButton;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.OneLineProgressIndicator;
import com.intellij.ide.plugins.newui.PluginLogo;
import com.intellij.ide.plugins.newui.RestartButton;
import com.intellij.ide.plugins.newui.SearchQueryParser;
import com.intellij.ide.plugins.newui.TagBuilder;
import com.intellij.ide.plugins.newui.TagComponent;
import com.intellij.ide.plugins.newui.UpdateButton;
import com.intellij.ide.plugins.newui.VerticalLayout;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetailsPagePluginComponent
extends OpaquePanel {
    private final MyPluginModel myPluginsModel;
    private final TagBuilder myTagBuilder;
    private final LinkListener<String> mySearchListener;
    public final IdeaPluginDescriptor myPlugin;
    private JLabel myNameComponent;
    private JLabel myIconLabel;
    private JButton myUpdateButton;
    private JButton myInstallButton;
    private JButton myEnableDisableButton;
    private RestartButton myRestartButton;
    private JBOptionButton myEnableDisableUninstallButton;
    private JPanel myButtonsPanel;
    private final JPanel myCenterPanel;
    private OneLineProgressIndicator myIndicator;
    public int backTabIndex;

    public DetailsPagePluginComponent(@NotNull MyPluginModel pluginsModel, @NotNull TagBuilder tagBuilder, @NotNull LinkListener<String> searchListener, @NotNull IdeaPluginDescriptor plugin, boolean update) {
        if (pluginsModel == null) {
            DetailsPagePluginComponent.$$$reportNull$$$0(0);
        }
        if (tagBuilder == null) {
            DetailsPagePluginComponent.$$$reportNull$$$0(1);
        }
        if (searchListener == null) {
            DetailsPagePluginComponent.$$$reportNull$$$0(2);
        }
        if (plugin == null) {
            DetailsPagePluginComponent.$$$reportNull$$$0(3);
        }
        super((LayoutManager)new BorderLayout(0, JBUI.scale((int)32)), PluginManagerConfigurableNew.MAIN_BG_COLOR);
        this.myPluginsModel = pluginsModel;
        this.myTagBuilder = tagBuilder;
        this.mySearchListener = searchListener;
        this.myPlugin = plugin;
        JPanel header = this.createHeaderPanel();
        this.myCenterPanel = this.createCenterPanel(update);
        header.add(this.myCenterPanel);
        if (!update) {
            this.createTagPanel();
        }
        this.createMetricsPanel();
        this.createErrorPanel();
        this.createProgressPanel(!update);
        this.createBottomPanel();
        this.setBorder((Border)new CustomLineBorder((Color)new JBColor(0xC5C5C5, 0x515151), (Insets)JBUI.insets((int)1, (int)0, (int)0, (int)0)){

            public Insets getBorderInsets(Component c) {
                return JBUI.insets((int)15, (int)20, (int)0, (int)0);
            }
        });
    }

    @NotNull
    private JPanel createCenterPanel(boolean update) {
        String version2;
        boolean bundled;
        final int offset = PluginManagerConfigurableNew.offset5();
        NonOpaquePanel centerPanel = new NonOpaquePanel((LayoutManager)((Object)new VerticalLayout(offset)));
        NonOpaquePanel nameButtons = new NonOpaquePanel((LayoutManager)new BorderLayout(offset, 0){
            Component myVersion;

            @Override
            public void addLayoutComponent(Component comp, Object constraints) {
                super.addLayoutComponent(comp, constraints);
                if (comp != DetailsPagePluginComponent.this.myNameComponent && comp != DetailsPagePluginComponent.this.myButtonsPanel) {
                    this.myVersion = comp;
                }
            }

            @Override
            public void layoutContainer(Container target2) {
                super.layoutContainer(target2);
                Insets insets = target2.getInsets();
                int left = insets.left;
                int right = DetailsPagePluginComponent.this.myButtonsPanel.getX() - offset;
                int parentWidth = right - left;
                int versionWidth = this.myVersion == null ? 0 : this.myVersion.getPreferredSize().width;
                int nameWidth = ((DetailsPagePluginComponent)DetailsPagePluginComponent.this).myNameComponent.getPreferredSize().width;
                int nameWithVersionWidth = nameWidth + versionWidth;
                if (versionWidth > 0) {
                    nameWithVersionWidth += offset;
                }
                if (nameWithVersionWidth <= parentWidth) {
                    DetailsPagePluginComponent.this.myNameComponent.setToolTipText(null);
                    return;
                }
                DetailsPagePluginComponent.this.myNameComponent.setToolTipText(DetailsPagePluginComponent.this.myNameComponent.getText());
                int top = insets.top;
                int bottom = target2.getHeight() - insets.bottom;
                if (this.myVersion != null) {
                    this.myVersion.setBounds(right - versionWidth, top, versionWidth, bottom - top);
                    parentWidth -= versionWidth + offset;
                }
                DetailsPagePluginComponent.this.myNameComponent.setBounds(left, top, parentWidth, bottom - top);
            }
        });
        boolean bl = bundled = this.myPlugin.isBundled() && !this.myPlugin.allowBundledUpdate();
        if (bundled) {
            this.myNameComponent = new JLabel();
        } else {
            LinkComponent linkComponent = new LinkComponent();
            linkComponent.setPaintUnderline(false);
            linkComponent.setListener((_0, _1) -> BrowserUtil.browse((String)("https://plugins.jetbrains.com/plugin/index?xmlId=" + URLUtil.encodeURIComponent((String)this.myPlugin.getPluginId().getIdString()))), null);
            this.myNameComponent = linkComponent;
        }
        this.myNameComponent.setOpaque(false);
        this.myNameComponent.setText(this.myPlugin.getName());
        Font font = this.myNameComponent.getFont();
        if (font != null) {
            this.myNameComponent.setFont(font.deriveFont(1, 30.0f));
        }
        if (!(this.myPlugin instanceof PluginNode) && !this.myPluginsModel.isEnabled(this.myPlugin)) {
            this.myNameComponent.setForeground(ListPluginComponent.DisabledColor);
        }
        nameButtons.add((Component)this.myNameComponent, "West");
        this.myButtonsPanel = this.createButtons(update);
        nameButtons.add((Component)this.myButtonsPanel, "East");
        centerPanel.add((Component)nameButtons, "fill_h");
        String string = version2 = bundled ? "bundled" : this.myPlugin.getVersion();
        if (!StringUtil.isEmptyOrSpaces((String)version2)) {
            if (!bundled) {
                version2 = "v" + version2;
            }
            final JTextField versionComponent = new JTextField(version2);
            versionComponent.setEditable(false);
            versionComponent.setFont(UIUtil.getLabelFont());
            versionComponent.setBorder(null);
            versionComponent.setOpaque(false);
            versionComponent.setForeground(CellPluginComponent.GRAY_COLOR);
            versionComponent.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    int caretPosition = versionComponent.getCaretPosition();
                    versionComponent.setSelectionStart(caretPosition);
                    versionComponent.setSelectionEnd(caretPosition);
                }
            });
            nameButtons.add(versionComponent);
            int nameBaseline = this.myNameComponent.getBaseline(this.myNameComponent.getWidth(), this.myNameComponent.getHeight());
            int versionBaseline = versionComponent.getBaseline(versionComponent.getWidth(), versionComponent.getHeight());
            versionComponent.setBorder((Border)JBUI.Borders.empty((int)(nameBaseline - versionBaseline), (int)4, (int)0, (int)0));
        }
        NonOpaquePanel nonOpaquePanel = centerPanel;
        if (nonOpaquePanel == null) {
            DetailsPagePluginComponent.$$$reportNull$$$0(4);
        }
        return nonOpaquePanel;
    }

    @NotNull
    private JPanel createButtons(boolean update) {
        NonOpaquePanel buttons = new NonOpaquePanel((LayoutManager)((Object)new HorizontalLayout(JBUI.scale((int)6))));
        buttons.setBorder((Border)JBUI.Borders.emptyTop((int)1));
        InstalledPluginsState pluginsState = InstalledPluginsState.getInstance();
        PluginId id = this.myPlugin.getPluginId();
        if (this.myPlugin instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)this.myPlugin).isDeleted() || pluginsState.wasInstalled(id) || pluginsState.wasUpdated(id)) {
            this.myRestartButton = new RestartButton(this.myPluginsModel);
            buttons.add(this.myRestartButton);
        } else if (update) {
            this.myUpdateButton = new UpdateButton();
            buttons.add(this.myUpdateButton);
        } else if (this.myPlugin instanceof PluginNode) {
            this.myInstallButton = new InstallButton(true);
            buttons.add(this.myInstallButton);
            this.myInstallButton.setEnabled(PluginManager.getPlugin(this.myPlugin.getPluginId()) == null);
        } else if (this.myPlugin.isBundled()) {
            this.myEnableDisableButton = new JButton(this.myPluginsModel.getEnabledTitle(this.myPlugin));
            this.myEnableDisableButton.addActionListener(e -> this.changeEnableDisable());
            ColorButton.setWidth72(this.myEnableDisableButton);
            buttons.add(this.myEnableDisableButton);
        } else {
            AbstractAction enableDisableAction = new AbstractAction(this.myPluginsModel.getEnabledTitle(this.myPlugin)){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DetailsPagePluginComponent.this.changeEnableDisable();
                }
            };
            AbstractAction uninstallAction = new AbstractAction("Uninstall"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DetailsPagePluginComponent.this.doUninstall();
                }
            };
            this.myEnableDisableUninstallButton = new MyOptionButton(enableDisableAction, uninstallAction);
            buttons.add((Component)this.myEnableDisableUninstallButton);
        }
        for (Component component : UIUtil.uiChildren((Component)buttons)) {
            component.setBackground(PluginManagerConfigurableNew.MAIN_BG_COLOR);
        }
        NonOpaquePanel nonOpaquePanel = buttons;
        if (nonOpaquePanel == null) {
            DetailsPagePluginComponent.$$$reportNull$$$0(5);
        }
        return nonOpaquePanel;
    }

    @NotNull
    private JPanel createHeaderPanel() {
        NonOpaquePanel header = new NonOpaquePanel((LayoutManager)new BorderLayout(JBUI.scale((int)20), 0));
        header.setBorder((Border)JBUI.Borders.emptyRight((int)20));
        this.add((Component)header, "North");
        this.myIconLabel = new JLabel();
        this.updateIcon();
        this.myIconLabel.setVerticalAlignment(1);
        this.myIconLabel.setOpaque(false);
        this.myIconLabel.setEnabled(this.myPlugin instanceof PluginNode || this.myPluginsModel.isEnabled(this.myPlugin));
        header.add((Component)this.myIconLabel, "West");
        NonOpaquePanel nonOpaquePanel = header;
        if (nonOpaquePanel == null) {
            DetailsPagePluginComponent.$$$reportNull$$$0(6);
        }
        return nonOpaquePanel;
    }

    private void updateIcon() {
        boolean jb = PluginManagerConfigurableNew.isJBPlugin(this.myPlugin);
        boolean errors = this.myPluginsModel.hasErrors(this.myPlugin);
        this.myIconLabel.setIcon(PluginLogo.getIcon(this.myPlugin, true, jb, errors, false));
        this.myIconLabel.setDisabledIcon(PluginLogo.getIcon(this.myPlugin, true, jb, errors, true));
    }

    private void createTagPanel() {
        List<String> tags = PluginManagerConfigurableNew.getTags(this.myPlugin);
        if (!tags.isEmpty()) {
            NonOpaquePanel tagPanel = new NonOpaquePanel((LayoutManager)((Object)new HorizontalLayout(JBUI.scale((int)6))));
            tagPanel.setBorder((Border)JBUI.Borders.emptyTop((int)2));
            this.myCenterPanel.add((Component)tagPanel);
            for (String tag : tags) {
                TagComponent component = this.myTagBuilder.createTagComponent(tag);
                component.setListener(this.mySearchListener, SearchQueryParser.getTagQuery(tag));
                tagPanel.add((Component)((Object)component));
            }
        }
    }

    private void createMetricsPanel() {
        if (!(this.myPlugin instanceof PluginNode)) {
            return;
        }
        String downloads = PluginManagerConfigurableNew.getDownloads(this.myPlugin);
        String date = PluginManagerConfigurableNew.getLastUpdatedDate(this.myPlugin);
        String rating = PluginManagerConfigurableNew.getRating(this.myPlugin);
        if (downloads != null || date != null || rating != null) {
            NonOpaquePanel metrics = new NonOpaquePanel((LayoutManager)((Object)new HorizontalLayout(JBUI.scale((int)20))));
            metrics.setBorder((Border)JBUI.Borders.emptyTop((int)3));
            this.myCenterPanel.add((Component)metrics);
            if (date != null) {
                DetailsPagePluginComponent.createRatingLabel((JPanel)metrics, date, AllIcons.Plugins.Updated, CellPluginComponent.GRAY_COLOR);
            }
            if (downloads != null) {
                DetailsPagePluginComponent.createRatingLabel((JPanel)metrics, downloads, AllIcons.Plugins.Downloads, CellPluginComponent.GRAY_COLOR);
            }
            if (rating != null) {
                RatesPanel ratesPanel = new RatesPanel();
                ratesPanel.setRate(rating);
                metrics.add(PluginManagerConfigurableNew.installTiny(ratesPanel));
            }
        }
    }

    private static void createRatingLabel(@NotNull JPanel panel2, @NotNull String text, @NotNull Icon icon, @NotNull Color color) {
        if (panel2 == null) {
            DetailsPagePluginComponent.$$$reportNull$$$0(7);
        }
        if (text == null) {
            DetailsPagePluginComponent.$$$reportNull$$$0(8);
        }
        if (icon == null) {
            DetailsPagePluginComponent.$$$reportNull$$$0(9);
        }
        if (color == null) {
            DetailsPagePluginComponent.$$$reportNull$$$0(10);
        }
        JLabel label2 = new JLabel(text, icon, 0);
        label2.setOpaque(false);
        label2.setForeground(color);
        panel2.add(PluginManagerConfigurableNew.installTiny(label2));
    }

    private void createErrorPanel() {
        if (this.myPluginsModel.hasErrors(this.myPlugin)) {
            final int offset = JBUI.scale((int)8);
            NonOpaquePanel errorPanel = new NonOpaquePanel((LayoutManager)((Object)new HorizontalLayout(offset){

                @Override
                public void layoutContainer(Container parent) {
                    super.layoutContainer(parent);
                    if (parent.getComponentCount() != 2) {
                        return;
                    }
                    Component message = parent.getComponent(0);
                    Component action = parent.getComponent(1);
                    int actionWidth = action.getPreferredSize().width;
                    int width = message.getPreferredSize().width + offset + actionWidth;
                    Insets insets = parent.getInsets();
                    int parentWidth = parent.getWidth() - insets.left - insets.right;
                    if (width <= parentWidth) {
                        return;
                    }
                    int right = parent.getWidth() - insets.right;
                    action.setLocation(right - actionWidth, action.getY());
                    message.setBounds(insets.left, message.getY(), (right -= actionWidth + offset) - insets.left, message.getHeight());
                }
            }));
            errorPanel.setBorder((Border)JBUI.Borders.emptyTop((int)15));
            this.myCenterPanel.add((Component)errorPanel);
            JLabel errorMessage = new JLabel();
            errorMessage.setForeground(DialogWrapper.ERROR_FOREGROUND_COLOR);
            errorMessage.setOpaque(false);
            errorPanel.add(errorMessage);
            Ref enableAction = new Ref();
            errorMessage.setText(PluginManagerConfigurableNew.getErrorMessage(this.myPluginsModel, (PluginDescriptor)this.myPlugin, (Ref<? super Boolean>)enableAction));
            if (!enableAction.isNull()) {
                LinkLabel errorAction = new LinkLabel("Enable", null);
                errorAction.setOpaque(false);
                errorPanel.add((Component)errorAction);
                errorAction.setListener((arg_0, arg_1) -> this.lambda$createErrorPanel$2((JPanel)errorPanel, arg_0, arg_1), null);
            }
        }
    }

    private void createProgressPanel(boolean install) {
        JButton button2;
        JButton jButton = button2 = this.myInstallButton == null ? this.myUpdateButton : this.myInstallButton;
        if (button2 == null) {
            return;
        }
        button2.addActionListener(e -> this.myPluginsModel.installOrUpdatePlugin(this.myPlugin, install));
        if (MyPluginModel.isInstallingOrUpdate(this.myPlugin)) {
            this.showProgress(false);
        }
    }

    public void showProgress() {
        this.showProgress(true);
    }

    private void showProgress(boolean repaint) {
        this.myIndicator = new OneLineProgressIndicator();
        this.myIndicator.setCancelRunnable(() -> this.myPluginsModel.finishInstall(this.myPlugin, false, false));
        this.myButtonsPanel.remove(this.myInstallButton == null ? this.myUpdateButton : this.myInstallButton);
        if (this.myEnableDisableButton != null) {
            this.myButtonsPanel.remove(this.myEnableDisableButton);
        }
        if (this.myEnableDisableUninstallButton != null) {
            this.myButtonsPanel.remove((Component)this.myEnableDisableUninstallButton);
        }
        this.myButtonsPanel.doLayout();
        this.myCenterPanel.add(this.myIndicator.getComponent());
        this.myPluginsModel.addProgress(this.myPlugin, this.myIndicator);
        if (repaint) {
            this.doLayout();
            this.revalidate();
            this.repaint();
        }
    }

    public void hideProgress(boolean success2) {
        assert (this.myIndicator != null);
        this.myCenterPanel.remove(this.myIndicator.getComponent());
        this.myIndicator = null;
        if (success2) {
            this.changeInstallOrUpdateToRestart();
        } else {
            this.myButtonsPanel.add(this.myInstallButton == null ? this.myUpdateButton : this.myInstallButton);
            if (this.myEnableDisableButton != null) {
                this.myButtonsPanel.add(this.myEnableDisableButton);
            }
            if (this.myEnableDisableUninstallButton != null) {
                this.myButtonsPanel.add((Component)this.myEnableDisableUninstallButton);
            }
            this.doLayout();
            this.revalidate();
            this.repaint();
        }
    }

    public void close() {
        if (this.myIndicator != null) {
            this.myPluginsModel.removeProgress(this.myPlugin, this.myIndicator);
            this.myIndicator = null;
        }
    }

    private void createBottomPanel() {
        String size;
        String description = this.getDescriptionAndChangeNotes();
        String vendor = this.myPlugin.isBundled() ? null : this.myPlugin.getVendor();
        String string = size = this.myPlugin instanceof PluginNode ? ((PluginNode)this.myPlugin).getSize() : null;
        if (!(StringUtil.isEmptyOrSpaces((String)description) && StringUtil.isEmptyOrSpaces((String)vendor) && StringUtil.isEmptyOrSpaces((String)size))) {
            OpaquePanel bottomPanel = new OpaquePanel((LayoutManager)((Object)new VerticalLayout(PluginManagerConfigurableNew.offset5())), PluginManagerConfigurableNew.MAIN_BG_COLOR);
            bottomPanel.setBorder((Border)JBUI.Borders.emptyBottom((int)15));
            JBScrollPane scrollPane = new JBScrollPane((Component)bottomPanel);
            scrollPane.getVerticalScrollBar().setBackground(PluginManagerConfigurableNew.MAIN_BG_COLOR);
            scrollPane.setHorizontalScrollBarPolicy(31);
            scrollPane.setBorder(null);
            this.add((Component)scrollPane);
            if (!StringUtil.isEmptyOrSpaces((String)description)) {
                JEditorPane descriptionComponent = new JEditorPane();
                HTMLEditorKit kit = UIUtil.getHTMLEditorKit();
                StyleSheet sheet = kit.getStyleSheet();
                sheet.addRule("ul {margin-left: 16px}");
                sheet.addRule("a {color: " + ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.Link.linkColor()) + "}");
                descriptionComponent.setEditable(false);
                descriptionComponent.setOpaque(false);
                descriptionComponent.setBorder(null);
                descriptionComponent.setContentType("text/html");
                descriptionComponent.setEditorKit(kit);
                descriptionComponent.setText(XmlStringUtil.wrapInHtml((CharSequence)description));
                descriptionComponent.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
                if (descriptionComponent.getCaret() != null) {
                    descriptionComponent.setCaretPosition(0);
                }
                bottomPanel.add(descriptionComponent, JBUI.scale((int)700), -1);
            }
            if (!StringUtil.isEmptyOrSpaces((String)vendor) || !StringUtil.isEmptyOrSpaces((String)size)) {
                ArrayList labels = new ArrayList();
                if (!StringUtil.isEmptyOrSpaces((String)vendor)) {
                    JPanel linePanel = DetailsPagePluginComponent.createLabelsPanel((JPanel)bottomPanel, labels, "Vendor:", vendor, this.myPlugin.getVendorUrl());
                    linePanel.setBorder((Border)JBUI.Borders.emptyTop((int)20));
                }
                if (!StringUtil.isEmptyOrSpaces((String)size)) {
                    DetailsPagePluginComponent.createLabelsPanel((JPanel)bottomPanel, labels, "Size:", PluginManagerColumnInfo.getFormattedSize(size), null);
                }
                if (labels.size() > 1) {
                    int width = 0;
                    for (JLabel label2 : labels) {
                        width = Math.max(width, label2.getPreferredSize().width);
                    }
                    for (JLabel label2 : labels) {
                        label2.setPreferredSize(new Dimension(width, label2.getPreferredSize().height));
                    }
                }
            }
        }
    }

    @NotNull
    private static JPanel createLabelsPanel(@NotNull JPanel parent, @NotNull List<? super JLabel> labels, @NotNull String labelText, @NotNull String text, @Nullable String link2) {
        if (parent == null) {
            DetailsPagePluginComponent.$$$reportNull$$$0(11);
        }
        if (labels == null) {
            DetailsPagePluginComponent.$$$reportNull$$$0(12);
        }
        if (labelText == null) {
            DetailsPagePluginComponent.$$$reportNull$$$0(13);
        }
        if (text == null) {
            DetailsPagePluginComponent.$$$reportNull$$$0(14);
        }
        NonOpaquePanel linePanel = new NonOpaquePanel((LayoutManager)((Object)new HorizontalLayout(5)));
        parent.add((Component)linePanel);
        JLabel label2 = new JLabel(labelText);
        linePanel.add(label2);
        labels.add(label2);
        if (StringUtil.isEmptyOrSpaces((String)link2)) {
            linePanel.add(new JLabel(text));
        } else {
            LinkLabel linkLabel = new LinkLabel(text, AllIcons.Ide.External_link_arrow, (_0, _1) -> BrowserUtil.browse((String)link2));
            linkLabel.setIconTextGap(0);
            linkLabel.setHorizontalTextPosition(2);
            linePanel.add((Component)linkLabel);
        }
        NonOpaquePanel nonOpaquePanel = linePanel;
        if (nonOpaquePanel == null) {
            DetailsPagePluginComponent.$$$reportNull$$$0(15);
        }
        return nonOpaquePanel;
    }

    @Nullable
    private String getDescriptionAndChangeNotes() {
        String notes;
        StringBuilder result2 = new StringBuilder();
        String description = this.myPlugin.getDescription();
        if (!StringUtil.isEmptyOrSpaces((String)description)) {
            result2.append(description);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(notes = this.myPlugin.getChangeNotes()))) {
            result2.append("<h4>Change Notes</h4>").append(notes);
        }
        return result2.length() > 0 ? result2.toString() : null;
    }

    private void changeEnableDisable() {
        this.myPluginsModel.changeEnableDisable(this.myPlugin);
        this.updateEnabledState();
    }

    private void updateEnabledState() {
        if (!(this.myPlugin instanceof PluginNode)) {
            boolean enabled = this.myPluginsModel.isEnabled(this.myPlugin);
            this.myNameComponent.setForeground(enabled ? null : ListPluginComponent.DisabledColor);
            this.myIconLabel.setEnabled(enabled);
        }
        String title = this.myPluginsModel.getEnabledTitle(this.myPlugin);
        if (this.myEnableDisableButton != null) {
            this.myEnableDisableButton.setText(title);
        }
        if (this.myEnableDisableUninstallButton != null) {
            this.myEnableDisableUninstallButton.setText(title);
        }
    }

    private void doUninstall() {
        if (this.myPluginsModel.showUninstallDialog(this.myPlugin.getName(), 1)) {
            this.myPluginsModel.doUninstall((Component)((Object)this), this.myPlugin, this::changeInstallOrUpdateToRestart);
        }
    }

    private void changeInstallOrUpdateToRestart() {
        if (this.myEnableDisableUninstallButton != null) {
            this.myButtonsPanel.remove((Component)this.myEnableDisableUninstallButton);
            this.myEnableDisableUninstallButton = null;
        }
        if (this.myUpdateButton != null) {
            this.myButtonsPanel.remove(this.myUpdateButton);
            this.myUpdateButton = null;
        }
        if (this.myInstallButton != null) {
            this.myButtonsPanel.remove(this.myInstallButton);
            this.myInstallButton = null;
        }
        if (this.myRestartButton == null) {
            this.myRestartButton = new RestartButton(this.myPluginsModel);
            this.myButtonsPanel.add(this.myRestartButton);
        }
        this.doLayout();
        this.revalidate();
        this.repaint();
    }

    private /* synthetic */ void lambda$createErrorPanel$2(JPanel errorPanel, LinkLabel aSource, Object aLinkData) {
        this.myPluginsModel.enableRequiredPlugins(this.myPlugin);
        this.myCenterPanel.remove(errorPanel);
        this.createErrorPanel();
        this.myCenterPanel.doLayout();
        this.updateIcon();
        this.updateEnabledState();
        this.doLayout();
        this.revalidate();
        this.repaint();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchListener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/DetailsPagePluginComponent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labels";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/DetailsPagePluginComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createButtons";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createHeaderPanel";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabelsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 15: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createRatingLabel";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createLabelsPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

