/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.OpenInBrowserRequestKt;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserService;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.ide.browsers.actions.BaseOpenInBrowserAction;
import com.intellij.ide.browsers.actions.BaseOpenInBrowserActionKt;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vcs.vfs.ContentRevisionVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.util.BitUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002\u001a\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\b\b\u0002\u0010\u0010\u001a\u00020\f2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0000\u001a\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "chooseUrl", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/util/Url;", "urls", "", "createRequest", "Lcom/intellij/ide/browsers/OpenInBrowserRequest;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "isForceFileUrlIfNoUrlProvider", "", "openInBrowser", "", "request", "preferLocalUrl", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.xml.impl"})
public final class BaseOpenInBrowserActionKt {
    private static final Logger LOG;

    public static final void openInBrowser(@NotNull OpenInBrowserRequest request, boolean preferLocalUrl, @Nullable WebBrowser browser2) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        try {
            Collection collection = WebBrowserService.getInstance().getUrlsToOpen(request, preferLocalUrl);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"WebBrowserService.getIns\u2026(request, preferLocalUrl)");
            Collection urls = collection;
            if (!urls.isEmpty()) {
                BaseOpenInBrowserActionKt.chooseUrl(urls).onSuccess((java.util.function.Consumer)new java.util.function.Consumer<Url>(browser2, request){
                    final /* synthetic */ WebBrowser $browser;
                    final /* synthetic */ OpenInBrowserRequest $request;

                    public final void accept(Url url) {
                        FileDocumentManager.getInstance().saveAllDocuments();
                        BrowserLauncher browserLauncher = BrowserLauncher.Companion.getInstance();
                        String string = url.toExternalForm();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toExternalForm()");
                        browserLauncher.browse(string, this.$browser, this.$request.getProject());
                    }
                    {
                        this.$browser = webBrowser;
                        this.$request = openInBrowserRequest;
                    }
                });
            }
        }
        catch (WebBrowserUrlProvider.BrowserException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)IdeBundle.message((String)"browser.error", (Object[])new Object[0]));
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public static /* synthetic */ void openInBrowser$default(OpenInBrowserRequest openInBrowserRequest, boolean bl, WebBrowser webBrowser, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            webBrowser = null;
        }
        BaseOpenInBrowserActionKt.openInBrowser(openInBrowserRequest, bl, webBrowser);
    }

    public static final void openInBrowser(@NotNull AnActionEvent event, @Nullable WebBrowser browser2) {
        block0: {
            OpenInBrowserRequest openInBrowserRequest;
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            DataContext dataContext = event.getDataContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataContext, (String)"event.dataContext");
            OpenInBrowserRequest openInBrowserRequest2 = BaseOpenInBrowserActionKt.createRequest(dataContext, true);
            if (openInBrowserRequest2 == null) break block0;
            OpenInBrowserRequest it = openInBrowserRequest = openInBrowserRequest2;
            boolean bl = false;
            BaseOpenInBrowserActionKt.openInBrowser(it, BitUtil.isSet((int)event.getModifiers(), (int)1), browser2);
        }
    }

    private static final OpenInBrowserRequest createRequest(DataContext context, boolean isForceFileUrlIfNoUrlProvider) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        if (editor == null) {
            PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
            VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
            Project project = (Project)CommonDataKeys.PROJECT.getData(context);
            if (virtualFile != null && !virtualFile.isDirectory() && virtualFile.isValid() && project != null && project.isInitialized()) {
                psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
            }
            if (psiFile != null && !(psiFile.getVirtualFile() instanceof ContentRevisionVirtualFile)) {
                return OpenInBrowserRequestKt.createOpenInBrowserRequest((PsiElement)((PsiElement)psiFile), (boolean)isForceFileUrlIfNoUrlProvider);
            }
        } else {
            Project project = editor.getProject();
            if (project != null && project.isInitialized()) {
                PsiFile psiFile;
                PsiFile psiFile2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
                if (psiFile2 == null) {
                    psiFile2 = psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
                }
                if (psiFile != null && !(psiFile.getVirtualFile() instanceof ContentRevisionVirtualFile)) {
                    return new OpenInBrowserRequest(editor, psiFile, isForceFileUrlIfNoUrlProvider, psiFile, isForceFileUrlIfNoUrlProvider){
                        static final /* synthetic */ KProperty[] $$delegatedProperties;
                        private final Lazy lazyElement$delegate;
                        final /* synthetic */ Editor $editor;
                        final /* synthetic */ PsiFile $psiFile;
                        final /* synthetic */ boolean $isForceFileUrlIfNoUrlProvider;

                        static {
                            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(createRequest.1.class), "lazyElement", "getLazyElement()Lcom/intellij/psi/PsiElement;"))};
                        }

                        private final PsiElement getLazyElement() {
                            Lazy lazy = this.lazyElement$delegate;
                            createRequest.1 var2_2 = this;
                            KProperty kProperty = $$delegatedProperties[0];
                            return (PsiElement)lazy.getValue();
                        }

                        @NotNull
                        public PsiElement getElement() {
                            PsiElement psiElement = this.getLazyElement();
                            if (psiElement == null) {
                                psiElement = (PsiElement)this.getFile();
                            }
                            return psiElement;
                        }
                        {
                            this.$editor = $captured_local_variable$0;
                            this.$psiFile = $captured_local_variable$1;
                            this.$isForceFileUrlIfNoUrlProvider = $captured_local_variable$2;
                            super($super_call_param$3, $super_call_param$4);
                            this.lazyElement$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PsiElement>(this){
                                final /* synthetic */ createRequest.1 this$0;

                                @Nullable
                                public final PsiElement invoke() {
                                    PsiFile psiFile = this.this$0.getFile();
                                    CaretModel caretModel = this.this$0.$editor.getCaretModel();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
                                    return psiFile.findElementAt(caretModel.getOffset());
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(0);
                                }
                            }));
                        }
                    };
                }
            }
        }
        return null;
    }

    private static final Promise<Url> chooseUrl(Collection<? extends Url> urls) {
        if (urls.size() == 1) {
            return Promises.resolvedPromise((Object)CollectionsKt.first((Iterable)urls));
        }
        AsyncPromise result2 = new AsyncPromise();
        JBPopupFactory.getInstance().createPopupChooserBuilder((List)ContainerUtil.newArrayList((Iterable)urls)).setRenderer((ListCellRenderer)new ColoredListCellRenderer<Url>(){

            protected void customizeCellRenderer(@NotNull JList<? extends Url> list2, @Nullable Url value, int index, boolean selected, boolean hasFocus) {
                Intrinsics.checkParameterIsNotNull(list2, (String)"list");
                this.setIcon(AllIcons.Nodes.Servlet);
                Url url = value;
                if (url == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.Url");
                }
                this.append(url.toDecodedForm());
            }
        }).setTitle("Choose Url").setItemChosenCallback((Consumer)new Consumer<Url>(result2){
            final /* synthetic */ AsyncPromise $result;

            public final void consume(Url value) {
                this.$result.setResult((Object)value);
            }
            {
                this.$result = asyncPromise;
            }
        }).createPopup().showInFocusCenter();
        return (Promise)result2;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BaseOpenInBrowserAction.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ OpenInBrowserRequest access$createRequest(DataContext context, boolean isForceFileUrlIfNoUrlProvider) {
        return BaseOpenInBrowserActionKt.createRequest(context, isForceFileUrlIfNoUrlProvider);
    }
}

