/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.TabbedConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableExtensionPointUtil;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.newEditor.SettingsDialogFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.navigation.Place;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Composite;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowSettingsUtilImpl
extends ShowSettingsUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.ShowSettingsUtilImpl");

    @NotNull
    private static Project getProject(@Nullable Project project) {
        Project project2 = project != null ? project : ProjectManager.getInstance().getDefaultProject();
        if (project2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(0);
        }
        return project2;
    }

    @NotNull
    public static DialogWrapper getDialog(@Nullable Project project, @NotNull ConfigurableGroup[] groups, @Nullable Configurable toSelect2) {
        if (groups == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(1);
        }
        project = ShowSettingsUtilImpl.getProject(project);
        ConfigurableGroup[] filteredGroups = ShowSettingsUtilImpl.filterEmptyGroups(groups);
        DialogWrapper dialogWrapper = SettingsDialogFactory.getInstance().create(project, filteredGroups, toSelect2, null);
        if (dialogWrapper == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(2);
        }
        return dialogWrapper;
    }

    @NotNull
    public static ConfigurableGroup[] getConfigurableGroups(@Nullable Project project, boolean withIdeSettings) {
        ConfigurableGroup group = ConfigurableExtensionPointUtil.getConfigurableGroup(project, withIdeSettings);
        ConfigurableGroup[] configurableGroupArray = new ConfigurableGroup[]{group};
        if (configurableGroupArray == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(3);
        }
        return configurableGroupArray;
    }

    @NotNull
    public static List<Configurable> getConfigurables(@Nullable Project project, boolean withIdeSettings) {
        ConfigurableGroup group = ConfigurableExtensionPointUtil.getConfigurableGroup(project, withIdeSettings);
        ArrayList<Configurable> list2 = new ArrayList<Configurable>();
        ShowSettingsUtilImpl.collect(list2, group.getConfigurables());
        ArrayList<Configurable> arrayList = list2;
        if (arrayList == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static void collect(List<? super Configurable> list2, Configurable ... configurables) {
        for (Configurable configurable : configurables) {
            list2.add((Configurable)configurable);
            if (!(configurable instanceof Configurable.Composite)) continue;
            Configurable.Composite composite = (Configurable.Composite)configurable;
            ShowSettingsUtilImpl.collect(list2, composite.getConfigurables());
        }
    }

    public void showSettingsDialog(@NotNull Project project, ConfigurableGroup ... group) {
        if (project == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(5);
        }
        if (group == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(6);
        }
        try {
            ShowSettingsUtilImpl.getDialog(project, group, null).show();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public <T extends Configurable> void showSettingsDialog(@Nullable Project project, @NotNull Class<T> configurableClass) {
        if (configurableClass == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(7);
        }
        this.showSettingsDialog(project, configurableClass, null);
    }

    public <T extends Configurable> void showSettingsDialog(@Nullable Project project, @NotNull Class<T> configurableClass, @Nullable Consumer<T> additionalConfiguration) {
        if (configurableClass == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(8);
        }
        assert (Configurable.class.isAssignableFrom(configurableClass)) : "Not a configurable: " + configurableClass.getName();
        this.showSettingsDialog(project, (? super Configurable it) -> ConfigurableWrapper.cast(configurableClass, (UnnamedConfigurable)it) != null, (? super Configurable it) -> {
            if (additionalConfiguration != null) {
                Configurable toConfigure = (Configurable)ConfigurableWrapper.cast(configurableClass, (UnnamedConfigurable)it);
                assert (toConfigure != null) : "Wrong configurable found: " + it.getClass();
                additionalConfiguration.accept(toConfigure);
            }
        });
    }

    public void showSettingsDialog(@Nullable Project project, final @NotNull Predicate<? super Configurable> predicate, @Nullable Consumer<? super Configurable> additionalConfiguration) {
        if (predicate == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(9);
        }
        ConfigurableGroup[] groups = ShowSettingsUtilImpl.getConfigurableGroups(project, true);
        Configurable config2 = new ConfigurableVisitor(){

            @Override
            protected boolean accept(Configurable configurable) {
                return predicate.test(configurable);
            }
        }.find(groups);
        assert (config2 != null) : "Cannot find configurable for specified predicate";
        if (additionalConfiguration != null) {
            additionalConfiguration.accept((Configurable)config2);
        }
        ShowSettingsUtilImpl.getDialog(project, groups, config2).show();
    }

    public void showSettingsDialog(@Nullable Project project, @NotNull String nameToSelect) {
        if (nameToSelect == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(10);
        }
        ConfigurableGroup[] groups = ShowSettingsUtilImpl.getConfigurableGroups(project, true);
        Project actualProject = ShowSettingsUtilImpl.getProject(project);
        groups = ShowSettingsUtilImpl.filterEmptyGroups(groups);
        ShowSettingsUtilImpl.getDialog(actualProject, groups, ShowSettingsUtilImpl.findPreselectedByDisplayName(nameToSelect, groups)).show();
    }

    @Nullable
    private static Configurable findPreselectedByDisplayName(String preselectedConfigurableDisplayName, ConfigurableGroup[] groups) {
        List<Configurable> all = SearchUtil.expand(groups);
        for (Configurable each : all) {
            if (!preselectedConfigurableDisplayName.equals(each.getDisplayName())) continue;
            return each;
        }
        return null;
    }

    public static void showSettingsDialog(@Nullable Project project, String id2Select, String filter) {
        ConfigurableGroup[] group = ShowSettingsUtilImpl.getConfigurableGroups(project, true);
        group = ShowSettingsUtilImpl.filterEmptyGroups(group);
        Configurable configurable2Select = id2Select == null ? null : new ConfigurableVisitor.ByID(id2Select).find(group);
        SettingsDialogFactory.getInstance().create(ShowSettingsUtilImpl.getProject(project), group, configurable2Select, filter).show();
    }

    public void showSettingsDialog(@NotNull Project project, Configurable toSelect2) {
        if (project == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(11);
        }
        ShowSettingsUtilImpl.getDialog(project, ShowSettingsUtilImpl.getConfigurableGroups(project, true), toSelect2).show();
    }

    @NotNull
    private static ConfigurableGroup[] filterEmptyGroups(@NotNull ConfigurableGroup[] group) {
        if (group == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(12);
        }
        ArrayList<ConfigurableGroup> groups = new ArrayList<ConfigurableGroup>();
        for (ConfigurableGroup g : group) {
            if (g.getConfigurables().length <= 0) continue;
            groups.add(g);
        }
        ConfigurableGroup[] configurableGroupArray = groups.toArray(new ConfigurableGroup[0]);
        if (configurableGroupArray == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(13);
        }
        return configurableGroupArray;
    }

    public boolean editConfigurable(Project project, Configurable configurable) {
        return this.editConfigurable(project, ShowSettingsUtilImpl.createDimensionKey(configurable), configurable);
    }

    public <T extends Configurable> T findProjectConfigurable(Project project, Class<T> confClass) {
        return ConfigurableExtensionPointUtil.findProjectConfigurable(project, confClass);
    }

    public boolean editConfigurable(Project project, String dimensionServiceKey, @NotNull Configurable configurable) {
        if (configurable == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(14);
        }
        return this.editConfigurable(project, dimensionServiceKey, configurable, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable));
    }

    private static boolean isWorthToShowApplyButton(@NotNull Configurable configurable) {
        if (configurable == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(15);
        }
        return configurable instanceof Place.Navigator || configurable instanceof Composite || configurable instanceof TabbedConfigurable;
    }

    public boolean editConfigurable(Project project, String dimensionServiceKey, @NotNull Configurable configurable, boolean showApplyButton) {
        if (configurable == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(16);
        }
        return ShowSettingsUtilImpl.editConfigurable(null, project, configurable, dimensionServiceKey, null, showApplyButton);
    }

    public boolean editConfigurable(Project project, Configurable configurable, Runnable advancedInitialization) {
        return ShowSettingsUtilImpl.editConfigurable(null, project, configurable, ShowSettingsUtilImpl.createDimensionKey(configurable), advancedInitialization, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable));
    }

    public boolean editConfigurable(@Nullable Component parent, @NotNull Configurable configurable) {
        if (configurable == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(17);
        }
        return this.editConfigurable(parent, configurable, null);
    }

    public boolean editConfigurable(@Nullable Component parent, @NotNull Configurable configurable, @Nullable Runnable advancedInitialization) {
        if (configurable == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(18);
        }
        return ShowSettingsUtilImpl.editConfigurable(parent, null, configurable, ShowSettingsUtilImpl.createDimensionKey(configurable), advancedInitialization, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable));
    }

    private static boolean editConfigurable(@Nullable Component parent, @Nullable Project project, @NotNull Configurable configurable, String dimensionKey, final @Nullable Runnable advancedInitialization, boolean showApplyButton) {
        if (configurable == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(19);
        }
        DialogWrapper editor = parent == null ? SettingsDialogFactory.getInstance().create(project, dimensionKey, configurable, showApplyButton, false) : SettingsDialogFactory.getInstance().create(parent, dimensionKey, configurable, showApplyButton, false);
        if (advancedInitialization != null) {
            new UiNotifyConnector.Once((Component)editor.getContentPane(), (Activatable)new Activatable.Adapter(){

                public void showNotify() {
                    advancedInitialization.run();
                }
            });
        }
        return editor.showAndGet();
    }

    @NotNull
    public static String createDimensionKey(@NotNull Configurable configurable) {
        if (configurable == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(20);
        }
        String string = '#' + configurable.getDisplayName().replace('\n', '_').replace(' ', '_');
        if (string == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(21);
        }
        return string;
    }

    public boolean editConfigurable(Component parent, String dimensionServiceKey, Configurable configurable) {
        return ShowSettingsUtilImpl.editConfigurable(parent, null, configurable, dimensionServiceKey, null, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ShowSettingsUtilImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurableClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameToSelect";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ShowSettingsUtilImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurableGroups";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurables";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "filterEmptyGroups";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createDimensionKey";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDialog";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showSettingsDialog";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "filterEmptyGroups";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "editConfigurable";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isWorthToShowApplyButton";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createDimensionKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

