/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.RecentLocationItem;
import com.intellij.ide.actions.RecentLocationsDataModel;
import com.intellij.ide.actions.RecentLocationsRenderer;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.laf.darcula.DarculaLookAndFeelInfo;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.FocusManagerImpl;
import com.intellij.ui.CaptionPanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class RecentLocationsAction
extends DumbAwareAction {
    private static final String RECENT_LOCATIONS_ACTION_ID = "RecentLocations";
    private static final String LOCATION_SETTINGS_KEY = "recent.locations.popup";
    private static final String SHOW_RECENT_CHANGED_LOCATIONS = "SHOW_RECENT_CHANGED_LOCATIONS";
    private static final int DEFAULT_WIDTH = JBUI.scale((int)700);
    private static final int DEFAULT_HEIGHT = JBUI.scale((int)530);
    private static final int MINIMUM_WIDTH = JBUI.scale((int)600);
    private static final int MINIMUM_HEIGHT = JBUI.scale((int)450);
    private static final Color SHORTCUT_FOREGROUND_COLOR = UIUtil.getContextHelpForeground();
    public static final String SHORTCUT_HEX_COLOR = String.format("#%02x%02x%02x", SHORTCUT_FOREGROUND_COLOR.getRed(), SHORTCUT_FOREGROUND_COLOR.getGreen(), SHORTCUT_FOREGROUND_COLOR.getBlue());
    static final String EMPTY_FILE_TEXT = IdeBundle.message((String)"recent.locations.popup.empty.file.text", (Object[])new Object[0]);

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RecentLocationsAction.$$$reportNull$$$0(0);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed(RECENT_LOCATIONS_ACTION_ID);
        final Project project = RecentLocationsAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return;
        }
        final RecentLocationsDataModel model = new RecentLocationsDataModel(project, ContainerUtil.newArrayList());
        final JBList list2 = new JBList((ListModel)JBList.createDefaultListModel(model.getPlaces(RecentLocationsAction.showChanged(project))));
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)list2, (int)20, (int)31);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        final ListWithFilter listWithFilter = (ListWithFilter)ListWithFilter.wrap((JList)list2, (JScrollPane)scrollPane, RecentLocationsAction.getNamer(project, model), (boolean)true);
        listWithFilter.setAutoPackHeight(false);
        listWithFilter.setBorder(BorderFactory.createEmptyBorder());
        SpeedSearch speedSearch = listWithFilter.getSpeedSearch();
        speedSearch.addChangeListener(evt -> {
            if (evt.getPropertyName().equals("enteredPrefix") && StringUtil.isEmpty((String)speedSearch.getFilter())) {
                model.getEditorsToRelease().forEach(editor -> RecentLocationsAction.clearSelectionInEditor(editor));
            }
        });
        list2.setCellRenderer((ListCellRenderer)((Object)new RecentLocationsRenderer(project, speedSearch, model)));
        list2.setEmptyText(IdeBundle.message((String)"recent.locations.popup.empty.text", (Object[])new Object[0]));
        list2.setBackground(EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground());
        ScrollingUtil.installActions((JList)list2);
        ScrollingUtil.ensureSelectionExists((JList)list2);
        final JLabel title = RecentLocationsAction.createTitle(RecentLocationsAction.showChanged(project));
        ShortcutSet showChangedOnlyShortcutSet = KeymapUtil.getActiveKeymapShortcuts((String)RECENT_LOCATIONS_ACTION_ID);
        final JBCheckBox checkBox2 = this.createCheckbox(project, showChangedOnlyShortcutSet);
        JPanel topPanel = RecentLocationsAction.createHeaderPanel(title, (JComponent)checkBox2);
        JPanel mainPanel = RecentLocationsAction.createMainPanel(listWithFilter, topPanel);
        Color borderColor = SystemInfoRt.isMac && LafManager.getInstance().getCurrentLookAndFeel() instanceof DarculaLookAndFeelInfo ? topPanel.getBackground() : null;
        final Ref navigationRef = Ref.create((Object)false);
        final JBPopup popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)mainPanel, (JComponent)list2).setProject(project).setCancelOnClickOutside(true).setRequestFocus(true).setCancelCallback(() -> {
            if (speedSearch.isHoldingFilter() && !((Boolean)navigationRef.get()).booleanValue()) {
                speedSearch.reset();
                return false;
            }
            return true;
        }).setResizable(true).setMovable(true).setBorderColor(borderColor).setDimensionServiceKey(project, LOCATION_SETTINGS_KEY, true).setMinSize(new Dimension(MINIMUM_WIDTH, MINIMUM_HEIGHT)).setLocateWithinScreenBounds(false).createPopup();
        DumbAwareAction.create(event -> {
            checkBox2.setSelected(!checkBox2.isSelected());
            RecentLocationsAction.updateItems(project, model, (ListWithFilter<RecentLocationItem>)listWithFilter, title, checkBox2, popup2);
        }).registerCustomShortcutSet(showChangedOnlyShortcutSet, (JComponent)list2, (Disposable)popup2);
        checkBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecentLocationsAction.updateItems(project, model, (ListWithFilter<RecentLocationItem>)listWithFilter, title, checkBox2, popup2);
            }
        });
        if (DimensionService.getInstance().getSize(LOCATION_SETTINGS_KEY, project) == null) {
            popup2.setSize(new Dimension(DEFAULT_WIDTH, DEFAULT_HEIGHT));
        }
        list2.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                int clickCount = event.getClickCount();
                if (clickCount > 1 && clickCount % 2 == 0) {
                    event.consume();
                    int i = list2.locationToIndex(event.getPoint());
                    if (i != -1) {
                        list2.setSelectedIndex(i);
                        RecentLocationsAction.navigateToSelected(project, (JBList<RecentLocationItem>)list2, popup2, (Ref<Boolean>)navigationRef);
                    }
                }
            }
        });
        popup2.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                model.getEditorsToRelease().forEach(editor -> EditorFactory.getInstance().releaseEditor(editor));
                model.getProjectConnection().disconnect();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/actions/RecentLocationsAction$3", "onClosed"));
            }
        });
        RecentLocationsAction.initSearchActions(project, model, (ListWithFilter<RecentLocationItem>)listWithFilter, (JBList<RecentLocationItem>)list2, popup2, (Ref<Boolean>)navigationRef);
        IdeEventQueue.getInstance().getPopupManager().closeAllPopups(false);
        list2.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!(e.getOppositeComponent() instanceof JCheckBox)) {
                    popup2.cancel();
                }
            }
        });
        RecentLocationsAction.showPopup(project, popup2);
    }

    private static void updateItems(@NotNull Project project, @NotNull RecentLocationsDataModel data, @NotNull ListWithFilter<RecentLocationItem> listWithFilter, @NotNull JLabel title, @NotNull JBCheckBox checkBox2, @NotNull JBPopup popup2) {
        if (project == null) {
            RecentLocationsAction.$$$reportNull$$$0(1);
        }
        if (data == null) {
            RecentLocationsAction.$$$reportNull$$$0(2);
        }
        if (listWithFilter == null) {
            RecentLocationsAction.$$$reportNull$$$0(3);
        }
        if (title == null) {
            RecentLocationsAction.$$$reportNull$$$0(4);
        }
        if (checkBox2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(5);
        }
        if (popup2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(6);
        }
        boolean state = checkBox2.isSelected();
        PropertiesComponent.getInstance((Project)project).setValue(SHOW_RECENT_CHANGED_LOCATIONS, state);
        RecentLocationsAction.updateModel(listWithFilter, data, state);
        RecentLocationsAction.updateTitleText(title, state);
        FocusManagerImpl.getInstance().requestFocus(listWithFilter, false);
        popup2.pack(false, false);
    }

    @NotNull
    public JBCheckBox createCheckbox(@NotNull Project project, @NotNull ShortcutSet checkboxShortcutSet) {
        if (project == null) {
            RecentLocationsAction.$$$reportNull$$$0(7);
        }
        if (checkboxShortcutSet == null) {
            RecentLocationsAction.$$$reportNull$$$0(8);
        }
        String text = "<html>" + IdeBundle.message((String)"recent.locations.title.text", (Object[])new Object[0]) + " <font color=\"" + SHORTCUT_HEX_COLOR + "\">" + KeymapUtil.getShortcutsText((Shortcut[])checkboxShortcutSet.getShortcuts()) + "</font></html>";
        JBCheckBox checkBox2 = new JBCheckBox(text);
        checkBox2.setSelected(RecentLocationsAction.showChanged(project));
        checkBox2.setBorder((Border)JBUI.Borders.empty());
        checkBox2.setOpaque(false);
        JBCheckBox jBCheckBox = checkBox2;
        if (jBCheckBox == null) {
            RecentLocationsAction.$$$reportNull$$$0(9);
        }
        return jBCheckBox;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RecentLocationsAction.$$$reportNull$$$0(10);
        }
        e.getPresentation().setEnabled(RecentLocationsAction.getEventProject((AnActionEvent)e) != null);
    }

    static void clearSelectionInEditor(@NotNull Editor editor) {
        if (editor == null) {
            RecentLocationsAction.$$$reportNull$$$0(11);
        }
        editor.getSelectionModel().removeSelection(true);
    }

    private static void showPopup(@NotNull Project project, @NotNull JBPopup popup2) {
        if (project == null) {
            RecentLocationsAction.$$$reportNull$$$0(12);
        }
        if (popup2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(13);
        }
        Point savedLocation = DimensionService.getInstance().getLocation(LOCATION_SETTINGS_KEY, project);
        Window recentFocusedWindow = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        if (savedLocation != null && recentFocusedWindow != null) {
            popup2.showInScreenCoordinates((Component)recentFocusedWindow, savedLocation);
        } else {
            popup2.showCenteredInCurrentWindow(project);
        }
    }

    private static void updateModel(@NotNull ListWithFilter<RecentLocationItem> listWithFilter, @NotNull RecentLocationsDataModel data, boolean changed) {
        if (listWithFilter == null) {
            RecentLocationsAction.$$$reportNull$$$0(14);
        }
        if (data == null) {
            RecentLocationsAction.$$$reportNull$$$0(15);
        }
        NameFilteringListModel model = (NameFilteringListModel)listWithFilter.getList().getModel();
        DefaultListModel originalModel = (DefaultListModel)model.getOriginalModel();
        originalModel.removeAllElements();
        data.getPlaces(changed).forEach(item -> originalModel.addElement(item));
        listWithFilter.getSpeedSearch().reset();
    }

    @NotNull
    private static JPanel createMainPanel(@NotNull ListWithFilter listWithFilter, @NotNull JPanel topPanel) {
        if (listWithFilter == null) {
            RecentLocationsAction.$$$reportNull$$$0(16);
        }
        if (topPanel == null) {
            RecentLocationsAction.$$$reportNull$$$0(17);
        }
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)topPanel, "North");
        mainPanel.add((Component)listWithFilter, "Center");
        JPanel jPanel = mainPanel;
        if (jPanel == null) {
            RecentLocationsAction.$$$reportNull$$$0(18);
        }
        return jPanel;
    }

    @NotNull
    private static JPanel createHeaderPanel(@NotNull JLabel title, @NotNull JComponent checkbox) {
        if (title == null) {
            RecentLocationsAction.$$$reportNull$$$0(19);
        }
        if (checkbox == null) {
            RecentLocationsAction.$$$reportNull$$$0(20);
        }
        CaptionPanel topPanel = new CaptionPanel();
        topPanel.add((Component)title, "West");
        topPanel.add((Component)checkbox, "East");
        Dimension size = topPanel.getPreferredSize();
        size.height = JBUI.scale((int)29);
        topPanel.setPreferredSize(size);
        topPanel.setBorder((Border)JBUI.Borders.empty((int)5, (int)8));
        WindowMoveListener moveListener = new WindowMoveListener((Component)topPanel);
        topPanel.addMouseListener(moveListener);
        topPanel.addMouseMotionListener(moveListener);
        CaptionPanel captionPanel = topPanel;
        if (captionPanel == null) {
            RecentLocationsAction.$$$reportNull$$$0(21);
        }
        return captionPanel;
    }

    @NotNull
    private static JLabel createTitle(boolean showChanged) {
        JBLabel title = new JBLabel();
        title.setFont(title.getFont().deriveFont(1));
        RecentLocationsAction.updateTitleText((JLabel)title, showChanged);
        JBLabel jBLabel = title;
        if (jBLabel == null) {
            RecentLocationsAction.$$$reportNull$$$0(22);
        }
        return jBLabel;
    }

    private static void updateTitleText(@NotNull JLabel title, boolean showChanged) {
        if (title == null) {
            RecentLocationsAction.$$$reportNull$$$0(23);
        }
        title.setText(showChanged ? IdeBundle.message((String)"recent.locations.changed.locations", (Object[])new Object[0]) : IdeBundle.message((String)"recent.locations.popup.title", (Object[])new Object[0]));
    }

    @NotNull
    private static Function<RecentLocationItem, String> getNamer(@NotNull Project project, @NotNull RecentLocationsDataModel data) {
        if (project == null) {
            RecentLocationsAction.$$$reportNull$$$0(24);
        }
        if (data == null) {
            RecentLocationsAction.$$$reportNull$$$0(25);
        }
        Function function = value -> {
            String breadcrumb = data.getBreadcrumbsMap(RecentLocationsAction.showChanged(project)).get(value.getInfo());
            EditorEx editor = value.getEditor();
            return breadcrumb + " " + value.getInfo().getFile().getName() + " " + editor.getDocument().getText();
        };
        if (function == null) {
            RecentLocationsAction.$$$reportNull$$$0(26);
        }
        return function;
    }

    private static void initSearchActions(final @NotNull Project project, @NotNull RecentLocationsDataModel data, @NotNull ListWithFilter<RecentLocationItem> listWithFilter, final @NotNull JBList<RecentLocationItem> list2, final @NotNull JBPopup popup2, final @NotNull Ref<Boolean> navigationRef) {
        if (project == null) {
            RecentLocationsAction.$$$reportNull$$$0(27);
        }
        if (data == null) {
            RecentLocationsAction.$$$reportNull$$$0(28);
        }
        if (listWithFilter == null) {
            RecentLocationsAction.$$$reportNull$$$0(29);
        }
        if (list2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(30);
        }
        if (popup2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(31);
        }
        if (navigationRef == null) {
            RecentLocationsAction.$$$reportNull$$$0(32);
        }
        listWithFilter.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                int clickCount = event.getClickCount();
                if (clickCount > 1 && clickCount % 2 == 0) {
                    event.consume();
                    RecentLocationsAction.navigateToSelected(project, (JBList<RecentLocationItem>)list2, popup2, (Ref<Boolean>)navigationRef);
                }
            }
        });
        DumbAwareAction.create(e -> RecentLocationsAction.navigateToSelected(project, list2, popup2, navigationRef)).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ENTER"}), listWithFilter, (Disposable)popup2);
        DumbAwareAction.create(e -> RecentLocationsAction.removePlaces(project, listWithFilter, list2, data)).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"DELETE", "BACK_SPACE"}), listWithFilter, (Disposable)popup2);
    }

    private static void removePlaces(@NotNull Project project, @NotNull ListWithFilter<RecentLocationItem> listWithFilter, @NotNull JBList<RecentLocationItem> list2, @NotNull RecentLocationsDataModel data) {
        List selectedValue;
        if (project == null) {
            RecentLocationsAction.$$$reportNull$$$0(33);
        }
        if (listWithFilter == null) {
            RecentLocationsAction.$$$reportNull$$$0(34);
        }
        if (list2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(35);
        }
        if (data == null) {
            RecentLocationsAction.$$$reportNull$$$0(36);
        }
        if ((selectedValue = list2.getSelectedValuesList()).isEmpty()) {
            return;
        }
        int index = list2.getSelectedIndex();
        boolean changed = RecentLocationsAction.showChanged(project);
        IdeDocumentHistory ideDocumentHistory = IdeDocumentHistory.getInstance(project);
        for (RecentLocationItem item : selectedValue) {
            if (changed) {
                ContainerUtil.filter(ideDocumentHistory.getChangePlaces(), info -> IdeDocumentHistoryImpl.isSame(info, item.getInfo())).forEach(info -> ideDocumentHistory.removeChangePlace((IdeDocumentHistoryImpl.PlaceInfo)info));
                continue;
            }
            ContainerUtil.filter(ideDocumentHistory.getBackPlaces(), info -> IdeDocumentHistoryImpl.isSame(info, item.getInfo())).forEach(info -> ideDocumentHistory.removeBackPlace((IdeDocumentHistoryImpl.PlaceInfo)info));
        }
        RecentLocationsAction.updateModel(listWithFilter, data, RecentLocationsAction.showChanged(project));
        if (list2.getModel().getSize() > 0) {
            ScrollingUtil.selectItem(list2, (int)(index < list2.getModel().getSize() ? index : index - 1));
        }
    }

    private static void navigateToSelected(@NotNull Project project, @NotNull JBList<RecentLocationItem> list2, @NotNull JBPopup popup2, @NotNull Ref<Boolean> navigationRef) {
        RecentLocationItem selectedValue;
        if (project == null) {
            RecentLocationsAction.$$$reportNull$$$0(37);
        }
        if (list2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(38);
        }
        if (popup2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(39);
        }
        if (navigationRef == null) {
            RecentLocationsAction.$$$reportNull$$$0(40);
        }
        if ((selectedValue = (RecentLocationItem)list2.getSelectedValue()) != null) {
            IdeDocumentHistory.getInstance(project).gotoPlaceInfo(selectedValue.getInfo());
        }
        navigationRef.set((Object)true);
        popup2.closeOk(null);
    }

    static boolean showChanged(@NotNull Project project) {
        if (project == null) {
            RecentLocationsAction.$$$reportNull$$$0(41);
        }
        return PropertiesComponent.getInstance((Project)project).getBoolean(SHOW_RECENT_CHANGED_LOCATIONS, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 18: 
            case 21: 
            case 22: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 18: 
            case 21: 
            case 22: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 7: 
            case 12: 
            case 24: 
            case 27: 
            case 33: 
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 15: 
            case 25: 
            case 28: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: 
            case 14: 
            case 16: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listWithFilter";
                break;
            }
            case 4: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkBox";
                break;
            }
            case 6: 
            case 13: 
            case 31: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkboxShortcutSet";
                break;
            }
            case 9: 
            case 18: 
            case 21: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/RecentLocationsAction";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topPanel";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkbox";
                break;
            }
            case 30: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 32: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigationRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/RecentLocationsAction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createCheckbox";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createMainPanel";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createHeaderPanel";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createTitle";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateItems";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createCheckbox";
                break;
            }
            case 9: 
            case 18: 
            case 21: 
            case 22: 
            case 26: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "clearSelectionInEditor";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showPopup";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateModel";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createMainPanel";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createHeaderPanel";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "updateTitleText";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getNamer";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "initSearchActions";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "removePlaces";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "navigateToSelected";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "showChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 18: 
            case 21: 
            case 22: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

