/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.OpenProjectFileChooserDescriptor;
import com.intellij.ide.highlighter.ProjectFileType;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import java.io.File;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenFileAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenFileAction.$$$reportNull$$$0(0);
        }
        Project eventProject = e.getProject();
        ApplicationManager.getApplication().invokeLater(() -> this.prepareFileChooserAndOpen(eventProject));
    }

    private void prepareFileChooserAndOpen(Project eventProject) {
        boolean showFiles = eventProject != null || PlatformProjectOpenProcessor.getInstanceIfItExists() != null;
        OpenProjectFileChooserDescriptor descriptor = showFiles ? new ProjectOrFileChooserDescriptor() : new ProjectOnlyFileChooserDescriptor();
        VirtualFile toSelect2 = null;
        if (StringUtil.isNotEmpty((String)GeneralSettings.getInstance().getDefaultProjectDirectory())) {
            toSelect2 = VfsUtil.findFileByIoFile((File)new File(GeneralSettings.getInstance().getDefaultProjectDirectory()), (boolean)true);
        }
        descriptor.putUserData(PathChooserDialog.PREFER_LAST_OVER_EXPLICIT, toSelect2 == null && showFiles);
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)eventProject, (VirtualFile)(toSelect2 != null ? toSelect2 : this.getPathToSelect()), files2 -> {
            for (VirtualFile file2 : files2) {
                if (descriptor.isFileSelectable(file2)) continue;
                String message = IdeBundle.message((String)"error.dir.contains.no.project", (Object[])new Object[]{file2.getPresentableUrl()});
                Messages.showInfoMessage((Project)eventProject, (String)message, (String)IdeBundle.message((String)"title.cannot.open.project", (Object[])new Object[0]));
                return;
            }
            OpenFileAction.doOpenFile(eventProject, files2);
        });
    }

    @Nullable
    protected VirtualFile getPathToSelect() {
        return VfsUtil.getUserHomeDir();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenFileAction.$$$reportNull$$$0(1);
        }
        if (NewWelcomeScreen.isNewWelcomeScreen(e)) {
            e.getPresentation().setIcon(AllIcons.Actions.Menu_open);
        }
    }

    private static void doOpenFile(@Nullable Project project, @NotNull List<VirtualFile> result2) {
        if (result2 == null) {
            OpenFileAction.$$$reportNull$$$0(2);
        }
        for (VirtualFile file2 : result2) {
            FileType type;
            if (file2.isDirectory()) {
                Project openedProject;
                if (ProjectAttachProcessor.canAttachToProject()) {
                    EnumSet<PlatformProjectOpenProcessor.Option> options = EnumSet.noneOf(PlatformProjectOpenProcessor.Option.class);
                    openedProject = PlatformProjectOpenProcessor.doOpenProject(file2, project, -1, null, options);
                } else {
                    openedProject = ProjectUtil.openOrImport(file2.getPath(), project, false);
                }
                FileChooserUtil.setLastOpenedFile(openedProject, file2);
                return;
            }
            if ((project == null || !file2.equals(project.getProjectFile())) && OpenProjectFileChooserDescriptor.isProjectFile(file2)) {
                int answer;
                int n = answer = file2.getFileType() instanceof ProjectFileType ? 0 : Messages.showYesNoCancelDialog((Project)project, (String)IdeBundle.message((String)"message.open.file.is.project", (Object[])new Object[]{file2.getName()}), (String)IdeBundle.message((String)"title.open.project", (Object[])new Object[0]), (String)IdeBundle.message((String)"message.open.file.is.project.open.as.project", (Object[])new Object[0]), (String)IdeBundle.message((String)"message.open.file.is.project.open.as.file", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.cancel", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                if (answer == 2) {
                    return;
                }
                if (answer == 0) {
                    Project openedProject = ProjectUtil.openOrImport(file2.getPath(), project, false);
                    if (openedProject != null) {
                        FileChooserUtil.setLastOpenedFile(openedProject, file2);
                    }
                    return;
                }
            }
            if ((type = FileTypeChooser.getKnownFileTypeOrAssociate(file2, project)) == null) {
                return;
            }
            if (project != null) {
                OpenFileAction.openFile(file2, project);
                continue;
            }
            PlatformProjectOpenProcessor.doOpenProject(file2, null, -1, null, EnumSet.of(PlatformProjectOpenProcessor.Option.TEMP_PROJECT));
        }
    }

    public static void openFile(String filePath, @NotNull Project project) {
        VirtualFile file2;
        if (project == null) {
            OpenFileAction.$$$reportNull$$$0(3);
        }
        if ((file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(filePath)) != null && file2.isValid()) {
            OpenFileAction.openFile(file2, project);
        }
    }

    public static void openFile(VirtualFile file2, @NotNull Project project) {
        if (project == null) {
            OpenFileAction.$$$reportNull$$$0(4);
        }
        NonProjectFileWritingAccessProvider.allowWriting(Collections.singletonList(file2));
        PsiNavigationSupport.getInstance().createNavigatable(project, file2, -1).navigate(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/OpenFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doOpenFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "openFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ProjectOrFileChooserDescriptor
    extends OpenProjectFileChooserDescriptor {
        private final FileChooserDescriptor myStandardDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withHideIgnored(false);

        ProjectOrFileChooserDescriptor() {
            super(true);
            this.setTitle(IdeBundle.message((String)"title.open.file.or.project", (Object[])new Object[0]));
        }

        @Override
        public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
            return file2.isDirectory() ? super.isFileVisible(file2, showHiddenFiles) : this.myStandardDescriptor.isFileVisible(file2, showHiddenFiles);
        }

        @Override
        public boolean isFileSelectable(VirtualFile file2) {
            return file2.isDirectory() ? super.isFileSelectable(file2) : this.myStandardDescriptor.isFileSelectable(file2);
        }

        public boolean isChooseMultiple() {
            return true;
        }
    }

    private static class ProjectOnlyFileChooserDescriptor
    extends OpenProjectFileChooserDescriptor {
        ProjectOnlyFileChooserDescriptor() {
            super(true);
            this.setTitle(IdeBundle.message((String)"title.open.project", (Object[])new Object[0]));
        }
    }
}

