/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.concurrency.JobScheduler;
import com.intellij.diagnostic.VMOptions;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.EditCustomVmOptionsAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.BrowseNotificationAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.notification.impl.NotificationFullContent;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.JdkBundle;
import com.intellij.util.SystemProperties;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class SystemHealthMonitor
implements BaseComponent {
    private static final Logger LOG = Logger.getInstance(SystemHealthMonitor.class);
    private static final NotificationGroup GROUP = new NotificationGroup("System Health", NotificationDisplayType.STICKY_BALLOON, true);
    private static final String SWITCH_JDK_ACTION = "SwitchBootJdk";
    private static final JavaVersion MIN_RECOMMENDED_JDK = JavaVersion.compose((int)8, (int)0, (int)144, (int)0, (boolean)false);
    private final PropertiesComponent myProperties;
    private static final SignalHandler NO_OP_HANDLER = sig -> {};

    public SystemHealthMonitor(@NotNull PropertiesComponent properties) {
        if (properties == null) {
            SystemHealthMonitor.$$$reportNull$$$0(0);
        }
        this.myProperties = properties;
    }

    public void initComponent() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            this.checkRuntime();
            this.checkReservedCodeCacheSize();
            this.checkIBus();
            this.checkSignalBlocking();
            SystemHealthMonitor.startDiskSpaceMonitoring();
        });
    }

    private void checkRuntime() {
        JdkBundle bootJdk;
        if (JavaVersion.current().ea) {
            this.showNotification("unsupported.jvm.ea.message", null, new Object[0]);
        }
        if (!(bootJdk = JdkBundle.createBoot()).isBundled()) {
            boolean outdatedRuntime;
            boolean bl = outdatedRuntime = bootJdk.getBundleVersion().compareTo(MIN_RECOMMENDED_JDK) < 0;
            if (!SystemInfo.isJetBrainsJvm || outdatedRuntime) {
                JdkBundle bundledJdk;
                boolean validBundledJdk = (SystemInfo.isWindows || SystemInfo.isMac || SystemInfo.isLinux) && (bundledJdk = JdkBundle.createBundled()) != null && bundledJdk.isOperational();
                NotificationAction switchAction = new NotificationAction("Switch"){

                    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (notification == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        notification.expire();
                        ActionManager.getInstance().getAction(SystemHealthMonitor.SWITCH_JDK_ACTION).actionPerformed(e);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "e";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "notification";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/ide/SystemHealthMonitor$1";
                        objectArray[2] = "actionPerformed";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                String current = bootJdk.getBundleVersion().toString();
                if (!SystemInfo.isJetBrainsJvm) {
                    current = current + " by " + SystemInfo.JAVA_VENDOR;
                }
                if (outdatedRuntime && validBundledJdk) {
                    this.showNotification("outdated.jre.version.message1", switchAction, current, MIN_RECOMMENDED_JDK);
                } else if (outdatedRuntime) {
                    this.showNotification("outdated.jre.version.message2", null, current, MIN_RECOMMENDED_JDK);
                } else if (validBundledJdk) {
                    this.showNotification("bundled.jre.version.message", switchAction, current);
                }
            }
        }
    }

    private void checkReservedCodeCacheSize() {
        int minReservedCodeCacheSize = 240;
        int reservedCodeCacheSize = VMOptions.readOption(VMOptions.MemoryKind.CODE_CACHE, true);
        if (reservedCodeCacheSize > 0 && reservedCodeCacheSize < minReservedCodeCacheSize) {
            final EditCustomVmOptionsAction vmEditAction = new EditCustomVmOptionsAction();
            NotificationAction action = new NotificationAction(IdeBundle.message((String)"vmoptions.edit.action", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (notification == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    notification.expire();
                    ActionUtil.performActionDumbAware((AnAction)vmEditAction, (AnActionEvent)e);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/ide/SystemHealthMonitor$2";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            this.showNotification("vmoptions.warn.message", (NotificationAction)(vmEditAction.isEnabled() ? action : null), reservedCodeCacheSize, minReservedCodeCacheSize);
        }
    }

    private void checkIBus() {
        String fix;
        Matcher m;
        String version2;
        String xim;
        if (SystemInfo.isXWindow && (xim = System.getenv("XMODIFIERS")) != null && xim.contains("im=ibus") && (version2 = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{"ibus-daemon", "--version"}))) != null && (m = Pattern.compile("ibus-daemon - Version ([0-9.]+)").matcher(version2)).find() && StringUtil.compareVersionNumbers((String)m.group(1), (String)"1.5.11") < 0 && ((fix = System.getenv("IBUS_ENABLE_SYNC_MODE")) == null || fix.isEmpty() || fix.equals("0") || fix.equalsIgnoreCase("false"))) {
            this.showNotification("ibus.blocking.warn.message", SystemHealthMonitor.detailsAction("https://youtrack.jetbrains.com/issue/IDEA-78860"), new Object[0]);
        }
    }

    private void checkSignalBlocking() {
        if (SystemInfo.isUnix) {
            try {
                Signal sigInt = new Signal("INT");
                SignalHandler oldInt = Signal.handle(sigInt, NO_OP_HANDLER);
                if (oldInt == SignalHandler.SIG_IGN) {
                    this.showNotification("ide.sigint.ignored.message", SystemHealthMonitor.detailsAction("https://youtrack.jetbrains.com/issue/IDEA-157989"), new Object[0]);
                } else {
                    Signal.handle(sigInt, oldInt);
                }
                Signal sigPipe = new Signal("PIPE");
                SignalHandler oldPipe = Signal.handle(sigPipe, NO_OP_HANDLER);
                if (oldPipe == SignalHandler.SIG_IGN) {
                    LOG.info("restored ignored PIPE handler");
                } else {
                    Signal.handle(sigInt, oldPipe);
                }
            }
            catch (Throwable t) {
                LOG.warn(t);
            }
        }
    }

    private void showNotification(final @PropertyKey(resourceBundle="messages.IdeBundle") String key, @Nullable NotificationAction action, Object ... params) {
        boolean ignored = this.myProperties.isValueSet("ignore." + key);
        LOG.info("issue detected: " + key + (ignored ? " (ignored)" : ""));
        if (ignored) {
            return;
        }
        MyNotification notification = new MyNotification(IdeBundle.message((String)key, (Object[])params));
        if (action != null) {
            notification.addAction((AnAction)action);
        }
        notification.addAction((AnAction)new NotificationAction(IdeBundle.message((String)"sys.health.acknowledge.action", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    3.$$$reportNull$$$0(1);
                }
                notification.expire();
                SystemHealthMonitor.this.myProperties.setValue("ignore." + key, "true");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/SystemHealthMonitor$3";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        notification.setImportant(true);
        ApplicationManager.getApplication().invokeLater(() -> Notifications.Bus.notify((Notification)notification));
    }

    private static NotificationAction detailsAction(String url) {
        return new BrowseNotificationAction(IdeBundle.message((String)"sys.health.details", (Object[])new Object[0]), url);
    }

    private static void startDiskSpaceMonitoring() {
        if (SystemProperties.getBooleanProperty((String)"idea.no.system.path.space.monitoring", (boolean)false)) {
            return;
        }
        final File file2 = new File(PathManager.getSystemPath());
        final AtomicBoolean reported = new AtomicBoolean();
        final ThreadLocal ourFreeSpaceCalculation = new ThreadLocal();
        JobScheduler.getScheduler().schedule(new Runnable(){
            private static final long LOW_DISK_SPACE_THRESHOLD = 0x3200000L;
            private static final long MAX_WRITE_SPEED_IN_BPS = 524288000L;

            @Override
            public void run() {
                if (!reported.get()) {
                    Future future2 = (Future)ourFreeSpaceCalculation.get();
                    if (future2 == null) {
                        future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                            long fileUsableSpace = file2.getUsableSpace();
                            while (fileUsableSpace == 0L) {
                                TimeoutUtil.sleep((long)5000L);
                                fileUsableSpace = file2.getUsableSpace();
                            }
                            return fileUsableSpace;
                        });
                        ourFreeSpaceCalculation.set(future2);
                    }
                    if (!future2.isDone() || future2.isCancelled()) {
                        this.restart(1L);
                        return;
                    }
                    try {
                        long fileUsableSpace = (Long)future2.get();
                        long timeout = Math.min(3600L, Math.max(5L, (fileUsableSpace - 0x3200000L) / 524288000L));
                        ourFreeSpaceCalculation.set(null);
                        if (fileUsableSpace < 0x3200000L) {
                            if (ReadAction.compute(() -> NotificationsConfiguration.getNotificationsConfiguration()) == null) {
                                ourFreeSpaceCalculation.set(future2);
                                this.restart(1L);
                                return;
                            }
                            reported.compareAndSet(false, true);
                            SwingUtilities.invokeLater(() -> {
                                String productName = ApplicationNamesInfo.getInstance().getFullProductName();
                                String message = IdeBundle.message((String)"low.disk.space.message", (Object[])new Object[]{productName});
                                if (fileUsableSpace < 102400L) {
                                    LOG.warn(message + " (" + fileUsableSpace + ")");
                                    Messages.showErrorDialog((String)message, (String)"Fatal Configuration Problem");
                                    reported.compareAndSet(true, false);
                                    this.restart(timeout);
                                } else {
                                    GROUP.createNotification(message, file2.getPath(), NotificationType.ERROR, null).whenExpired(() -> {
                                        reported.compareAndSet(true, false);
                                        this.restart(timeout);
                                    }).notify(null);
                                }
                            });
                        } else {
                            this.restart(timeout);
                        }
                    }
                    catch (Exception ex) {
                        LOG.error((Throwable)ex);
                    }
                }
            }

            private void restart(long timeout) {
                JobScheduler.getScheduler().schedule(this, timeout, TimeUnit.SECONDS);
            }
        }, 1L, TimeUnit.SECONDS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/ide/SystemHealthMonitor", "<init>"));
    }

    private static final class MyNotification
    extends Notification
    implements NotificationFullContent {
        MyNotification(@NotNull String content) {
            if (content == null) {
                MyNotification.$$$reportNull$$$0(0);
            }
            super(GROUP.getDisplayId(), "", content, NotificationType.WARNING);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/SystemHealthMonitor$MyNotification", "<init>"));
        }
    }
}

