/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl.exclude;

import com.intellij.framework.detection.impl.exclude.ExcludeListItem;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.EmptyIcon;

class InvalidExcludeListItem
extends ExcludeListItem {
    private final String myFileUrl;
    private final String myFrameworkTypeId;

    InvalidExcludeListItem(String frameworkTypeId, String fileUrl) {
        this.myFrameworkTypeId = frameworkTypeId;
        this.myFileUrl = fileUrl;
    }

    @Override
    public String getFrameworkTypeId() {
        return this.myFrameworkTypeId;
    }

    @Override
    public String getFileUrl() {
        return this.myFileUrl;
    }

    @Override
    public void renderItem(ColoredListCellRenderer renderer2) {
        if (this.myFrameworkTypeId != null) {
            renderer2.append(this.myFrameworkTypeId, SimpleTextAttributes.ERROR_ATTRIBUTES);
            if (this.myFileUrl != null) {
                renderer2.append(" in " + this.myFileUrl, SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        } else {
            renderer2.append(this.myFileUrl, SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
        renderer2.setIcon(EmptyIcon.ICON_16);
    }

    @Override
    public String getPresentableFrameworkName() {
        return this.myFrameworkTypeId;
    }
}

