/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.ui.MacroComboBoxWithBrowseButton;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextAccessor;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonProgramParametersPanel
extends JPanel
implements PanelWithAnchor {
    private LabeledComponent<RawCommandLineEditor> myProgramParametersComponent;
    private LabeledComponent<JComponent> myWorkingDirectoryComponent;
    @Deprecated
    protected TextFieldWithBrowseButton myWorkingDirectoryField;
    private MacroComboBoxWithBrowseButton myWorkingDirectoryComboBox;
    private EnvironmentVariablesComponent myEnvVariablesComponent;
    protected JComponent myAnchor;
    private Module myModuleContext = null;

    public CommonProgramParametersPanel() {
        this(true);
    }

    public CommonProgramParametersPanel(boolean init2) {
        this.setLayout((LayoutManager)new VerticalFlowLayout(1, 0, 5, true, false));
        if (init2) {
            this.init();
        }
    }

    protected void init() {
        this.initComponents();
        this.updateUI();
        this.setupAnchor();
    }

    protected void setupAnchor() {
        this.myAnchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.myProgramParametersComponent, this.myWorkingDirectoryComponent, this.myEnvVariablesComponent});
    }

    @Nullable
    protected Project getProject() {
        return this.myModuleContext != null ? this.myModuleContext.getProject() : null;
    }

    protected void initComponents() {
        this.myProgramParametersComponent = LabeledComponent.create((JComponent)new RawCommandLineEditor(), (String)ExecutionBundle.message((String)"run.configuration.program.parameters", (Object[])new Object[0]));
        FileChooserDescriptor fileChooserDescriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fileChooserDescriptor2.setTitle(ExecutionBundle.message((String)"select.working.directory.message", (Object[])new Object[0]));
        this.myWorkingDirectoryComboBox = new MacroComboBoxWithBrowseButton(fileChooserDescriptor2, this.getProject());
        this.myWorkingDirectoryField = new TextFieldWithBrowseButton();
        this.addWorkingDirectoryListener(arg_0 -> ((TextFieldWithBrowseButton)this.myWorkingDirectoryField).setText(arg_0));
        this.myWorkingDirectoryComponent = LabeledComponent.create((JComponent)((Object)this.myWorkingDirectoryComboBox), (String)ExecutionBundle.message((String)"run.configuration.working.directory.label", (Object[])new Object[0]));
        this.myEnvVariablesComponent = new EnvironmentVariablesComponent();
        this.myEnvVariablesComponent.setLabelLocation("West");
        this.myProgramParametersComponent.setLabelLocation("West");
        this.myWorkingDirectoryComponent.setLabelLocation("West");
        this.addComponents();
        this.setPreferredSize(new Dimension(10, 10));
        this.copyDialogCaption(this.myProgramParametersComponent);
    }

    @Deprecated
    protected JComponent createComponentWithMacroBrowse(final @NotNull TextFieldWithBrowseButton textAccessor) {
        if (textAccessor == null) {
            CommonProgramParametersPanel.$$$reportNull$$$0(0);
        }
        final FixedSizeButton button2 = new FixedSizeButton((JComponent)textAccessor);
        button2.setIcon(AllIcons.Actions.ListFiles);
        button2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList macros = new ArrayList();
                ComboBoxModel model = ((ComboBox)CommonProgramParametersPanel.this.myWorkingDirectoryComboBox.getChildComponent()).getModel();
                for (int i = 0; i < model.getSize(); ++i) {
                    macros.add(model.getElementAt(i));
                }
                JBPopupFactory.getInstance().createPopupChooserBuilder(macros).setItemChosenCallback(value -> textAccessor.setText(value)).setMovable(false).setResizable(false).createPopup().showUnderneathOf((Component)button2);
            }
        });
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)textAccessor, "Center");
        panel2.add((Component)button2, "East");
        return panel2;
    }

    protected void addComponents() {
        this.add((Component)this.myProgramParametersComponent);
        this.add((Component)this.myWorkingDirectoryComponent);
        this.add((Component)((Object)this.myEnvVariablesComponent));
    }

    protected void copyDialogCaption(LabeledComponent<RawCommandLineEditor> component) {
        RawCommandLineEditor rawCommandLineEditor = (RawCommandLineEditor)component.getComponent();
        rawCommandLineEditor.setDialogCaption(component.getRawText());
        component.getLabel().setLabelFor((Component)rawCommandLineEditor.getTextField());
    }

    public void setProgramParametersLabel(String textWithMnemonic) {
        this.myProgramParametersComponent.setText(textWithMnemonic);
        this.copyDialogCaption(this.myProgramParametersComponent);
    }

    public void setProgramParameters(String params) {
        ((RawCommandLineEditor)this.myProgramParametersComponent.getComponent()).setText(params);
    }

    public TextAccessor getWorkingDirectoryAccessor() {
        return this.myWorkingDirectoryComboBox;
    }

    public void addWorkingDirectoryListener(Consumer<? super String> onTextChange) {
        ((ComboBox)this.myWorkingDirectoryComboBox.getChildComponent()).addActionListener(event -> onTextChange.accept(this.myWorkingDirectoryComboBox.getText()));
    }

    public void setWorkingDirectory(String dir) {
        this.myWorkingDirectoryComboBox.setText(dir);
    }

    public void setModuleContext(Module moduleContext) {
        this.myModuleContext = moduleContext;
        this.myWorkingDirectoryComboBox.setModule(moduleContext);
    }

    public void setHasModuleMacro() {
        this.myWorkingDirectoryComboBox.showModuleMacroAlways();
    }

    public LabeledComponent<RawCommandLineEditor> getProgramParametersComponent() {
        return this.myProgramParametersComponent;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(JComponent anchor2) {
        this.myAnchor = anchor2;
        this.myProgramParametersComponent.setAnchor(anchor2);
        this.myWorkingDirectoryComponent.setAnchor(anchor2);
        this.myEnvVariablesComponent.setAnchor(anchor2);
    }

    public void applyTo(CommonProgramRunConfigurationParameters configuration) {
        configuration.setProgramParameters(this.fromTextField((TextAccessor)this.myProgramParametersComponent.getComponent(), configuration));
        configuration.setWorkingDirectory(this.fromTextField(this.myWorkingDirectoryComboBox, configuration));
        configuration.setEnvs(this.myEnvVariablesComponent.getEnvs());
        configuration.setPassParentEnvs(this.myEnvVariablesComponent.isPassParentEnvs());
    }

    @Nullable
    protected String fromTextField(@NotNull TextAccessor textAccessor, @NotNull CommonProgramRunConfigurationParameters configuration) {
        if (textAccessor == null) {
            CommonProgramParametersPanel.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            CommonProgramParametersPanel.$$$reportNull$$$0(2);
        }
        return textAccessor.getText();
    }

    public void reset(CommonProgramRunConfigurationParameters configuration) {
        this.setProgramParameters(configuration.getProgramParameters());
        this.setWorkingDirectory(PathUtil.toSystemDependentName((String)configuration.getWorkingDirectory()));
        this.myEnvVariablesComponent.setEnvs(configuration.getEnvs());
        this.myEnvVariablesComponent.setPassParentEnvs(configuration.isPassParentEnvs());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAccessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/ui/CommonProgramParametersPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createComponentWithMacroBrowse";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fromTextField";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

