/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.history.actions;

import com.intellij.execution.TestStateStorage;
import com.intellij.execution.testframework.sm.TestHistoryConfiguration;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.history.actions.AbstractImportTestsAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.DateFormatUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportTestsFromHistoryAction
extends AbstractImportTestsAction {
    private final String myFileName;

    public ImportTestsFromHistoryAction(@Nullable SMTRunnerConsoleProperties properties, Project project, String name) {
        super(properties, StringUtil.escapeMnemonics((String)ImportTestsFromHistoryAction.getPresentableText(project, name)), ImportTestsFromHistoryAction.getPresentableText(project, name), ImportTestsFromHistoryAction.getIcon(project, name));
        this.myFileName = name;
    }

    private static Icon getIcon(Project project, String name) {
        return TestHistoryConfiguration.getInstance(project).getIcon(name);
    }

    @NotNull
    private static String getPresentableText(Project project, String name) {
        String nameWithoutExtension = FileUtil.getNameWithoutExtension((String)name);
        int lastIndexOf = nameWithoutExtension.lastIndexOf(" - ");
        if (lastIndexOf > 0) {
            String string;
            String date = nameWithoutExtension.substring(lastIndexOf + 3);
            try {
                Date creationDate = new SimpleDateFormat("yyyy.MM.dd 'at' HH'h' mm'm' ss's'").parse(date);
                String configurationName = TestHistoryConfiguration.getInstance(project).getConfigurationName(name);
                string = (configurationName != null ? configurationName : nameWithoutExtension.substring(0, lastIndexOf)) + " (" + DateFormatUtil.formatDateTime((Date)creationDate) + ")";
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (string == null) {
                ImportTestsFromHistoryAction.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = nameWithoutExtension;
        if (string == null) {
            ImportTestsFromHistoryAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public VirtualFile getFile(@NotNull Project project) {
        if (project == null) {
            ImportTestsFromHistoryAction.$$$reportNull$$$0(2);
        }
        return LocalFileSystem.getInstance().findFileByPath(TestStateStorage.getTestHistoryRoot(project).getPath() + "/" + this.myFileName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/sm/runner/history/actions/ImportTestsFromHistoryAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/sm/runner/history/actions/ImportTestsFromHistoryAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

