/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.ConsoleHistoryBaseModel;
import com.intellij.execution.console.ConsoleHistoryModel;
import com.intellij.execution.console.MasterModel;
import com.intellij.execution.console.PrefixHistoryModelKt;
import gnu.trove.TIntStack;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\b\u0010\u001c\u001a\u00020\fH\u0016J+\u0010\u001d\u001a$\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u00070\u0007 \u001f*\u0010\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u00070\u00070\n0\u001eH\u0097\u0001J\n\u0010 \u001a\u0004\u0018\u00010\u001aH\u0016J\n\u0010!\u001a\u0004\u0018\u00010\u001aH\u0016J\t\u0010\"\u001a\u00020\fH\u0096\u0001J\t\u0010#\u001a\u00020\fH\u0096\u0001J\t\u0010$\u001a\u00020%H\u0096\u0001J\b\u0010&\u001a\u00020'H\u0016J\t\u0010(\u001a\u00020'H\u0096\u0001J\b\u0010)\u001a\u00020'H\u0016J\u0012\u0010*\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u0016J\u0016\u0010+\u001a\u00020\u00172\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00070\u001eH\u0016J\b\u0010-\u001a\u00020\u0017H\u0002J\u0010\u0010.\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0007H\u0016R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006/"}, d2={"Lcom/intellij/execution/console/PrefixHistoryModel;", "Lcom/intellij/execution/console/ConsoleHistoryBaseModel;", "Lcom/intellij/execution/console/ConsoleHistoryModel;", "masterModel", "Lcom/intellij/execution/console/MasterModel;", "getPrefixFn", "Lkotlin/Function0;", "", "(Lcom/intellij/execution/console/MasterModel;Lkotlin/jvm/functions/Function0;)V", "currentEntries", "", "currentIndex", "", "Ljava/lang/Integer;", "historyPrefix", "prevEntries", "Lgnu/trove/TIntStack;", "userContent", "getUserContent", "()Ljava/lang/String;", "setUserContent", "(Ljava/lang/String;)V", "addToHistory", "", "statement", "createEntry", "Lcom/intellij/execution/console/ConsoleHistoryModel$Entry;", "prevEntry", "getCurrentIndex", "getEntries", "", "kotlin.jvm.PlatformType", "getHistoryNext", "getHistoryPrev", "getHistorySize", "getMaxHistorySize", "getModificationCount", "", "hasHistory", "", "isEmpty", "prevOnLastLine", "removeFromHistory", "resetEntries", "entries", "resetIndex", "setContent", "intellij.platform.lang.impl"})
final class PrefixHistoryModel
implements ConsoleHistoryBaseModel,
ConsoleHistoryModel {
    @NotNull
    private String userContent;
    private Integer currentIndex;
    private List<String> currentEntries;
    private TIntStack prevEntries;
    private String historyPrefix;
    private final MasterModel masterModel;
    private final Function0<String> getPrefixFn;

    @NotNull
    public final String getUserContent() {
        return this.userContent;
    }

    public final void setUserContent(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.userContent = string;
    }

    @Override
    public void setContent(@NotNull String userContent) {
        Intrinsics.checkParameterIsNotNull((Object)userContent, (String)"userContent");
        this.userContent = userContent;
    }

    @Override
    public void resetEntries(@NotNull List<String> entries2) {
        Intrinsics.checkParameterIsNotNull(entries2, (String)"entries");
        this.masterModel.resetEntries(entries2);
        this.resetIndex();
    }

    @Override
    public void addToHistory(@Nullable String statement) {
        PrefixHistoryModelKt.access$assertDispatchThread();
        CharSequence charSequence = statement;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        this.masterModel.addToHistory(statement);
        this.resetIndex();
    }

    @Override
    public void removeFromHistory(@Nullable String statement) {
        PrefixHistoryModelKt.access$assertDispatchThread();
        CharSequence charSequence = statement;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        this.masterModel.removeFromHistory(statement);
        this.resetIndex();
    }

    private final void resetIndex() {
        this.currentIndex = null;
        this.currentEntries = null;
        this.prevEntries.clear();
        this.historyPrefix = "";
    }

    @Override
    @Nullable
    public ConsoleHistoryModel.Entry getHistoryNext() {
        int offset;
        List<String> list2 = this.currentEntries;
        if (list2 == null) {
            list2 = this.masterModel.getEntries();
        }
        List<String> entries2 = list2;
        Integer n = this.currentIndex;
        int n2 = offset = n != null ? n.intValue() : entries2.size();
        if (offset <= 0) {
            return null;
        }
        if (this.currentIndex == null) {
            this.historyPrefix = (String)this.getPrefixFn.invoke();
        }
        Object object = CollectionsKt.withIndex((Iterable)entries2);
        Iterable iterable = object;
        Object var6_6 = null;
        for (Object t : iterable) {
            IndexedValue it = (IndexedValue)t;
            boolean bl = false;
            if (!(it.getIndex() < offset && StringsKt.startsWith$default((String)((String)it.getValue()), (String)this.historyPrefix, (boolean)false, (int)2, null))) continue;
            var6_6 = t;
        }
        IndexedValue indexedValue = var6_6;
        if (indexedValue == null) {
            return null;
        }
        IndexedValue res2 = indexedValue;
        if (this.currentEntries == null) {
            this.currentEntries = entries2;
        }
        Integer n3 = this.currentIndex;
        if (n3 != null) {
            object = n3;
            int it = ((Number)object).intValue();
            boolean bl = false;
            this.prevEntries.push(it);
        }
        this.currentIndex = res2.getIndex();
        return this.createEntry((String)res2.getValue());
    }

    @Override
    @Nullable
    public ConsoleHistoryModel.Entry getHistoryPrev() {
        ConsoleHistoryModel.Entry entry;
        List<String> list2 = this.currentEntries;
        if (list2 == null) {
            return null;
        }
        List<String> entries2 = list2;
        if (this.prevEntries.size() > 0) {
            int index = this.prevEntries.pop();
            this.currentIndex = index;
            entry = this.createEntry(entries2.get(index));
        } else {
            this.resetIndex();
            entry = this.createEntry(this.userContent);
        }
        return entry;
    }

    private final ConsoleHistoryModel.Entry createEntry(String prevEntry) {
        return new ConsoleHistoryModel.Entry(prevEntry, prevEntry.length());
    }

    @Override
    public int getCurrentIndex() {
        Integer n = this.currentIndex;
        return n != null ? n : this.getEntries().size() - 1;
    }

    @Override
    public boolean prevOnLastLine() {
        return true;
    }

    @Override
    public boolean hasHistory() {
        return this.currentEntries != null;
    }

    public PrefixHistoryModel(@NotNull MasterModel masterModel, @NotNull Function0<String> getPrefixFn) {
        Intrinsics.checkParameterIsNotNull((Object)masterModel, (String)"masterModel");
        Intrinsics.checkParameterIsNotNull(getPrefixFn, (String)"getPrefixFn");
        this.masterModel = masterModel;
        this.getPrefixFn = getPrefixFn;
        this.userContent = "";
        this.prevEntries = new TIntStack();
        this.historyPrefix = "";
        this.resetIndex();
    }

    @Override
    @NotNull
    public List<String> getEntries() {
        return this.masterModel.getEntries();
    }

    @Override
    public int getHistorySize() {
        return this.masterModel.getHistorySize();
    }

    @Override
    public int getMaxHistorySize() {
        return this.masterModel.getMaxHistorySize();
    }

    public long getModificationCount() {
        return this.masterModel.getModificationCount();
    }

    @Override
    public boolean isEmpty() {
        return this.masterModel.isEmpty();
    }
}

