/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.util;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.vcs.log.VcsFullCommitDetails;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CommitCompareInfo {
    private static final Logger LOG = Logger.getInstance(CommitCompareInfo.class);
    private final Map<Repository, Pair<List<VcsFullCommitDetails>, List<VcsFullCommitDetails>>> myInfo;
    private final Map<Repository, Collection<Change>> myTotalDiff;
    private final InfoType myInfoType;

    public CommitCompareInfo() {
        this(InfoType.BOTH);
    }

    public CommitCompareInfo(@NotNull InfoType infoType) {
        if (infoType == null) {
            CommitCompareInfo.$$$reportNull$$$0(0);
        }
        this.myInfo = new HashMap<Repository, Pair<List<VcsFullCommitDetails>, List<VcsFullCommitDetails>>>();
        this.myTotalDiff = new HashMap<Repository, Collection<Change>>();
        this.myInfoType = infoType;
    }

    public void put(@NotNull Repository repository, @NotNull List<? extends VcsFullCommitDetails> headToBranch, @NotNull List<? extends VcsFullCommitDetails> branchToHead) {
        if (repository == null) {
            CommitCompareInfo.$$$reportNull$$$0(1);
        }
        if (headToBranch == null) {
            CommitCompareInfo.$$$reportNull$$$0(2);
        }
        if (branchToHead == null) {
            CommitCompareInfo.$$$reportNull$$$0(3);
        }
        this.myInfo.put(repository, (Pair<List<VcsFullCommitDetails>, List<VcsFullCommitDetails>>)Couple.of(headToBranch, branchToHead));
    }

    public void putTotalDiff(@NotNull Repository repository, @NotNull Collection<Change> totalDiff) {
        if (repository == null) {
            CommitCompareInfo.$$$reportNull$$$0(4);
        }
        if (totalDiff == null) {
            CommitCompareInfo.$$$reportNull$$$0(5);
        }
        this.myTotalDiff.put(repository, totalDiff);
    }

    @NotNull
    public List<VcsFullCommitDetails> getHeadToBranchCommits(@NotNull Repository repo) {
        if (repo == null) {
            CommitCompareInfo.$$$reportNull$$$0(6);
        }
        List list2 = (List)this.getCompareInfo(repo).getFirst();
        if (list2 == null) {
            CommitCompareInfo.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @NotNull
    public List<VcsFullCommitDetails> getBranchToHeadCommits(@NotNull Repository repo) {
        if (repo == null) {
            CommitCompareInfo.$$$reportNull$$$0(8);
        }
        List list2 = (List)this.getCompareInfo(repo).getSecond();
        if (list2 == null) {
            CommitCompareInfo.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @NotNull
    private Pair<List<VcsFullCommitDetails>, List<VcsFullCommitDetails>> getCompareInfo(@NotNull Repository repo) {
        Pair<List<VcsFullCommitDetails>, List<VcsFullCommitDetails>> pair;
        if (repo == null) {
            CommitCompareInfo.$$$reportNull$$$0(10);
        }
        if ((pair = this.myInfo.get(repo)) == null) {
            LOG.error("Compare info not found for repository " + repo);
            Pair pair2 = Pair.create(Collections.emptyList(), Collections.emptyList());
            if (pair2 == null) {
                CommitCompareInfo.$$$reportNull$$$0(11);
            }
            return pair2;
        }
        Pair<List<VcsFullCommitDetails>, List<VcsFullCommitDetails>> pair3 = pair;
        if (pair3 == null) {
            CommitCompareInfo.$$$reportNull$$$0(12);
        }
        return pair3;
    }

    @NotNull
    public Collection<Repository> getRepositories() {
        Set<Repository> set2 = this.myInfo.keySet();
        if (set2 == null) {
            CommitCompareInfo.$$$reportNull$$$0(13);
        }
        return set2;
    }

    public boolean isEmpty() {
        return this.myInfo.isEmpty();
    }

    public InfoType getInfoType() {
        return this.myInfoType;
    }

    @NotNull
    public List<Change> getTotalDiff() {
        ArrayList<Change> changes2 = new ArrayList<Change>();
        for (Collection<Change> changeCollection : this.myTotalDiff.values()) {
            changes2.addAll(changeCollection);
        }
        ArrayList<Change> arrayList = changes2;
        if (arrayList == null) {
            CommitCompareInfo.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    protected void updateTotalDiff(@NotNull Map<Repository, Collection<Change>> newDiff) {
        if (newDiff == null) {
            CommitCompareInfo.$$$reportNull$$$0(15);
        }
        this.myTotalDiff.clear();
        this.myTotalDiff.putAll(newDiff);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoType";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headToBranch";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchToHead";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "totalDiff";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repo";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/util/CommitCompareInfo";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDiff";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/util/CommitCompareInfo";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeadToBranchCommits";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchToHeadCommits";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompareInfo";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTotalDiff";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "putTotalDiff";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getHeadToBranchCommits";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBranchToHeadCommits";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCompareInfo";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateTotalDiff";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum InfoType {
        BOTH,
        HEAD_TO_BRANCH,
        BRANCH_TO_HEAD;

    }
}

