/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsLogSingleCommitAction<Repo extends Repository>
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            VcsLogSingleCommitAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLog log2 = (VcsLog)e.getRequiredData(VcsLogDataKeys.VCS_LOG);
        CommitId commit2 = (CommitId)ContainerUtil.getFirstItem((List)log2.getSelectedCommits());
        assert (commit2 != null);
        Repo repository = this.getRepositoryForRoot(project, commit2.getRoot());
        assert (repository != null);
        this.actionPerformed(repository, commit2.getHash());
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            VcsLogSingleCommitAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        VcsLog log2 = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        if (project == null || log2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        List commits = log2.getSelectedCommits();
        if (commits.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        CommitId commit2 = (CommitId)ContainerUtil.getFirstItem((List)commits);
        assert (commit2 != null);
        Repo repository = this.getRepositoryForRoot(project, commit2.getRoot());
        if (repository == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(this.isVisible(project, repository, commit2.getHash()));
        e.getPresentation().setEnabled(commits.size() == 1 && this.isEnabled(repository, commit2.getHash()));
    }

    protected abstract void actionPerformed(@NotNull Repo var1, @NotNull Hash var2);

    protected boolean isEnabled(@NotNull Repo repository, @NotNull Hash commit2) {
        if (repository == null) {
            VcsLogSingleCommitAction.$$$reportNull$$$0(2);
        }
        if (commit2 == null) {
            VcsLogSingleCommitAction.$$$reportNull$$$0(3);
        }
        return true;
    }

    protected boolean isVisible(@NotNull Project project, @NotNull Repo repository, @NotNull Hash hash) {
        if (project == null) {
            VcsLogSingleCommitAction.$$$reportNull$$$0(4);
        }
        if (repository == null) {
            VcsLogSingleCommitAction.$$$reportNull$$$0(5);
        }
        if (hash == null) {
            VcsLogSingleCommitAction.$$$reportNull$$$0(6);
        }
        return !this.getRepositoryManager(project).isExternal(repository);
    }

    @NotNull
    protected abstract AbstractRepositoryManager<Repo> getRepositoryManager(@NotNull Project var1);

    @Nullable
    protected abstract Repo getRepositoryForRoot(@NotNull Project var1, @NotNull VirtualFile var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dvcs/ui/VcsLogSingleCommitAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isVisible";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

