/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.TableView;
import com.intellij.util.Consumer;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitListPanel
extends JPanel
implements TypeSafeDataProvider {
    private final List<VcsFullCommitDetails> myCommits;
    private final TableView<VcsFullCommitDetails> myTable;

    public CommitListPanel(@NotNull List<? extends VcsFullCommitDetails> commits, @Nullable String emptyText) {
        if (commits == null) {
            CommitListPanel.$$$reportNull$$$0(0);
        }
        this.myCommits = new ArrayList<VcsFullCommitDetails>(commits);
        this.myTable = new TableView();
        this.updateModel();
        this.myTable.setSelectionMode(2);
        this.myTable.setStriped(true);
        if (emptyText != null) {
            this.myTable.getEmptyText().setText(emptyText);
        }
        this.setLayout(new BorderLayout());
        this.add(ScrollPaneFactory.createScrollPane(this.myTable));
    }

    public void addListSelectionListener(final @NotNull Consumer<VcsFullCommitDetails> listener2) {
        if (listener2 == null) {
            CommitListPanel.$$$reportNull$$$0(1);
        }
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                int i = lsm.getMaxSelectionIndex();
                int j = lsm.getMinSelectionIndex();
                if (i >= 0 && i == j) {
                    listener2.consume(CommitListPanel.this.myCommits.get(i));
                }
            }
        });
    }

    public void addListMultipleSelectionListener(final @NotNull Consumer<List<Change>> listener2) {
        if (listener2 == null) {
            CommitListPanel.$$$reportNull$$$0(2);
        }
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                List commits = CommitListPanel.this.myTable.getSelectedObjects();
                ArrayList changes2 = new ArrayList();
                ListIterator iterator = commits.listIterator(commits.size());
                while (iterator.hasPrevious()) {
                    changes2.addAll(((VcsFullCommitDetails)iterator.previous()).getChanges());
                }
                listener2.consume(CommittedChangesTreeBrowser.zipChanges(changes2));
            }
        });
    }

    public void registerDiffAction(@NotNull AnAction diffAction) {
        if (diffAction == null) {
            CommitListPanel.$$$reportNull$$$0(3);
        }
        diffAction.registerCustomShortcutSet(diffAction.getShortcutSet(), this.myTable);
    }

    public void calcData(@NotNull DataKey key, @NotNull DataSink sink) {
        if (key == null) {
            CommitListPanel.$$$reportNull$$$0(4);
        }
        if (sink == null) {
            CommitListPanel.$$$reportNull$$$0(5);
        }
        if (VcsDataKeys.CHANGES.equals(key)) {
            int[] rows = this.myTable.getSelectedRows();
            if (rows.length != 1) {
                return;
            }
            int row2 = rows[0];
            VcsFullCommitDetails commit2 = this.myCommits.get(row2);
            sink.put(key, (Object)commit2.getChanges().toArray(new Change[0]));
        }
    }

    @NotNull
    public JComponent getPreferredFocusComponent() {
        TableView<VcsFullCommitDetails> tableView = this.myTable;
        if (tableView == null) {
            CommitListPanel.$$$reportNull$$$0(6);
        }
        return tableView;
    }

    public void clearSelection() {
        this.myTable.clearSelection();
    }

    public void setCommits(@NotNull List<? extends VcsFullCommitDetails> commits) {
        if (commits == null) {
            CommitListPanel.$$$reportNull$$$0(7);
        }
        this.myCommits.clear();
        this.myCommits.addAll(commits);
        this.updateModel();
        this.myTable.repaint();
    }

    private void updateModel() {
        this.myTable.setModelAndUpdateColumns(new ListTableModel(this.generateColumnsInfo(this.myCommits), this.myCommits, 0));
    }

    @NotNull
    private ColumnInfo[] generateColumnsInfo(@NotNull List<? extends VcsFullCommitDetails> commits) {
        if (commits == null) {
            CommitListPanel.$$$reportNull$$$0(8);
        }
        ItemAndWidth hash = new ItemAndWidth("", 0);
        ItemAndWidth author = new ItemAndWidth("", 0);
        ItemAndWidth time = new ItemAndWidth("", 0);
        for (VcsFullCommitDetails vcsFullCommitDetails : commits) {
            hash = this.getMax(hash, CommitListPanel.getHash(vcsFullCommitDetails));
            author = this.getMax(author, CommitListPanel.getAuthor(vcsFullCommitDetails));
            time = this.getMax(time, CommitListPanel.getTime(vcsFullCommitDetails));
        }
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new CommitColumnInfo("Hash", hash.myItem){

            public String valueOf(VcsFullCommitDetails commit2) {
                return CommitListPanel.getHash(commit2);
            }
        }, new ColumnInfo<VcsFullCommitDetails, String>("Subject"){

            public String valueOf(VcsFullCommitDetails commit2) {
                return commit2.getSubject();
            }
        }, new CommitColumnInfo("Author", author.myItem){

            public String valueOf(VcsFullCommitDetails commit2) {
                return CommitListPanel.getAuthor(commit2);
            }
        }, new CommitColumnInfo("Author time", time.myItem){

            public String valueOf(VcsFullCommitDetails commit2) {
                return CommitListPanel.getTime(commit2);
            }
        }};
        if (columnInfoArray == null) {
            CommitListPanel.$$$reportNull$$$0(9);
        }
        return columnInfoArray;
    }

    private ItemAndWidth getMax(ItemAndWidth current, String candidate) {
        int width = this.myTable.getFontMetrics(this.myTable.getFont()).stringWidth(candidate);
        if (width > current.myWidth) {
            return new ItemAndWidth(candidate, width);
        }
        return current;
    }

    private static String getHash(VcsFullCommitDetails commit2) {
        return DvcsUtil.getShortHash(((Hash)commit2.getId()).toString());
    }

    private static String getAuthor(VcsFullCommitDetails commit2) {
        return VcsUserUtil.getShortPresentation(commit2.getAuthor());
    }

    private static String getTime(VcsFullCommitDetails commit2) {
        return DateFormatUtil.formatPrettyDateTime((long)commit2.getAuthorTime());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/ui/CommitListPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/ui/CommitListPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generateColumnsInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addListSelectionListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addListMultipleSelectionListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerDiffAction";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calcData";
                break;
            }
            case 6: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setCommits";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateColumnsInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class CommitColumnInfo
    extends ColumnInfo<VcsFullCommitDetails, String> {
        @NotNull
        private final String myMaxString;

        CommitColumnInfo(@NotNull String name, @NotNull String maxString) {
            if (name == null) {
                CommitColumnInfo.$$$reportNull$$$0(0);
            }
            if (maxString == null) {
                CommitColumnInfo.$$$reportNull$$$0(1);
            }
            super(name);
            this.myMaxString = maxString;
        }

        public String getMaxStringValue() {
            return this.myMaxString;
        }

        public int getAdditionalWidth() {
            return 10;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "maxString";
                    break;
                }
            }
            objectArray[1] = "com/intellij/dvcs/ui/CommitListPanel$CommitColumnInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ItemAndWidth {
        private final String myItem;
        private final int myWidth;

        private ItemAndWidth(String item, int width) {
            this.myItem = item;
            this.myWidth = width;
        }
    }
}

