/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryCreator;
import com.intellij.dvcs.repo.VcsRepositoryMappingListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRepositoryManager
implements Disposable,
VcsListener {
    public static final Topic<VcsRepositoryMappingListener> VCS_REPOSITORY_MAPPING_UPDATED = Topic.create((String)"VCS repository mapping updated", VcsRepositoryMappingListener.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final ReentrantReadWriteLock REPO_LOCK;
    @NotNull
    private final ReentrantReadWriteLock.WriteLock MODIFY_LOCK;
    @NotNull
    private final Map<VirtualFile, Repository> myRepositories;
    @NotNull
    private final Map<VirtualFile, Repository> myExternalRepositories;
    @NotNull
    private final List<VcsRepositoryCreator> myRepositoryCreators;
    private volatile boolean myDisposed;

    @NotNull
    public static VcsRepositoryManager getInstance(@NotNull Project project) {
        if (project == null) {
            VcsRepositoryManager.$$$reportNull$$$0(0);
        }
        VcsRepositoryManager vcsRepositoryManager = (VcsRepositoryManager)ObjectUtils.assertNotNull((Object)project.getComponent(VcsRepositoryManager.class));
        if (vcsRepositoryManager == null) {
            VcsRepositoryManager.$$$reportNull$$$0(1);
        }
        return vcsRepositoryManager;
    }

    public VcsRepositoryManager(@NotNull Project project, @NotNull ProjectLevelVcsManager vcsManager) {
        if (project == null) {
            VcsRepositoryManager.$$$reportNull$$$0(2);
        }
        if (vcsManager == null) {
            VcsRepositoryManager.$$$reportNull$$$0(3);
        }
        this.REPO_LOCK = new ReentrantReadWriteLock();
        this.MODIFY_LOCK = new ReentrantReadWriteLock().writeLock();
        this.myRepositories = ContainerUtil.newHashMap();
        this.myExternalRepositories = ContainerUtil.newHashMap();
        this.myProject = project;
        this.myVcsManager = vcsManager;
        this.myRepositoryCreators = Arrays.asList(VcsRepositoryCreator.EXTENSION_POINT_NAME.getExtensions((AreaInstance)project));
        project.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this);
    }

    public void dispose() {
        this.myDisposed = true;
        try {
            this.REPO_LOCK.writeLock().lock();
            this.myRepositories.clear();
        }
        finally {
            this.REPO_LOCK.writeLock().unlock();
        }
    }

    public void directoryMappingChanged() {
        this.checkAndUpdateRepositoriesCollection(null);
    }

    @Nullable
    public Repository getRepositoryForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VcsRepositoryManager.$$$reportNull$$$0(4);
        }
        return this.getRepositoryForFile(file2, false);
    }

    @Deprecated
    @Nullable
    public Repository getRepositoryForFileQuick(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VcsRepositoryManager.$$$reportNull$$$0(5);
        }
        return this.getRepositoryForFile(file2, true);
    }

    @Nullable
    public Repository getRepositoryForFile(@NotNull VirtualFile file2, boolean quick) {
        VcsRoot vcsRoot;
        if (file2 == null) {
            VcsRepositoryManager.$$$reportNull$$$0(6);
        }
        if ((vcsRoot = this.myVcsManager.getVcsRootObjectFor(file2)) == null) {
            return null;
        }
        return quick ? this.getRepositoryForRootQuick(vcsRoot.getPath()) : this.getRepositoryForRoot(vcsRoot.getPath());
    }

    @Nullable
    public Repository getRepositoryForRootQuick(@Nullable VirtualFile root) {
        return this.getRepositoryForRoot(root, false);
    }

    @Nullable
    public Repository getRepositoryForRoot(@Nullable VirtualFile root) {
        return this.getRepositoryForRoot(root, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Repository getRepositoryForRoot(@Nullable VirtualFile root, boolean updateIfNeeded) {
        Repository result2;
        if (root == null) {
            return null;
        }
        try {
            this.REPO_LOCK.readLock().lock();
            if (this.myDisposed) {
                throw new ProcessCanceledException();
            }
            Repository repo = this.myRepositories.get(root);
            result2 = repo != null ? repo : this.myExternalRepositories.get(root);
        }
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
        if (updateIfNeeded && result2 == null && ArrayUtil.contains((Object)root, (Object[])this.myVcsManager.getAllVersionedRoots())) {
            this.checkAndUpdateRepositoriesCollection(root);
            try {
                this.REPO_LOCK.readLock().lock();
                Repository repository = this.myRepositories.get(root);
                return repository;
            }
            finally {
                this.REPO_LOCK.readLock().unlock();
            }
        }
        return result2;
    }

    public void addExternalRepository(@NotNull VirtualFile root, @NotNull Repository repository) {
        if (root == null) {
            VcsRepositoryManager.$$$reportNull$$$0(7);
        }
        if (repository == null) {
            VcsRepositoryManager.$$$reportNull$$$0(8);
        }
        this.REPO_LOCK.writeLock().lock();
        try {
            this.myExternalRepositories.put(root, repository);
        }
        finally {
            this.REPO_LOCK.writeLock().unlock();
        }
    }

    public void removeExternalRepository(@NotNull VirtualFile root) {
        if (root == null) {
            VcsRepositoryManager.$$$reportNull$$$0(9);
        }
        this.REPO_LOCK.writeLock().lock();
        try {
            this.myExternalRepositories.remove(root);
        }
        finally {
            this.REPO_LOCK.writeLock().unlock();
        }
    }

    public boolean isExternal(@NotNull Repository repository) {
        if (repository == null) {
            VcsRepositoryManager.$$$reportNull$$$0(10);
        }
        try {
            this.REPO_LOCK.readLock().lock();
            boolean bl = !this.myRepositories.containsValue(repository) && this.myExternalRepositories.containsValue(repository);
            return bl;
        }
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
    }

    @NotNull
    public Collection<Repository> getRepositories() {
        this.REPO_LOCK.readLock().lock();
        ArrayList<Repository> arrayList = new ArrayList<Repository>(this.myRepositories.values());
        ArrayList<Repository> arrayList2 = arrayList;
        if (arrayList2 == null) {
            VcsRepositoryManager.$$$reportNull$$$0(11);
        }
        return arrayList2;
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndUpdateRepositoriesCollection(@Nullable VirtualFile checkedRoot) {
        try {
            HashMap repositories;
            this.MODIFY_LOCK.lock();
            try {
                this.REPO_LOCK.readLock().lock();
                if (this.myRepositories.containsKey(checkedRoot)) {
                    return;
                }
                repositories = ContainerUtil.newHashMap(this.myRepositories);
            }
            finally {
                this.REPO_LOCK.readLock().unlock();
            }
            Collection<VirtualFile> invalidRoots = this.findInvalidRoots(repositories.keySet());
            repositories.keySet().removeAll(invalidRoots);
            Map<VirtualFile, Repository> newRoots = this.findNewRoots(repositories.keySet());
            repositories.putAll(newRoots);
            this.REPO_LOCK.writeLock().lock();
            try {
                if (!this.myDisposed) {
                    this.myRepositories.clear();
                    this.myRepositories.putAll(repositories);
                }
            }
            finally {
                this.REPO_LOCK.writeLock().unlock();
            }
            BackgroundTaskUtil.syncPublisher(this.myProject, VCS_REPOSITORY_MAPPING_UPDATED).mappingChanged();
        }
        finally {
            this.MODIFY_LOCK.unlock();
        }
    }

    @NotNull
    private Map<VirtualFile, Repository> findNewRoots(@NotNull Set<VirtualFile> knownRoots) {
        if (knownRoots == null) {
            VcsRepositoryManager.$$$reportNull$$$0(12);
        }
        HashMap newRootsMap = ContainerUtil.newHashMap();
        for (VcsRoot root : this.myVcsManager.getAllVcsRoots()) {
            Repository repository;
            AbstractVcs vcs;
            VcsRepositoryCreator repositoryCreator;
            VirtualFile rootPath = root.getPath();
            if (rootPath == null || knownRoots.contains(rootPath) || (repositoryCreator = this.getRepositoryCreator(vcs = root.getVcs())) == null || (repository = repositoryCreator.createRepositoryIfValid(rootPath)) == null) continue;
            newRootsMap.put(rootPath, repository);
        }
        HashMap hashMap = newRootsMap;
        if (hashMap == null) {
            VcsRepositoryManager.$$$reportNull$$$0(13);
        }
        return hashMap;
    }

    @NotNull
    private Collection<VirtualFile> findInvalidRoots(@NotNull Collection<VirtualFile> roots) {
        if (roots == null) {
            VcsRepositoryManager.$$$reportNull$$$0(14);
        }
        VirtualFile[] validRoots = this.myVcsManager.getAllVersionedRoots();
        List list2 = ContainerUtil.filter(roots, file2 -> !ArrayUtil.contains((Object)file2, (Object[])validRoots));
        if (list2 == null) {
            VcsRepositoryManager.$$$reportNull$$$0(15);
        }
        return list2;
    }

    @Nullable
    private VcsRepositoryCreator getRepositoryCreator(@Nullable AbstractVcs vcs) {
        if (vcs == null) {
            return null;
        }
        return (VcsRepositoryCreator)ContainerUtil.find(this.myRepositoryCreators, creator -> creator.getVcsKey().equals((Object)vcs.getKeyInstanceMethod()));
    }

    @NotNull
    public String toString() {
        String string = "RepositoryManager{myRepositories: " + this.myRepositories + '}';
        if (string == null) {
            VcsRepositoryManager.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/repo/VcsRepositoryManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsManager";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "knownRoots";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/repo/VcsRepositoryManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findNewRoots";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findInvalidRoots";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryForFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryForFileQuick";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addExternalRepository";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeExternalRepository";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isExternal";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findNewRoots";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findInvalidRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

