/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.UtilKt;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DvcsCompareWithBranchAction<T extends Repository>
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VirtualFile file2 = (VirtualFile)ObjectUtils.assertNotNull((Object)UtilKt.getIfSingle((Stream)((Stream)e.getData(VcsDataKeys.VIRTUAL_FILE_STREAM))));
        Repository repository = (Repository)ObjectUtils.assertNotNull(this.getRepositoryManager(project).getRepositoryForFile(file2));
        assert (!repository.isFresh());
        String presentableRevisionName = (String)ObjectUtils.chooseNotNull((Object)repository.getCurrentBranchName(), (Object)DvcsUtil.getShortHash((String)ObjectUtils.assertNotNull((Object)repository.getCurrentRevision())));
        List<String> branchNames = this.getBranchNamesExceptCurrent(repository);
        JBPopupFactory.getInstance().createPopupChooserBuilder(branchNames).setTitle("Select Branch to Compare").setItemChosenCallback(selected -> this.showDiffWithBranchUnderModalProgress(project, file2, presentableRevisionName, (String)selected)).setAutoselectOnMouseMove(true).setNamerForFiltering(o -> o).createPopup().showCenteredInCurrentWindow(project);
    }

    @NotNull
    protected abstract List<String> getBranchNamesExceptCurrent(@NotNull T var1);

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        VirtualFile file2 = (VirtualFile)UtilKt.getIfSingle((Stream)((Stream)e.getData(VcsDataKeys.VIRTUAL_FILE_STREAM)));
        presentation.setVisible(project != null);
        presentation.setEnabled(project != null && file2 != null && this.isEnabled(this.getRepositoryManager(project).getRepositoryForFileQuick(file2)));
    }

    private boolean isEnabled(@Nullable T repository) {
        return repository != null && !repository.isFresh() && !this.noBranchesToCompare(repository);
    }

    @NotNull
    protected abstract AbstractRepositoryManager<T> getRepositoryManager(@NotNull Project var1);

    protected abstract boolean noBranchesToCompare(@NotNull T var1);

    @NotNull
    protected abstract Collection<Change> getDiffChanges(@NotNull Project var1, @NotNull VirtualFile var2, @NotNull String var3) throws VcsException;

    private void showDiffWithBranchUnderModalProgress(final @NotNull Project project, final @NotNull VirtualFile file2, final @NotNull String head, final @NotNull String compare) {
        if (project == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(3);
        }
        if (head == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(4);
        }
        if (compare == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(5);
        }
        new Task.Backgroundable(project, "Collecting Changes...", true){
            private Collection<Change> changes;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    this.changes = DvcsCompareWithBranchAction.this.getDiffChanges(project, file2, compare);
                }
                catch (VcsException e) {
                    VcsNotifier.getInstance(project).notifyImportantWarning("Couldn't compare with branch", String.format("Couldn't compare " + DvcsUtil.fileOrFolder(file2) + " [%s] with branch [%s];\n %s", file2, compare, e.getMessage()));
                }
            }

            public void onSuccess() {
                if (this.changes != null) {
                    VcsDiffUtil.showDiffFor(project, this.changes, VcsDiffUtil.getRevisionTitle(compare, false), VcsDiffUtil.getRevisionTitle(head, true), VcsUtil.getFilePath((VirtualFile)file2));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dvcs/actions/DvcsCompareWithBranchAction$1", "run"));
            }
        }.queue();
    }

    protected static String fileDoesntExistInBranchError(@NotNull VirtualFile file2, @NotNull String branchToCompare) {
        if (file2 == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(6);
        }
        if (branchToCompare == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(7);
        }
        return String.format("%s <code>%s</code> doesn't exist in branch <code>%s</code>", StringUtil.capitalize((String)DvcsUtil.fileOrFolder(file2)), file2.getPresentableUrl(), branchToCompare);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "head";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compare";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchToCompare";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dvcs/actions/DvcsCompareWithBranchAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showDiffWithBranchUnderModalProgress";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "fileDoesntExistInBranchError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

