/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.CommonBundle;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.ErrorReportConfigurable;
import com.intellij.diagnostic.ITNProxy;
import com.intellij.diagnostic.ITNReporter;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.JetBrainsAccountDialogKt;
import com.intellij.diagnostic.ReportMessages;
import com.intellij.errorreport.error.NoSuchEAPUserException;
import com.intellij.errorreport.error.UpdateAvailableException;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.Consumer;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.util.Date;
import java.util.function.IntConsumer;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\u001a<\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u001a2\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u001a:\u0010\u0017\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u001a0\u0010\u0017\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"INTERVAL", "", "previousReport", "Lkotlin/Pair;", "", "onError", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "errorBean", "Lcom/intellij/diagnostic/ITNProxy$ErrorBean;", "callback", "Lcom/intellij/util/Consumer;", "Lcom/intellij/openapi/diagnostic/SubmittedReportInfo;", "parentComponent", "Ljava/awt/Component;", "project", "Lcom/intellij/openapi/project/Project;", "onSuccess", "threadId", "eventData", "", "submit", "credentials", "Lcom/intellij/credentialStore/Credentials;", "", "intellij.platform.ide.impl"})
public final class ITNReporterKt {
    private static final long INTERVAL = 600000L;
    private static volatile Pair<Long, Integer> previousReport;

    private static final boolean submit(ITNProxy.ErrorBean errorBean, Consumer<SubmittedReportInfo> callback2, Component parentComponent, Project project) {
        Credentials credentials = ErrorReportConfigurable.Companion.getCredentials();
        if (CredentialAttributesKt.hasOnlyUserName((Credentials)credentials) && (credentials = JetBrainsAccountDialogKt.askJBAccountCredentials$default(parentComponent, project, false, 4, null)) == null) {
            return false;
        }
        ITNReporterKt.submit(credentials, errorBean, callback2, parentComponent, project);
        return true;
    }

    private static final void submit(Credentials credentials, ITNProxy.ErrorBean errorBean, Consumer<SubmittedReportInfo> callback2, Component parentComponent, Project project) {
        Credentials credentials2 = credentials;
        Credentials credentials3 = credentials;
        ITNProxy.sendError(project, credentials2 != null ? credentials2.getUserName() : null, credentials3 != null ? credentials3.getPasswordAsString() : null, errorBean, new IntConsumer(errorBean, callback2, project){
            final /* synthetic */ ITNProxy.ErrorBean $errorBean;
            final /* synthetic */ Consumer $callback;
            final /* synthetic */ Project $project;

            public final void accept(int threadId) {
                IdeaLoggingEvent ideaLoggingEvent = this.$errorBean.event;
                Intrinsics.checkExpressionValueIsNotNull((Object)ideaLoggingEvent, (String)"errorBean.event");
                ITNReporterKt.access$onSuccess(threadId, ideaLoggingEvent.getData(), this.$callback, this.$project);
            }
            {
                this.$errorBean = errorBean;
                this.$callback = consumer;
                this.$project = project;
            }
        }, new java.util.function.Consumer<Exception>(errorBean, callback2, parentComponent, project){
            final /* synthetic */ ITNProxy.ErrorBean $errorBean;
            final /* synthetic */ Consumer $callback;
            final /* synthetic */ Component $parentComponent;
            final /* synthetic */ Project $project;

            public final void accept(Exception e) {
                Exception exception = e;
                Intrinsics.checkExpressionValueIsNotNull((Object)exception, (String)"e");
                ITNReporterKt.access$onError(exception, this.$errorBean, this.$callback, this.$parentComponent, this.$project);
            }
            {
                this.$errorBean = errorBean;
                this.$callback = consumer;
                this.$parentComponent = component;
                this.$project = project;
            }
        });
    }

    private static final void onSuccess(int threadId, Object eventData, Consumer<SubmittedReportInfo> callback2, Project project) {
        Pair pair;
        if (eventData instanceof AbstractMessage) {
            Date date = ((AbstractMessage)eventData).getDate();
            Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"eventData.date");
            pair = TuplesKt.to((Object)date.getTime(), (Object)threadId);
        } else {
            pair = null;
        }
        previousReport = pair;
        String linkText = String.valueOf(threadId);
        SubmittedReportInfo reportInfo = new SubmittedReportInfo(ITNProxy.getBrowseUrl(threadId), linkText, SubmittedReportInfo.SubmissionStatus.NEW_ISSUE);
        callback2.consume((Object)reportInfo);
        ApplicationManager.getApplication().invokeLater(new Runnable(reportInfo, project){
            final /* synthetic */ SubmittedReportInfo $reportInfo;
            final /* synthetic */ Project $project;

            public final void run() {
                StringBuilder text = new StringBuilder();
                IdeErrorsDialog.appendSubmissionInformation(this.$reportInfo, text);
                text.append('.').append("<br/>").append(DiagnosticBundle.message("error.report.gratitude", new Object[0]));
                String string = XmlStringUtil.wrapInHtml((CharSequence)text);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"XmlStringUtil.wrapInHtml(text)");
                String content = string;
                ReportMessages.GROUP.createNotification(ReportMessages.ERROR_REPORT, content, NotificationType.INFORMATION, NotificationListener.URL_OPENING_LISTENER).setImportant(false).notify(this.$project);
            }
            {
                this.$reportInfo = submittedReportInfo;
                this.$project = project;
            }
        });
    }

    private static final void onError(Exception e, ITNProxy.ErrorBean errorBean, Consumer<SubmittedReportInfo> callback2, Component parentComponent, Project project) {
        Logger.getInstance(ITNReporter.class).info("reporting failed: " + e);
        ApplicationManager.getApplication().invokeLater(new Runnable(e, parentComponent, project, callback2, errorBean){
            final /* synthetic */ Exception $e;
            final /* synthetic */ Component $parentComponent;
            final /* synthetic */ Project $project;
            final /* synthetic */ Consumer $callback;
            final /* synthetic */ ITNProxy.ErrorBean $errorBean;

            public final void run() {
                if (this.$e instanceof UpdateAvailableException) {
                    String message = DiagnosticBundle.message("error.report.new.eap.build.message", this.$e.getMessage());
                    String title = CommonBundle.getWarningTitle();
                    Icon icon = Messages.getWarningIcon();
                    Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"Messages.getWarningIcon()");
                    Icon icon2 = icon;
                    if (this.$parentComponent.isShowing()) {
                        Messages.showMessageDialog((Component)this.$parentComponent, (String)message, (String)title, (Icon)icon2);
                    } else {
                        Messages.showMessageDialog((Project)this.$project, (String)message, (String)title, (Icon)icon2);
                    }
                    this.$callback.consume((Object)new SubmittedReportInfo(SubmittedReportInfo.SubmissionStatus.FAILED));
                } else if (this.$e instanceof NoSuchEAPUserException) {
                    Credentials credentials = JetBrainsAccountDialogKt.askJBAccountCredentials(this.$parentComponent, this.$project, true);
                    if (credentials != null) {
                        ITNReporterKt.access$submit(credentials, this.$errorBean, this.$callback, this.$parentComponent, this.$project);
                    } else {
                        this.$callback.consume((Object)new SubmittedReportInfo(SubmittedReportInfo.SubmissionStatus.FAILED));
                    }
                } else {
                    String message = DiagnosticBundle.message("error.report.posting.failed", this.$e.getMessage());
                    int result2 = ((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)ReportMessages.ERROR_REPORT, (String)message).project(this.$project)).show();
                    if (result2 != 0 || !ITNReporterKt.access$submit(this.$errorBean, this.$callback, this.$parentComponent, this.$project)) {
                        this.$callback.consume((Object)new SubmittedReportInfo(SubmittedReportInfo.SubmissionStatus.FAILED));
                    }
                }
            }
            {
                this.$e = exception;
                this.$parentComponent = component;
                this.$project = project;
                this.$callback = consumer;
                this.$errorBean = errorBean;
            }
        });
    }

    public static final /* synthetic */ Pair access$getPreviousReport$p() {
        return previousReport;
    }

    public static final /* synthetic */ void access$setPreviousReport$p(Pair pair) {
        previousReport = pair;
    }

    public static final /* synthetic */ boolean access$submit(ITNProxy.ErrorBean errorBean, Consumer callback2, Component parentComponent, Project project) {
        return ITNReporterKt.submit(errorBean, (Consumer<SubmittedReportInfo>)callback2, parentComponent, project);
    }

    public static final /* synthetic */ void access$onSuccess(int threadId, Object eventData, Consumer callback2, Project project) {
        ITNReporterKt.onSuccess(threadId, eventData, (Consumer<SubmittedReportInfo>)callback2, project);
    }

    public static final /* synthetic */ void access$onError(Exception e, ITNProxy.ErrorBean errorBean, Consumer callback2, Component parentComponent, Project project) {
        ITNReporterKt.onError(e, errorBean, (Consumer<SubmittedReportInfo>)callback2, parentComponent, project);
    }

    public static final /* synthetic */ void access$submit(Credentials credentials, ITNProxy.ErrorBean errorBean, Consumer callback2, Component parentComponent, Project project) {
        ITNReporterKt.submit(credentials, errorBean, (Consumer<SubmittedReportInfo>)callback2, parentComponent, project);
    }
}

