/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.kdbx.ConstantValueCreator;
import com.intellij.credentialStore.kdbx.DateValueCreator;
import com.intellij.credentialStore.kdbx.UuidValueCreator;
import com.intellij.credentialStore.kdbx.ValueCreator;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.JdomKt;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.SkippingStreamCipher;
import org.bouncycastle.crypto.engines.ChaCha7539Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u001a\u0010\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0002\u001a\b\u0010#\u001a\u00020$H\u0002\u001a\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002\u001a*\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020$2\u0018\u0010,\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0001\u0012\u0004\u0012\u00020\u001f0\u001eH\u0000\u001a%\u0010-\u001a\u0004\u0018\u00010$2\u0006\u0010+\u001a\u00020$2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010/\u001a\u0010\u00100\u001a\n \u0018*\u0004\u0018\u00010\u00020\u0002H\u0000\u001a\u0018\u00101\u001a\u00020*2\u0006\u0010'\u001a\u00020(2\u0006\u00102\u001a\u00020&H\u0002\"\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0005\u001a\u0004\b\u0003\u0010\u0004\"\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0005\u001a\u0004\b\u0007\u0010\u0004\"\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0005\u001a\u0004\b\t\u0010\u0004\"\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0005\u001a\u0004\b\u000b\u0010\u0004\"\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0005\u001a\u0004\b\r\u0010\u0004\"\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0005\u001a\u0004\b\u000f\u0010\u0004\"\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0005\u001a\u0004\b\u0011\u0010\u0004\"\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0005\u001a\u0004\b\u0013\u0010\u0004\"\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0005\u001a\u0004\b\u0015\u0010\u0004\"\"\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\" \u0010\u001d\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0001\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"CREATION_TIME_ELEMENT_NAME", "", "", "getCREATION_TIME_ELEMENT_NAME", "()[Ljava/lang/String;", "[Ljava/lang/String;", "EXPIRES_ELEMENT_NAME", "getEXPIRES_ELEMENT_NAME", "EXPIRY_TIME_ELEMENT_NAME", "getEXPIRY_TIME_ELEMENT_NAME", "ICON_ELEMENT_NAME", "getICON_ELEMENT_NAME", "LAST_ACCESS_TIME_ELEMENT_NAME", "getLAST_ACCESS_TIME_ELEMENT_NAME", "LAST_MODIFICATION_TIME_ELEMENT_NAME", "getLAST_MODIFICATION_TIME_ELEMENT_NAME", "LOCATION_CHANGED", "getLOCATION_CHANGED", "USAGE_COUNT_ELEMENT_NAME", "getUSAGE_COUNT_ELEMENT_NAME", "UUID_ELEMENT_NAME", "getUUID_ELEMENT_NAME", "dateFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getDateFormatter", "()Ljava/time/format/DateTimeFormatter;", "setDateFormatter", "(Ljava/time/format/DateTimeFormatter;)V", "mandatoryEntryElements", "", "Lcom/intellij/credentialStore/kdbx/ValueCreator;", "base64FromUuid", "uuid", "Ljava/util/UUID;", "createEmptyDatabase", "Lorg/jdom/Element;", "createRandomlyInitializedChaCha7539Engine", "Lorg/bouncycastle/crypto/SkippingStreamCipher;", "secureRandom", "Ljava/security/SecureRandom;", "ensureElements", "", "element", "childElements", "findElement", "elementPath", "(Lorg/jdom/Element;[Ljava/lang/String;)Lorg/jdom/Element;", "formattedNow", "initCipherRandomly", "engine", "intellij.platform.credentialStore"})
public final class KeePassDatabaseKt {
    @NotNull
    private static final String[] LOCATION_CHANGED = new String[]{"Times", "LocationChanged"};
    @NotNull
    private static final String[] USAGE_COUNT_ELEMENT_NAME = new String[]{"Times", "UsageCount"};
    @NotNull
    private static final String[] EXPIRES_ELEMENT_NAME = new String[]{"Times", "Expires"};
    @NotNull
    private static final String[] ICON_ELEMENT_NAME = new String[]{"IconID"};
    @NotNull
    private static final String[] UUID_ELEMENT_NAME = new String[]{"UUID"};
    @NotNull
    private static final String[] LAST_MODIFICATION_TIME_ELEMENT_NAME = new String[]{"Times", "LastModificationTime"};
    @NotNull
    private static final String[] CREATION_TIME_ELEMENT_NAME = new String[]{"Times", "CreationTime"};
    @NotNull
    private static final String[] LAST_ACCESS_TIME_ELEMENT_NAME = new String[]{"Times", "LastAccessTime"};
    @NotNull
    private static final String[] EXPIRY_TIME_ELEMENT_NAME = new String[]{"Times", "ExpiryTime"};
    private static DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final Map<String[], ValueCreator> mandatoryEntryElements = MapsKt.linkedMapOf((Pair[])new Pair[]{TuplesKt.to((Object)UUID_ELEMENT_NAME, (Object)new UuidValueCreator()), TuplesKt.to((Object)ICON_ELEMENT_NAME, (Object)new ConstantValueCreator("0")), TuplesKt.to((Object)CREATION_TIME_ELEMENT_NAME, (Object)new DateValueCreator()), TuplesKt.to((Object)LAST_MODIFICATION_TIME_ELEMENT_NAME, (Object)new DateValueCreator()), TuplesKt.to((Object)LAST_ACCESS_TIME_ELEMENT_NAME, (Object)new DateValueCreator()), TuplesKt.to((Object)EXPIRY_TIME_ELEMENT_NAME, (Object)new DateValueCreator()), TuplesKt.to((Object)EXPIRES_ELEMENT_NAME, (Object)new ConstantValueCreator("False")), TuplesKt.to((Object)USAGE_COUNT_ELEMENT_NAME, (Object)new ConstantValueCreator("0")), TuplesKt.to((Object)LOCATION_CHANGED, (Object)new DateValueCreator())});

    @NotNull
    public static final String[] getLOCATION_CHANGED() {
        return LOCATION_CHANGED;
    }

    @NotNull
    public static final String[] getUSAGE_COUNT_ELEMENT_NAME() {
        return USAGE_COUNT_ELEMENT_NAME;
    }

    @NotNull
    public static final String[] getEXPIRES_ELEMENT_NAME() {
        return EXPIRES_ELEMENT_NAME;
    }

    @NotNull
    public static final String[] getICON_ELEMENT_NAME() {
        return ICON_ELEMENT_NAME;
    }

    @NotNull
    public static final String[] getUUID_ELEMENT_NAME() {
        return UUID_ELEMENT_NAME;
    }

    @NotNull
    public static final String[] getLAST_MODIFICATION_TIME_ELEMENT_NAME() {
        return LAST_MODIFICATION_TIME_ELEMENT_NAME;
    }

    @NotNull
    public static final String[] getCREATION_TIME_ELEMENT_NAME() {
        return CREATION_TIME_ELEMENT_NAME;
    }

    @NotNull
    public static final String[] getLAST_ACCESS_TIME_ELEMENT_NAME() {
        return LAST_ACCESS_TIME_ELEMENT_NAME;
    }

    @NotNull
    public static final String[] getEXPIRY_TIME_ELEMENT_NAME() {
        return EXPIRY_TIME_ELEMENT_NAME;
    }

    public static final DateTimeFormatter getDateFormatter() {
        return dateFormatter;
    }

    public static final void setDateFormatter(DateTimeFormatter dateTimeFormatter) {
        dateFormatter = dateTimeFormatter;
    }

    private static final SkippingStreamCipher createRandomlyInitializedChaCha7539Engine(SecureRandom secureRandom2) {
        ChaCha7539Engine engine = new ChaCha7539Engine();
        KeePassDatabaseKt.initCipherRandomly(secureRandom2, (SkippingStreamCipher)engine);
        return (SkippingStreamCipher)engine;
    }

    private static final void initCipherRandomly(SecureRandom secureRandom2, SkippingStreamCipher engine) {
        KeyParameter keyParameter = new KeyParameter(CredentialStoreKt.generateBytes(secureRandom2, 32));
        engine.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)keyParameter, CredentialStoreKt.generateBytes(secureRandom2, 12)));
    }

    public static final void ensureElements(@NotNull Element element, @NotNull Map<String[], ? extends ValueCreator> childElements) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull(childElements, (String)"childElements");
        Map<String[], ? extends ValueCreator> map2 = childElements;
        Iterator<Map.Entry<String[], ? extends ValueCreator>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String[], ? extends ValueCreator> entry;
            Map.Entry<String[], ? extends ValueCreator> entry2 = entry = iterator.next();
            String[] elementPath = entry2.getKey();
            entry2 = entry;
            ValueCreator value = entry2.getValue();
            Element result2 = KeePassDatabaseKt.findElement(element, elementPath);
            if (result2 != null) continue;
            Element currentElement = element;
            for (String elementName : elementPath) {
                currentElement = JdomKt.getOrCreate((Element)currentElement, (String)elementName);
            }
            currentElement.setText(value.getValue());
        }
    }

    private static final Element findElement(Element element, String[] elementPath) {
        Element result2 = element;
        for (String elementName : elementPath) {
            if (result2.getChild(elementName) != null) continue;
            return null;
        }
        return result2;
    }

    public static final String formattedNow() {
        return LocalDateTime.now(ZoneOffset.UTC).format(dateFormatter);
    }

    private static final String base64FromUuid(UUID uuid) {
        ByteBuffer b = ByteBuffer.wrap(new byte[16]);
        b.putLong(uuid.getMostSignificantBits());
        b.putLong(uuid.getLeastSignificantBits());
        String string = Base64.getEncoder().encodeToString(b.array());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Base64.getEncoder().encodeToString(b.array())");
        return string;
    }

    private static final Element createEmptyDatabase() {
        String creationDate = KeePassDatabaseKt.formattedNow();
        Element element = JDOMUtil.load((CharSequence)("<KeePassFile>\n      <Meta>\n        <Generator>IJ</Generator>\n        <HeaderHash></HeaderHash>\n        <DatabaseName>New Database</DatabaseName>\n        <DatabaseNameChanged>" + creationDate + "</DatabaseNameChanged>\n        <DatabaseDescription>Empty Database</DatabaseDescription>\n        <DatabaseDescriptionChanged>" + creationDate + "</DatabaseDescriptionChanged>\n        <DefaultUserName/>\n        <DefaultUserNameChanged>" + creationDate + "</DefaultUserNameChanged>\n        <MaintenanceHistoryDays>365</MaintenanceHistoryDays>\n        <Color/>\n        <MasterKeyChanged>" + creationDate + "</MasterKeyChanged>\n        <MasterKeyChangeRec>-1</MasterKeyChangeRec>\n        <MasterKeyChangeForce>-1</MasterKeyChangeForce>\n        <MemoryProtection>\n            <ProtectTitle>False</ProtectTitle>\n            <ProtectUserName>False</ProtectUserName>\n            <ProtectPassword>True</ProtectPassword>\n            <ProtectURL>False</ProtectURL>\n            <ProtectNotes>False</ProtectNotes>\n        </MemoryProtection>\n        <CustomIcons/>\n        <RecycleBinEnabled>True</RecycleBinEnabled>\n        <RecycleBinUUID>AAAAAAAAAAAAAAAAAAAAAA==</RecycleBinUUID>\n        <RecycleBinChanged>" + creationDate + "</RecycleBinChanged>\n        <EntryTemplatesGroup>AAAAAAAAAAAAAAAAAAAAAA==</EntryTemplatesGroup>\n        <EntryTemplatesGroupChanged>" + creationDate + "</EntryTemplatesGroupChanged>\n        <LastSelectedGroup>AAAAAAAAAAAAAAAAAAAAAA==</LastSelectedGroup>\n        <LastTopVisibleGroup>AAAAAAAAAAAAAAAAAAAAAA==</LastTopVisibleGroup>\n        <HistoryMaxItems>10</HistoryMaxItems>\n        <HistoryMaxSize>6291456</HistoryMaxSize>\n        <Binaries/>\n        <CustomData/>\n      </Meta>\n    </KeePassFile>"));
        Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"JDOMUtil.load(\"\"\"<KeePas\u2026a>\n    </KeePassFile>\"\"\")");
        return element;
    }

    public static final /* synthetic */ void access$initCipherRandomly(SecureRandom secureRandom2, SkippingStreamCipher engine) {
        KeePassDatabaseKt.initCipherRandomly(secureRandom2, engine);
    }

    public static final /* synthetic */ SkippingStreamCipher access$createRandomlyInitializedChaCha7539Engine(SecureRandom secureRandom2) {
        return KeePassDatabaseKt.createRandomlyInitializedChaCha7539Engine(secureRandom2);
    }

    public static final /* synthetic */ Map access$getMandatoryEntryElements$p() {
        return mandatoryEntryElements;
    }

    public static final /* synthetic */ Element access$createEmptyDatabase() {
        return KeePassDatabaseKt.createEmptyDatabase();
    }

    public static final /* synthetic */ String access$base64FromUuid(UUID uuid) {
        return KeePassDatabaseKt.base64FromUuid(uuid);
    }
}

