/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DataStateChanged;
import com.intellij.configurationStore.DataWriter;
import com.intellij.configurationStore.SaveSession;
import com.intellij.configurationStore.SaveSessionBase;
import com.intellij.configurationStore.SaveSessionProducer;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StateMapKt;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.configurationStore.StorageBaseEx;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.TrackingPathMacroSubstitutorImpl;
import com.intellij.configurationStore.XmlDataWriter;
import com.intellij.configurationStore.XmlElementStorageKt;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.impl.stores.FileStorageCoreUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.LargeFileWriteRequestor;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import gnu.trove.THashMap;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001>B=\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00040\u0015H\u0016J \u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001aH\u0014J*\u0010\u001d\u001a\u00020\u00132\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040!H\u0014J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0002H$J\b\u0010%\u001a\u0004\u0018\u00010#J*\u0010&\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0017\u001a\u00020\u00022\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010)\u001a\u00020*J\u0018\u0010+\u001a\u00020*2\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0004H\u0004J\b\u0010,\u001a\u00020\u0002H\u0004J\u0014\u0010-\u001a\u0004\u0018\u00010\u001a2\b\b\u0002\u0010.\u001a\u00020*H\u0002J\n\u0010/\u001a\u0004\u0018\u00010\u001aH$J\u0010\u00100\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u001a\u00101\u001a\u00020\u00132\b\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u000205H\u0014J\u000e\u00106\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001aJ\u001a\u00107\u001a\u00020\u00132\u0006\u00108\u001a\u00020\u00022\b\u00109\u001a\u0004\u0018\u00010\u0002H\u0002J$\u0010:\u001a\u00020\u00132\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010<\u001a\u00020*2\u0006\u0010.\u001a\u00020*J\u001c\u0010=\u001a\u00020\u00132\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010<\u001a\u00020*R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006?"}, d2={"Lcom/intellij/configurationStore/XmlElementStorage;", "Lcom/intellij/configurationStore/StorageBaseEx;", "Lcom/intellij/configurationStore/StateMap;", "fileSpec", "", "rootElementName", "pathMacroSubstitutor", "Lcom/intellij/openapi/components/PathMacroSubstitutor;", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "provider", "Lcom/intellij/configurationStore/StreamProvider;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/components/PathMacroSubstitutor;Lcom/intellij/openapi/components/RoamingType;Lcom/intellij/configurationStore/StreamProvider;)V", "getFileSpec", "()Ljava/lang/String;", "getRoamingType", "()Lcom/intellij/openapi/components/RoamingType;", "getRootElementName", "analyzeExternalChangesAndUpdateIfNeed", "", "componentNames", "", "archiveState", "storageData", "componentName", "serializedState", "Lorg/jdom/Element;", "beforeElementLoaded", "element", "beforeElementSaved", "elements", "", "rootAttributes", "", "createSaveSession", "Lcom/intellij/configurationStore/SaveSessionProducer;", "states", "createSaveSessionProducer", "getSerializedState", "component", "", "archive", "", "hasState", "loadData", "loadElement", "useStreamProvider", "loadLocalData", "loadState", "providerDataStateChanged", "writer", "Lcom/intellij/configurationStore/DataWriter;", "type", "Lcom/intellij/configurationStore/DataStateChanged;", "setDefaultState", "setStates", "oldStorageData", "newStorageData", "updatedFrom", "changedComponentNames", "deleted", "updatedFromStreamProvider", "XmlElementStorageSaveSession", "intellij.platform.configurationStore.impl"})
public abstract class XmlElementStorage
extends StorageBaseEx<StateMap> {
    @NotNull
    private final RoamingType roamingType;
    @NotNull
    private final String fileSpec;
    @Nullable
    private final String rootElementName;
    private final PathMacroSubstitutor pathMacroSubstitutor;
    private final StreamProvider provider;

    @NotNull
    public final RoamingType getRoamingType() {
        return this.roamingType;
    }

    @Nullable
    protected abstract Element loadLocalData();

    @Override
    @Nullable
    public final Element getSerializedState(@NotNull StateMap storageData, @Nullable Object component, @NotNull String componentName, boolean archive) {
        Intrinsics.checkParameterIsNotNull((Object)storageData, (String)"storageData");
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        return storageData.getState(componentName, archive);
    }

    @Override
    public final void archiveState(@NotNull StateMap storageData, @NotNull String componentName, @Nullable Element serializedState) {
        Intrinsics.checkParameterIsNotNull((Object)storageData, (String)"storageData");
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        storageData.archive(componentName, serializedState);
    }

    @Override
    protected final boolean hasState(@NotNull StateMap storageData, @NotNull String componentName) {
        Intrinsics.checkParameterIsNotNull((Object)storageData, (String)"storageData");
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        return storageData.hasState(componentName);
    }

    @Override
    @NotNull
    protected final StateMap loadData() {
        Object object;
        block3: {
            block2: {
                Element element;
                object = XmlElementStorage.loadElement$default(this, false, 1, null);
                if (object == null) break block2;
                Element it = element = object;
                boolean bl = false;
                object = this.loadState(it);
                if (object != null) break block3;
            }
            object = StateMap.Companion.getEMPTY();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final Element loadElement(boolean useStreamProvider) {
        void element;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        try {
            boolean isLoadLocalData = false;
            isLoadLocalData = useStreamProvider && this.provider != null ? !this.provider.read(this.fileSpec, this.roamingType, (Function1)new Function1<InputStream, Unit>(this, (Ref.ObjectRef)element){
                final /* synthetic */ XmlElementStorage this$0;
                final /* synthetic */ Ref.ObjectRef $element;

                public final void invoke(@Nullable InputStream inputStream) {
                    block1: {
                        InputStream inputStream2;
                        InputStream inputStream3 = inputStream;
                        if (inputStream3 == null) break block1;
                        InputStream it = inputStream2 = inputStream3;
                        boolean bl = false;
                        this.$element.element = JDOMUtil.load((InputStream)inputStream);
                        Element element = (Element)this.$element.element;
                        if (element == null) {
                            Intrinsics.throwNpe();
                        }
                        this.this$0.providerDataStateChanged(XmlElementStorageKt.createDataWriterForElement(element, this.this$0.toString()), DataStateChanged.LOADED);
                    }
                }
                {
                    this.this$0 = xmlElementStorage;
                    this.$element = objectRef;
                    super(1);
                }
            }) : true;
            if (isLoadLocalData) {
                element.element = this.loadLocalData();
            }
        }
        catch (FileNotFoundException e) {
            throw (Throwable)e;
        }
        catch (Throwable e) {
            ComponentStoreImplKt.getLOG().error("Cannot load data for " + this.fileSpec, e);
        }
        return (Element)element.element;
    }

    static /* synthetic */ Element loadElement$default(XmlElementStorage xmlElementStorage, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadElement");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return xmlElementStorage.loadElement(bl);
    }

    protected void providerDataStateChanged(@Nullable DataWriter writer, @NotNull DataStateChanged type) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
    }

    private final StateMap loadState(Element element) {
        this.beforeElementLoaded(element);
        Map<String, Element> map2 = FileStorageCoreUtil.load(element, this.pathMacroSubstitutor);
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"FileStorageCoreUtil.load\u2026nt, pathMacroSubstitutor)");
        return StateMap.Companion.fromMap(map2);
    }

    public final void setDefaultState(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        String string = this.rootElementName;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        element.setName(string);
        this.getStorageDataRef().set(this.loadState(element));
    }

    @Nullable
    public final SaveSessionProducer createSaveSessionProducer() {
        return this.checkIsSavingDisabled() ? null : this.createSaveSession((StateMap)StateStorageBase.getStorageData$default(this, false, 1, null));
    }

    @NotNull
    protected abstract SaveSessionProducer createSaveSession(@NotNull StateMap var1);

    public void analyzeExternalChangesAndUpdateIfNeed(@NotNull Set<? super String> componentNames) {
        Intrinsics.checkParameterIsNotNull(componentNames, (String)"componentNames");
        StateMap oldData = (StateMap)this.getStorageDataRef().get();
        StateMap newData = (StateMap)this.getStorageData(true);
        if (oldData == null) {
            Logger $receiver$iv = ComponentStoreImplKt.getLOG();
            Exception e$iv = null;
            boolean $i$f$debug = false;
            if ($receiver$iv.isDebugEnabled()) {
                Logger logger = $receiver$iv;
                boolean bl = false;
                String string = "analyzeExternalChangesAndUpdateIfNeed: old data null, load new for " + this.toString();
                logger.debug(string, (Throwable)e$iv);
            }
            CollectionsKt.addAll((Collection)componentNames, (Object[])newData.keys());
        } else {
            Set changedComponentNames = XmlElementStorageKt.access$getChangedComponentNames(oldData, newData);
            Logger $receiver$iv = ComponentStoreImplKt.getLOG();
            Exception e$iv = null;
            boolean $i$f$debug = false;
            if ($receiver$iv.isDebugEnabled()) {
                Logger logger = $receiver$iv;
                boolean bl = false;
                String string = "analyzeExternalChangesAndUpdateIfNeed: changedComponentNames " + changedComponentNames + " for " + this.toString();
                logger.debug(string, (Throwable)e$iv);
            }
            Collection collection = changedComponentNames;
            if (!collection.isEmpty()) {
                componentNames.addAll(changedComponentNames);
            }
        }
    }

    private final void setStates(StateMap oldStorageData, StateMap newStorageData) {
        if (oldStorageData != newStorageData && this.getStorageDataRef().getAndSet(newStorageData) != oldStorageData) {
            ComponentStoreImplKt.getLOG().warn("Old storage data is not equal to current, new storage data was set anyway");
        }
    }

    protected void beforeElementLoaded(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
    }

    protected void beforeElementSaved(@NotNull List<Element> elements, @NotNull Map<String, String> rootAttributes) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        Intrinsics.checkParameterIsNotNull(rootAttributes, (String)"rootAttributes");
    }

    public final void updatedFromStreamProvider(@NotNull Set<String> changedComponentNames, boolean deleted) {
        Intrinsics.checkParameterIsNotNull(changedComponentNames, (String)"changedComponentNames");
        this.updatedFrom(changedComponentNames, deleted, true);
    }

    public final void updatedFrom(@NotNull Set<String> changedComponentNames, boolean deleted, boolean useStreamProvider) {
        Intrinsics.checkParameterIsNotNull(changedComponentNames, (String)"changedComponentNames");
        if (this.roamingType == RoamingType.DISABLED) {
            return;
        }
        Logger $receiver$iv = ComponentStoreImplKt.getLOG();
        boolean $i$f$runAndLogException = false;
        try {
            boolean bl = false;
            Element newElement = deleted ? null : this.loadElement(useStreamProvider);
            StateMap states = (StateMap)this.getStorageDataRef().get();
            if (newElement == null) {
                if (states != null) {
                    CollectionsKt.addAll((Collection)changedComponentNames, (Object[])states.keys());
                    this.setStates(states, null);
                }
            } else if (states != null) {
                StateMap newStates = this.loadState(newElement);
                changedComponentNames.addAll(XmlElementStorageKt.access$getChangedComponentNames(states, newStates));
                this.setStates(states, newStates);
            }
        }
        catch (ProcessCanceledException e$iv) {
            throw (Throwable)e$iv;
        }
        catch (Throwable e$iv) {
            $receiver$iv.error(e$iv);
        }
    }

    @NotNull
    public final String getFileSpec() {
        return this.fileSpec;
    }

    @Nullable
    protected final String getRootElementName() {
        return this.rootElementName;
    }

    protected XmlElementStorage(@NotNull String fileSpec, @Nullable String rootElementName, @Nullable PathMacroSubstitutor pathMacroSubstitutor, @Nullable RoamingType roamingType, @Nullable StreamProvider provider) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        this.fileSpec = fileSpec;
        this.rootElementName = rootElementName;
        this.pathMacroSubstitutor = pathMacroSubstitutor;
        this.provider = provider;
        RoamingType roamingType2 = roamingType;
        if (roamingType2 == null) {
            roamingType2 = RoamingType.DEFAULT;
        }
        this.roamingType = roamingType2;
    }

    public /* synthetic */ XmlElementStorage(String string, String string2, PathMacroSubstitutor pathMacroSubstitutor, RoamingType roamingType, StreamProvider streamProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            pathMacroSubstitutor = null;
        }
        if ((n & 8) != 0) {
            roamingType = RoamingType.DEFAULT;
        }
        if ((n & 0x10) != 0) {
            streamProvider = null;
        }
        this(string, string2, pathMacroSubstitutor, roamingType, streamProvider);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u001cB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H$J\u001a\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\rH\u0014R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/intellij/configurationStore/XmlElementStorage$XmlElementStorageSaveSession;", "T", "Lcom/intellij/configurationStore/XmlElementStorage;", "Lcom/intellij/configurationStore/SaveSessionBase;", "originalStates", "Lcom/intellij/configurationStore/StateMap;", "storage", "(Lcom/intellij/configurationStore/StateMap;Lcom/intellij/configurationStore/XmlElementStorage;)V", "copiedStates", "", "", "", "newLiveStates", "Lorg/jdom/Element;", "getStorage", "()Lcom/intellij/configurationStore/XmlElementStorage;", "Lcom/intellij/configurationStore/XmlElementStorage;", "createSaveSession", "Lcom/intellij/configurationStore/SaveSession;", "isSaveAllowed", "", "saveLocally", "", "dataWriter", "Lcom/intellij/configurationStore/DataWriter;", "setSerializedState", "componentName", "element", "SaveExecutor", "intellij.platform.configurationStore.impl"})
    public static abstract class XmlElementStorageSaveSession<T extends XmlElementStorage>
    extends SaveSessionBase {
        private Map<String, Object> copiedStates;
        private Map<String, Element> newLiveStates;
        private final StateMap originalStates;
        @NotNull
        private final T storage;

        protected boolean isSaveAllowed() {
            return !((StateStorageBase)this.storage).checkIsSavingDisabled();
        }

        @Nullable
        public final SaveSession createSaveSession() {
            if (this.copiedStates == null || !this.isSaveAllowed()) {
                return null;
            }
            Map<String, Object> map2 = this.copiedStates;
            if (map2 == null) {
                Intrinsics.throwNpe();
            }
            StateMap stateMap = StateMap.Companion.fromMap(map2);
            Map<String, Element> map3 = this.newLiveStates;
            if (map3 == null) {
                throw (Throwable)new IllegalStateException("createSaveSession was already called");
            }
            List elements = XmlElementStorageKt.access$save(stateMap, map3);
            this.newLiveStates = null;
            DataWriter writer = null;
            if (elements == null) {
                writer = null;
            } else {
                PathMacroManager pathMacroManager;
                LinkedHashMap rootAttributes = new LinkedHashMap();
                ((XmlElementStorage)this.storage).beforeElementSaved(elements, rootAttributes);
                if (((XmlElementStorage)this.storage).pathMacroSubstitutor == null) {
                    pathMacroManager = null;
                } else {
                    PathMacroSubstitutor pathMacroSubstitutor = ((XmlElementStorage)this.storage).pathMacroSubstitutor;
                    if (pathMacroSubstitutor == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.TrackingPathMacroSubstitutorImpl");
                    }
                    pathMacroManager = ((TrackingPathMacroSubstitutorImpl)pathMacroSubstitutor).getMacroManager$intellij_platform_configurationStore_impl();
                }
                PathMacroManager macroManager = pathMacroManager;
                writer = new XmlDataWriter(((XmlElementStorage)this.storage).getRootElementName(), elements, rootAttributes, macroManager, this.storage.toString());
            }
            return new SaveExecutor(elements, writer, stateMap);
        }

        @Override
        protected void setSerializedState(@NotNull String componentName, @Nullable Element element) {
            Element normalized;
            Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
            Map<String, Element> map2 = this.newLiveStates;
            if (map2 == null) {
                throw (Throwable)new IllegalStateException("createSaveSession was already called");
            }
            Map<String, Element> newLiveStates = map2;
            Element element2 = element;
            Object object = normalized = element2 != null ? XmlElementStorageKt.normalizeRootName(element2) : null;
            if (this.copiedStates == null) {
                this.copiedStates = StateMapKt.setStateAndCloneIfNeed(componentName, normalized, this.originalStates, newLiveStates);
            } else {
                Map<String, Object> map3 = this.copiedStates;
                if (map3 == null) {
                    Intrinsics.throwNpe();
                }
                StateMapKt.updateState(map3, componentName, normalized, newLiveStates);
            }
        }

        protected abstract void saveLocally(@Nullable DataWriter var1);

        @NotNull
        protected final T getStorage() {
            return this.storage;
        }

        public XmlElementStorageSaveSession(@NotNull StateMap originalStates, @NotNull T storage2) {
            Intrinsics.checkParameterIsNotNull((Object)originalStates, (String)"originalStates");
            Intrinsics.checkParameterIsNotNull(storage2, (String)"storage");
            this.originalStates = originalStates;
            this.storage = storage2;
            this.newLiveStates = (Map)new THashMap();
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B'\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/configurationStore/XmlElementStorage$XmlElementStorageSaveSession$SaveExecutor;", "Lcom/intellij/configurationStore/SaveSession;", "Lcom/intellij/openapi/vfs/SafeWriteRequestor;", "Lcom/intellij/openapi/vfs/LargeFileWriteRequestor;", "elements", "", "Lorg/jdom/Element;", "writer", "Lcom/intellij/configurationStore/DataWriter;", "stateMap", "Lcom/intellij/configurationStore/StateMap;", "(Lcom/intellij/configurationStore/XmlElementStorage$XmlElementStorageSaveSession;Ljava/util/List;Lcom/intellij/configurationStore/DataWriter;Lcom/intellij/configurationStore/StateMap;)V", "save", "", "intellij.platform.configurationStore.impl"})
        private final class SaveExecutor
        implements SaveSession,
        SafeWriteRequestor,
        LargeFileWriteRequestor {
            private final List<Element> elements;
            private final DataWriter writer;
            private final StateMap stateMap;

            public void save() {
                boolean isSavedLocally = false;
                StreamProvider provider = ((XmlElementStorage)XmlElementStorageSaveSession.this.getStorage()).provider;
                if (this.elements == null) {
                    if (provider == null || !provider.delete(((XmlElementStorage)XmlElementStorageSaveSession.this.getStorage()).getFileSpec(), ((XmlElementStorage)XmlElementStorageSaveSession.this.getStorage()).getRoamingType())) {
                        isSavedLocally = true;
                        XmlElementStorageSaveSession.this.saveLocally(this.writer);
                    }
                } else if (provider != null && provider.isApplicable(((XmlElementStorage)XmlElementStorageSaveSession.this.getStorage()).getFileSpec(), ((XmlElementStorage)XmlElementStorageSaveSession.this.getStorage()).getRoamingType())) {
                    String string = ((XmlElementStorage)XmlElementStorageSaveSession.this.getStorage()).getFileSpec();
                    DataWriter dataWriter = this.writer;
                    if (dataWriter == null) {
                        Intrinsics.throwNpe();
                    }
                    provider.write(string, XmlElementStorageKt.toBufferExposingByteArray$default(dataWriter, null, 1, null), ((XmlElementStorage)XmlElementStorageSaveSession.this.getStorage()).getRoamingType());
                } else {
                    isSavedLocally = true;
                    XmlElementStorageSaveSession.this.saveLocally(this.writer);
                }
                if (!isSavedLocally) {
                    ((XmlElementStorage)XmlElementStorageSaveSession.this.getStorage()).providerDataStateChanged(this.writer, DataStateChanged.SAVED);
                }
                ((XmlElementStorage)XmlElementStorageSaveSession.this.getStorage()).setStates(XmlElementStorageSaveSession.this.originalStates, this.stateMap);
            }

            public SaveExecutor(@Nullable List<Element> elements, @NotNull DataWriter writer, StateMap stateMap) {
                Intrinsics.checkParameterIsNotNull((Object)stateMap, (String)"stateMap");
                this.elements = elements;
                this.writer = writer;
                this.stateMap = stateMap;
            }
        }
    }
}

