/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.BinaryXmlOutputterKt;
import com.intellij.configurationStore.DigestOutputStream;
import com.intellij.configurationStore.SchemeManagerIprProvider;
import com.intellij.configurationStore.SchemeNameToFileName;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.project.ProjectKt;
import com.intellij.util.JdomKt;
import com.intellij.util.SmartList;
import com.intellij.util.io.PathKt;
import com.intellij.util.lang.CompoundRuntimeException;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u0006\u0010\u000b\u001a\u00020\f\u001a.\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015\u001a\u0016\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\n\u0010\u0017\u001a\u00020\u0018*\u00020\u000e\u001a\u000e\u0010\u0019\u001a\u00020\u001a*\u0006\u0012\u0002\b\u00030\u0015\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"CURRENT_NAME_CONVERTER", "Lcom/intellij/configurationStore/SchemeNameToFileName;", "getCURRENT_NAME_CONVERTER", "()Lcom/intellij/configurationStore/SchemeNameToFileName;", "MODERN_NAME_CONVERTER", "getMODERN_NAME_CONVERTER", "OLD_NAME_CONVERTER", "getOLD_NAME_CONVERTER", "sha1Provider", "Ljava/security/Provider;", "kotlin.jvm.PlatformType", "createDataDigest", "Ljava/security/MessageDigest;", "unwrapState", "Lorg/jdom/Element;", "element", "project", "Lcom/intellij/openapi/project/Project;", "iprAdapter", "Lcom/intellij/configurationStore/SchemeManagerIprProvider;", "schemeManager", "Lcom/intellij/openapi/options/SchemeManager;", "wrapState", "digest", "", "save", "", "intellij.platform.projectModel.impl"})
public final class Scheme_implKt {
    @NotNull
    private static final SchemeNameToFileName OLD_NAME_CONVERTER = new SchemeNameToFileName(){

        @NotNull
        public String schemeNameToFileName(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            String string = FileUtil.sanitizeFileName((String)name, (boolean)true);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.sanitizeFileName(name, true)");
            return string;
        }
    };
    @NotNull
    private static final SchemeNameToFileName CURRENT_NAME_CONVERTER = new SchemeNameToFileName(){

        @NotNull
        public String schemeNameToFileName(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            String string = FileUtil.sanitizeFileName((String)name, (boolean)false);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.sanitizeFileName(name, false)");
            return string;
        }
    };
    @NotNull
    private static final SchemeNameToFileName MODERN_NAME_CONVERTER = new SchemeNameToFileName(){

        @NotNull
        public String schemeNameToFileName(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return PathKt.sanitizeFileName$default((String)name, null, (boolean)false, (int)6, null);
        }
    };
    private static final Provider sha1Provider = Security.getProvider("SUN");

    @NotNull
    public static final SchemeNameToFileName getOLD_NAME_CONVERTER() {
        return OLD_NAME_CONVERTER;
    }

    @NotNull
    public static final SchemeNameToFileName getCURRENT_NAME_CONVERTER() {
        return CURRENT_NAME_CONVERTER;
    }

    @NotNull
    public static final SchemeNameToFileName getMODERN_NAME_CONVERTER() {
        return MODERN_NAME_CONVERTER;
    }

    @NotNull
    public static final MessageDigest createDataDigest() {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1", sha1Provider);
        Intrinsics.checkExpressionValueIsNotNull((Object)messageDigest, (String)"MessageDigest.getInstance(\"SHA-1\", sha1Provider)");
        return messageDigest;
    }

    @NotNull
    public static final byte[] digest(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        MessageDigest digest = Scheme_implKt.createDataDigest();
        BinaryXmlOutputterKt.serializeElementToBinary($receiver, new DigestOutputStream(digest));
        byte[] byArray = digest.digest();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"digest.digest()");
        return byArray;
    }

    @Nullable
    public static final Element unwrapState(@NotNull Element element, @NotNull Project project, @Nullable SchemeManagerIprProvider iprAdapter, @NotNull SchemeManager<?> schemeManager2) {
        Element data;
        block0: {
            SchemeManagerIprProvider schemeManagerIprProvider;
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull(schemeManager2, (String)"schemeManager");
            data = ProjectKt.isDirectoryBased(project) ? element.getChild("settings") : element;
            SchemeManagerIprProvider schemeManagerIprProvider2 = iprAdapter;
            if (schemeManagerIprProvider2 == null) break block0;
            SchemeManagerIprProvider it = schemeManagerIprProvider = schemeManagerIprProvider2;
            boolean bl = false;
            SchemeManagerIprProvider.load$default(it, data, null, 2, null);
            schemeManager2.reload();
        }
        return data;
    }

    @NotNull
    public static final Element wrapState(@NotNull Element element, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (JdomKt.isEmpty((Element)element) || !ProjectKt.isDirectoryBased(project)) {
            element.setName("state");
            return element;
        }
        Element wrapper2 = new Element("state");
        wrapper2.addContent(element);
        return wrapper2;
    }

    public static final void save(@NotNull SchemeManager<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        SmartList errors = new SmartList();
        $receiver.save((List)errors);
        CompoundRuntimeException.throwIfNotEmpty((List)((List)errors));
    }
}

