/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentInfo;
import com.intellij.configurationStore.ComponentInfoImpl;
import com.intellij.configurationStore.ComponentInfoKt;
import com.intellij.configurationStore.ComponentSerializationUtil;
import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DefaultStateSerializerKt;
import com.intellij.configurationStore.FileStorageAnnotation;
import com.intellij.configurationStore.PersistenceStateAdapter;
import com.intellij.configurationStore.SaveResult;
import com.intellij.configurationStore.SaveSessionProducer;
import com.intellij.configurationStore.SaveSessionProducerManager;
import com.intellij.configurationStore.StateAnnotation;
import com.intellij.configurationStore.StateGetter;
import com.intellij.configurationStore.StateLoadPolicy;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerImplKt;
import com.intellij.configurationStore.StorageBaseExKt;
import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.configurationStore.XmlElementStorage;
import com.intellij.configurationStore.statistic.eventLog.FeatureUsageSettingsEvents;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.async.AppUIExecutorExKt;
import com.intellij.openapi.application.ex.DecodeDefaultsUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageChooserEx;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.components.impl.stores.BatchUpdateListener;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u0002J+\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0010\u00a2\u0006\u0002\b!J#\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001dH\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b&\u0010'J\r\u0010(\u001a\u00020\u0018H\u0010\u00a2\u0006\u0002\b)J\"\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/H\u0002J#\u00100\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0000\u00a2\u0006\u0002\b1J6\u00102\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020/2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-032\u000e\u00104\u001a\n\u0012\u0004\u0012\u000206\u0018\u0001052\u0006\u00107\u001a\u00020\u001dH\u0002J#\u00108\u001a\u00020\u00162\u0006\u00109\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001dH\u00a0@\u00f8\u0001\u0000\u00a2\u0006\u0004\b:\u0010'J\u0019\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\bH\u0000\u00a2\u0006\u0002\b<J7\u0010=\u001a\u0004\u0018\u0001H>\"\b\b\u0000\u0010>*\u00020-2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u001a\u001a\u00020\u00052\f\u0010?\u001a\b\u0012\u0004\u0012\u0002H>0@H\u0002\u00a2\u0006\u0002\u0010AJ\u001a\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00050C2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00050CJ\n\u0010E\u001a\u0004\u0018\u00010FH\u0014J2\u0010G\u001a\b\u0012\u0004\u0012\u00020I0H\"\u0004\b\u0000\u0010>2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H>032\u0006\u0010.\u001a\u00020/2\u0006\u0010J\u001a\u00020KH\u0014J(\u0010L\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u00072\u000e\u00104\u001a\n\u0012\u0004\u0012\u000206\u0018\u0001052\u0006\u00107\u001a\u00020\u001dH\u0002J\u0018\u0010L\u001a\u00020\u00162\u0006\u0010,\u001a\u00020-2\u0006\u0010M\u001a\u00020\u001dH\u0016J\u001a\u0010N\u001a\u0004\u0018\u00010\u00052\u0006\u0010,\u001a\u00020O2\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0018\u0010P\u001a\u00020\u00162\u0006\u0010,\u001a\u00020-2\u0006\u0010Q\u001a\u00020\u0005H\u0016J$\u0010R\u001a\u00020\u00052\n\u0010,\u001a\u0006\u0012\u0002\b\u0003032\u0006\u0010.\u001a\u00020/2\u0006\u0010M\u001a\u00020\u001dH\u0002J\u0010\u0010S\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u0005H\u0002J\u0014\u0010T\u001a\u00020\u001d2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u000505J\u0010\u0010U\u001a\u00020\u001d2\u0006\u0010V\u001a\u000206H\u0014J\u0018\u0010W\u001a\u00020\u001d2\u0006\u0010V\u001a\u0002062\u0006\u0010+\u001a\u00020\u0005H\u0002J4\u0010X\u001a\u00020\u00162\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u0005052\u000e\b\u0002\u00104\u001a\b\u0012\u0004\u0012\u000206052\u000e\b\u0002\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00050CJ\u001c\u0010Z\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010C2\f\u00104\u001a\b\u0012\u0004\u0012\u00020605J\u001a\u0010[\u001a\u00020\u00162\u0012\u0010\\\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u0003030@J\u001e\u0010[\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u00052\f\u00104\u001a\b\u0012\u0004\u0012\u00020605H\u0002J\u001c\u0010]\u001a\u00020\u00162\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u0005052\u0006\u0010^\u001a\u00020_J\u000e\u0010`\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u0005J\u0019\u0010a\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u001dH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010bJ\u0014\u0010c\u001a\u00020\u00162\n\u0010,\u001a\u0006\u0012\u0002\b\u000303H\u0016J\b\u0010d\u001a\u00020\u0005H\u0016RN\u0010\u0003\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006e"}, d2={"Lcom/intellij/configurationStore/ComponentStoreImpl;", "Lcom/intellij/openapi/components/impl/stores/IComponentStore;", "()V", "components", "", "", "kotlin.jvm.PlatformType", "Lcom/intellij/configurationStore/ComponentInfo;", "", "loadPolicy", "Lcom/intellij/configurationStore/StateLoadPolicy;", "getLoadPolicy", "()Lcom/intellij/configurationStore/StateLoadPolicy;", "project", "Lcom/intellij/openapi/project/Project;", "getProject$intellij_platform_configurationStore_impl", "()Lcom/intellij/openapi/project/Project;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManager;", "getStorageManager", "()Lcom/intellij/configurationStore/StateStorageManager;", "commitComponent", "", "session", "Lcom/intellij/configurationStore/SaveSessionProducerManager;", "info", "componentName", "commitComponents", "isForce", "", "errors", "", "", "commitComponents$intellij_platform_configurationStore_impl", "createSaveSessionManagerAndSaveComponents", "saveResult", "Lcom/intellij/configurationStore/SaveResult;", "isForceSavingAllSettings", "createSaveSessionManagerAndSaveComponents$intellij_platform_configurationStore_impl", "(Lcom/intellij/configurationStore/SaveResult;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createSaveSessionProducerManager", "createSaveSessionProducerManager$intellij_platform_configurationStore_impl", "doAddComponent", "name", "component", "", "stateSpec", "Lcom/intellij/openapi/components/State;", "doCreateSaveSessionManagerAndCommitComponents", "doCreateSaveSessionManagerAndCommitComponents$intellij_platform_configurationStore_impl", "doInitComponent", "Lcom/intellij/openapi/components/PersistentStateComponent;", "changedStorages", "", "Lcom/intellij/openapi/components/StateStorage;", "reloadData", "doSave", "result", "doSave$intellij_platform_configurationStore_impl", "getComponents", "getComponents$intellij_platform_configurationStore_impl", "getDefaultState", "T", "stateClass", "Ljava/lang/Class;", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "getNotReloadableComponents", "", "componentNames", "getPathMacroManagerForDefaults", "Lcom/intellij/openapi/components/PathMacroManager;", "getStorageSpecs", "", "Lcom/intellij/openapi/components/Storage;", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "initComponent", "isService", "initJdomExternalizable", "Lcom/intellij/openapi/util/JDOMExternalizable;", "initPersistencePlainComponent", "key", "initPersistenceStateComponent", "isNotReloadable", "isReloadPossible", "isUseLoadedStateAsExisting", "storage", "isUseLoadedStateAsExistingForComponent", "reinitComponents", "notReloadableComponents", "reload", "reloadState", "componentClass", "reloadStates", "messageBus", "Lcom/intellij/util/messages/MessageBus;", "removeComponent", "save", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveComponent", "toString", "intellij.platform.configurationStore.impl"})
public abstract class ComponentStoreImpl
implements IComponentStore {
    private final Map<String, ComponentInfo> components = Collections.synchronizedMap((Map)new THashMap());

    @Nullable
    public Project getProject$intellij_platform_configurationStore_impl() {
        return null;
    }

    @NotNull
    public StateLoadPolicy getLoadPolicy() {
        return StateLoadPolicy.LOAD;
    }

    @Override
    @NotNull
    public abstract StateStorageManager getStorageManager();

    @NotNull
    public final Map<String, ComponentInfo> getComponents$intellij_platform_configurationStore_impl() {
        Map<String, ComponentInfo> map2 = this.components;
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"components");
        return map2;
    }

    @Override
    public void initComponent(@NotNull Object component, boolean isService) {
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        String componentName = "";
        try {
            if (component instanceof PersistentStateComponent) {
                componentName = this.initPersistenceStateComponent((PersistentStateComponent)component, StoreUtilKt.getStateSpec((PersistentStateComponent)component), isService);
            } else if (component instanceof JDOMExternalizable) {
                String string = ComponentManagerImpl.getComponentName(component);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ComponentManagerImpl.getComponentName(component)");
                componentName = string;
                this.initJdomExternalizable((JDOMExternalizable)component, componentName);
            }
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            PluginException.logPluginError((Logger)ComponentStoreImplKt.getLOG(), (String)("Cannot init " + componentName + " component state"), (Throwable)e, component.getClass());
        }
    }

    @Override
    public void initPersistencePlainComponent(@NotNull Object component, @NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.initPersistenceStateComponent(new PersistenceStateAdapter(component), new StateAnnotation(key, new FileStorageAnnotation("$WORKSPACE_FILE$", false)), false);
    }

    private final String initPersistenceStateComponent(PersistentStateComponent<?> component, State stateSpec, boolean isService) {
        String componentName;
        block2: {
            componentName = stateSpec.name();
            ComponentInfo info = this.doAddComponent(componentName, component, stateSpec);
            if (!this.initComponent(info, null, false) || !isService) break block2;
            Project project = this.getProject$intellij_platform_configurationStore_impl();
            if (project != null) {
                Application app;
                Project project2;
                Project it = project2 = project;
                boolean bl = false;
                Application application = app = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
                if (!application.isHeadlessEnvironment() && !app.isUnitTestMode() && it.isInitialized()) {
                    ComponentStoreImplKt.access$notifyUnknownMacros(this, it, componentName);
                }
            }
        }
        return componentName;
    }

    @Override
    @Nullable
    public Object save(boolean bl, @NotNull Continuation<? super Unit> continuation) {
        return ComponentStoreImpl.save$suspendImpl(this, bl, continuation);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object save$suspendImpl(ComponentStoreImpl this, boolean isForceSavingAllSettings, Continuation var2_2) {
        if (!(var2_2 instanceof save.1)) ** GOTO lbl-1000
        var5_3 = var2_2;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ ComponentStoreImpl this$0;
                Object L$0;
                Object L$1;
                boolean Z$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object result2) {
                    this.result = result2;
                    this.label |= Integer.MIN_VALUE;
                    return ComponentStoreImpl.save$suspendImpl(this.this$0, false, (Continuation)this);
                }
                {
                    this.this$0 = componentStoreImpl;
                    super(continuation);
                }
            };
        }
        var4_4 = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                v0 = var4_4;
                if (v0 instanceof Result.Failure) {
                    throw ((Result.Failure)v0).exception;
                }
                result = new SaveResult();
                $continuation.L$0 = this;
                $continuation.Z$0 = isForceSavingAllSettings;
                $continuation.L$1 = result;
                $continuation.label = 1;
                v1 = this.doSave$intellij_platform_configurationStore_impl(result, isForceSavingAllSettings, (Continuation<? super Unit>)$continuation);
                if (v1 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl31
            }
            case 1: {
                result = (SaveResult)$continuation.L$1;
                isForceSavingAllSettings = $continuation.Z$0;
                this = (ComponentStoreImpl)$continuation.L$0;
                v2 = var4_4;
                if (v2 instanceof Result.Failure) {
                    throw ((Result.Failure)v2).exception;
                }
                v1 = var4_4;
lbl31:
                // 2 sources

                result.throwIfErrored();
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public abstract Object doSave$intellij_platform_configurationStore_impl(@NotNull SaveResult var1, boolean var2, @NotNull Continuation<? super Unit> var3);

    @Nullable
    public final Object createSaveSessionManagerAndSaveComponents$intellij_platform_configurationStore_impl(@NotNull SaveResult saveResult2, boolean isForceSavingAllSettings, @NotNull Continuation<? super SaveSessionProducerManager> continuation) {
        AppUIExecutor uiExecutor;
        block0: {
            ComponentManager componentManager;
            AppUIExecutor appUIExecutor = AppUIExecutor.onUiThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)appUIExecutor, (String)"AppUIExecutor.onUiThread()");
            uiExecutor = appUIExecutor;
            ComponentManager componentManager2 = this.getStorageManager().getComponentManager();
            if (componentManager2 == null) break block0;
            ComponentManager it = componentManager = componentManager2;
            boolean bl = false;
            uiExecutor.inTransaction((Disposable)it);
        }
        return BuildersKt.withContext((CoroutineContext)AppUIExecutorExKt.coroutineDispatchingContext(uiExecutor), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SaveSessionProducerManager>, Object>(this, isForceSavingAllSettings, saveResult2, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ ComponentStoreImpl this$0;
            final /* synthetic */ boolean $isForceSavingAllSettings;
            final /* synthetic */ SaveResult $saveResult;

            @Nullable
            public final Object invokeSuspend(@NotNull Object result2) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object object2 = result2;
                        if (object2 instanceof Result.Failure) {
                            throw ((Result.Failure)object2).exception;
                        }
                        CoroutineScope coroutineScope = this.p$;
                        SmartList errors = new SmartList();
                        SaveSessionProducerManager manager = this.this$0.doCreateSaveSessionManagerAndCommitComponents$intellij_platform_configurationStore_impl(this.$isForceSavingAllSettings, (List)errors);
                        this.$saveResult.addErrors((List)errors);
                        return manager;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = componentStoreImpl;
                this.$isForceSavingAllSettings = bl;
                this.$saveResult = saveResult2;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super SaveSessionProducerManager>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), continuation);
    }

    @NotNull
    public final SaveSessionProducerManager doCreateSaveSessionManagerAndCommitComponents$intellij_platform_configurationStore_impl(boolean isForce, @NotNull List<Throwable> errors) {
        Intrinsics.checkParameterIsNotNull(errors, (String)"errors");
        SaveSessionProducerManager saveManager = this.createSaveSessionProducerManager$intellij_platform_configurationStore_impl();
        this.commitComponents$intellij_platform_configurationStore_impl(isForce, saveManager, errors);
        return saveManager;
    }

    public void commitComponents$intellij_platform_configurationStore_impl(boolean isForce, @NotNull SaveSessionProducerManager session2, @NotNull List<Throwable> errors) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull(errors, (String)"errors");
        if (this.components.isEmpty()) {
            return;
        }
        boolean isUseModificationCount = Registry.is((String)"store.save.use.modificationCount", (boolean)true);
        Object[] objectArray = ArrayUtilRt.toStringArray((Collection)this.components.keySet());
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"ArrayUtilRt.toStringArray(components.keys)");
        Object[] names = objectArray;
        Arrays.sort(names);
        StringBuilder timeLog = null;
        int nowInSeconds = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        for (Object name : names) {
            long start2 = System.currentTimeMillis();
            try {
                String string;
                Logger logger;
                boolean $i$f$debug;
                Exception e$iv;
                Logger $receiver$iv;
                ComponentInfo info;
                if (this.components.get(name) == null) {
                    Intrinsics.throwNpe();
                }
                long currentModificationCount = -1L;
                if (info.isModificationTrackingSupported() && (currentModificationCount = info.getCurrentModificationCount()) == info.getLastModificationCount()) {
                    $receiver$iv = ComponentStoreImplKt.getLOG();
                    e$iv = null;
                    $i$f$debug = false;
                    if ($receiver$iv.isDebugEnabled()) {
                        logger = $receiver$iv;
                        boolean bl = false;
                        string = (isUseModificationCount ? "Skip " : "") + (String)name + ": modificationCount " + currentModificationCount + " equals to last saved";
                        logger.debug(string, (Throwable)e$iv);
                    }
                    if (isUseModificationCount) continue;
                }
                if (info.getLastSaved() != -1) {
                    if (isForce || nowInSeconds - info.getLastSaved() > ComponentStoreImplKt.access$getNOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD$p()) {
                        info.setLastSaved(nowInSeconds);
                    } else {
                        $receiver$iv = ComponentStoreImplKt.getLOG();
                        e$iv = null;
                        $i$f$debug = false;
                        if (!$receiver$iv.isDebugEnabled()) continue;
                        logger = $receiver$iv;
                        boolean bl = false;
                        string = "Skip " + (String)name + ": was already saved in last " + TimeUnit.SECONDS.toMinutes(ComponentStoreImplKt.access$getNOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD_DEFAULT$p()) + " minutes (lastSaved " + info.getLastSaved() + ", now: " + nowInSeconds + ')';
                        logger.debug(string, (Throwable)e$iv);
                        continue;
                    }
                }
                this.commitComponent(session2, info, (String)name);
                info.updateModificationCount(currentModificationCount);
            }
            catch (Throwable e) {
                errors.add(new Exception("Cannot get " + (String)name + " component state", e));
            }
            long duration = System.currentTimeMillis() - start2;
            if (duration <= (long)10) continue;
            if (timeLog == null) {
                timeLog = new StringBuilder("Saving " + this.toString());
            } else {
                timeLog.append(", ");
            }
            timeLog.append((String)name).append(" took ").append(duration).append(" ms");
        }
        if (timeLog != null) {
            ComponentStoreImplKt.getLOG().info(timeLog.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveComponent(@NotNull PersistentStateComponent<?> component) {
        Intrinsics.checkParameterIsNotNull(component, (String)"component");
        State stateSpec = StoreUtilKt.getStateSpec(component);
        ComponentStoreImplKt.getLOG().info("saveComponent is called for " + stateSpec.name());
        SaveSessionProducerManager saveManager = this.createSaveSessionProducerManager$intellij_platform_configurationStore_impl();
        this.commitComponent(saveManager, new ComponentInfoImpl(component, stateSpec), null);
        String absolutePath = ((Object)Paths.get(this.getStorageManager().expandMacros(StateStorageManagerImplKt.getPath(ComponentStoreImplKt.access$findNonDeprecated(stateSpec.storages()))), new String[0]).toAbsolutePath()).toString();
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkExpressionValueIsNotNull((Object)disposable, (String)"Disposer.newDisposable()");
        Disposable newDisposable = disposable;
        try {
            VfsRootAccess.allowRootAccess(newDisposable, absolutePath);
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(saveManager, stateSpec, null){
                private CoroutineScope p$;
                int label;
                final /* synthetic */ SaveSessionProducerManager $saveManager;
                final /* synthetic */ State $stateSpec;

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object result) {
                    var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            v0 = result;
                            if (v0 instanceof Result.Failure) {
                                throw ((Result.Failure)v0).exception;
                            }
                            var2_3 = this.p$;
                            this.label = 1;
                            v1 = this.$saveManager.save((Continuation<? super SaveResult>)this);
                            if (v1 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl18
                        }
                        case 1: {
                            v2 = result;
                            if (v2 instanceof Result.Failure) {
                                throw ((Result.Failure)v2).exception;
                            }
                            v1 = result;
lbl18:
                            // 2 sources

                            saveResult = (SaveResult)v1;
                            saveResult.throwIfErrored();
                            isSomethingChanged = saveResult.isChanged();
                            if (!isSomethingChanged) {
                                ComponentStoreImplKt.getLOG().info("saveApplicationComponent is called for " + this.$stateSpec.name() + " but nothing to save");
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$saveManager = saveSessionProducerManager;
                    this.$stateSpec = state;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }
        finally {
            Disposer.dispose((Disposable)newDisposable);
        }
    }

    @NotNull
    public SaveSessionProducerManager createSaveSessionProducerManager$intellij_platform_configurationStore_impl() {
        return new SaveSessionProducerManager();
    }

    private final void commitComponent(SaveSessionProducerManager session2, ComponentInfo info, String componentName) {
        Object object;
        String effectiveComponentName;
        Object component = info.getComponent();
        if (component instanceof JDOMExternalizable) {
            String string = componentName;
            if (string == null) {
                String string2 = ComponentManagerImpl.getComponentName(component);
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ComponentManagerImpl.getComponentName(component)");
            }
            String effectiveComponentName2 = string;
            StateStorage stateStorage = this.getStorageManager().getOldStorage(component, effectiveComponentName2, StateStorageOperation.WRITE);
            if (stateStorage != null) {
                StateStorage stateStorage2;
                StateStorage it = stateStorage2 = stateStorage;
                boolean bl = false;
                SaveSessionProducer saveSessionProducer = session2.getProducer(it);
                if (saveSessionProducer != null) {
                    saveSessionProducer.setState(component, effectiveComponentName2, component);
                }
            }
            return;
        }
        Object object2 = component;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.components.PersistentStateComponent<*>");
        }
        Object object3 = ((PersistentStateComponent)object2).getState();
        if (object3 == null) {
            return;
        }
        Object state = object3;
        State state2 = info.getStateSpec();
        if (state2 == null) {
            Intrinsics.throwNpe();
        }
        State stateSpec = state2;
        String string = componentName;
        if (string == null) {
            string = effectiveComponentName = stateSpec.name();
        }
        if (!((object = component) instanceof StateStorageChooserEx)) {
            object = null;
        }
        StateStorageChooserEx stateStorageChooser = (StateStorageChooserEx)object;
        List<Storage> storageSpecs = this.getStorageSpecs((PersistentStateComponent)component, stateSpec, StateStorageOperation.WRITE);
        for (Storage storageSpec : storageSpecs) {
            StateStorageChooserEx.Resolution resolution;
            if (stateStorageChooser == null) {
                resolution = StateStorageChooserEx.Resolution.DO;
            } else {
                StateStorageChooserEx.Resolution resolution2 = stateStorageChooser.getResolution(storageSpec, StateStorageOperation.WRITE);
                resolution = resolution2;
                Intrinsics.checkExpressionValueIsNotNull((Object)resolution2, (String)"stateStorageChooser.getR\u2026teStorageOperation.WRITE)");
            }
            StateStorageChooserEx.Resolution resolution3 = resolution;
            if (resolution3 == StateStorageChooserEx.Resolution.SKIP) continue;
            StateStorage storage2 = this.getStorageManager().getStateStorage(storageSpec);
            if (resolution3 == StateStorageChooserEx.Resolution.DO && (resolution3 = storage2.getResolution((PersistentStateComponent)component, StateStorageOperation.WRITE)) == StateStorageChooserEx.Resolution.SKIP) continue;
            SaveSessionProducer saveSessionProducer = session2.getProducer(storage2);
            if (saveSessionProducer == null) continue;
            saveSessionProducer.setState(component, effectiveComponentName, storageSpec.deprecated() || resolution3 == StateStorageChooserEx.Resolution.CLEAR ? null : state);
        }
    }

    private final String initJdomExternalizable(JDOMExternalizable component, String componentName) {
        StateStorage stateStorage;
        this.doAddComponent(componentName, component, null);
        if (this.getLoadPolicy() != StateLoadPolicy.LOAD) {
            return null;
        }
        try {
            Element element = this.getDefaultState(component, componentName, Element.class);
            if (element != null) {
                Element element2;
                Element it = element2 = element;
                boolean bl = false;
                component.readExternal(it);
            }
        }
        catch (Throwable e) {
            ComponentStoreImplKt.getLOG().error(e);
        }
        if ((stateStorage = this.getStorageManager().getOldStorage(component, componentName, StateStorageOperation.READ)) == null || (stateStorage = (Element)stateStorage.getState((Object)component, componentName, Element.class, null, false)) == null) {
            return null;
        }
        StateStorage element = stateStorage;
        try {
            component.readExternal((Element)element);
        }
        catch (InvalidDataException e) {
            ComponentStoreImplKt.getLOG().error((Throwable)e);
            return null;
        }
        return componentName;
    }

    private final ComponentInfo doAddComponent(String name, Object component, State stateSpec) {
        ComponentInfo newInfo = ComponentInfoKt.createComponentInfo(component, stateSpec);
        ComponentInfo existing = this.components.put(name, newInfo);
        if (existing != null && existing.getComponent() != component) {
            this.components.put(name, existing);
            ComponentStoreImplKt.getLOG().error("Conflicting component name '" + name + "': " + existing.getComponent().getClass() + " and " + component.getClass());
            return existing;
        }
        return newInfo;
    }

    private final boolean initComponent(ComponentInfo info, Set<? extends StateStorage> changedStorages, boolean reloadData) {
        if (this.getLoadPolicy() == StateLoadPolicy.NOT_LOAD) {
            return false;
        }
        State state = info.getStateSpec();
        if (state == null) {
            Intrinsics.throwNpe();
        }
        Object object = info.getComponent();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.components.PersistentStateComponent<kotlin.Any>");
        }
        if (this.doInitComponent(state, (PersistentStateComponent<Object>)((PersistentStateComponent)object), changedStorages, reloadData)) {
            ComponentInfo.updateModificationCount$default(info, 0L, 1, null);
            return true;
        }
        return false;
    }

    private final boolean doInitComponent(State stateSpec, PersistentStateComponent<Object> component, Set<? extends StateStorage> changedStorages, boolean reloadData) {
        Object defaultState;
        Class<?> clazz;
        String name = stateSpec.name();
        if (component instanceof PersistenceStateAdapter) {
            clazz = ((PersistenceStateAdapter)component).getComponent().getClass();
            if (clazz == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<kotlin.Any>");
            }
        } else {
            Class<?> clazz2 = ComponentSerializationUtil.getStateClass(component.getClass());
            clazz = clazz2;
            Intrinsics.checkExpressionValueIsNotNull(clazz2, (String)"ComponentSerializationUt\u2026Any>(component.javaClass)");
        }
        Class<?> stateClass = clazz;
        if (!stateSpec.defaultStateAsResource() && ComponentStoreImplKt.getLOG().isDebugEnabled() && this.getDefaultState(component, name, stateClass) != null) {
            ComponentStoreImplKt.getLOG().error(name + " has default state, but not marked to load it");
        }
        Object s = defaultState = stateSpec.defaultStateAsResource() ? (Object)this.getDefaultState(component, name, stateClass) : null;
        if (this.getLoadPolicy() == StateLoadPolicy.LOAD) {
            PersistentStateComponent<Object> persistentStateComponent = component;
            if (!(persistentStateComponent instanceof StateStorageChooserEx)) {
                persistentStateComponent = null;
            }
            StateStorageChooserEx storageChooser = (StateStorageChooserEx)persistentStateComponent;
            for (Storage storageSpec : this.getStorageSpecs(component, stateSpec, StateStorageOperation.READ)) {
                StateStorageChooserEx stateStorageChooserEx = storageChooser;
                if ((stateStorageChooserEx != null ? stateStorageChooserEx.getResolution(storageSpec, StateStorageOperation.READ) : null) == StateStorageChooserEx.Resolution.SKIP) continue;
                StateStorage storage2 = this.getStorageManager().getStateStorage(storageSpec);
                StateGetter<Object> stateGetter = StorageBaseExKt.createStateGetter(stateSpec.useLoadedStateAsExisting() && this.isUseLoadedStateAsExistingForComponent(storage2, name), storage2, component, name, stateClass, reloadData);
                Object state = stateGetter.getState(defaultState);
                if (state == null) {
                    if (changedStorages != null && changedStorages.contains(storage2)) {
                        Object v5 = DefaultStateSerializerKt.deserializeState(new Element("state"), stateClass, null);
                        if (v5 == null) {
                            Intrinsics.throwNpe();
                        }
                        state = v5;
                    } else {
                        FeatureUsageSettingsEvents.INSTANCE.logDefaultConfigurationState(name, stateSpec, stateClass, this.getProject$intellij_platform_configurationStore_impl());
                        continue;
                    }
                }
                component.loadState(state);
                Object stateAfterLoad = stateGetter.archiveState();
                Logger $receiver$iv = ComponentStoreImplKt.getLOG();
                boolean $i$f$runAndLogException = false;
                try {
                    boolean bl = false;
                    Object object = stateAfterLoad;
                    if (object == null) {
                        object = state;
                    }
                    FeatureUsageSettingsEvents.INSTANCE.logConfigurationState(name, stateSpec, object, this.getProject$intellij_platform_configurationStore_impl());
                }
                catch (ProcessCanceledException e$iv) {
                    throw (Throwable)e$iv;
                }
                catch (Throwable e$iv) {
                    $receiver$iv.error(e$iv);
                }
                return true;
            }
        }
        if (defaultState == null) {
            component.noStateLoaded();
        } else {
            component.loadState(defaultState);
        }
        return true;
    }

    private final boolean isUseLoadedStateAsExistingForComponent(StateStorage storage2, String name) {
        return this.isUseLoadedStateAsExisting(storage2) && Intrinsics.areEqual((Object)name, (Object)"ProjectModuleManager") ^ true && Intrinsics.areEqual((Object)name, (Object)"FacetManager") ^ true && SystemProperties.getBooleanProperty((String)"use.loaded.state.as.existing", (boolean)true);
    }

    protected boolean isUseLoadedStateAsExisting(@NotNull StateStorage storage2) {
        Intrinsics.checkParameterIsNotNull((Object)storage2, (String)"storage");
        StateStorage stateStorage = storage2;
        if (!(stateStorage instanceof XmlElementStorage)) {
            stateStorage = null;
        }
        XmlElementStorage xmlElementStorage = (XmlElementStorage)stateStorage;
        return (xmlElementStorage != null ? xmlElementStorage.getRoamingType() : null) != RoamingType.DISABLED;
    }

    @Nullable
    protected PathMacroManager getPathMacroManagerForDefaults() {
        return null;
    }

    private final <T> T getDefaultState(Object component, String componentName, Class<T> stateClass) {
        URL uRL = DecodeDefaultsUtil.getDefaults(component, componentName);
        if (uRL == null) {
            return null;
        }
        URL url = uRL;
        try {
            Element element = JDOMUtil.load((URL)url);
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"JDOMUtil.load(url)");
            Element element2 = element;
            PathMacroManager pathMacroManager = this.getPathMacroManagerForDefaults();
            if (pathMacroManager != null) {
                pathMacroManager.expandPaths(element2);
            }
            return DefaultStateSerializerKt.deserializeState(element2, stateClass, null);
        }
        catch (Throwable e) {
            throw (Throwable)new IOException("Error loading default state from " + url, e);
        }
    }

    @NotNull
    protected <T> List<Storage> getStorageSpecs(@NotNull PersistentStateComponent<T> component, @NotNull State stateSpec, @NotNull StateStorageOperation operation) {
        Intrinsics.checkParameterIsNotNull(component, (String)"component");
        Intrinsics.checkParameterIsNotNull((Object)stateSpec, (String)"stateSpec");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Object[] storages = stateSpec.storages();
        if (storages.length == 1 || component instanceof StateStorageChooserEx) {
            return ArraysKt.toList((Object[])storages);
        }
        Object[] objectArray = storages;
        if (objectArray.length == 0) {
            if (stateSpec.defaultStateAsResource()) {
                return CollectionsKt.emptyList();
            }
            throw (Throwable)((Object)new AssertionError((Object)"No storage specified"));
        }
        return ComponentStoreImplKt.sortByDeprecated((Storage[])storages);
    }

    @Override
    public final boolean isReloadPossible(@NotNull Set<String> componentNames) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull(componentNames, (String)"componentNames");
            Iterable $receiver$iv = componentNames;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!this.isNotReloadable(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return !bl;
    }

    private final boolean isNotReloadable(String name) {
        Object object = this.components.get(name);
        if (object == null || (object = ((ComponentInfo)object).getComponent()) == null) {
            return false;
        }
        Object component = object;
        return !(component instanceof PersistentStateComponent) || !StoreUtilKt.getStateSpec((PersistentStateComponent)component).reloadable();
    }

    @NotNull
    public final Collection<String> getNotReloadableComponents(@NotNull Collection<String> componentNames) {
        Intrinsics.checkParameterIsNotNull(componentNames, (String)"componentNames");
        Set notReloadableComponents = null;
        for (String componentName : componentNames) {
            if (!this.isNotReloadable(componentName)) continue;
            if (notReloadableComponents == null) {
                notReloadableComponents = new LinkedHashSet();
            }
            notReloadableComponents.add(componentName);
        }
        Set set2 = notReloadableComponents;
        return set2 != null ? (Collection)set2 : (Collection)SetsKt.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void reloadStates(@NotNull Set<String> componentNames, @NotNull MessageBus messageBus) {
        Intrinsics.checkParameterIsNotNull(componentNames, (String)"componentNames");
        Intrinsics.checkParameterIsNotNull((Object)messageBus, (String)"messageBus");
        boolean $i$f$runBatchUpdate = false;
        Object object = messageBus.syncPublisher(BatchUpdateListener.TOPIC);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"messageBus.syncPublisher\u2026atchUpdateListener.TOPIC)");
        BatchUpdateListener publisher$iv = (BatchUpdateListener)object;
        publisher$iv.onBatchUpdateStarted();
        try {
            boolean bl = false;
            ComponentStoreImpl.reinitComponents$default(this, componentNames, null, null, 6, null);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            publisher$iv.onBatchUpdateFinished();
        }
    }

    @Override
    public final void reloadState(@NotNull Class<? extends PersistentStateComponent<?>> componentClass) {
        block2: {
            PersistentStateComponent persistentStateComponent;
            Intrinsics.checkParameterIsNotNull(componentClass, (String)"componentClass");
            State stateSpec = StoreUtilKt.getStateSpecOrError(componentClass);
            ComponentInfo componentInfo = this.components.get(stateSpec.name());
            if (componentInfo == null) {
                return;
            }
            ComponentInfo info = componentInfo;
            Object object = info.getComponent();
            if (!(object instanceof PersistentStateComponent)) {
                object = null;
            }
            PersistentStateComponent persistentStateComponent2 = (PersistentStateComponent)object;
            if (persistentStateComponent2 == null) break block2;
            PersistentStateComponent it = persistentStateComponent = persistentStateComponent2;
            boolean bl = false;
            this.initComponent(info, SetsKt.emptySet(), true);
        }
    }

    private final boolean reloadState(String componentName, Set<? extends StateStorage> changedStorages) {
        ComponentInfo componentInfo = this.components.get(componentName);
        if (componentInfo == null) {
            return false;
        }
        ComponentInfo info = componentInfo;
        if (!(info.getComponent() instanceof PersistentStateComponent)) {
            return false;
        }
        boolean changedStoragesEmpty = changedStorages.isEmpty();
        this.initComponent(info, changedStoragesEmpty ? null : changedStorages, changedStoragesEmpty);
        return true;
    }

    @Nullable
    public final Collection<String> reload(@NotNull Set<? extends StateStorage> changedStorages) {
        Intrinsics.checkParameterIsNotNull(changedStorages, (String)"changedStorages");
        if (changedStorages.isEmpty()) {
            return SetsKt.emptySet();
        }
        SmartHashSet componentNames = new SmartHashSet();
        for (StateStorage stateStorage : changedStorages) {
            try {
                stateStorage.analyzeExternalChangesAndUpdateIfNeed((Set)componentNames);
            }
            catch (Throwable e) {
                ComponentStoreImplKt.getLOG().error(e);
            }
        }
        if (componentNames.isEmpty()) {
            return SetsKt.emptySet();
        }
        Collection<String> collection = this.getNotReloadableComponents((Collection)componentNames);
        this.reinitComponents((Set)componentNames, changedStorages, collection);
        return collection.isEmpty() ? null : collection;
    }

    public final void reinitComponents(@NotNull Set<String> componentNames, @NotNull Set<? extends StateStorage> changedStorages, @NotNull Collection<String> notReloadableComponents) {
        Intrinsics.checkParameterIsNotNull(componentNames, (String)"componentNames");
        Intrinsics.checkParameterIsNotNull(changedStorages, (String)"changedStorages");
        Intrinsics.checkParameterIsNotNull(notReloadableComponents, (String)"notReloadableComponents");
        for (String componentName : componentNames) {
            if (notReloadableComponents.contains(componentName)) continue;
            this.reloadState(componentName, changedStorages);
        }
    }

    public static /* synthetic */ void reinitComponents$default(ComponentStoreImpl componentStoreImpl, Set set2, Set set3, Collection collection, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reinitComponents");
        }
        if ((n & 2) != 0) {
            set3 = SetsKt.emptySet();
        }
        if ((n & 4) != 0) {
            collection = SetsKt.emptySet();
        }
        componentStoreImpl.reinitComponents(set2, set3, collection);
    }

    public final void removeComponent(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.components.remove(name);
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.getStorageManager().getComponentManager());
    }
}

