/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InspectionViewChangeAdapter
extends PsiTreeChangeAdapter {
    private final InspectionResultsView myView;
    private final Alarm myAlarm;
    private final Set<VirtualFile> myUnPresentEditedFiles;
    private final Set<VirtualFile> myFilesToProcess;
    private final AtomicBoolean myNeedReValidate;
    private final Alarm myUpdateQueue;

    InspectionViewChangeAdapter(@NotNull InspectionResultsView view) {
        if (view == null) {
            InspectionViewChangeAdapter.$$$reportNull$$$0(0);
        }
        this.myUnPresentEditedFiles = Collections.synchronizedSet(ContainerUtil.createWeakSet());
        this.myFilesToProcess = new THashSet();
        this.myNeedReValidate = new AtomicBoolean(false);
        this.myView = view;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)view);
        this.myUpdateQueue = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)view);
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            InspectionViewChangeAdapter.$$$reportNull$$$0(1);
        }
        this.processFileEvent(event);
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            InspectionViewChangeAdapter.$$$reportNull$$$0(2);
        }
        this.processFileOrDirEvent(event);
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            InspectionViewChangeAdapter.$$$reportNull$$$0(3);
        }
        this.processFileOrDirEvent(event);
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            InspectionViewChangeAdapter.$$$reportNull$$$0(4);
        }
        if (!this.processFileEvent(event)) {
            PsiElement oldParent = event.getOldParent();
            PsiElement newParent = event.getNewParent();
            if (oldParent instanceof PsiDirectory || newParent instanceof PsiDirectory) {
                this.needReValidateTree();
            }
        }
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            InspectionViewChangeAdapter.$$$reportNull$$$0(5);
        }
        this.processFileOrDirEvent(event);
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            InspectionViewChangeAdapter.$$$reportNull$$$0(6);
        }
        this.processFileEvent(event);
    }

    private void needReValidateTree() {
        this.myNeedReValidate.set(true);
        this.invokeQueue();
    }

    private void processFileOrDirEvent(@NotNull PsiTreeChangeEvent event) {
        PsiElement parent;
        if (event == null) {
            InspectionViewChangeAdapter.$$$reportNull$$$0(7);
        }
        if (!this.processFileEvent(event) && (parent = event.getParent()) instanceof PsiDirectory) {
            this.needReValidateTree();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processFileEvent(@NotNull PsiTreeChangeEvent event) {
        PsiFile file2;
        if (event == null) {
            InspectionViewChangeAdapter.$$$reportNull$$$0(8);
        }
        if ((file2 = event.getFile()) != null) {
            VirtualFile vFile = file2.getVirtualFile();
            if (!this.myUnPresentEditedFiles.contains(vFile)) {
                Set<VirtualFile> set2 = this.myFilesToProcess;
                synchronized (set2) {
                    this.myFilesToProcess.add(vFile);
                }
                this.invokeQueue();
            }
            return true;
        }
        return false;
    }

    private void invokeQueue() {
        this.myUpdateQueue.cancelAllRequests();
        this.myUpdateQueue.addRequest(() -> {
            THashSet filesToCheck;
            boolean[] needUpdateUI = new boolean[]{false};
            Processor nodeProcessor = null;
            if (this.myNeedReValidate.compareAndSet(true, false)) {
                nodeProcessor = node -> {
                    VirtualFile vFile;
                    SmartPsiElementPointer pointer;
                    RefElement element;
                    if (this.myView.isDisposed()) {
                        return false;
                    }
                    if (node instanceof SuppressableInspectionTreeNode && (element = (RefElement)ObjectUtils.tryCast((Object)((SuppressableInspectionTreeNode)node).getElement(), RefElement.class)) != null && (pointer = element.getPointer()) != null && ((vFile = pointer.getVirtualFile()) == null || !vFile.isValid())) {
                        ((SuppressableInspectionTreeNode)node).dropCache();
                        if (!needUpdateUI[0]) {
                            needUpdateUI[0] = true;
                        }
                    }
                    return true;
                };
            }
            Set<VirtualFile> set2 = this.myFilesToProcess;
            synchronized (set2) {
                filesToCheck = new THashSet(this.myFilesToProcess);
                this.myFilesToProcess.clear();
            }
            THashSet unPresentFiles = new THashSet((Collection)filesToCheck);
            if (!filesToCheck.isEmpty()) {
                Processor fileCheckProcessor = arg_0 -> this.lambda$null$2((Set)filesToCheck, (Set)unPresentFiles, needUpdateUI, arg_0);
                nodeProcessor = CompositeProcessor.combine(fileCheckProcessor, nodeProcessor);
            }
            this.myView.getTree().getInspectionTreeModel().traverse(this.myView.getTree().getInspectionTreeModel().getRoot()).processEach(nodeProcessor);
            if (!unPresentFiles.isEmpty()) {
                this.myUnPresentEditedFiles.addAll((Collection<VirtualFile>)unPresentFiles);
            }
            if (needUpdateUI[0] && !this.myAlarm.isDisposed()) {
                this.myAlarm.cancelAllRequests();
                this.myAlarm.addRequest(() -> this.myView.getTree().getInspectionTreeModel().reload(), 100, ModalityState.NON_MODAL);
            }
        }, 200);
    }

    private /* synthetic */ boolean lambda$null$2(Set filesToCheck, Set unPresentFiles, boolean[] needUpdateUI, InspectionTreeNode node) {
        VirtualFile vFile;
        SmartPsiElementPointer pointer;
        RefElement element;
        if (this.myView.isDisposed()) {
            return false;
        }
        if (node instanceof SuppressableInspectionTreeNode && (element = (RefElement)ObjectUtils.tryCast((Object)((SuppressableInspectionTreeNode)node).getElement(), RefElement.class)) != null && (pointer = element.getPointer()) != null && filesToCheck.contains(vFile = (VirtualFile)ReadAction.compute(() -> pointer.getVirtualFile()))) {
            unPresentFiles.remove(vFile);
            ((SuppressableInspectionTreeNode)node).dropCache();
            if (!needUpdateUI[0]) {
                needUpdateUI[0] = true;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/ui/InspectionViewChangeAdapter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "childAdded";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "childRemoved";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "childReplaced";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "childMoved";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "childrenChanged";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processFileOrDirEvent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processFileEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CompositeProcessor<X>
    implements Processor<X> {
        private final Processor<? super X> myFirstProcessor;
        private boolean myFirstFinished;
        private final Processor<? super X> mySecondProcessor;
        private boolean mySecondFinished;

        private CompositeProcessor(@NotNull Processor<? super X> firstProcessor, @NotNull Processor<? super X> secondProcessor) {
            if (firstProcessor == null) {
                CompositeProcessor.$$$reportNull$$$0(0);
            }
            if (secondProcessor == null) {
                CompositeProcessor.$$$reportNull$$$0(1);
            }
            this.myFirstProcessor = firstProcessor;
            this.mySecondProcessor = secondProcessor;
        }

        public boolean process(X x) {
            if (!this.myFirstFinished && !this.myFirstProcessor.process(x)) {
                this.myFirstFinished = true;
            }
            if (!this.mySecondFinished && !this.mySecondProcessor.process(x)) {
                this.mySecondFinished = true;
            }
            return !this.myFirstFinished || !this.mySecondFinished;
        }

        @NotNull
        public static <X> Processor<X> combine(@NotNull Processor<X> processor1, @Nullable Processor<? super X> processor2) {
            if (processor1 == null) {
                CompositeProcessor.$$$reportNull$$$0(2);
            }
            CompositeProcessor<? super X> compositeProcessor = processor2 == null ? processor1 : new CompositeProcessor<X>(processor1, processor2);
            if (compositeProcessor == null) {
                CompositeProcessor.$$$reportNull$$$0(3);
            }
            return compositeProcessor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstProcessor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "secondProcessor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor1";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ui/InspectionViewChangeAdapter$CompositeProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ui/InspectionViewChangeAdapter$CompositeProcessor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "combine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "combine";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

