/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.actions.RunInspectionAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeTable;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLabelDecorator;
import com.intellij.ui.components.panels.StatelessCardLayout;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class InspectionNodeInfo
extends JPanel {
    private static final Logger LOG = Logger.getInstance(InspectionNodeInfo.class);

    public InspectionNodeInfo(final @NotNull InspectionTree tree, final @NotNull Project project) {
        String toolDescription;
        if (tree == null) {
            InspectionNodeInfo.$$$reportNull$$$0(0);
        }
        if (project == null) {
            InspectionNodeInfo.$$$reportNull$$$0(1);
        }
        this.setLayout(new GridBagLayout());
        this.setBorder((Border)JBUI.Borders.emptyTop((int)11));
        final InspectionToolWrapper toolWrapper = tree.getSelectedToolWrapper(false);
        LOG.assertTrue(toolWrapper != null);
        final InspectionProfileImpl currentProfile = InspectionProjectProfileManager.getInstance(project).getCurrentProfile();
        final boolean enabled = currentProfile.getTools(toolWrapper.getShortName(), project).isEnabled();
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 2));
        JBLabelDecorator label2 = JBLabelDecorator.createJBLabelDecorator().setBold(true);
        label2.setText(toolWrapper.getDisplayName() + " inspection");
        titlePanel.add((Component)label2);
        titlePanel.add(Box.createHorizontalStrut(JBUI.scale((int)16)));
        if (!enabled) {
            JBLabel enabledLabel = new JBLabel();
            enabledLabel.setForeground((Color)JBColor.GRAY);
            enabledLabel.setText("Disabled");
            titlePanel.add((Component)enabledLabel);
        }
        this.add((Component)titlePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, (Insets)new JBInsets(0, 12, 5, 16), 0, 0));
        JEditorPane description = new JEditorPane();
        description.setContentType("text/html");
        description.setEditable(false);
        description.setOpaque(false);
        description.setBackground(UIUtil.getLabelBackground());
        description.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        String descriptionText = toolWrapper.loadDescription();
        if (descriptionText == null) {
            InspectionEP extension = toolWrapper.getExtension();
            LOG.error((Throwable)new PluginException("Inspection #" + toolWrapper.getShortName() + " has no description", extension != null ? extension.getPluginId() : null));
        }
        SingleInspectionProfilePanel.readHTML(description, SingleInspectionProfilePanel.toHTML(description, (toolDescription = InspectionNodeInfo.stripUIRefsFromInspectionDescription(StringUtil.notNullize((String)descriptionText))) == null ? "" : toolDescription, false));
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)description, (boolean)true);
        int maxWidth = this.getFontMetrics(UIUtil.getLabelFont()).charWidth('f') * 110 - pane.getMinimumSize().width;
        pane.setMaximumSize(new Dimension(maxWidth, Integer.MAX_VALUE));
        pane.setAlignmentX(0.0f);
        this.add((Component)StatelessCardLayout.wrap((Component)pane), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, (Insets)new JBInsets(0, 10, 0, 0), 0, 0));
        JButton enableButton = null;
        if (currentProfile.getSingleTool() != null) {
            enableButton = new JButton((enabled ? "Disable" : "Enable") + " inspection");
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    InspectionsConfigTreeTable.setToolEnabled(!enabled, currentProfile, toolWrapper.getShortName(), project);
                    tree.getContext().getView().profileChanged();
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInspection/ui/InspectionNodeInfo$1", "onClick"));
                }
            }.installOn((Component)enableButton);
        }
        JButton runInspectionOnButton = new JButton(InspectionsBundle.message((String)"run.inspection.on.file.intention.text", (Object[])new Object[0]));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                RunInspectionAction.runInspection(project, toolWrapper.getShortName(), null, null, null);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInspection/ui/InspectionNodeInfo$2", "onClick"));
            }
        }.installOn((Component)runInspectionOnButton);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 2));
        if (enableButton != null) {
            buttons.add(enableButton);
        }
        buttons.add(Box.createHorizontalStrut(JBUI.scale((int)3)));
        buttons.add(runInspectionOnButton);
        this.add((Component)buttons, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 0, (Insets)new JBInsets(15, 9, 9, 0), 0, 0));
    }

    public static String stripUIRefsFromInspectionDescription(@NotNull String description) {
        int descriptionEnd;
        if (description == null) {
            InspectionNodeInfo.$$$reportNull$$$0(2);
        }
        if ((descriptionEnd = description.indexOf("<!-- tooltip end -->")) < 0) {
            Pattern pattern = Pattern.compile(".*Use.*(the (panel|checkbox|checkboxes|field|button|controls).*below).*", 32);
            Matcher matcher = pattern.matcher(description);
            int startFindIdx = 0;
            while (matcher.find(startFindIdx)) {
                int end;
                startFindIdx = end = matcher.end(1);
                description = description.substring(0, matcher.start(1)) + " inspection settings " + description.substring(end);
            }
        } else {
            description = description.substring(0, descriptionEnd);
        }
        return description;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/ui/InspectionNodeInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "stripUIRefsFromInspectionDescription";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

