/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.export;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HTMLExportUtil {
    public static void writeFile(String folder, @NonNls String fileName2, CharSequence buf, Project project) {
        File dir;
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        File fullPath = new File(folder + File.separator + fileName2);
        if (indicator != null) {
            ProgressManager.checkCanceled();
            indicator.setText(InspectionsBundle.message((String)"inspection.export.generating.html.for", (Object[])new Object[]{fullPath.getAbsolutePath()}));
        }
        if (!(dir = fullPath.getParentFile()).exists() && !dir.mkdirs()) {
            HTMLExportUtil.showErrorMessage("Can't create dir", dir, project);
            return;
        }
        if (!dir.canWrite() && !fullPath.canWrite()) {
            HTMLExportUtil.showErrorMessage("Permission denied", fullPath, project);
            return;
        }
        try (FileWriter writer = new FileWriter(fullPath, false);){
            writer.write(buf.toString().toCharArray());
        }
        catch (IOException e) {
            HTMLExportUtil.showErrorMessage(String.valueOf(e.getCause()), fullPath, project);
        }
    }

    private static void showErrorMessage(@NotNull String message, @NotNull File file2, @NotNull Project project) {
        if (message == null) {
            HTMLExportUtil.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            HTMLExportUtil.$$$reportNull$$$0(1);
        }
        if (project == null) {
            HTMLExportUtil.$$$reportNull$$$0(2);
        }
        Runnable showError2 = () -> Messages.showMessageDialog((Project)project, (String)InspectionsBundle.message((String)"inspection.export.error.writing.to", (Object[])new Object[]{file2.getAbsolutePath(), message}), (String)InspectionsBundle.message((String)"inspection.export.results.error.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        ApplicationManager.getApplication().invokeLater(showError2, ModalityState.NON_MODAL);
        throw new ProcessCanceledException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "message";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/export/HTMLExportUtil";
        objectArray[2] = "showErrorMessage";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

