/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.analysis.dialog.ModelScopeItem;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileKt;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunInspectionIntention
implements IntentionAction,
HighPriorityAction {
    private static final Logger LOG = Logger.getInstance(RunInspectionIntention.class);
    private final String myShortName;

    public RunInspectionIntention(HighlightDisplayKey key) {
        this.myShortName = key.toString();
    }

    @NotNull
    public String getText() {
        String string = InspectionsBundle.message((String)"run.inspection.on.file.intention.text", (Object[])new Object[0]);
        if (string == null) {
            RunInspectionIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            RunInspectionIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            RunInspectionIntention.$$$reportNull$$$0(2);
        }
        return LocalInspectionToolWrapper.findTool2RunInBatch(project, (PsiElement)file2, this.myShortName) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            RunInspectionIntention.$$$reportNull$$$0(3);
        }
        Module module = file2 != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)file2) : null;
        AnalysisScope analysisScope = new AnalysisScope(project);
        if (file2 != null) {
            PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)file2);
            VirtualFile virtualFile = topLevelFile.getVirtualFile();
            if (file2.isPhysical() && virtualFile != null && virtualFile.isInLocalFileSystem()) {
                analysisScope = new AnalysisScope(topLevelFile);
            }
        }
        RunInspectionIntention.selectScopeAndRunInspection(this.myShortName, analysisScope, module, (PsiElement)file2, project);
    }

    public static void selectScopeAndRunInspection(@NotNull String toolShortName, @NotNull AnalysisScope customScope, @Nullable Module module, @Nullable PsiElement context, @NotNull Project project) {
        if (toolShortName == null) {
            RunInspectionIntention.$$$reportNull$$$0(4);
        }
        if (customScope == null) {
            RunInspectionIntention.$$$reportNull$$$0(5);
        }
        if (project == null) {
            RunInspectionIntention.$$$reportNull$$$0(6);
        }
        List<ModelScopeItem> items = BaseAnalysisActionDialog.standardItems(project, customScope, module, context);
        BaseAnalysisActionDialog dlg = new BaseAnalysisActionDialog(AnalysisScopeBundle.message((String)"specify.analysis.scope", (Object[])new Object[]{InspectionsBundle.message((String)"inspection.action.title", (Object[])new Object[0])}), AnalysisScopeBundle.message((String)"analysis.scope.title", (Object[])new Object[]{InspectionsBundle.message((String)"inspection.action.noun", (Object[])new Object[0])}), project, items, AnalysisUIOptions.getInstance(project), true);
        if (!dlg.showAndGet()) {
            return;
        }
        AnalysisUIOptions uiOptions = AnalysisUIOptions.getInstance(project);
        customScope = dlg.getScope(uiOptions, customScope, project, module);
        InspectionToolWrapper wrapper2 = LocalInspectionToolWrapper.findTool2RunInBatch(project, context, toolShortName);
        LOG.assertTrue(wrapper2 != null, (Object)("Can't find tool with name = \"" + toolShortName + "\""));
        RunInspectionIntention.rerunInspection(wrapper2, (InspectionManagerEx)InspectionManager.getInstance((Project)project), customScope, context);
    }

    public static void rerunInspection(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionManagerEx managerEx, @NotNull AnalysisScope scope, @Nullable PsiElement psiElement) {
        if (toolWrapper == null) {
            RunInspectionIntention.$$$reportNull$$$0(7);
        }
        if (managerEx == null) {
            RunInspectionIntention.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            RunInspectionIntention.$$$reportNull$$$0(9);
        }
        GlobalInspectionContextImpl inspectionContext = RunInspectionIntention.createContext(toolWrapper, managerEx, psiElement);
        inspectionContext.doInspections(scope);
    }

    @NotNull
    public static GlobalInspectionContextImpl createContext(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionManagerEx managerEx, @Nullable PsiElement psiElement) {
        if (toolWrapper == null) {
            RunInspectionIntention.$$$reportNull$$$0(10);
        }
        if (managerEx == null) {
            RunInspectionIntention.$$$reportNull$$$0(11);
        }
        InspectionProfileImpl model = RunInspectionIntention.createProfile(toolWrapper, managerEx, psiElement);
        GlobalInspectionContextImpl inspectionContext = managerEx.createNewGlobalContext();
        inspectionContext.setExternalProfile(model);
        GlobalInspectionContextImpl globalInspectionContextImpl = inspectionContext;
        if (globalInspectionContextImpl == null) {
            RunInspectionIntention.$$$reportNull$$$0(12);
        }
        return globalInspectionContextImpl;
    }

    @NotNull
    public static InspectionProfileImpl createProfile(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionManagerEx managerEx, @Nullable PsiElement psiElement) {
        if (toolWrapper == null) {
            RunInspectionIntention.$$$reportNull$$$0(13);
        }
        if (managerEx == null) {
            RunInspectionIntention.$$$reportNull$$$0(14);
        }
        InspectionProfileImpl rootProfile = InspectionProfileManager.getInstance().getCurrentProfile();
        LinkedHashSet<InspectionToolWrapper> allWrappers = new LinkedHashSet<InspectionToolWrapper>();
        allWrappers.add(toolWrapper);
        rootProfile.collectDependentInspections(toolWrapper, allWrappers, managerEx.getProject());
        List toolWrappers = allWrappers.size() == 1 ? Collections.singletonList(allWrappers.iterator().next()) : new ArrayList(allWrappers);
        InspectionProfileImpl model = InspectionProfileKt.createSimple(toolWrapper.getDisplayName(), managerEx.getProject(), toolWrappers);
        try {
            Element element = new Element("toCopy");
            for (InspectionToolWrapper wrapper2 : toolWrappers) {
                wrapper2.getTool().writeSettings(element);
                InspectionToolWrapper tw = psiElement == null ? model.getInspectionTool(wrapper2.getShortName(), managerEx.getProject()) : model.getInspectionTool(wrapper2.getShortName(), psiElement);
                tw.getTool().readSettings(element);
            }
        }
        catch (InvalidDataException | WriteExternalException throwable) {
            // empty catch block
        }
        model.setSingleTool(toolWrapper.getShortName());
        InspectionProfileImpl inspectionProfileImpl = model;
        if (inspectionProfileImpl == null) {
            RunInspectionIntention.$$$reportNull$$$0(15);
        }
        return inspectionProfileImpl;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/actions/RunInspectionIntention";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolShortName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customScope";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "managerEx";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/actions/RunInspectionIntention";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createContext";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createProfile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "selectScopeAndRunInspection";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "rerunInspection";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createProfile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

