/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LanguageInspectionSuppressors;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.RedundantSuppressionDetector;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionElementsMerger;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.UnfairLocalInspectionTool;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.BidirectionalMap;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantSuppressInspection
extends GlobalSimpleInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.RedundantSuppressInspection");
    public static final String SHORT_NAME = "RedundantSuppression";
    public boolean IGNORE_ALL;
    private BidirectionalMap<String, QuickFix> myQuickFixes;

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            RedundantSuppressInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.redundant.suppression.name", (Object[])new Object[0]);
        if (string == null) {
            RedundantSuppressInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if (SHORT_NAME == null) {
            RedundantSuppressInspection.$$$reportNull$$$0(2);
        }
        return SHORT_NAME;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Ignore '@SuppressWarning(\"ALL\")'", (InspectionProfileEntry)this, "IGNORE_ALL");
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            RedundantSuppressInspection.$$$reportNull$$$0(3);
        }
        if (this.IGNORE_ALL) {
            super.writeSettings(node);
        }
    }

    public void checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, @NotNull ProblemsHolder problemsHolder, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        ProblemDescriptor[] descriptors;
        if (file2 == null) {
            RedundantSuppressInspection.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            RedundantSuppressInspection.$$$reportNull$$$0(5);
        }
        if (problemsHolder == null) {
            RedundantSuppressInspection.$$$reportNull$$$0(6);
        }
        if (globalContext == null) {
            RedundantSuppressInspection.$$$reportNull$$$0(7);
        }
        if (problemDescriptionsProcessor == null) {
            RedundantSuppressInspection.$$$reportNull$$$0(8);
        }
        if (!((GlobalInspectionContextBase)globalContext).isToCheckFile(file2, (InspectionProfileEntry)this)) {
            return;
        }
        InspectionSuppressor extension = (InspectionSuppressor)LanguageInspectionSuppressors.INSTANCE.forLanguage(file2.getLanguage());
        if (!(extension instanceof RedundantSuppressionDetector)) {
            return;
        }
        for (ProblemDescriptor descriptor : descriptors = this.checkElement(file2, (RedundantSuppressionDetector)extension, manager)) {
            PsiElement psiElement;
            if (descriptor instanceof ProblemDescriptor && (psiElement = descriptor.getPsiElement()) != null) {
                PsiNamedElement member = globalContext.getRefManager().getContainerElement(psiElement);
                RefElement reference = globalContext.getRefManager().getReference((PsiElement)member);
                if (reference != null) {
                    problemDescriptionsProcessor.addProblemElement((RefEntity)reference, new CommonProblemDescriptor[]{descriptor});
                    continue;
                }
                problemsHolder.registerProblem(psiElement, descriptor.getDescriptionTemplate(), new LocalQuickFix[0]);
                continue;
            }
            problemsHolder.registerProblem((PsiElement)file2, descriptor.getDescriptionTemplate(), new LocalQuickFix[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public ProblemDescriptor[] checkElement(@NotNull PsiFile psiElement, RedundantSuppressionDetector extension, @NotNull InspectionManager manager) {
        void result2;
        if (psiElement == null) {
            RedundantSuppressInspection.$$$reportNull$$$0(9);
        }
        if (manager == null) {
            RedundantSuppressInspection.$$$reportNull$$$0(10);
        }
        THashMap suppressedScopes = new THashMap();
        psiElement.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((Map)suppressedScopes, extension){
            final /* synthetic */ Map val$suppressedScopes;
            final /* synthetic */ RedundantSuppressionDetector val$extension;
            {
                this.val$suppressedScopes = map2;
                this.val$extension = redundantSuppressionDetector;
            }

            public void visitElement(PsiElement element) {
                super.visitElement(element);
                RedundantSuppressInspection.collectSuppressions(element, this.val$suppressedScopes, RedundantSuppressInspection.this.IGNORE_ALL, this.val$extension);
            }
        });
        if (suppressedScopes.values().isEmpty()) {
            if (ProblemDescriptor.EMPTY_ARRAY == null) {
                RedundantSuppressInspection.$$$reportNull$$$0(11);
            }
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        THashMap suppressedTools = new THashMap();
        InspectionToolWrapper[] toolWrappers = this.getInspectionTools((PsiElement)psiElement, manager);
        for (Collection ids : suppressedScopes.values()) {
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                String suppressId = ((String)iterator.next()).trim();
                List<InspectionToolWrapper> reportingWrappers = RedundantSuppressInspection.findReportingTools(toolWrappers, suppressId);
                if (reportingWrappers.isEmpty()) {
                    iterator.remove();
                    continue;
                }
                for (InspectionToolWrapper toolWrapper : reportingWrappers) {
                    suppressedTools.put(toolWrapper, suppressId);
                }
            }
        }
        PsiFile file2 = psiElement.getContainingFile();
        AnalysisScope scope = new AnalysisScope(file2);
        GlobalInspectionContextBase globalContext = this.createContext(file2);
        globalContext.setCurrentScope(scope);
        RefManagerImpl refManager = (RefManagerImpl)globalContext.getRefManager();
        refManager.inspectionReadActionStarted();
        try {
            ArrayList<ProblemDescriptor> result22 = new ArrayList<ProblemDescriptor>();
            for (InspectionToolWrapper toolWrapper : suppressedTools.keySet()) {
                Object global;
                ArrayList<Object> descriptors;
                String toolId = (String)suppressedTools.get(toolWrapper);
                toolWrapper.initialize((GlobalInspectionContext)globalContext);
                if (toolWrapper instanceof LocalInspectionToolWrapper) {
                    LocalInspectionToolWrapper local = (LocalInspectionToolWrapper)toolWrapper;
                    if (local.isUnfair()) continue;
                    List results = ((LocalInspectionTool)local.getTool()).processFile(file2, manager);
                    descriptors = new ArrayList(results);
                } else {
                    GlobalInspectionTool globalTool;
                    if (!(toolWrapper instanceof GlobalInspectionToolWrapper) || (globalTool = (GlobalInspectionTool)(global = (GlobalInspectionToolWrapper)toolWrapper).getTool()).isGraphNeeded()) continue;
                    descriptors = new ArrayList<ProblemDescriptor>(InspectionEngine.runInspectionOnFile(file2, (InspectionToolWrapper)global, globalContext));
                }
                global = suppressedScopes.keySet().iterator();
                block7: while (global.hasNext()) {
                    PsiElement suppressedScope = (PsiElement)global.next();
                    Collection suppressedIds = (Collection)suppressedScopes.get(suppressedScope);
                    if (!suppressedIds.contains(toolId)) continue;
                    for (CommonProblemDescriptor commonProblemDescriptor : descriptors) {
                        PsiLanguageInjectionHost host;
                        PsiElement element;
                        if (!(commonProblemDescriptor instanceof ProblemDescriptor) || (element = ((ProblemDescriptor)commonProblemDescriptor).getPsiElement()) == null || !extension.isSuppressionFor(suppressedScope, (PsiElement)ObjectUtils.notNull((Object)(host = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectionHost(element)), (Object)element), toolId)) continue;
                        suppressedIds.remove(toolId);
                        continue block7;
                    }
                }
            }
            for (PsiElement suppressedScope : suppressedScopes.keySet()) {
                Collection suppressedIds = (Collection)suppressedScopes.get(suppressedScope);
                for (String toolId : suppressedIds) {
                    void var20_24;
                    String key;
                    QuickFix<ProblemDescriptor> fix;
                    PsiNamedElement documentedElement = globalContext.getRefManager().getContainerElement(suppressedScope);
                    if (documentedElement == null || !documentedElement.isValid()) continue;
                    if (this.myQuickFixes == null) {
                        this.myQuickFixes = new BidirectionalMap();
                    }
                    if ((fix = (QuickFix<ProblemDescriptor>)this.myQuickFixes.get((Object)(key = toolId + ";" + suppressedScope.getLanguage().getID()))) == null) {
                        fix = RedundantSuppressInspection.createQuickFix(key);
                        this.myQuickFixes.put((Object)key, fix);
                    }
                    if (suppressedScope instanceof PsiNameIdentifierOwner && suppressedScope == documentedElement) {
                        PsiElement psiElement2 = (PsiElement)ObjectUtils.notNull((Object)((PsiNameIdentifierOwner)suppressedScope).getNameIdentifier(), (Object)suppressedScope);
                    } else {
                        PsiElement psiElement3 = suppressedScope;
                    }
                    result22.add(manager.createProblemDescriptor((PsiElement)var20_24, InspectionsBundle.message((String)"inspection.redundant.suppression.description", (Object[])new Object[0]), (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false));
                }
            }
        }
        finally {
            refManager.inspectionReadActionFinished();
            globalContext.close(true);
        }
        ProblemDescriptor[] problemDescriptorArray = result2.toArray(ProblemDescriptor.EMPTY_ARRAY);
        if (problemDescriptorArray == null) {
            RedundantSuppressInspection.$$$reportNull$$$0(12);
        }
        return problemDescriptorArray;
    }

    private static List<InspectionToolWrapper> findReportingTools(InspectionToolWrapper[] toolWrappers, String suppressedId) {
        List<InspectionToolWrapper> wrappers = Collections.emptyList();
        String mergedToolName = InspectionElementsMerger.getMergedToolName((String)suppressedId);
        for (InspectionToolWrapper toolWrapper : toolWrappers) {
            String toolWrapperShortName = toolWrapper.getShortName();
            String alternativeID = toolWrapper.getTool().getAlternativeID();
            if (toolWrapper instanceof LocalInspectionToolWrapper && (((LocalInspectionTool)((LocalInspectionToolWrapper)toolWrapper).getTool()).getID().equals(suppressedId) || suppressedId.equals(alternativeID) || toolWrapperShortName.equals(mergedToolName))) {
                if (((LocalInspectionToolWrapper)toolWrapper).isUnfair()) continue;
                if (wrappers.isEmpty()) {
                    wrappers = new ArrayList<InspectionToolWrapper>();
                }
                wrappers.add(toolWrapper);
                continue;
            }
            if (!toolWrapperShortName.equals(suppressedId) && !toolWrapperShortName.equals(mergedToolName) && !suppressedId.equals(alternativeID) || !(toolWrapper instanceof LocalInspectionToolWrapper) && (!(toolWrapper instanceof GlobalInspectionToolWrapper) || ((GlobalInspectionTool)((GlobalInspectionToolWrapper)toolWrapper).getTool()).isGraphNeeded())) continue;
            if (wrappers.isEmpty()) {
                wrappers = new ArrayList<InspectionToolWrapper>();
            }
            wrappers.add(toolWrapper);
        }
        return wrappers;
    }

    private static boolean collectSuppressions(@NotNull PsiElement element, Map<PsiElement, Collection<String>> suppressedScopes, boolean ignoreAll, RedundantSuppressionDetector suppressor) {
        String idsString;
        if (element == null) {
            RedundantSuppressInspection.$$$reportNull$$$0(13);
        }
        if ((idsString = suppressor.getSuppressionIds(element)) != null && !idsString.isEmpty()) {
            ArrayList<String> ids = new ArrayList<String>();
            StringUtil.tokenize((String)idsString, (String)"[, ]").forEach(ids::add);
            boolean isSuppressAll = ids.stream().anyMatch(id -> id.equalsIgnoreCase("ALL"));
            if (ignoreAll && isSuppressAll) {
                return false;
            }
            Collection<String> suppressed = suppressedScopes.get(element);
            if (suppressed == null) {
                suppressed = ids;
            } else {
                for (String id2 : ids) {
                    if (suppressed.contains(id2)) continue;
                    suppressed.add(id2);
                }
            }
            suppressedScopes.put(element, suppressed);
            return isSuppressAll;
        }
        return false;
    }

    public LocalInspectionTool createLocalTool(RedundantSuppressionDetector suppressor, Map<String, Set<PsiElement>> toolToSuppressScopes, Set<String> activeTools) {
        return new LocalRedundantSuppressionInspection(suppressor, activeTools, toolToSuppressScopes);
    }

    private static QuickFix<ProblemDescriptor> createQuickFix(String key) {
        Language language;
        String[] toolAndLang = key.split(";");
        Language language2 = language = toolAndLang.length < 2 ? null : Language.findLanguageByID((String)toolAndLang[1]);
        if (language == null) {
            return null;
        }
        InspectionSuppressor suppressor = (InspectionSuppressor)LanguageInspectionSuppressors.INSTANCE.forLanguage(language);
        return suppressor instanceof RedundantSuppressionDetector ? ((RedundantSuppressionDetector)suppressor).createRemoveRedundantSuppressionFix(toolAndLang[0]) : null;
    }

    @NotNull
    protected InspectionToolWrapper[] getInspectionTools(PsiElement psiElement, @NotNull InspectionManager manager) {
        if (manager == null) {
            RedundantSuppressInspection.$$$reportNull$$$0(14);
        }
        String currentProfileName = ((InspectionManagerBase)manager).getCurrentProfile();
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance(manager.getProject());
        InspectionProfileImpl usedProfile = profileManager.getProfile(currentProfileName, false);
        InspectionToolWrapper[] inspectionToolWrapperArray = ((InspectionProfileImpl)ObjectUtils.notNull((Object)usedProfile, (Object)profileManager.getCurrentProfile())).getInspectionTools(psiElement);
        if (inspectionToolWrapperArray == null) {
            RedundantSuppressInspection.$$$reportNull$$$0(15);
        }
        return inspectionToolWrapperArray;
    }

    @Nullable
    public QuickFix getQuickFix(String hint) {
        return this.myQuickFixes != null ? (QuickFix)this.myQuickFixes.get((Object)hint) : RedundantSuppressInspection.createQuickFix(hint);
    }

    @Nullable
    public String getHint(@NotNull QuickFix fix) {
        List list2;
        if (fix == null) {
            RedundantSuppressInspection.$$$reportNull$$$0(16);
        }
        if (this.myQuickFixes != null && (list2 = this.myQuickFixes.getKeysByValue((Object)fix)) != null) {
            LOG.assertTrue(list2.size() == 1);
            return (String)list2.get(0);
        }
        return null;
    }

    public boolean worksInBatchModeOnly() {
        return false;
    }

    protected GlobalInspectionContextBase createContext(PsiFile file2) {
        InspectionManager inspectionManagerEx = InspectionManager.getInstance((Project)file2.getProject());
        return (GlobalInspectionContextBase)inspectionManagerEx.createNewGlobalContext();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/RedundantSuppressInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptionsProcessor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/RedundantSuppressInspection";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "checkElement";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionTools";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectSuppressions";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionTools";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getHint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LocalRedundantSuppressionInspection
    extends LocalInspectionTool
    implements UnfairLocalInspectionTool {
        private final RedundantSuppressionDetector mySuppressor;
        private final Set<String> myActiveTools;
        private final Map<String, Set<PsiElement>> myToolToSuppressScopes;

        private LocalRedundantSuppressionInspection(RedundantSuppressionDetector suppressor, Set<String> activeTools, Map<String, Set<PsiElement>> toolToSuppressScopes) {
            this.mySuppressor = suppressor;
            this.myActiveTools = activeTools;
            this.myToolToSuppressScopes = toolToSuppressScopes;
        }

        @NotNull
        public String getShortName() {
            if (RedundantSuppressInspection.SHORT_NAME == null) {
                LocalRedundantSuppressionInspection.$$$reportNull$$$0(0);
            }
            return RedundantSuppressInspection.SHORT_NAME;
        }

        @Nls
        @NotNull
        public String getDisplayName() {
            String string = RedundantSuppressInspection.this.getDisplayName();
            if (string == null) {
                LocalRedundantSuppressionInspection.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
            if (holder == null) {
                LocalRedundantSuppressionInspection.$$$reportNull$$$0(2);
            }
            PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

                public void visitElement(PsiElement element) {
                    super.visitElement(element);
                    HashMap scopes = new HashMap();
                    boolean suppressAll = RedundantSuppressInspection.collectSuppressions(element, scopes, RedundantSuppressInspection.this.IGNORE_ALL, LocalRedundantSuppressionInspection.this.mySuppressor);
                    if (suppressAll) {
                        for (String suppressId : LocalRedundantSuppressionInspection.this.myActiveTools) {
                            if (!this.isSuppressedFor(element, suppressId, (Set)LocalRedundantSuppressionInspection.this.myToolToSuppressScopes.get(suppressId))) continue;
                            return;
                        }
                        TextRange range2 = LocalRedundantSuppressionInspection.this.mySuppressor.getHighlightingRange(element, "ALL");
                        String allSuppression = element.getText().substring(range2.getStartOffset(), range2.getEndOffset());
                        holder.registerProblem(element, range2, InspectionsBundle.message((String)"inspection.redundant.suppression.description", (Object[])new Object[0]), new LocalQuickFix[]{LocalRedundantSuppressionInspection.this.mySuppressor.createRemoveRedundantSuppressionFix(allSuppression)});
                        return;
                    }
                    Collection suppressIds = (Collection)scopes.get(element);
                    if (suppressIds != null) {
                        for (String suppressId : suppressIds) {
                            if (!LocalRedundantSuppressionInspection.this.myActiveTools.contains(suppressId) || this.isSuppressedFor(element, suppressId, (Set)LocalRedundantSuppressionInspection.this.myToolToSuppressScopes.get(suppressId)) || SuppressionUtil.inspectionResultSuppressed(element, LocalRedundantSuppressionInspection.this)) continue;
                            holder.registerProblem(element, LocalRedundantSuppressionInspection.this.mySuppressor.getHighlightingRange(element, suppressId), InspectionsBundle.message((String)"inspection.redundant.suppression.description", (Object[])new Object[0]), new LocalQuickFix[]{LocalRedundantSuppressionInspection.this.mySuppressor.createRemoveRedundantSuppressionFix(suppressId)});
                        }
                    }
                }

                private boolean isSuppressedFor(PsiElement element, String suppressId, Set<PsiElement> suppressedPlaces) {
                    return suppressedPlaces != null && suppressedPlaces.stream().anyMatch(place -> LocalRedundantSuppressionInspection.this.mySuppressor.isSuppressionFor(element, place, suppressId));
                }
            };
            if (psiElementVisitor == null) {
                LocalRedundantSuppressionInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/RedundantSuppressInspection$LocalRedundantSuppressionInspection";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShortName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/RedundantSuppressInspection$LocalRedundantSuppressionInspection";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "buildVisitor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

