/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.actions;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.navigation.GotoDeclarationProvider;
import com.intellij.codeInsight.navigation.PsiElementNavigationTarget;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationAction;
import com.intellij.model.Symbol;
import com.intellij.model.SymbolReference;
import com.intellij.model.SymbolResolveResult;
import com.intellij.model.psi.PsiElementSymbol;
import com.intellij.navigation.NavigationTarget;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0000\u0012\u00020\t0\bH\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0000\u0012\u00020\t0\bH\u0016J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/codeInsight/navigation/actions/DefaultGotoDeclarationProvider;", "Lcom/intellij/codeInsight/navigation/GotoDeclarationProvider;", "()V", "collectTargets", "", "symbol", "Lcom/intellij/model/Symbol;", "consumer", "Ljava/util/function/Consumer;", "Lcom/intellij/navigation/NavigationTarget;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "findReferences", "", "Lcom/intellij/model/SymbolReference;", "intellij.platform.lang.impl"})
public final class DefaultGotoDeclarationProvider
implements GotoDeclarationProvider {
    @Override
    public void collectTargets(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull Consumer<? super NavigationTarget> consumer) {
        PsiElement[] psiElementArray;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull(consumer, (String)"consumer");
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        PsiElement[] elements = GotoDeclarationAction.findTargetElementsFromProviders(project, editor, caretModel.getOffset());
        if (elements != null && !(((PsiElement[])(object = (psiElementArray = elements))).length == 0)) {
            PsiElement[] psiElementArray2 = elements;
            int n = psiElementArray2.length;
            for (int i = 0; i < n; ++i) {
                PsiElement element;
                PsiElement psiElement = element = psiElementArray2[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"element");
                consumer.accept(new PsiElementNavigationTarget(psiElement));
            }
            return;
        }
        for (SymbolReference reference : this.findReferences(editor, file2)) {
            Iterator iterator = reference.resolveReference().iterator();
            while (iterator.hasNext()) {
                SymbolResolveResult resolveResult;
                SymbolResolveResult symbolResolveResult = resolveResult = (SymbolResolveResult)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)symbolResolveResult, (String)"resolveResult");
                Symbol symbol = symbolResolveResult.getTarget();
                Intrinsics.checkExpressionValueIsNotNull((Object)symbol, (String)"resolveResult.target");
                this.collectTargets(symbol, consumer);
            }
        }
    }

    private final Collection<SymbolReference> findReferences(Editor editor, PsiFile file2) {
        Document document = editor.getDocument();
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        int offset = TargetElementUtil.adjustOffset(file2, document, caretModel.getOffset());
        PsiReference reference = file2.findReferenceAt(offset);
        return reference == null ? (Collection)CollectionsKt.emptyList() : (Collection)CollectionsKt.listOf((Object)reference);
    }

    private final void collectTargets(Symbol symbol, Consumer<? super NavigationTarget> consumer) {
        Symbol symbol2 = symbol;
        if (symbol2 instanceof PsiElement) {
            consumer.accept(new PsiElementNavigationTarget((PsiElement)symbol));
        } else if (symbol2 instanceof PsiElementSymbol) {
            PsiElement psiElement = ((PsiElementSymbol)symbol).getElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"symbol.element");
            consumer.accept(new PsiElementNavigationTarget(psiElement));
        }
    }
}

