/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.IntentionsUI;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.FeatureUsageTrackerImpl;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.IntentionsCollector;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.stubs.StubTextInconsistencyException;
import com.intellij.util.PairProcessor;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowIntentionActionsHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        LookupEx lookup;
        if (project == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(2);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
            file2 = InjectedLanguageManager.getInstance((Project)file2.getProject()).getTopLevelFile((PsiElement)file2);
        }
        if ((lookup = LookupManager.getActiveLookup(editor)) != null) {
            lookup.showElementActions();
            return;
        }
        DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project);
        ShowIntentionActionsHandler.letAutoImportComplete(editor, file2, codeAnalyzer);
        ShowIntentionsPass.IntentionsInfo intentions = ShowIntentionsPass.getActionsToShow(editor, file2);
        IntentionsUI.getInstance(project).hide();
        if (HintManagerImpl.getInstanceImpl().performCurrentQuestionAction()) {
            return;
        }
        TemplateState state = TemplateManagerImpl.getTemplateState(editor);
        if (state != null && !state.isFinished()) {
            return;
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        Editor finalEditor = editor;
        PsiFile finalFile = file2;
        editor.getScrollingModel().runActionOnScrollingFinished(() -> this.showIntentionHint(project, finalEditor, finalFile, intentions));
    }

    protected void showIntentionHint(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull ShowIntentionsPass.IntentionsInfo intentions) {
        if (project == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(5);
        }
        if (intentions == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(6);
        }
        if (!intentions.isEmpty()) {
            CachedIntentions cachedIntentions = CachedIntentions.createAndUpdateActions(project, file2, editor, intentions);
            IntentionHintComponent.showIntentionHint(project, file2, editor, true, cachedIntentions);
        }
    }

    private static void letAutoImportComplete(@NotNull Editor editor, @NotNull PsiFile file2, DaemonCodeAnalyzerImpl codeAnalyzer) {
        if (editor == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(8);
        }
        CommandProcessor.getInstance().runUndoTransparentAction(() -> codeAnalyzer.autoImportReferenceAtCursor(editor, file2));
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static boolean availableFor(@NotNull PsiFile psiFile, @NotNull Editor editor, @NotNull IntentionAction action) {
        if (psiFile == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(10);
        }
        if (action == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(11);
        }
        if (!psiFile.isValid()) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement psiElement = psiFile.findElementAt(offset);
        try {
            Project project = psiFile.getProject();
            if (action instanceof IntentionActionDelegate) {
                action = ((IntentionActionDelegate)action).getDelegate();
            }
            if (action instanceof IntentionActionDelegate) {
                action = ((IntentionActionDelegate)action).getDelegate();
            }
            if (action instanceof SuppressIntentionActionFromFix) {
                ThreeState shouldBeAppliedToInjectionHost = ((SuppressIntentionActionFromFix)action).isShouldBeAppliedToInjectionHost();
                if (editor instanceof EditorWindow && shouldBeAppliedToInjectionHost == ThreeState.YES) {
                    return false;
                }
                if (!(editor instanceof EditorWindow) && shouldBeAppliedToInjectionHost == ThreeState.NO) {
                    return false;
                }
            }
            if (action instanceof PsiElementBaseIntentionAction) {
                PsiElementBaseIntentionAction psiAction = (PsiElementBaseIntentionAction)action;
                if (psiElement == null || !psiAction.checkFile(psiFile) || !psiAction.isAvailable(project, editor, psiElement)) {
                    return false;
                }
            } else if (!action.isAvailable(project, editor, psiFile)) {
                return false;
            }
        }
        catch (IndexNotReadyException e) {
            return false;
        }
        return true;
    }

    @Nullable
    public static Pair<PsiFile, Editor> chooseBetweenHostAndInjected(@NotNull PsiFile hostFile, @NotNull Editor hostEditor, @NotNull PairProcessor<? super PsiFile, ? super Editor> predicate) {
        Editor injectedEditor;
        if (hostFile == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(12);
        }
        if (hostEditor == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(13);
        }
        if (predicate == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(14);
        }
        Editor editorToApply = null;
        PsiFile fileToApply = null;
        int offset = hostEditor.getCaretModel().getOffset();
        PsiFile injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(hostFile, offset);
        if (injectedFile != null && predicate.process((Object)injectedFile, (Object)(injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(hostEditor, injectedFile)))) {
            editorToApply = injectedEditor;
            fileToApply = injectedFile;
        }
        if (editorToApply == null && predicate.process((Object)hostFile, (Object)hostEditor)) {
            editorToApply = hostEditor;
            fileToApply = hostFile;
        }
        if (editorToApply == null) {
            return null;
        }
        return Pair.create(fileToApply, editorToApply);
    }

    public static boolean chooseActionAndInvoke(@NotNull PsiFile hostFile, @NotNull Editor hostEditor, @NotNull IntentionAction action, @NotNull String text) {
        if (hostFile == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(15);
        }
        if (hostEditor == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(16);
        }
        if (action == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(17);
        }
        if (text == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(18);
        }
        Project project = hostFile.getProject();
        return ShowIntentionActionsHandler.chooseActionAndInvoke(hostFile, hostEditor, action, text, project);
    }

    static boolean chooseActionAndInvoke(@NotNull PsiFile hostFile, @Nullable Editor hostEditor, @NotNull IntentionAction action, @NotNull String text, @NotNull Project project) {
        if (hostFile == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(19);
        }
        if (action == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(20);
        }
        if (text == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(21);
        }
        if (project == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(22);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.quickFix");
        ((FeatureUsageTrackerImpl)FeatureUsageTracker.getInstance()).getFixesStats().registerInvocation();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        Pair<PsiFile, Editor> pair = ShowIntentionActionsHandler.chooseFileForAction(hostFile, hostEditor, action);
        if (pair == null) {
            return false;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> TransactionGuard.getInstance().submitTransactionAndWait(() -> ShowIntentionActionsHandler.invokeIntention(action, (Editor)pair.second, (PsiFile)pair.first)), text, null);
        ShowIntentionActionsHandler.checkPsiTextConsistency(hostFile);
        return true;
    }

    private static void checkPsiTextConsistency(@NotNull PsiFile hostFile) {
        if (hostFile == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(23);
        }
        if ((Registry.is((String)"ide.check.stub.text.consistency") || ApplicationManager.getApplication().isUnitTestMode() && !ApplicationInfoImpl.isInStressTest()) && hostFile.isValid()) {
            StubTextInconsistencyException.checkStubTextConsistency(hostFile);
        }
    }

    private static void invokeIntention(@NotNull IntentionAction action, @Nullable Editor editor, @NotNull PsiFile file2) {
        if (action == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(24);
        }
        if (file2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(25);
        }
        IntentionsCollector.getInstance().record(file2.getProject(), action, file2.getLanguage());
        PsiElement elementToMakeWritable = action.getElementToMakeWritable(file2);
        if (elementToMakeWritable != null && !FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{elementToMakeWritable})) {
            return;
        }
        Runnable r = () -> action.invoke(file2.getProject(), editor, file2);
        if (action.startInWriteAction()) {
            WriteAction.run(r::run);
        } else {
            r.run();
        }
    }

    @Nullable
    public static Pair<PsiFile, Editor> chooseFileForAction(@NotNull PsiFile hostFile, @Nullable Editor hostEditor, @NotNull IntentionAction action) {
        if (hostFile == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(26);
        }
        if (action == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(27);
        }
        return hostEditor == null ? Pair.create((Object)hostFile, null) : ShowIntentionActionsHandler.chooseBetweenHostAndInjected(hostFile, hostEditor, (PairProcessor<? super PsiFile, ? super Editor>)((PairProcessor)(psiFile, editor) -> ShowIntentionActionsHandler.availableFor(psiFile, editor, action)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentions";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 11: 
            case 17: 
            case 20: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 12: 
            case 15: 
            case 19: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFile";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostEditor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "showIntentionHint";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "letAutoImportComplete";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "availableFor";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "chooseBetweenHostAndInjected";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "chooseActionAndInvoke";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "checkPsiTextConsistency";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeIntention";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "chooseFileForAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

