/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.moveLeftRight;

import com.intellij.codeInsight.editorActions.moveLeftRight.MoveElementLeftRightHandler;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorLastActionTracker;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Range;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveElementLeftRightActionHandler
extends EditorWriteActionHandler {
    private static final Comparator<PsiElement> BY_OFFSET = (o1, o2) -> o1.getTextOffset() - o2.getTextOffset();
    private static final Set<String> OUR_ACTIONS = new HashSet<String>(Arrays.asList("MoveElementLeft", "MoveElementRight"));
    private final boolean myIsLeft;

    public MoveElementLeftRightActionHandler(boolean isLeft) {
        super(true);
        this.myIsLeft = isLeft;
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        Project project;
        if (editor == null) {
            MoveElementLeftRightActionHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            MoveElementLeftRightActionHandler.$$$reportNull$$$0(1);
        }
        if ((project = editor.getProject()) == null) {
            return false;
        }
        Document document = editor.getDocument();
        if (!(document instanceof DocumentEx)) {
            return false;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file2 == null) {
            return false;
        }
        PsiElement[] elementList = MoveElementLeftRightActionHandler.getElementList(file2, caret.getSelectionStart(), caret.getSelectionEnd());
        return elementList != null;
    }

    @Nullable
    private static PsiElement[] getElementList(@NotNull PsiFile file2, int rangeStart, int rangeEnd) {
        PsiElement startElement;
        if (file2 == null) {
            MoveElementLeftRightActionHandler.$$$reportNull$$$0(2);
        }
        if ((startElement = file2.findElementAt(rangeStart)) == null) {
            return null;
        }
        if (rangeEnd > rangeStart) {
            PsiElement endElement = file2.findElementAt(rangeEnd - 1);
            if (endElement == null) {
                return null;
            }
            PsiElement element = PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement);
            return MoveElementLeftRightActionHandler.getElementList(element, rangeStart, rangeEnd);
        }
        PsiElement[] list2 = MoveElementLeftRightActionHandler.getElementList(startElement, rangeStart, rangeStart);
        if (list2 != null || rangeStart <= 0) {
            return list2;
        }
        startElement = file2.findElementAt(rangeStart - 1);
        if (startElement == null) {
            return null;
        }
        return MoveElementLeftRightActionHandler.getElementList(startElement, rangeStart, rangeStart);
    }

    @Nullable
    private static PsiElement[] getElementList(PsiElement element, int rangeStart, int rangeEnd) {
        while (element != null) {
            List handlers = MoveElementLeftRightHandler.EXTENSION.allForLanguageOrAny(element.getLanguage());
            for (MoveElementLeftRightHandler handler2 : handlers) {
                PsiElement[] elementList = handler2.getMovableSubElements(element);
                if (elementList.length <= 1) continue;
                PsiElement[] elements = (PsiElement[])elementList.clone();
                Arrays.sort(elements, BY_OFFSET);
                PsiElement first = elements[0];
                PsiElement last = elements[elements.length - 1];
                if (rangeStart < first.getTextRange().getStartOffset() || rangeEnd > last.getTextRange().getEndOffset() || rangeStart < first.getTextRange().getEndOffset() && rangeEnd > last.getTextRange().getStartOffset()) continue;
                return elements;
            }
            element = element.getParent();
        }
        return null;
    }

    public void executeWriteAction(Editor editor, @Nullable Caret caret, DataContext dataContext) {
        int caretShift;
        assert (caret != null);
        DocumentEx document = (DocumentEx)editor.getDocument();
        Project project = editor.getProject();
        assert (project != null);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        PsiFile file2 = psiDocumentManager.getPsiFile((Document)document);
        assert (file2 != null);
        int selectionStart = caret.getSelectionStart();
        int selectionEnd = caret.getSelectionEnd();
        assert (selectionStart <= selectionEnd);
        PsiElement[] elementList = MoveElementLeftRightActionHandler.getElementList(file2, selectionStart, selectionEnd);
        assert (elementList != null);
        Range<Integer> elementRange = this.findRangeOfElementsToMove(elementList, selectionStart, selectionEnd);
        if (elementRange == null) {
            return;
        }
        if (!OUR_ACTIONS.contains(EditorLastActionTracker.getInstance().getLastActionId())) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("move.element.left.right");
        }
        int toMoveStart = elementList[(Integer)elementRange.getFrom()].getTextRange().getStartOffset();
        int toMoveEnd = elementList[(Integer)elementRange.getTo()].getTextRange().getEndOffset();
        int otherIndex = this.myIsLeft ? (Integer)elementRange.getFrom() - 1 : (Integer)elementRange.getTo() + 1;
        int otherStart = elementList[otherIndex].getTextRange().getStartOffset();
        int otherEnd = elementList[otherIndex].getTextRange().getEndOffset();
        selectionStart = MoveElementLeftRightActionHandler.trim(selectionStart, toMoveStart, toMoveEnd);
        selectionEnd = MoveElementLeftRightActionHandler.trim(selectionEnd, toMoveStart, toMoveEnd);
        int caretOffset = MoveElementLeftRightActionHandler.trim(caret.getOffset(), toMoveStart, toMoveEnd);
        if (toMoveStart < otherStart) {
            document.moveText(toMoveStart, toMoveEnd, otherStart);
            document.moveText(otherStart, otherEnd, toMoveStart);
            caretShift = otherEnd - toMoveEnd;
        } else {
            document.moveText(otherStart, otherEnd, toMoveStart);
            document.moveText(toMoveStart, toMoveEnd, otherStart);
            caretShift = otherStart - toMoveStart;
        }
        caret.moveToOffset(caretOffset + caretShift);
        caret.setSelection(selectionStart + caretShift, selectionEnd + caretShift);
    }

    @Nullable
    private Range<Integer> findRangeOfElementsToMove(@NotNull PsiElement[] elements, int startOffset, int endOffset) {
        if (elements == null) {
            MoveElementLeftRightActionHandler.$$$reportNull$$$0(3);
        }
        int startIndex = elements.length;
        int endIndex = -1;
        if (startOffset == endOffset) {
            for (int i = 0; i < elements.length; ++i) {
                if (!elements[i].getTextRange().containsOffset(startOffset)) continue;
                startIndex = endIndex = i;
                break;
            }
        } else {
            int i = 0;
            while (i < elements.length) {
                PsiElement psiElement = elements[i];
                TextRange range2 = psiElement.getTextRange();
                if (i < startIndex && startOffset < range2.getEndOffset()) {
                    startIndex = i;
                }
                if (endOffset > range2.getStartOffset()) {
                    endIndex = i++;
                    continue;
                }
                break;
            }
        }
        return startIndex > endIndex || (this.myIsLeft ? startIndex == 0 : endIndex == elements.length - 1) ? null : new Range((Comparable)Integer.valueOf(startIndex), (Comparable)Integer.valueOf(endIndex));
    }

    private static int trim(int offset, int rangeStart, int rangeEnd) {
        return Math.max(rangeStart, Math.min(rangeEnd, offset));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/moveLeftRight/MoveElementLeftRightActionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForCaret";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementList";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findRangeOfElementsToMove";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

