/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.ErrorQuickFixProvider;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlErrorQuickFixProvider
implements ErrorQuickFixProvider {
    @NonNls
    private static final String AMP_ENTITY = "&amp;";

    @Override
    public void registerErrorQuickFix(@NotNull PsiErrorElement element, @NotNull HighlightInfo highlightInfo) {
        if (element == null) {
            XmlErrorQuickFixProvider.$$$reportNull$$$0(0);
        }
        if (highlightInfo == null) {
            XmlErrorQuickFixProvider.$$$reportNull$$$0(1);
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class) != null) {
            XmlErrorQuickFixProvider.registerXmlErrorQuickFix(element, highlightInfo);
        }
    }

    private static void registerXmlErrorQuickFix(final PsiErrorElement element, HighlightInfo highlightInfo) {
        String text = element.getErrorDescription();
        if (text.startsWith(XmlErrorMessages.message("unescaped.ampersand", new Object[0]))) {
            QuickFixAction.registerQuickFixAction(highlightInfo, new IntentionAction(){

                @NotNull
                public String getText() {
                    String string = XmlErrorMessages.message("escape.ampersand.quickfix", new Object[0]);
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @NotNull
                public String getFamilyName() {
                    String string = this.getText();
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
                    if (project == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return true;
                }

                public void invoke(@NotNull Project project, Editor editor, PsiFile file2) {
                    if (project == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)file2);
                    Document document = PsiDocumentManager.getInstance((Project)project).getDocument(topLevelFile);
                    assert (document != null);
                    int textOffset = element.getTextOffset();
                    document.replaceString(textOffset, textOffset + 1, (CharSequence)XmlErrorQuickFixProvider.AMP_ENTITY);
                }

                public boolean startInWriteAction() {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 2: 
                        case 3: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 2: 
                        case 3: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/XmlErrorQuickFixProvider$1";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getText";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getFamilyName";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/XmlErrorQuickFixProvider$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "isAvailable";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray;
                            objectArray[2] = "invoke";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 2: 
                        case 3: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "highlightInfo";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/daemon/impl/analysis/XmlErrorQuickFixProvider";
        objectArray[2] = "registerErrorQuickFix";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

