/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ObjectIntMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WholeFileLocalInspectionsPassFactory
implements TextEditorHighlightingPassFactory,
ProjectComponent {
    private final Set<PsiFile> mySkipWholeInspectionsCache = ContainerUtil.createWeakSet();
    private final ObjectIntMap<PsiFile> myPsiModificationCount = ContainerUtil.createWeakKeyIntValueMap();
    private final Project myProject;

    public WholeFileLocalInspectionsPassFactory(Project project, TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        this.myProject = project;
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{7}, true, 12);
    }

    public void projectOpened() {
        ProjectInspectionProfileManager profileManager = ProjectInspectionProfileManager.getInstance(this.myProject);
        profileManager.addProfileChangeListener(new ProfileChangeAdapter(){

            public void profileChanged(InspectionProfile profile2) {
                WholeFileLocalInspectionsPassFactory.this.clearCaches();
            }

            public void profileActivated(InspectionProfile oldProfile, @Nullable InspectionProfile profile2) {
                WholeFileLocalInspectionsPassFactory.this.clearCaches();
            }
        }, (Disposable)this.myProject);
        Disposer.register((Disposable)this.myProject, this::clearCaches);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCaches() {
        Set<PsiFile> set2 = this.mySkipWholeInspectionsCache;
        synchronized (set2) {
            this.mySkipWholeInspectionsCache.clear();
        }
        set2 = this.myPsiModificationCount;
        synchronized (set2) {
            this.myPsiModificationCount.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(final @NotNull PsiFile file2, @NotNull Editor editor) {
        if (file2 == null) {
            WholeFileLocalInspectionsPassFactory.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            WholeFileLocalInspectionsPassFactory.$$$reportNull$$$0(1);
        }
        long actualCount = PsiManager.getInstance((Project)this.myProject).getModificationTracker().getModificationCount();
        Object object = this.myPsiModificationCount;
        synchronized (object) {
            if (this.myPsiModificationCount.get((Object)file2) == (int)actualCount) {
                return null;
            }
        }
        if (!ProblemHighlightFilter.shouldHighlightFile((PsiFile)file2)) {
            return null;
        }
        object = this.mySkipWholeInspectionsCache;
        synchronized (object) {
            if (this.mySkipWholeInspectionsCache.contains(file2)) {
                return null;
            }
        }
        ProperTextRange visibleRange = VisibleHighlightingPassFactory.calculateVisibleRange(editor);
        return new LocalInspectionsPass(file2, editor.getDocument(), 0, file2.getTextLength(), (TextRange)visibleRange, true, new DefaultHighlightInfoProcessor(), false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NotNull
            List<LocalInspectionToolWrapper> getInspectionTools(@NotNull InspectionProfileWrapper profile2) {
                List<LocalInspectionToolWrapper> tools;
                List result2;
                if (profile2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((result2 = ContainerUtil.filter(tools = super.getInspectionTools(profile2), LocalInspectionToolWrapper::runForWholeFile)).isEmpty()) {
                    Set set2 = WholeFileLocalInspectionsPassFactory.this.mySkipWholeInspectionsCache;
                    synchronized (set2) {
                        WholeFileLocalInspectionsPassFactory.this.mySkipWholeInspectionsCache.add(file2);
                    }
                }
                List list2 = result2;
                if (list2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return list2;
            }

            @Override
            protected String getPresentableName() {
                return DaemonBundle.message((String)"pass.whole.inspections", (Object[])new Object[0]);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void applyInformationWithProgress() {
                super.applyInformationWithProgress();
                long modificationCount = PsiManager.getInstance((Project)this.myProject).getModificationTracker().getModificationCount();
                ObjectIntMap objectIntMap = WholeFileLocalInspectionsPassFactory.this.myPsiModificationCount;
                synchronized (objectIntMap) {
                    WholeFileLocalInspectionsPassFactory.this.myPsiModificationCount.put((Object)file2, (int)modificationCount);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "profile";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getInspectionTools";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getInspectionTools";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory";
        objectArray[2] = "createHighlightingPass";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

