/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPass;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.TestModeFlags;
import org.jetbrains.annotations.NotNull;

public class IdentifierHighlighterPassFactory
implements TextEditorHighlightingPassFactory {
    private static final int[] AFTER_PASSES = new int[]{4};
    private static final Key<Boolean> ourTestingIdentifierHighlighting = Key.create((String)"TestingIdentifierHighlighting");
    private final Project myProject;

    public IdentifierHighlighterPassFactory(Project project, TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        this.myProject = project;
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, AFTER_PASSES, false, -1);
    }

    @Override
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        if (file2 == null) {
            IdentifierHighlighterPassFactory.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            IdentifierHighlighterPassFactory.$$$reportNull$$$0(1);
        }
        if (!(editor.isOneLineMode() || !CodeInsightSettings.getInstance().HIGHLIGHT_IDENTIFIER_UNDER_CARET || DumbService.isDumb((Project)this.myProject) || ApplicationManager.getApplication().isUnitTestMode() && !TestModeFlags.is(ourTestingIdentifierHighlighting) || !file2.isPhysical() && !file2.getOriginalFile().isPhysical())) {
            return new IdentifierHighlighterPass(file2.getProject(), file2, editor);
        }
        return null;
    }

    public static void doWithHighlightingEnabled(@NotNull Runnable r) {
        if (r == null) {
            IdentifierHighlighterPassFactory.$$$reportNull$$$0(2);
        }
        TestModeFlags.set(ourTestingIdentifierHighlighting, (Object)true);
        try {
            r.run();
        }
        finally {
            TestModeFlags.reset(ourTestingIdentifierHighlighting);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/IdentifierHighlighterPassFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightingPass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doWithHighlightingEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

