/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VcsAwareFormatChangedTextUtil
extends FormatChangedTextUtil {
    VcsAwareFormatChangedTextUtil() {
    }

    @Override
    @NotNull
    public List<TextRange> getChangedTextRanges(@NotNull Project project, @NotNull PsiFile file2) {
        ChangedRangesInfo helper;
        if (project == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(1);
        }
        List list2 = (helper = this.getChangedRangesInfo(file2)) != null ? helper.allChangedRanges : ContainerUtil.newArrayList();
        if (list2 == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Override
    @Nullable
    public ChangedRangesInfo getChangedRangesInfo(@NotNull PsiFile file2) {
        CharSequence testContent;
        Project project;
        Document document;
        if (file2 == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(3);
        }
        if ((document = PsiDocumentManager.getInstance((Project)(project = file2.getProject())).getDocument(file2)) == null) {
            return null;
        }
        ChangedRangesInfo cachedChangedTextHelper = VcsAwareFormatChangedTextUtil.getCachedChangedLines(project, document);
        if (cachedChangedTextHelper != null) {
            return cachedChangedTextHelper;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && (testContent = (CharSequence)file2.getUserData(TEST_REVISION_CONTENT)) != null) {
            return VcsAwareFormatChangedTextUtil.calculateChangedRangesInfo(document, testContent);
        }
        Change change = ChangeListManager.getInstance((Project)project).getChange(file2.getVirtualFile());
        if (change == null) {
            return null;
        }
        if (change.getType() == Change.Type.NEW) {
            TextRange fileRange = file2.getTextRange();
            return new ChangedRangesInfo((List)ContainerUtil.newArrayList((Object[])new TextRange[]{fileRange}), null);
        }
        String contentFromVcs = VcsAwareFormatChangedTextUtil.getRevisionedContentFrom(change);
        return contentFromVcs != null ? VcsAwareFormatChangedTextUtil.calculateChangedRangesInfo(document, contentFromVcs) : null;
    }

    @Override
    @NotNull
    public <T extends PsiElement> List<T> getChangedElements(@NotNull Project project, @NotNull Change[] changes2, @NotNull Function<? super VirtualFile, ? extends List<T>> elementsConvertor) {
        if (project == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(4);
        }
        if (changes2 == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(5);
        }
        if (elementsConvertor == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(6);
        }
        List result2 = ContainerUtil.newSmartList();
        for (Change change : changes2) {
            List elements;
            Document document;
            VirtualFile file2;
            if (change.getType() == Change.Type.DELETED || !(change.getAfterRevision() instanceof CurrentContentRevision) || (file2 = ((CurrentContentRevision)change.getAfterRevision()).getVirtualFile()) == null || (document = FileDocumentManager.getInstance().getDocument(file2)) == null) continue;
            List<T> apply2 = elementsConvertor.apply((VirtualFile)file2);
            List list2 = elements = apply2 == null ? null : ContainerUtil.skipNulls(apply2);
            if (ContainerUtil.isEmpty((Collection)elements)) continue;
            BitSet changedLines = VcsAwareFormatChangedTextUtil.getChangedLines(project, document, change);
            if (changedLines != null) {
                for (PsiElement element : elements) {
                    if (!VcsAwareFormatChangedTextUtil.isElementChanged(element, document, changedLines)) continue;
                    result2.add(element);
                }
                continue;
            }
            result2.addAll(elements);
        }
        List list3 = result2;
        if (list3 == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(7);
        }
        return list3;
    }

    @Nullable
    private static BitSet getChangedLines(@NotNull Project project, @NotNull Document document, @NotNull Change change) {
        if (project == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(8);
        }
        if (document == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(9);
        }
        if (change == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(10);
        }
        if (change.getType() == Change.Type.NEW) {
            return null;
        }
        List<? extends Range> ranges = VcsAwareFormatChangedTextUtil.getChangedRanges(project, document, change);
        if (ranges == null) {
            return null;
        }
        BitSet changedLines = new BitSet();
        for (Range range2 : ranges) {
            if (range2.getType() == 3) {
                changedLines.set(Math.max(0, range2.getLine1() - 1), range2.getLine1() + 1);
                continue;
            }
            changedLines.set(range2.getLine1(), range2.getLine2());
        }
        return changedLines;
    }

    @Nullable
    private static List<? extends Range> getChangedRanges(@NotNull Project project, @NotNull Document document, @NotNull Change change) {
        LineStatusTracker<?> tracker;
        if (project == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(11);
        }
        if (document == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(12);
        }
        if (change == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(13);
        }
        if ((tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(document)) != null) {
            if (change instanceof ChangeListChange && tracker instanceof PartialLocalLineStatusTracker) {
                String changeListId = ((ChangeListChange)change).getChangeListId();
                List ranges = ((PartialLocalLineStatusTracker)tracker).getRanges();
                if (ranges != null) {
                    return ContainerUtil.filter(ranges, range2 -> range2.getChangelistId().equals(changeListId));
                }
                return null;
            }
            return tracker.getRanges();
        }
        String contentFromVcs = VcsAwareFormatChangedTextUtil.getRevisionedContentFrom(change);
        if (contentFromVcs != null) {
            return VcsAwareFormatChangedTextUtil.getRanges(document, contentFromVcs);
        }
        return null;
    }

    private static boolean isElementChanged(@NotNull PsiElement element, @NotNull Document document, @NotNull BitSet changedLines) {
        if (element == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(14);
        }
        if (document == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(15);
        }
        if (changedLines == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(16);
        }
        TextRange textRange = element.getTextRange();
        int startLine = document.getLineNumber(textRange.getStartOffset());
        int endLine = textRange.isEmpty() ? startLine + 1 : document.getLineNumber(textRange.getEndOffset() - 1) + 1;
        int nextSetBit = changedLines.nextSetBit(startLine);
        return nextSetBit != -1 && nextSetBit < endLine;
    }

    @Nullable
    private static String getRevisionedContentFrom(@NotNull Change change) {
        ContentRevision revision;
        if (change == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(17);
        }
        if ((revision = change.getBeforeRevision()) == null) {
            return null;
        }
        try {
            return revision.getContent();
        }
        catch (VcsException e) {
            LOG.error("Can't get content for: " + change.getVirtualFile(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static ChangedRangesInfo getCachedChangedLines(@NotNull Project project, @NotNull Document document) {
        List ranges;
        LineStatusTracker<?> tracker;
        if (project == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(18);
        }
        if (document == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(19);
        }
        if ((tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(document)) != null && (ranges = tracker.getRanges()) != null) {
            return VcsAwareFormatChangedTextUtil.getChangedTextRanges(document, ranges);
        }
        return null;
    }

    @NotNull
    private static ChangedRangesInfo calculateChangedRangesInfo(@NotNull Document document, @NotNull CharSequence contentFromVcs) {
        if (document == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(20);
        }
        if (contentFromVcs == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(21);
        }
        ChangedRangesInfo changedRangesInfo = VcsAwareFormatChangedTextUtil.getChangedTextRanges(document, VcsAwareFormatChangedTextUtil.getRanges(document, contentFromVcs));
        if (changedRangesInfo == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(22);
        }
        return changedRangesInfo;
    }

    @NotNull
    private static List<Range> getRanges(@NotNull Document document, @NotNull CharSequence contentFromVcs) {
        if (document == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(23);
        }
        if (contentFromVcs == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(24);
        }
        List<Range> list2 = RangesBuilder.createRanges(document.getImmutableCharSequence(), StringUtilRt.convertLineSeparators((CharSequence)contentFromVcs, (String)"\n"));
        if (list2 == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(25);
        }
        return list2;
    }

    @Override
    public int calculateChangedLinesNumber(@NotNull Document document, @NotNull CharSequence contentFromVcs) {
        if (document == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(26);
        }
        if (contentFromVcs == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(27);
        }
        List<Range> changedRanges = VcsAwareFormatChangedTextUtil.getRanges(document, contentFromVcs);
        int linesChanges = 0;
        for (Range range2 : changedRanges) {
            int inserted = range2.getLine2() - range2.getLine1();
            int deleted = range2.getVcsLine2() - range2.getVcsLine1();
            linesChanges += Math.max(inserted, deleted);
        }
        return linesChanges;
    }

    @NotNull
    private static ChangedRangesInfo getChangedTextRanges(@NotNull Document document, @NotNull List<? extends Range> changedRanges) {
        if (document == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(28);
        }
        if (changedRanges == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(29);
        }
        ArrayList ranges = ContainerUtil.newArrayList();
        ArrayList insertedRanges = ContainerUtil.newArrayList();
        for (Range range2 : changedRanges) {
            if (range2.getType() == 3) continue;
            int changeStartLine = range2.getLine1();
            int changeEndLine = range2.getLine2();
            int lineStartOffset = document.getLineStartOffset(changeStartLine);
            int lineEndOffset = document.getLineEndOffset(changeEndLine - 1);
            TextRange changedTextRange = new TextRange(lineStartOffset, lineEndOffset);
            ranges.add(changedTextRange);
            if (range2.getType() != 2) continue;
            insertedRanges.add(changedTextRange);
        }
        ChangedRangesInfo changedRangesInfo = new ChangedRangesInfo((List)ranges, (List)insertedRanges);
        if (changedRangesInfo == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(30);
        }
        return changedRangesInfo;
    }

    @Override
    public boolean isChangeNotTrackedForFile(@NotNull Project project, @NotNull PsiFile file2) {
        boolean isUnderVcs;
        if (project == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(31);
        }
        if (file2 == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(32);
        }
        if (!(isUnderVcs = VcsUtil.isFileUnderVcs((Project)project, (FilePath)VcsUtil.getFilePath((VirtualFile)file2.getVirtualFile())))) {
            return true;
        }
        ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(project);
        List<VirtualFile> unversionedFiles = changeListManager.getUnversionedFiles();
        return unversionedFiles.contains(file2.getVirtualFile());
    }

    @Override
    public void runHeavyModificationTask(@NotNull Project project, @NotNull Document document, @NotNull Runnable o) {
        LineStatusTracker<?> tracker;
        if (project == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(33);
        }
        if (document == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(34);
        }
        if (o == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(35);
        }
        if ((tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(document)) != null) {
            tracker.doFrozen(o);
        } else {
            o.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 22: 
            case 25: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 22: 
            case 25: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 7: 
            case 22: 
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConvertor";
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 28: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 10: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedLines";
                break;
            }
            case 21: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentFromVcs";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedRanges";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil";
                break;
            }
            case 2: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedTextRanges";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedElements";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateChangedRangesInfo";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChangedTextRanges";
                break;
            }
            case 2: 
            case 7: 
            case 22: 
            case 25: 
            case 30: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getChangedRangesInfo";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChangedElements";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getChangedLines";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getChangedRanges";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isElementChanged";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRevisionedContentFrom";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCachedChangedLines";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "calculateChangedRangesInfo";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getRanges";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "calculateChangedLinesNumber";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isChangeNotTrackedForFile";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "runHeavyModificationTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 22: 
            case 25: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

