/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.editorActions.CompletionAutoPopupHandler;
import com.intellij.codeInsight.hint.ShowParameterInfoHandler;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoPopupController
implements Disposable {
    public static final Key<Boolean> ALWAYS_AUTO_POPUP = Key.create((String)"Always Show Completion Auto-Popup");
    public static final Key<Boolean> NO_ADS = Key.create((String)"Show Completion Auto-Popup without Ads");
    public static final Key<Boolean> AUTO_POPUP_ON_FOCUS_GAINED = Key.create((String)"Show Completion Auto-Popup On Focus Gained");
    private final Project myProject;
    private final Alarm myAlarm = new Alarm((Disposable)this);

    public static AutoPopupController getInstance(Project project) {
        return (AutoPopupController)ServiceManager.getService((Project)project, AutoPopupController.class);
    }

    public AutoPopupController(Project project) {
        this.myProject = project;
        this.setupListeners();
    }

    private void setupListeners() {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(AnActionListener.TOPIC, (Object)new AnActionListener(){

            public void beforeActionPerformed(@NotNull AnAction action, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
                if (action == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (dataContext == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                AutoPopupController.this.cancelAllRequests();
            }

            public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
                if (dataContext == null) {
                    1.$$$reportNull$$$0(3);
                }
                AutoPopupController.this.cancelAllRequests();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "action";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataContext";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/AutoPopupController$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeActionPerformed";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeEditorTyping";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        IdeEventQueue.getInstance().addActivityListener(this::cancelAllRequests, this);
    }

    public void autoPopupMemberLookup(Editor editor, @Nullable Condition<PsiFile> condition) {
        this.autoPopupMemberLookup(editor, CompletionType.BASIC, condition);
    }

    public void autoPopupMemberLookup(Editor editor, CompletionType completionType, @Nullable Condition<PsiFile> condition) {
        this.scheduleAutoPopup(editor, completionType, condition);
    }

    public void scheduleAutoPopup(@NotNull Editor editor, @NotNull CompletionType completionType, @Nullable Condition<PsiFile> condition) {
        if (editor == null) {
            AutoPopupController.$$$reportNull$$$0(0);
        }
        if (completionType == null) {
            AutoPopupController.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !TestModeFlags.is(CompletionAutoPopupHandler.ourTestingAutopopup)) {
            return;
        }
        boolean alwaysAutoPopup = Boolean.TRUE.equals(editor.getUserData(ALWAYS_AUTO_POPUP));
        if (!CodeInsightSettings.getInstance().AUTO_POPUP_COMPLETION_LOOKUP && !alwaysAutoPopup) {
            return;
        }
        if (PowerSaveMode.isEnabled()) {
            return;
        }
        if (!CompletionServiceImpl.isPhase(CompletionPhase.CommittingDocuments.class, CompletionPhase.NoCompletion.getClass())) {
            return;
        }
        CompletionProgressIndicator currentCompletion = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
        if (currentCompletion != null) {
            currentCompletion.closeAndFinish(true);
        }
        CompletionPhase.CommittingDocuments.scheduleAsyncCompletion(editor, completionType, condition, this.myProject, null);
    }

    public void scheduleAutoPopup(Editor editor) {
        this.scheduleAutoPopup(editor, CompletionType.BASIC, null);
    }

    private void addRequest(Runnable request, int delay) {
        Runnable runnable2 = () -> {
            if (!this.myAlarm.isDisposed()) {
                this.myAlarm.addRequest(request, delay);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable2.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable2);
        }
    }

    public void cancelAllRequests() {
        this.myAlarm.cancelAllRequests();
    }

    public void autoPopupParameterInfo(@NotNull Editor editor, @Nullable PsiElement highlightedMethod) {
        if (editor == null) {
            AutoPopupController.$$$reportNull$$$0(2);
        }
        if (DumbService.isDumb((Project)this.myProject)) {
            return;
        }
        if (PowerSaveMode.isEnabled()) {
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        if (settings.AUTO_POPUP_PARAMETER_INFO) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
            PsiFile file2 = documentManager.getPsiFile(editor.getDocument());
            if (file2 == null) {
                return;
            }
            if (!documentManager.isUncommited(editor.getDocument()) && (file2 = documentManager.getPsiFile(InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, file2).getDocument())) == null) {
                return;
            }
            Runnable request = () -> {
                if (!(this.myProject.isDisposed() || DumbService.isDumb((Project)this.myProject) || editor.isDisposed() || !ApplicationManager.getApplication().isHeadlessEnvironment() && !editor.getComponent().isShowing())) {
                    int lbraceOffset = editor.getCaretModel().getOffset() - 1;
                    try {
                        PsiFile file1 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
                        if (file1 != null) {
                            ShowParameterInfoHandler.invoke(this.myProject, editor, file1, lbraceOffset, highlightedMethod, false, true);
                        }
                    }
                    catch (IndexNotReadyException indexNotReadyException) {
                        // empty catch block
                    }
                }
            };
            this.addRequest(() -> documentManager.performLaterWhenAllCommitted(request), settings.PARAMETER_INFO_DELAY);
        }
    }

    public void dispose() {
    }

    public static void runTransactionWithEverythingCommitted(@NotNull Project project, @NotNull Runnable runnable2) {
        if (project == null) {
            AutoPopupController.$$$reportNull$$$0(3);
        }
        if (runnable2 == null) {
            AutoPopupController.$$$reportNull$$$0(4);
        }
        AppUIExecutor.onUiThread().later().withDocumentsCommitted(project).inTransaction((Disposable)project).execute(runnable2);
    }

    /*
     * WARNING - void declaration
     */
    public void waitForDelayedActions(long timeout, @NotNull TimeUnit timeUnit) throws TimeoutException {
        void unit;
        if (timeUnit == null) {
            AutoPopupController.$$$reportNull$$$0(5);
        }
        long deadline = System.currentTimeMillis() + unit.toMillis(timeout);
        while (System.currentTimeMillis() < deadline) {
            if (this.myAlarm.isEmpty()) {
                return;
            }
            LockSupport.parkNanos(10000000L);
            UIUtil.dispatchAllInvocationEvents();
        }
        throw new TimeoutException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/AutoPopupController";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleAutoPopup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "autoPopupParameterInfo";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "runTransactionWithEverythingCommitted";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "waitForDelayedActions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

