/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildContentManager;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.process.BuildProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.BaseContentCloseListener;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.TabbedContent;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class BuildContentManagerImpl
implements BuildContentManager {
    public static final String Build = "Build";
    public static final String Sync = "Sync";
    public static final String Run = "Run";
    public static final String Debug = "Debug";
    private static final String[] ourPresetOrder = new String[]{"Build", "Sync", "Run", "Debug"};
    private static final Key<Map<Object, CloseListener>> CONTENT_CLOSE_LISTENERS = Key.create((String)"CONTENT_CLOSE_LISTENERS");
    private Project myProject;
    private ToolWindow myToolWindow;
    private final List<Runnable> myPostponedRunnables = new ArrayList<Runnable>();
    private final Map<Content, Pair<Icon, AtomicInteger>> liveContentsMap = ContainerUtil.newConcurrentMap();

    public BuildContentManagerImpl(Project project) {
        this.init(project);
    }

    private void init(Project project) {
        this.myProject = project;
        if (project.isDefault()) {
            return;
        }
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).registerToolWindow(ToolWindowId.BUILD, true, ToolWindowAnchor.BOTTOM, (Disposable)project, true);
            toolWindow.setIcon(AllIcons.Toolwindows.ToolWindowBuild);
            toolWindow.setAvailable(true, null);
            toolWindow.hide(null);
            this.myToolWindow = toolWindow;
            final ContentManager contentManager = this.myToolWindow.getContentManager();
            contentManager.addDataProvider(new DataProvider(){
                private int myInsideGetData = 0;

                public Object getData(@NotNull String dataId) {
                    if (dataId == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ++this.myInsideGetData;
                    try {
                        Object object = this.myInsideGetData == 1 ? DataManager.getInstance().getDataContext((Component)contentManager.getComponent()).getData(dataId) : null;
                        return object;
                    }
                    finally {
                        --this.myInsideGetData;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/build/BuildContentManagerImpl$1", "getData"));
                }
            });
            new ContentManagerWatcher(toolWindow, contentManager);
            for (Runnable postponedRunnable : this.myPostponedRunnables) {
                postponedRunnable.run();
            }
            this.myPostponedRunnables.clear();
        });
    }

    public Promise<Void> runWhenInitialized(Runnable runnable2) {
        if (this.myToolWindow != null) {
            runnable2.run();
            return Promises.resolvedPromise(null);
        }
        AsyncPromise promise = new AsyncPromise();
        this.myPostponedRunnables.add(() -> {
            if (!this.myProject.isDisposed()) {
                runnable2.run();
                promise.setResult(null);
            }
        });
        return promise;
    }

    public void addContent(Content content) {
        this.runWhenInitialized(() -> {
            if (!this.myToolWindow.isAvailable()) {
                this.myToolWindow.setAvailable(true, null);
            }
            ContentManager contentManager = this.myToolWindow.getContentManager();
            String name = content.getTabName();
            String category = StringUtil.trimEnd((String)((String)StringUtil.split((String)name, (String)" ").get(0)), (char)':');
            int idx = -1;
            for (int i = 0; i < ourPresetOrder.length; ++i) {
                String s = ourPresetOrder[i];
                if (!s.equals(category)) continue;
                idx = i;
                break;
            }
            Content[] existingContents = contentManager.getContents();
            if (idx != -1) {
                Content[] existingCategoriesNames = MultiMap.createSmart();
                Content[] contentArray = existingContents;
                int n = contentArray.length;
                for (int i = 0; i < n; ++i) {
                    Content existingContent = contentArray[i];
                    String tabName = existingContent.getTabName();
                    existingCategoriesNames.putValue((Object)StringUtil.trimEnd((String)((String)StringUtil.split((String)tabName, (String)" ").get(0)), (char)':'), (Object)tabName);
                }
                int place = 0;
                for (int i = 0; i < idx; ++i) {
                    String key = ourPresetOrder[i];
                    Collection tabNames = existingCategoriesNames.get((Object)key);
                    if (key.equals(category)) continue;
                    place += tabNames.size();
                }
                contentManager.addContent(content, place);
            } else {
                contentManager.addContent(content);
            }
            for (Content existingContent : existingContents) {
                existingContent.setDisplayName(existingContent.getTabName());
            }
            String tabName = content.getTabName();
            this.updateTabDisplayName(content, tabName);
        });
    }

    public void updateTabDisplayName(Content content, String tabName) {
        this.runWhenInitialized(() -> {
            if (!tabName.equals(content.getDisplayName())) {
                content.setTabName(tabName);
                content.setDisplayName(tabName);
            }
        });
    }

    public void removeContent(Content content) {
        this.runWhenInitialized(() -> {
            ContentManager contentManager = this.myToolWindow.getContentManager();
            if (contentManager != null && !contentManager.isDisposed()) {
                contentManager.removeContent(content, true);
            }
        });
    }

    public ActionCallback setSelectedContent(@NotNull Content content, boolean requestFocus, boolean forcedFocus, boolean activate, @Nullable Runnable activationCallback) {
        if (content == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(0);
        }
        ActionCallback actionCallback = new ActionCallback();
        Disposer.register((Disposable)content, (Disposable)actionCallback);
        this.runWhenInitialized(() -> {
            if (!this.myToolWindow.isAvailable()) {
                actionCallback.setRejected();
                return;
            }
            if (activate) {
                this.myToolWindow.show(activationCallback);
            }
            ActionCallback callback2 = this.myToolWindow.getContentManager().setSelectedContent(content, requestFocus, forcedFocus, false);
            callback2.notify(actionCallback);
        });
        return actionCallback;
    }

    public Content addTabbedContent(@NotNull JComponent contentComponent, @NotNull String groupPrefix, @NotNull String tabName, @Nullable Icon icon, @Nullable Disposable childDisposable) {
        TabbedContent tabbedContent;
        if (contentComponent == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(1);
        }
        if (groupPrefix == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(2);
        }
        if (tabName == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(3);
        }
        ContentManager contentManager = this.myToolWindow.getContentManager();
        ContentUtilEx.addTabbedContent(contentManager, contentComponent, groupPrefix, tabName, false, childDisposable);
        Content content = contentManager.findContent(ContentUtilEx.getFullName(groupPrefix, tabName));
        if (icon != null && (tabbedContent = ContentUtilEx.findTabbedContent(contentManager, groupPrefix)) != null) {
            tabbedContent.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
            tabbedContent.setIcon(icon);
        }
        return content;
    }

    public void startBuildNotified(@NotNull BuildDescriptor buildDescriptor, @NotNull Content content, @Nullable BuildProcessHandler processHandler2) {
        if (buildDescriptor == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(4);
        }
        if (content == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(5);
        }
        if (processHandler2 != null) {
            Map closeListenerMap = (Map)content.getUserData(CONTENT_CLOSE_LISTENERS);
            if (closeListenerMap == null) {
                closeListenerMap = ContainerUtil.newHashMap();
                content.putUserData(CONTENT_CLOSE_LISTENERS, (Object)closeListenerMap);
            }
            closeListenerMap.put(buildDescriptor.getId(), new CloseListener(content, processHandler2));
        }
        this.runWhenInitialized(() -> {
            Pair pair = this.liveContentsMap.computeIfAbsent(content, c -> Pair.pair((Object)c.getIcon(), (Object)new AtomicInteger(0)));
            ((AtomicInteger)pair.second).incrementAndGet();
            content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
            if (pair.first == null) {
                content.putUserData(Content.TAB_LABEL_ORIENTATION_KEY, (Object)ComponentOrientation.RIGHT_TO_LEFT);
            }
            content.setIcon(ExecutionUtil.getLiveIndicator((Icon)((Icon)pair.first), (int)0, (int)13));
            JComponent component = content.getComponent();
            if (component != null) {
                component.invalidate();
            }
            this.myToolWindow.setIcon(ExecutionUtil.getLiveIndicator((Icon)AllIcons.Toolwindows.ToolWindowBuild));
        });
    }

    public void finishBuildNotified(@NotNull BuildDescriptor buildDescriptor, @NotNull Content content) {
        CloseListener closeListener;
        Map closeListenerMap;
        if (buildDescriptor == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(6);
        }
        if (content == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(7);
        }
        if ((closeListenerMap = (Map)content.getUserData(CONTENT_CLOSE_LISTENERS)) != null && (closeListener = (CloseListener)((Object)closeListenerMap.remove(buildDescriptor.getId()))) != null) {
            closeListener.dispose();
            if (closeListenerMap.isEmpty()) {
                content.putUserData(CONTENT_CLOSE_LISTENERS, null);
            }
        }
        this.runWhenInitialized(() -> {
            Pair<Icon, AtomicInteger> pair = this.liveContentsMap.get(content);
            if (pair != null && ((AtomicInteger)pair.second).decrementAndGet() == 0) {
                content.setIcon((Icon)pair.first);
                if (pair.first == null) {
                    content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.FALSE);
                }
                this.liveContentsMap.remove(content);
                if (this.liveContentsMap.isEmpty()) {
                    this.myToolWindow.setIcon(AllIcons.Toolwindows.ToolWindowBuild);
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupPrefix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabName";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildDescriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/build/BuildContentManagerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelectedContent";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addTabbedContent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "startBuildNotified";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "finishBuildNotified";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class CloseListener
    extends BaseContentCloseListener {
        @Nullable
        private BuildProcessHandler myProcessHandler;

        private CloseListener(@NotNull Content content, BuildProcessHandler processHandler2) {
            if (content == null) {
                CloseListener.$$$reportNull$$$0(0);
            }
            if (processHandler2 == null) {
                CloseListener.$$$reportNull$$$0(1);
            }
            super(content, BuildContentManagerImpl.this.myProject);
            this.myProcessHandler = processHandler2;
        }

        @Override
        protected void disposeContent(@NotNull Content content) {
            if (content == null) {
                CloseListener.$$$reportNull$$$0(2);
            }
            if (this.myProcessHandler instanceof Disposable) {
                Disposer.dispose((Disposable)((Disposable)this.myProcessHandler));
            }
            this.myProcessHandler = null;
        }

        @Override
        protected boolean closeQuery(@NotNull Content content, boolean modal) {
            if (content == null) {
                CloseListener.$$$reportNull$$$0(3);
            }
            if (this.myProcessHandler == null || this.myProcessHandler.isProcessTerminated() || this.myProcessHandler.isProcessTerminating()) {
                return true;
            }
            this.myProcessHandler.putUserData(RunContentManagerImpl.ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY, (Object)Boolean.TRUE);
            String sessionName = this.myProcessHandler.getExecutionName();
            BaseContentCloseListener.WaitForProcessTask task2 = new BaseContentCloseListener.WaitForProcessTask((ProcessHandler)this.myProcessHandler, sessionName, modal, BuildContentManagerImpl.this.myProject){

                @Override
                public void onCancel() {
                    CloseListener.this.myProcessHandler.forceProcessDetach();
                }
            };
            return this.askUserAndWait((ProcessHandler)this.myProcessHandler, sessionName, task2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processHandler";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/build/BuildContentManagerImpl$CloseListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "disposeContent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "closeQuery";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

