/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.bootRuntime.command;

import com.intellij.bootRuntime.BinTrayUtil;
import com.intellij.bootRuntime.Controller;
import com.intellij.bootRuntime.bundles.Runtime;
import com.intellij.bootRuntime.command.RuntimeCommand;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.jetbrains.io.TarKt;

public class Extract
extends RuntimeCommand {
    public Extract(Project project, Controller controller, Runtime runtime) {
        super(project, controller, "Extract", runtime);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.runWithProgress("Extracting...", indicator -> {
            File directoryToExtractFile;
            String archiveFileName = this.getRuntime().getFileName();
            String directoryToExtractName = BinTrayUtil.archveToDirectoryName(archiveFileName);
            File jdkStoragePathFile = BinTrayUtil.getJdkStoragePathFile();
            if (!jdkStoragePathFile.exists()) {
                FileUtil.createDirectory((File)jdkStoragePathFile);
            }
            if (!(directoryToExtractFile = new File(jdkStoragePathFile, directoryToExtractName)).exists()) {
                FileUtil.createDirectory((File)directoryToExtractFile);
                try (FileInputStream inputStream = new FileInputStream(this.myRuntime.getDownloadPath());){
                    TarKt.unpackTarGz(inputStream, directoryToExtractFile.toPath());
                    FileUtil.delete((File)this.myRuntime.getDownloadPath());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            BinTrayUtil.updateJdkConfigFileAndRestart(directoryToExtractFile);
        });
    }
}

