/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.bootRuntime;

import com.intellij.bootRuntime.BinTrayUtil;
import com.intellij.bootRuntime.BundleState;
import com.intellij.bootRuntime.bundles.Remote;
import com.intellij.bootRuntime.bundles.Runtime;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/bootRuntime/Model;", "", "selectedBundle", "Lcom/intellij/bootRuntime/bundles/Runtime;", "bundles", "", "(Lcom/intellij/bootRuntime/bundles/Runtime;Ljava/util/List;)V", "getBundles", "()Ljava/util/List;", "getSelectedBundle", "()Lcom/intellij/bootRuntime/bundles/Runtime;", "setSelectedBundle", "(Lcom/intellij/bootRuntime/bundles/Runtime;)V", "currentState", "Lcom/intellij/bootRuntime/BundleState;", "isDownloaded", "", "bundle", "isExtracted", "isInstalled", "isRemote", "updateBundle", "", "newBundle", "intellij.platform.lang.impl"})
public final class Model {
    @NotNull
    private Runtime selectedBundle;
    @NotNull
    private final List<Runtime> bundles;

    public final void updateBundle(@NotNull Runtime newBundle) {
        Intrinsics.checkParameterIsNotNull((Object)newBundle, (String)"newBundle");
        this.selectedBundle = newBundle;
    }

    @NotNull
    public final BundleState currentState() {
        return this.isInstalled(this.selectedBundle) ? BundleState.INSTALLED : (this.isExtracted(this.selectedBundle) ? BundleState.EXTRACTED : (this.isDownloaded(this.selectedBundle) ? BundleState.DOWNLOADED : (this.isRemote(this.selectedBundle) ? BundleState.REMOTE : BundleState.UNINSTALLED)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isInstalled(@NotNull Runtime bundle) {
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
        if (!bundle.getInstallationPath().exists()) return false;
        if (!BinTrayUtil.getJdkConfigFilePath().exists()) return false;
        String string = FileUtil.loadFile((File)BinTrayUtil.getJdkConfigFilePath());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.loadFile(BinTra\u2026l.getJdkConfigFilePath())");
        String string2 = bundle.getInstallationPath().getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"bundle.installationPath.absolutePath");
        if (!StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) return false;
        return true;
    }

    public final boolean isExtracted(@NotNull Runtime bundle) {
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
        return bundle.getTransitionPath().exists();
    }

    public final boolean isDownloaded(@NotNull Runtime bundle) {
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
        return bundle.getDownloadPath().exists();
    }

    public final boolean isRemote(@NotNull Runtime bundle) {
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
        return bundle instanceof Remote;
    }

    @NotNull
    public final Runtime getSelectedBundle() {
        return this.selectedBundle;
    }

    public final void setSelectedBundle(@NotNull Runtime runtime) {
        Intrinsics.checkParameterIsNotNull((Object)runtime, (String)"<set-?>");
        this.selectedBundle = runtime;
    }

    @NotNull
    public final List<Runtime> getBundles() {
        return this.bundles;
    }

    public Model(@NotNull Runtime selectedBundle, @NotNull List<Runtime> bundles) {
        Intrinsics.checkParameterIsNotNull((Object)selectedBundle, (String)"selectedBundle");
        Intrinsics.checkParameterIsNotNull(bundles, (String)"bundles");
        this.selectedBundle = selectedBundle;
        this.bundles = bundles;
    }
}

