/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.excludedFiles;

import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.excludedFiles.ExcludedFilesScopeDialog;
import com.intellij.formatting.fileSet.FileSetDescriptor;
import com.intellij.formatting.fileSet.NamedScopeDescriptor;
import com.intellij.ide.util.scopeChooser.EditScopesDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExcludedFilesList
extends JBList<FileSetDescriptor> {
    private final ToolbarDecorator myFileListDecorator = ToolbarDecorator.createDecorator((JList)((Object)this)).setAddAction(new AnActionButtonRunnable(){

        public void run(AnActionButton button2) {
            ExcludedFilesList.this.addDescriptor();
        }
    }).setRemoveAction(new AnActionButtonRunnable(){

        public void run(AnActionButton button2) {
            ExcludedFilesList.this.removeDescriptor();
        }
    }).setEditAction(new AnActionButtonRunnable(){

        public void run(AnActionButton button2) {
            ExcludedFilesList.this.editDescriptor();
        }
    }).disableUpDownActions();
    private DefaultListModel<FileSetDescriptor> myModel;
    @Nullable
    private CodeStyleSchemesModel mySchemesModel;

    public ExcludedFilesList() {
        this.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ExcludedFilesList.this.onSelectionChange();
            }
        });
    }

    public void initModel() {
        this.myModel = ExcludedFilesList.createDefaultListModel((Object[])new FileSetDescriptor[0]);
        this.setModel(this.myModel);
    }

    private void onSelectionChange() {
        int i = this.getSelectedIndex();
        AnActionButton removeButton = ToolbarDecorator.findRemoveButton((JComponent)this.myFileListDecorator.getActionsPanel());
        removeButton.setEnabled(i >= 0);
    }

    public void reset(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            ExcludedFilesList.$$$reportNull$$$0(0);
        }
        this.myModel.clear();
        for (FileSetDescriptor descriptor : settings.getExcludedFiles().getDescriptors()) {
            this.myModel.addElement(descriptor);
        }
    }

    public void apply(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            ExcludedFilesList.$$$reportNull$$$0(1);
        }
        settings.getExcludedFiles().clear();
        for (int i = 0; i < this.myModel.getSize(); ++i) {
            settings.getExcludedFiles().addDescriptor(this.myModel.get(i));
        }
    }

    public boolean isModified(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            ExcludedFilesList.$$$reportNull$$$0(2);
        }
        if (this.myModel.size() != settings.getExcludedFiles().getDescriptors().size()) {
            return true;
        }
        for (int i = 0; i < this.myModel.getSize(); ++i) {
            if (this.myModel.get(i).equals(settings.getExcludedFiles().getDescriptors().get(i))) continue;
            return true;
        }
        return false;
    }

    public ToolbarDecorator getDecorator() {
        return this.myFileListDecorator;
    }

    private void addDescriptor() {
        assert (this.mySchemesModel != null);
        List<NamedScope> availableScopes = this.getAvailableScopes();
        if (!availableScopes.isEmpty()) {
            ExcludedFilesScopeDialog dialog2 = new ExcludedFilesScopeDialog(this.mySchemesModel.getProject(), availableScopes);
            dialog2.show();
            if (dialog2.isOK()) {
                FileSetDescriptor descriptor = dialog2.getDescriptor();
                if (descriptor != null) {
                    int insertAt = this.getSelectedIndex() < 0 ? this.getItemsCount() : this.getSelectedIndex() + 1;
                    int exiting = this.myModel.indexOf(descriptor);
                    if (exiting < 0) {
                        this.myModel.add(insertAt, descriptor);
                        this.setSelectedValue(descriptor, true);
                    } else {
                        this.setSelectedValue(this.myModel.get(exiting), true);
                    }
                }
            } else if (dialog2.getExitCode() == 2) {
                this.editScope(null);
            }
        } else {
            this.editScope(null);
        }
    }

    private List<NamedScope> getAvailableScopes() {
        Set<String> usedNames = this.getUsedScopeNames();
        ArrayList namedScopes = ContainerUtil.newArrayList();
        for (NamedScopesHolder holder : this.getScopeHolders()) {
            for (NamedScope scope : holder.getEditableScopes()) {
                if (usedNames.contains(scope.getName())) continue;
                namedScopes.add(scope);
            }
        }
        return namedScopes;
    }

    private Set<String> getUsedScopeNames() {
        HashSet usedScopeNames = ContainerUtil.newHashSet();
        for (int i = 0; i < this.myModel.size(); ++i) {
            FileSetDescriptor descriptor = this.myModel.get(i);
            if (!(descriptor instanceof NamedScopeDescriptor)) continue;
            usedScopeNames.add(descriptor.getName());
        }
        return usedScopeNames;
    }

    private void removeDescriptor() {
        int i = this.getSelectedIndex();
        if (i >= 0) {
            this.myModel.remove(i);
        }
    }

    private void editDescriptor() {
        FileSetDescriptor selectedDescriptor;
        int i = this.getSelectedIndex();
        FileSetDescriptor fileSetDescriptor = selectedDescriptor = i >= 0 ? this.myModel.get(i) : null;
        if (selectedDescriptor instanceof NamedScopeDescriptor) {
            this.ensureScopeExists((NamedScopeDescriptor)selectedDescriptor);
            this.editScope(selectedDescriptor.getName());
        } else {
            this.editScope(null);
        }
    }

    public void setSchemesModel(@NotNull CodeStyleSchemesModel schemesModel) {
        if (schemesModel == null) {
            ExcludedFilesList.$$$reportNull$$$0(3);
        }
        this.mySchemesModel = schemesModel;
    }

    public void editScope(@Nullable String selectedName) {
        NamedScope scope;
        assert (this.mySchemesModel != null);
        EditScopesDialog scopesDialog = EditScopesDialog.showDialog(this.getScopeHolderProject(), selectedName);
        if (scopesDialog.isOK() && (scope = scopesDialog.getSelectedScope()) != null) {
            String newName = scope.getName();
            FileSetDescriptor newDesciptor = null;
            if (selectedName == null) {
                newDesciptor = this.findDescriptor(newName);
                if (newDesciptor == null) {
                    newDesciptor = new NamedScopeDescriptor(scope);
                    this.myModel.addElement(newDesciptor);
                }
            } else {
                FileSetDescriptor oldDescriptor = this.findDescriptor(selectedName);
                if (!selectedName.equals(newName)) {
                    int index = this.myModel.indexOf(oldDescriptor);
                    this.myModel.removeElement(oldDescriptor);
                    newDesciptor = this.findDescriptor(newName);
                    if (newDesciptor == null) {
                        newDesciptor = new NamedScopeDescriptor(scope);
                        this.myModel.add(index, newDesciptor);
                    }
                } else if (oldDescriptor != null) {
                    PackageSet fileSet = scope.getValue();
                    oldDescriptor.setPattern(fileSet != null ? fileSet.getText() : null);
                }
            }
            if (newDesciptor != null) {
                this.setSelectedValue(newDesciptor, true);
            }
        }
    }

    private void ensureScopeExists(@NotNull NamedScopeDescriptor descriptor) {
        if (descriptor == null) {
            ExcludedFilesList.$$$reportNull$$$0(4);
        }
        List<NamedScopesHolder> holders = this.getScopeHolders();
        for (NamedScopesHolder holder : holders) {
            if (holder.getScope(descriptor.getName()) == null) continue;
            return;
        }
        DependencyValidationManager projectScopeHolder = DependencyValidationManager.getInstance((Project)this.getScopeHolderProject());
        NamedScope newScope = projectScopeHolder.createScope(descriptor.getName(), descriptor.getFileSet());
        projectScopeHolder.addScope(newScope);
    }

    private Project getScopeHolderProject() {
        assert (this.mySchemesModel != null);
        CodeStyleScheme scheme2 = this.mySchemesModel.getSelectedScheme();
        return this.mySchemesModel.isProjectScheme(scheme2) ? this.mySchemesModel.getProject() : ProjectManager.getInstance().getDefaultProject();
    }

    @Nullable
    private FileSetDescriptor findDescriptor(@NotNull String name) {
        if (name == null) {
            ExcludedFilesList.$$$reportNull$$$0(5);
        }
        for (int i = 0; i < this.myModel.size(); ++i) {
            if (!name.equals(this.myModel.get(i).getName())) continue;
            return this.myModel.get(i);
        }
        return null;
    }

    private List<NamedScopesHolder> getScopeHolders() {
        ArrayList holders = ContainerUtil.newArrayList();
        Project project = this.getScopeHolderProject();
        holders.add(DependencyValidationManager.getInstance((Project)project));
        holders.add(NamedScopeManager.getInstance((Project)project));
        return holders;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemesModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/codeStyle/excludedFiles/ExcludedFilesList";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isModified";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setSchemesModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureScopeExists";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findDescriptor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

