/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.CodeStyleSchemesActions;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.application.options.schemes.SimpleSchemesPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemeImpl;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemesPanel
extends SimpleSchemesPanel<CodeStyleScheme> {
    private final CodeStyleSchemesModel myModel;
    private boolean myIsReset;

    public CodeStyleSchemesPanel(CodeStyleSchemesModel model, int vGap) {
        super(vGap);
        this.myModel = model;
    }

    CodeStyleSchemesPanel(CodeStyleSchemesModel model, @NotNull JComponent linkComponent) {
        if (linkComponent == null) {
            CodeStyleSchemesPanel.$$$reportNull$$$0(0);
        }
        super(8, linkComponent);
        this.myModel = model;
    }

    private void onCombo() {
        CodeStyleScheme selected = (CodeStyleScheme)this.getSelectedScheme();
        if (selected != null) {
            this.myModel.selectScheme(selected, this);
        }
    }

    public void resetSchemesCombo() {
        this.myIsReset = true;
        try {
            ArrayList<CodeStyleScheme> schemes = new ArrayList<CodeStyleScheme>(this.myModel.getAllSortedSchemes());
            this.resetSchemes(schemes);
            this.selectScheme(this.myModel.getSelectedScheme());
        }
        finally {
            this.myIsReset = false;
        }
    }

    public void onSelectedSchemeChanged() {
        this.myIsReset = true;
        try {
            this.selectScheme(this.myModel.getSelectedScheme());
        }
        finally {
            this.myIsReset = false;
        }
    }

    @Override
    @NotNull
    protected AbstractSchemeActions<CodeStyleScheme> createSchemeActions() {
        CodeStyleSchemesActions codeStyleSchemesActions = new CodeStyleSchemesActions(this){

            @Override
            protected void onSchemeChanged(@Nullable CodeStyleScheme scheme2) {
                if (!CodeStyleSchemesPanel.this.myIsReset) {
                    ApplicationManager.getApplication().invokeLater(() -> CodeStyleSchemesPanel.this.onCombo());
                }
            }

            @Override
            protected void renameScheme(@NotNull CodeStyleScheme scheme2, @NotNull String newName) {
                if (scheme2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (newName == null) {
                    1.$$$reportNull$$$0(1);
                }
                CodeStyleSchemeImpl newScheme = new CodeStyleSchemeImpl(newName, false, scheme2);
                CodeStyleSchemesPanel.this.myModel.addScheme(newScheme, false);
                CodeStyleSchemesPanel.this.myModel.removeScheme(scheme2);
                CodeStyleSchemesPanel.this.myModel.selectScheme(newScheme, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "scheme";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "newName";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/application/options/codeStyle/CodeStyleSchemesPanel$1";
                objectArray[2] = "renameScheme";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (codeStyleSchemesActions == null) {
            CodeStyleSchemesPanel.$$$reportNull$$$0(1);
        }
        return codeStyleSchemesActions;
    }

    @Override
    @NotNull
    public SchemesModel<CodeStyleScheme> getModel() {
        CodeStyleSchemesModel codeStyleSchemesModel = this.myModel;
        if (codeStyleSchemesModel == null) {
            CodeStyleSchemesPanel.$$$reportNull$$$0(2);
        }
        return codeStyleSchemesModel;
    }

    @Override
    protected boolean supportsProjectSchemes() {
        return true;
    }

    @Override
    protected boolean highlightNonDefaultSchemes() {
        return true;
    }

    @Override
    public boolean useBoldForNonRemovableSchemes() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkComponent";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/CodeStyleSchemesPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/CodeStyleSchemesPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createSchemeActions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

