/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.PathMacroExpandableProtocolBean;
import com.intellij.openapi.components.PathMacroMap;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.hash.LinkedHashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplacePathToMacroMap
extends PathMacroMap {
    private List<String> myPathsIndex;
    private final Map<String, String> myMacroMap;
    @NonNls
    public static final String[] PROTOCOLS;

    public ReplacePathToMacroMap() {
        this.myPathsIndex = null;
        this.myMacroMap = new LinkedHashMap();
    }

    public ReplacePathToMacroMap(@NotNull ReplacePathToMacroMap map2) {
        if (map2 == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(0);
        }
        this.myPathsIndex = null;
        this.myMacroMap = new LinkedHashMap();
        this.myMacroMap.putAll(map2.myMacroMap);
    }

    public void addMacroReplacement(String path, String macroName) {
        this.addReplacement(FileUtil.toSystemIndependentName((String)path), "$" + macroName + "$", true);
    }

    public void addReplacement(String path, String macroExpr, boolean overwrite) {
        path = StringUtil.trimEnd((String)path, (String)"/");
        this.putIfAbsent(path, macroExpr, overwrite);
        for (String protocol : PROTOCOLS) {
            this.putIfAbsent(protocol + ":" + path, protocol + ":" + macroExpr, overwrite);
            this.putIfAbsent(protocol + ":/" + path, protocol + ":/" + macroExpr, overwrite);
            this.putIfAbsent(protocol + "://" + path, protocol + "://" + macroExpr, overwrite);
        }
    }

    private void putIfAbsent(String path, String substitution, boolean overwrite) {
        if (overwrite || !this.myMacroMap.containsKey(path)) {
            this.myMacroMap.put(path, substitution);
        }
    }

    public String substitute(@Nullable String text, boolean caseSensitive) {
        if (text == null) {
            return null;
        }
        for (String path : this.getPathIndex()) {
            text = this.replacePathMacro(text, path, caseSensitive);
        }
        return text;
    }

    private String replacePathMacro(@NotNull String text, @NotNull String path, boolean caseSensitive) {
        if (text == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(1);
        }
        if (path == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(2);
        }
        if (text.length() < path.length() || path.isEmpty()) {
            return text;
        }
        if (!(!caseSensitive ? StringUtilRt.startsWithIgnoreCase((String)text, (String)path) : text.startsWith(path))) {
            return text;
        }
        int endOfOccurrence = path.length();
        boolean isWindowsRoot = path.endsWith(":/");
        if (!(isWindowsRoot || endOfOccurrence >= text.length() || text.charAt(endOfOccurrence) == '/' || text.charAt(endOfOccurrence) == '!' && text.substring(endOfOccurrence).startsWith("!/"))) {
            return text;
        }
        String s = this.myMacroMap.get(path);
        if (text.length() > endOfOccurrence) {
            return s + text.substring(endOfOccurrence);
        }
        return s;
    }

    @NotNull
    public String substituteRecursively(@NotNull String text, boolean caseSensitive) {
        if (text == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(3);
        }
        CharSequence result2 = text;
        for (String path : this.getPathIndex()) {
            result2 = this.replacePathMacroRecursively(result2, path, caseSensitive);
        }
        String string = result2.toString();
        if (string == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(4);
        }
        return string;
    }

    private CharSequence replacePathMacroRecursively(@NotNull CharSequence text, @NotNull String path, boolean caseSensitive) {
        if (text == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(5);
        }
        if (path == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(6);
        }
        if (text.length() < path.length() || path.isEmpty()) {
            return text;
        }
        StringBuilder newText = new StringBuilder();
        boolean isWindowsRoot = path.endsWith(":/");
        int i = 0;
        while (i < text.length()) {
            int occurrenceOfPath;
            int n = occurrenceOfPath = caseSensitive ? StringUtil.indexOf((CharSequence)text, (CharSequence)path, (int)i) : StringUtil.indexOfIgnoreCase((CharSequence)text, (CharSequence)path, (int)i);
            if (occurrenceOfPath >= 0) {
                char prev2;
                int endOfOccurrence = occurrenceOfPath + path.length();
                if (!isWindowsRoot && endOfOccurrence < text.length() && text.charAt(endOfOccurrence) != '/' && text.charAt(endOfOccurrence) != '\"' && text.charAt(endOfOccurrence) != ' ' && !StringUtil.startsWith((CharSequence)text, (int)endOfOccurrence, (CharSequence)"!/")) {
                    newText.append(text, i, endOfOccurrence);
                    i = endOfOccurrence;
                    continue;
                }
                if (occurrenceOfPath > 0 && (Character.isLetterOrDigit(prev2 = text.charAt(occurrenceOfPath - 1)) || prev2 == '_')) {
                    newText.append(text, i, endOfOccurrence);
                    i = endOfOccurrence;
                    continue;
                }
            }
            if (occurrenceOfPath < 0) {
                if (newText.length() == 0) {
                    return text;
                }
                newText.append(text, i, text.length());
                break;
            }
            newText.append(text, i, occurrenceOfPath);
            newText.append(this.myMacroMap.get(path));
            i = occurrenceOfPath + path.length();
        }
        return newText;
    }

    private static int getIndex(@NotNull String replacement) {
        if (replacement == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(7);
        }
        if (replacement.contains("..") || replacement.contains("$USER_HOME$") || replacement.contains("$APPLICATION_HOME_DIR$") || replacement.contains("$MAVEN_REPOSITORY$")) {
            return 1;
        }
        if (replacement.contains("$MODULE_DIR$") || replacement.contains("$PROJECT_DIR$")) {
            return 3;
        }
        return 2;
    }

    private static int stripPrefix(@NotNull String key) {
        if (key == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(8);
        }
        key = StringUtil.trimStart((String)key, (String)"jar:");
        key = StringUtil.trimStart((String)key, (String)"file:");
        while (key.startsWith("/")) {
            key = key.substring(1);
        }
        return key.length();
    }

    @NotNull
    private List<String> getPathIndex() {
        if (this.myPathsIndex == null || this.myPathsIndex.size() != this.myMacroMap.size()) {
            ArrayList<Map.Entry<String, String>> entries2 = new ArrayList<Map.Entry<String, String>>(this.myMacroMap.entrySet());
            TObjectIntHashMap weights = new TObjectIntHashMap(entries2.size());
            for (Map.Entry entry2 : entries2) {
                weights.put(entry2.getKey(), ReplacePathToMacroMap.getIndex((String)entry2.getValue()) * 512 + ReplacePathToMacroMap.stripPrefix((String)entry2.getKey()));
            }
            entries2.sort((o1, o2) -> weights.get(o2.getKey()) - weights.get(o1.getKey()));
            this.myPathsIndex = ContainerUtilRt.map2List(entries2, entry -> (String)entry.getKey());
        }
        List<String> list2 = this.myPathsIndex;
        if (list2 == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(9);
        }
        return list2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ReplacePathToMacroMap)) {
            return false;
        }
        return this.myMacroMap.equals(((ReplacePathToMacroMap)((Object)obj)).myMacroMap);
    }

    public int hashCode() {
        return this.myMacroMap.hashCode();
    }

    public void put(String path, String replacement) {
        this.myMacroMap.put(path, replacement);
    }

    public String toString() {
        return "macroMap: " + this.myMacroMap + "\n\npathsIndex: " + StringUtil.join(this.myPathsIndex, (String)"\n");
    }

    static {
        ArrayList<String> protocols = new ArrayList<String>();
        protocols.add("file");
        protocols.add("jar");
        if (Extensions.getRootArea().hasExtensionPoint(PathMacroExpandableProtocolBean.EP_NAME)) {
            for (PathMacroExpandableProtocolBean bean : PathMacroExpandableProtocolBean.EP_NAME.getExtensionList()) {
                protocols.add(bean.protocol);
            }
        }
        PROTOCOLS = ArrayUtil.toStringArray(protocols);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/ReplacePathToMacroMap";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/ReplacePathToMacroMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteRecursively";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "replacePathMacro";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "substituteRecursively";
                break;
            }
            case 4: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replacePathMacroRecursively";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIndex";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "stripPrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

